/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.document.excel.coditional;

import com.inet.docx.document.excel.WorkbookAnalyzer;
import com.inet.docx.document.excel.coditional.CellAddressAndValue;
import com.inet.docx.document.excel.coditional.ConditionalFormatingHandler;
import com.inet.docx.document.excel.coditional.FormatingHandler;
import java.util.List;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDxf;

public class TopPercentHandler
extends FormatingHandler {
    private boolean isBottom;
    private int numberOfCells;

    protected TopPercentHandler(int priority, ConditionalFormatingHandler formatingHandler, CTDxf dfx, int number, boolean isPercent, boolean isBottom, int valueCount) {
        super(priority, formatingHandler, dfx);
        this.isBottom = isBottom;
        this.numberOfCells = isPercent ? valueCount * number / 100 : number;
        this.numberOfCells = this.numberOfCells == 0 ? 1 : this.numberOfCells;
    }

    @Override
    protected void checkValues(List<CellAddressAndValue> cellValues, WorkbookAnalyzer.IndexSizeAndStyle[] rows, WorkbookAnalyzer.IndexSizeAndStyle[] columns) {
        int index;
        int n = index = this.isBottom ? 0 : cellValues.size() - 1;
        while (this.numberOfCells > 0) {
            CellAddressAndValue cav = cellValues.get(index);
            if (TopPercentHandler.isInDisplayedRange(rows, columns, cav.getAddress())) {
                this.addAddress(cav.getAddress());
            }
            index = this.isBottom ? ++index : --index;
            --this.numberOfCells;
        }
    }
}

