/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.document.elements.subelements.table;

import com.inet.docx.document.elements.style.LineProperties;
import com.inet.docx.document.elements.subelements.BorderLines;
import com.inet.docx.document.utilities.Util;
import java.awt.Color;
import java.util.HashMap;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBorder;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblBorders;

public class TableBorder
extends BorderLines {
    private LineProperties insideHorizontal;
    private LineProperties insideVertical;

    private TableBorder() {
        this.setLeftLine(LineProperties.EMPTY_LINE);
        this.setRightLine(LineProperties.EMPTY_LINE);
        this.setTopLine(LineProperties.EMPTY_LINE);
        this.setBottomLine(LineProperties.EMPTY_LINE);
        this.insideHorizontal = LineProperties.EMPTY_LINE;
        this.insideVertical = LineProperties.EMPTY_LINE;
    }

    public TableBorder(CTTblBorders tableBorders, HashMap<String, Color> themeColors) {
        this.setLeftLine(Util.getLinePropertiesFromBorder(tableBorders.getLeft(), themeColors));
        this.setRightLine(Util.getLinePropertiesFromBorder(tableBorders.getRight(), themeColors));
        this.setTopLine(Util.getLinePropertiesFromBorder(tableBorders.getTop(), themeColors));
        this.setBottomLine(Util.getLinePropertiesFromBorder(tableBorders.getBottom(), themeColors));
        this.setInsideHorizontal(Util.getLinePropertiesFromBorder(tableBorders.getInsideH(), themeColors));
        this.setInsideVertical(Util.getLinePropertiesFromBorder(tableBorders.getInsideV(), themeColors));
    }

    public LineProperties getInsideHorizontal() {
        return this.insideHorizontal;
    }

    public LineProperties getInsideVertical() {
        return this.insideVertical;
    }

    public void setInsideHorizontal(LineProperties insideHorizontal) {
        this.insideHorizontal = insideHorizontal;
    }

    public void setInsideVertical(LineProperties insideVertical) {
        this.insideVertical = insideVertical;
    }

    public TableBorder mergeBorders(CTTblBorders tableBorders, HashMap<String, Color> themeColors) {
        if (tableBorders != null) {
            TableBorder mergeeBorders = new TableBorder();
            CTBorder border = tableBorders.getLeft();
            if (border != null) {
                mergeeBorders.setLeftLine(Util.getLinePropertiesFromBorder(border, themeColors));
            } else {
                mergeeBorders.setLeftLine(this.getLeftLine());
            }
            border = tableBorders.getRight();
            if (border != null) {
                mergeeBorders.setRightLine(Util.getLinePropertiesFromBorder(border, themeColors));
            } else {
                mergeeBorders.setRightLine(this.getRightLine());
            }
            border = tableBorders.getTop();
            if (border != null) {
                mergeeBorders.setTopLine(Util.getLinePropertiesFromBorder(border, themeColors));
            } else {
                mergeeBorders.setTopLine(this.getRightLine());
            }
            border = tableBorders.getBottom();
            if (border != null) {
                mergeeBorders.setBottomLine(Util.getLinePropertiesFromBorder(border, themeColors));
            } else {
                mergeeBorders.setBottomLine(this.getBottomLine());
            }
            border = tableBorders.getInsideV();
            mergeeBorders.insideVertical = border != null ? Util.getLinePropertiesFromBorder(border, themeColors) : this.insideVertical;
            border = tableBorders.getInsideH();
            mergeeBorders.insideHorizontal = border != null ? Util.getLinePropertiesFromBorder(border, themeColors) : this.insideHorizontal;
            return mergeeBorders;
        }
        return this;
    }

    public static TableBorder getDefaultBorders() {
        return new TableBorder();
    }
}

