/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.document.elements.subelements.drawing;

import com.inet.docx.document.elements.style.RenderFont;
import com.inet.docx.document.elements.subelements.FieldPart;
import com.inet.docx.view.drawing.DrawingReflection;
import com.inet.docx.view.drawing.SimpleShape;
import java.awt.Color;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.math.BigInteger;

public class FormfieldCheckBox
extends SimpleShape {
    private Boolean checked;

    private FormfieldCheckBox(double width, double height, Boolean checked) {
        super("rect", new Rectangle2D.Double(0.0, 0.0, width, height), 0.0, 1.0, 1.0, DrawingReflection.NONE);
        this.checked = checked;
    }

    public boolean isChecked() {
        return this.checked == null ? false : this.checked;
    }

    public static FormfieldCheckBox createCheckBox(RenderFont fieldRenderFont, FieldPart definitionData, Color color) {
        BigInteger size = (BigInteger)definitionData.getAttributeValue(FieldPart.FormFieldAttribute.checkBoxSize);
        double length = size != null ? size.doubleValue() : (definitionData.getRenderFont().getRenderDimensions() != null ? definitionData.getRenderFont().getRenderDimensions().getRowHeight() : fieldRenderFont.getRenderDimensions().getRowHeight());
        FormfieldCheckBox fcb = new FormfieldCheckBox(length + 20.0, length, (Boolean)definitionData.getAttributeValue(FieldPart.FormFieldAttribute.checkBoxValue));
        fcb.getBasicStrokeData().setBorderLineWidth(10.0);
        fcb.getBasicStrokeData().setBorderColor(color);
        double scaleNormal = 20.0 / length;
        double scaleEnd = 40.0 / length;
        Path2D.Double shape = new Path2D.Double();
        shape.moveTo(scaleNormal, scaleNormal);
        shape.lineTo(1.0 - scaleEnd, scaleNormal);
        shape.lineTo(1.0 - scaleEnd, 1.0 - scaleNormal);
        shape.lineTo(scaleNormal, 1.0 - scaleNormal);
        shape.closePath();
        if (Boolean.TRUE.equals(fcb.isChecked())) {
            shape.lineTo(1.0 - scaleEnd, 1.0 - scaleNormal);
            shape.moveTo(1.0 - scaleEnd, scaleNormal);
            shape.lineTo(scaleNormal, 1.0 - scaleNormal);
        }
        shape.moveTo(1.0, 1.0);
        fcb.addMultiLine(shape);
        return fcb;
    }
}

