/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.document.elements.subelements.drawing;

import com.inet.docx.document.elements.subelements.drawing.Anchor;
import com.inet.docx.document.elements.subelements.drawing.DimensionDefinition;
import com.inet.docx.view.drawing.DrawingElement;
import com.inet.docx.view.drawing.DrawingReflection;
import com.inet.docx.view.drawing.VmlShapeConverter;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class DrawingContent {
    private Anchor horizontalAnchor;
    private Anchor verticalAnchor;
    private double rotation;
    private DrawingReflection reflection = DrawingReflection.NONE;
    private DimensionDefinition height;
    private DimensionDefinition width;
    private double top;
    private double left;
    private long zIndex;
    private ImageData image;
    private OleObjectData oleObject;
    private ArrayList<DrawingElement> content = new ArrayList();
    private HashMap<String, VmlShapeConverter> shapeTypes = new HashMap();
    private Point2D.Double coordinateOrigin = new Point2D.Double(0.0, 0.0);
    private Point2D.Double coordinateSize = new Point2D.Double(1000.0, 1000.0);

    public DrawingReflection getReflection() {
        return this.reflection;
    }

    public void setReflection(String reflection) {
        this.reflection = "x".equals(reflection) ? DrawingReflection.HORIZONTAL : ("y".equals(reflection) ? DrawingReflection.VERTICAL : DrawingReflection.NONE);
    }

    public void addShapeType(String id, VmlShapeConverter data) {
        this.shapeTypes.put(id, data);
    }

    public VmlShapeConverter getShapeType(String id) {
        return this.shapeTypes.get(id);
    }

    public double getTop() {
        return this.top;
    }

    public void setTop(double top) {
        this.top = top;
    }

    public double getLeft() {
        return this.left;
    }

    public void setLeft(double left) {
        this.left = left;
    }

    public long getzIndex() {
        return this.zIndex;
    }

    public void setzIndex(long zIndex) {
        this.zIndex = zIndex;
    }

    public Anchor getHorizontalAnchor() {
        return this.horizontalAnchor;
    }

    public void setHorizontalAnchor(Anchor horizontalAnchor) {
        this.horizontalAnchor = horizontalAnchor;
    }

    public Anchor getVerticalAnchor() {
        return this.verticalAnchor;
    }

    public void setVerticalAnchor(Anchor verticalAnchor) {
        this.verticalAnchor = verticalAnchor;
    }

    public double getRotation() {
        return this.rotation;
    }

    public void setRotation(double rotation) {
        this.rotation = rotation;
    }

    public DimensionDefinition getHeight() {
        return this.height;
    }

    public void setHeight(DimensionDefinition height) {
        this.height = height;
    }

    public DimensionDefinition getWidth() {
        return this.width;
    }

    public void setCoordinateOrigin(Point2D.Double coordinateOrigin) {
        this.coordinateOrigin = coordinateOrigin;
    }

    public Point2D.Double getCoordinateOrigin() {
        return this.coordinateOrigin;
    }

    public void setCoordinateSize(Point2D.Double coordinateSize) {
        this.coordinateSize = coordinateSize;
    }

    public Point2D.Double getCoordinateSize() {
        return this.coordinateSize;
    }

    public double getScaleX() {
        if (this.getWidth() != null) {
            return this.getWidth().getValue() / this.getCoordinateSize().getX();
        }
        return 1.0;
    }

    public double getScaleY() {
        if (this.getHeight() != null) {
            return this.getHeight().getValue() / this.getCoordinateSize().getY();
        }
        return 1.0;
    }

    public void setWidth(DimensionDefinition width) {
        this.width = width;
    }

    public void addElement(DrawingElement element) {
        this.content.add(element);
    }

    public List<DrawingElement> getContent() {
        return this.content;
    }

    public void setImage(String key, String title, String shapeId) {
        if (this.image != null) {
            throw new IllegalArgumentException("Only single image is implemented!");
        }
        this.image = new ImageData(key, title, shapeId);
    }

    public String getImageKey() {
        return this.image == null ? null : this.image.getImageKey();
    }

    public void setOleObject(String refId, String progId, String shapeId, Object type, Object drawAspect) {
        this.oleObject = new OleObjectData(refId, progId, shapeId, type != null ? type.toString() : null, drawAspect != null ? drawAspect.toString() : null);
    }

    public OleObjectData getOleData() {
        return this.oleObject;
    }

    public class ImageData {
        private String imageKey;
        private String imageTitle;
        private String shapeId;

        private ImageData(String imageKey, String imageTitle, String shapeId) {
            this.imageKey = imageKey;
            this.imageTitle = imageTitle;
            this.shapeId = shapeId;
        }

        public String getImageKey() {
            return this.imageKey;
        }
    }

    public class OleObjectData {
        private String oleRefKey;
        private String progId;
        private String shapeId;
        private String type;
        private String drawAspect;

        private OleObjectData(String oleRefKey, String progId, String shapeId, String type, String drawAspect) {
            this.oleRefKey = oleRefKey;
            this.progId = progId;
            this.shapeId = shapeId;
            this.type = type;
            this.drawAspect = drawAspect;
        }

        public String getOleRefKey() {
            return this.oleRefKey;
        }

        public boolean isExcelSheet() {
            return "Excel.Sheet.12".equals(this.progId);
        }

        public boolean displayAsIcon() {
            return "Icon".equals(this.drawAspect);
        }
    }
}

