/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.document.elements.subelements;

import com.inet.docx.document.elements.style.RenderFont;
import com.inet.docx.document.elements.style.RunRenderInformations;
import com.inet.docx.document.elements.subelements.ParagraphElement;
import java.awt.Color;

public class TextRowElement
implements ParagraphElement {
    private RenderFont renderFont;
    private Color color;
    private Color bgColor;
    private String text;

    public TextRowElement(String text, RenderFont renderFont, Color color, Color bgColor) {
        this.text = text;
        this.renderFont = renderFont;
        this.color = color;
        this.bgColor = bgColor;
    }

    protected TextRowElement(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    protected void setRenderFont(RenderFont renderFont) {
        if (this.renderFont != null && !this.renderFont.equals(renderFont)) {
            throw new IllegalStateException("setRenderFont() is only allowed to be used by the constructor of the extending class!");
        }
        if (renderFont == null) {
            throw new IllegalStateException("A text run requires a font to be rendered.");
        }
        this.renderFont = renderFont;
    }

    public void setColor(Color color) {
        if (this.color != null && this.color != RunRenderInformations.AUTO && !this.color.equals(color)) {
            throw new IllegalStateException("setColor() is only allowed to be used by the constructor of the extending class!");
        }
        this.color = color;
    }

    protected void setBackgroundColor(Color bgColor) {
        if (this.bgColor != null && !this.bgColor.equals(bgColor)) {
            throw new IllegalStateException("setBackgroundColor() is only allowed to be used by the constructor of the extending class!");
        }
        this.bgColor = bgColor;
    }

    public Color getColor() {
        return this.color;
    }

    public Color getBackgroundColor() {
        return this.bgColor;
    }

    @Override
    public RenderFont getRenderFont() {
        return this.renderFont;
    }

    public void merge(TextRowElement textEle) {
        this.text = this.text + textEle.getText();
    }

    @Override
    public ParagraphElement.ParagraphElementType getElementType() {
        return ParagraphElement.ParagraphElementType.Text;
    }

    @Override
    public boolean isAnchored() {
        return false;
    }

    public String toString() {
        return String.valueOf(this.text);
    }

    public ParagraphElement clone() {
        return new TextRowElement(this.text, this.renderFont, this.color, this.bgColor);
    }
}

