/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.document.elements.subelements;

import com.inet.docx.document.DocumentProperties;
import com.inet.docx.document.elements.style.RenderFont;
import com.inet.docx.document.elements.subelements.Drawing;
import com.inet.docx.document.elements.subelements.FieldPart;
import com.inet.docx.document.elements.subelements.ParagraphElement;
import com.inet.docx.document.elements.subelements.TextRowElement;
import com.inet.docx.document.elements.subelements.drawing.FormfieldCheckBox;
import com.inet.docx.document.utilities.NumberFormating;
import com.inet.docx.document.utilities.Util;
import com.inet.docx.view.PageProperties;
import com.inet.docx.view.RenderContext;
import java.awt.Color;
import java.text.Format;
import java.util.ArrayList;
import java.util.Date;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STFldCharType;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STNumberFormat;

public class Field
extends TextRowElement {
    private DefaultValueHandler valueHandler;

    private Field() {
        super("FIELD");
    }

    public Field(String function, DocumentProperties documentProperties, TextRowElement tre) {
        this();
        this.setValueHandler(function, tre.getText(), null, documentProperties);
        this.setColor(tre.getColor());
        this.setBackgroundColor(tre.getBackgroundColor());
        this.setRenderFont(tre.getRenderFont());
    }

    public Field(ArrayList<ParagraphElement> elements, DocumentProperties documentProperties) {
        this();
        String resultText = null;
        Color col = null;
        Color bg = null;
        RenderFont rf = null;
        Object keyValue = null;
        boolean function = false;
        boolean toNeglect = false;
        FieldPart formFieldInfos = null;
        for (ParagraphElement element : elements) {
            if (element instanceof TextRowElement) {
                TextRowElement te = (TextRowElement)element;
                if (toNeglect) continue;
                if (function) {
                    keyValue = keyValue == null ? te.getText().trim() : (String)keyValue + te.getText().trim();
                    col = te.getColor();
                    bg = te.getBackgroundColor();
                    rf = te.getRenderFont();
                    continue;
                }
                String string = resultText = resultText == null ? te.getText() : resultText + te.getText();
                if (keyValue != null && !((String)keyValue).contains("CHARFORMAT")) {
                    col = te.getColor();
                    bg = te.getBackgroundColor();
                    rf = te.getRenderFont();
                }
                if (rf != null) continue;
                rf = te.getRenderFont();
                continue;
            }
            if (!(element instanceof FieldPart)) continue;
            FieldPart fp = (FieldPart)element;
            if (STFldCharType.BEGIN == fp.getTypeMarker()) {
                function = true;
                if (fp.getFormFieldType() == FieldPart.FormFieldType.none) continue;
                formFieldInfos = fp;
                documentProperties.getLayouter(fp.getRenderFont());
                continue;
            }
            if (STFldCharType.SEPARATE == fp.getTypeMarker()) {
                function = false;
                continue;
            }
            if (STFldCharType.END != fp.getTypeMarker()) continue;
            function = false;
            toNeglect = false;
        }
        this.setValueHandler((String)keyValue, resultText, formFieldInfos, documentProperties);
        this.setColor(col);
        this.setBackgroundColor(bg);
        documentProperties.getLayouter(rf);
        this.setRenderFont(rf);
    }

    private void setValueHandler(String keyValue, String resultText, FieldPart formFieldInfos, DocumentProperties documentProperties) {
        if (keyValue != null) {
            keyValue = keyValue.replace("\\* MERGEFORMAT", "");
            keyValue = keyValue.replace("\\* CHARFORMAT", "");
            keyValue = keyValue.trim();
        } else {
            keyValue = "";
        }
        this.valueHandler = this.getValueHandler(keyValue, resultText, formFieldInfos, documentProperties);
        if (this.valueHandler.isReferencedContent()) {
            documentProperties.registerVariableField(this);
        }
    }

    @Override
    public String getText() {
        return this.valueHandler.getText();
    }

    public Drawing getDrawing() {
        return this.valueHandler.getDrawing();
    }

    @Override
    public ParagraphElement.ParagraphElementType getElementType() {
        return ParagraphElement.ParagraphElementType.Field;
    }

    @Override
    public ParagraphElement clone() {
        Field theClone = new Field();
        theClone.setRenderFont(this.getRenderFont());
        theClone.setColor(this.getColor());
        theClone.setBackgroundColor(this.getBackgroundColor());
        theClone.valueHandler = this.valueHandler;
        return theClone;
    }

    public void checkFieldContent(RenderContext context) {
        this.valueHandler.checkFieldContent(context);
    }

    private FieldNames getFieldName(String functionName) {
        for (FieldNames fn : FieldNames.values()) {
            if (!functionName.equals(fn.toString())) continue;
            return fn;
        }
        return null;
    }

    private DefaultValueHandler getValueHandler(String fieldDefinition, String predifined, FieldPart formFieldInfos, DocumentProperties documentProperties) {
        FieldNames fn;
        String functionName;
        String val2 = null;
        int index = fieldDefinition.indexOf(32);
        if (index > -1) {
            functionName = fieldDefinition.substring(0, index);
            if ((fieldDefinition = fieldDefinition.substring(index + 1).trim()).length() > 0) {
                if (fieldDefinition.charAt(0) == '\\') {
                    index = fieldDefinition.indexOf(32);
                    if (index >= 0) {
                        val2 = fieldDefinition.substring(index + 1).trim();
                    }
                } else if (fieldDefinition.charAt(0) == '_' && (index = fieldDefinition.indexOf(32)) >= 0) {
                    val2 = fieldDefinition.substring(0, index);
                }
            }
        } else {
            functionName = fieldDefinition;
        }
        if ((fn = this.getFieldName(functionName.toUpperCase())) != null) {
            switch (fn) {
                case STYLEREF: {
                    Util.LOGGER.error((Object)(String.valueOf((Object)FieldNames.STYLEREF) + " " + fieldDefinition + " not implemented!"));
                    return new StringValueHandler(fn, "");
                }
                case MACROBUTTON: {
                    fieldDefinition = fieldDefinition.replace("NoMakro ", "");
                    return new StringValueHandler(fn, fieldDefinition);
                }
                case CREATEDATE: 
                case DATE: 
                case PRINTDATE: 
                case SAVEDATE: {
                    return new DateValueHandler(fn, predifined, val2, documentProperties);
                }
                case AUTHOR: 
                case LASTSAVEDBY: 
                case TITLE: 
                case SUBJECT: 
                case COMMENTS: 
                case KEYWORDS: 
                case REVNUM: 
                case TEMPLATE: 
                case APPLICATION: 
                case APPVERSION: {
                    return new StringValueHandler(fn, predifined);
                }
                case NUMCHARS: 
                case NUMWORDS: 
                case NUMPAGES: 
                case PAGEREF: 
                case PAGE: 
                case SECTIONPAGES: 
                case SECTION: {
                    return new NumberValueHandler(fn, predifined, val2);
                }
                case FORMCHECKBOX: {
                    return new DrawingValueHandler(fn, predifined, formFieldInfos);
                }
                case FORMDROPDOWN: {
                    String text = (String)formFieldInfos.getAttributeValue(FieldPart.FormFieldAttribute.dropDownSelection);
                    return new StringValueHandler(fn, text);
                }
            }
        }
        return new DefaultValueHandler(null, predifined);
    }

    private class DefaultValueHandler {
        String defaultText;
        FieldNames fn;

        private DefaultValueHandler(FieldNames fn, String defaultText) {
            this.defaultText = defaultText;
            this.fn = fn;
        }

        protected boolean isReferencedContent() {
            return false;
        }

        protected Drawing getDrawing() {
            return null;
        }

        private String getText() {
            return this.defaultText != null ? this.defaultText : "";
        }

        protected void checkFieldContent(RenderContext context) {
        }
    }

    public static enum FieldNames {
        APPLICATION,
        APPVERSION,
        AUTHOR,
        COMMENTS,
        CREATEDATE,
        DATE,
        FORMCHECKBOX,
        FORMDROPDOWN,
        KEYWORDS,
        LASTSAVEDBY,
        MACROBUTTON,
        NUMCHARS,
        NUMWORDS,
        NUMPAGES,
        PAGE,
        PAGEREF,
        PRINTDATE,
        REVNUM,
        SAVEDATE,
        SECTION,
        SECTIONPAGES,
        STYLEREF,
        SUBJECT,
        TEMPLATE,
        TITLE;

    }

    private class StringValueHandler
    extends DefaultValueHandler {
        private StringValueHandler(FieldNames fn, String text) {
            super(fn, text);
        }

        @Override
        protected void checkFieldContent(RenderContext context) {
            Object value = context.getDocumentProperties().getValue(this.fn);
            if ((this.defaultText == null || this.defaultText.length() == 0) && value != null) {
                this.defaultText = value.toString();
            }
        }
    }

    private class DateValueHandler
    extends DefaultValueHandler {
        String dateFormat;

        private DateValueHandler(FieldNames fn, String text, String valueFormat, DocumentProperties documentProperties) {
            super(fn, text);
            if (valueFormat != null) {
                this.dateFormat = valueFormat.replace('\"', ' ').trim();
                Format format = Util.getFormaterForPattern(this.dateFormat);
                if (fn == FieldNames.DATE) {
                    this.defaultText = format.format(new Date());
                }
                if (fn == FieldNames.SAVEDATE || fn == FieldNames.PRINTDATE || fn == FieldNames.CREATEDATE) {
                    Object saveDate = documentProperties.getValue(fn);
                    this.defaultText = saveDate instanceof Date ? format.format(saveDate) : text;
                }
            }
        }

        @Override
        protected void checkFieldContent(RenderContext context) {
            Object date = context.getDocumentProperties().getValue(this.fn);
            if ((this.defaultText == null || this.defaultText.length() == 0 || this.fn == FieldNames.SAVEDATE || this.fn == FieldNames.PRINTDATE || this.fn == FieldNames.CREATEDATE) && date != null) {
                Format format = Util.getFormaterForPattern(this.dateFormat);
                this.defaultText = format.format(date);
            }
        }
    }

    private class NumberValueHandler
    extends DefaultValueHandler {
        private String valueFormat;
        private STNumberFormat.Enum format;

        private NumberValueHandler(FieldNames fn, String text, String valueFormat) {
            super(fn, text);
            this.valueFormat = valueFormat != null ? valueFormat : "";
        }

        @Override
        protected boolean isReferencedContent() {
            return this.fn == FieldNames.PAGEREF;
        }

        private STNumberFormat.Enum getFormat() {
            if (this.format != null) {
                return this.format;
            }
            switch (this.valueFormat = this.valueFormat != null ? this.valueFormat : "") {
                case "ROMAN": 
                case "Roman": {
                    this.format = STNumberFormat.UPPER_ROMAN;
                    break;
                }
                case "roman": {
                    this.format = STNumberFormat.LOWER_ROMAN;
                    break;
                }
                case "ALPHABETIC": 
                case "Alphabetic": {
                    this.format = STNumberFormat.UPPER_LETTER;
                    break;
                }
                case "alphabetic": {
                    this.format = STNumberFormat.LOWER_LETTER;
                    break;
                }
            }
            return this.format;
        }

        @Override
        protected void checkFieldContent(RenderContext context) {
            PageProperties pp = context.getPageLayout();
            if (this.format == null) {
                this.format = pp.getNumberFormat();
            }
            if (this.fn == FieldNames.NUMPAGES || this.fn == FieldNames.NUMCHARS || this.fn == FieldNames.NUMWORDS) {
                Object numPages = context.getDocumentProperties().getValue(this.fn);
                if (numPages != null) {
                    this.defaultText = NumberFormating.getFormatedValue(this.format, ((Number)numPages).intValue());
                }
            } else if (this.fn == FieldNames.PAGE) {
                this.defaultText = NumberFormating.getFormatedValue(this.getFormat(), context.getDisplayPageNumber());
            } else if (this.fn == FieldNames.SECTIONPAGES || this.fn == FieldNames.PAGEREF) {
                // empty if block
            }
        }
    }

    private class DrawingValueHandler
    extends DefaultValueHandler {
        private Drawing draw;
        private FieldPart drawingInfos;

        private DrawingValueHandler(FieldNames fn, String text, FieldPart drawingInfos) {
            super(fn, text);
            this.drawingInfos = drawingInfos;
        }

        @Override
        protected Drawing getDrawing() {
            if (this.draw == null) {
                Color color = Field.this.getColor() != null ? Field.this.getColor() : Color.BLACK;
                FormfieldCheckBox fcb = FormfieldCheckBox.createCheckBox(Field.this.getRenderFont(), this.drawingInfos, color);
                this.draw = new Drawing(fcb.getWidth(), fcb.getHeight());
                this.draw.setContent(fcb);
            }
            return this.draw;
        }
    }
}

