/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.document.elements.style;

import com.inet.docx.document.DocumentProperties;
import com.inet.docx.document.elements.style.Indent;
import com.inet.docx.document.elements.style.RenderFont;
import com.inet.docx.document.elements.subelements.Tab;
import com.inet.docx.document.utilities.Util;
import com.inet.docx.view.PageProperties;
import java.awt.Color;
import java.util.ArrayList;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STPTabAlignment;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STTabJc;

public class TabStop {
    private int startx;
    private int defaultTabStop;
    private Tab[] tabs = new Tab[0];
    private int offsetX = 0;

    public TabStop(int startx) {
        this(startx, 720);
    }

    public TabStop(int startx, int defaultTabStop) {
        this.startx = startx;
        this.defaultTabStop = defaultTabStop;
    }

    public TabStop(DocumentProperties documentProperties, PageProperties properties, Tab[] tabStop, Indent indent) {
        this(properties.getMarginLeft(), documentProperties.getSettings().getDefaultTabStop());
        this.offsetX = indent == null ? 0 : (indent.getHanging() == 0 ? 0 : indent.getLeft());
        this.tabs = tabStop;
        ArrayList<Tab> tabList = new ArrayList<Tab>();
        if (this.tabs.length != 0 && this.offsetX != 0) {
            boolean wasAdded = false;
            for (Tab tab : this.tabs) {
                if (tab.getPosition() < this.offsetX || wasAdded) {
                    tabList.add(tab);
                    continue;
                }
                wasAdded = true;
                tabList.add(new Tab(this.offsetX));
            }
            if (!wasAdded) {
                tabList.add(new Tab(this.offsetX));
            }
            while (this.defaultTabStop > 0 && properties.getPageWidth() > ((Tab)tabList.get(tabList.size() - 1)).getPosition()) {
                int factor = ((Tab)tabList.get(tabList.size() - 1)).getPosition() / this.defaultTabStop + 1;
                tabList.add(new Tab(this.defaultTabStop * factor));
            }
            this.tabs = tabList.toArray(new Tab[0]);
        } else if (this.offsetX != 0) {
            tabList.add(new Tab(this.offsetX));
            while (this.defaultTabStop > 0 && properties.getPageWidth() > ((Tab)tabList.get(tabList.size() - 1)).getPosition()) {
                int factor = ((Tab)tabList.get(tabList.size() - 1)).getPosition() / this.defaultTabStop + 1;
                tabList.add(new Tab(this.defaultTabStop * factor));
            }
            this.tabs = tabList.toArray(new Tab[0]);
        }
    }

    public STTabJc.Enum getAligmnent(double x) {
        double width = x - (double)this.startx;
        for (Tab tab : this.tabs) {
            if (!((double)(tab.getPosition() - this.offsetX) > width)) continue;
            return tab.getTabStyle();
        }
        return STTabJc.Enum.forString((String)"left");
    }

    public double getNextTabStopPosition(double x) {
        if (x < (double)this.startx) {
            Util.LOGGER.debug((Object)("The x position ( " + x + " ) cannot greater than the start position for calculation the tabsStop " + this.startx));
            x = this.startx;
        }
        if (x < 0.0 || this.startx < 0) {
            Util.LOGGER.warn((Object)"The tab in negativ area are not implemented, yet");
            x = 0.0;
        }
        double width = x - (double)this.startx;
        for (Tab tab : this.tabs) {
            double calcWidth;
            double d = calcWidth = tab.getTabAlign() == STPTabAlignment.RIGHT || tab.getTabAlign() == STPTabAlignment.CENTER ? x : width;
            if (!((double)tab.getPosition() > calcWidth)) continue;
            return this.startx + tab.getPosition();
        }
        if (this.defaultTabStop <= 0) {
            return x;
        }
        int numOfTabs = (int)(width / (double)this.defaultTabStop) + 1;
        return this.startx + numOfTabs * this.defaultTabStop;
    }

    public String getPlaceholder(double x, RenderFont font, Color foreground, Color background) {
        double width = x - (double)this.startx;
        for (Tab tab : this.tabs) {
            if (!((double)(tab.getPosition() - this.offsetX) > width)) continue;
            return tab.getPlaceholder(font, foreground, background).getText();
        }
        return null;
    }
}

