/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.document.elements.style;

import com.inet.docx.document.utilities.Util;
import org.apache.xmlbeans.impl.values.XmlValueOutOfRangeException;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextParagraphProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextSpacing;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextSpacingPercent;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextSpacingPoint;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSpacing;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STLineSpacingRule;

public class Spacing {
    public static final int DEFAULT_LINE_SPACING_SINGLE = 240;
    public static final Integer AUTO_SPACING_VALUE = 280;
    private Integer spacingAfter;
    private Integer spacingLine;
    private Integer spacingBefore;
    private Double spacingFactor;
    private STLineSpacingRule.Enum spacingLineRule = STLineSpacingRule.AUTO;
    private Spacing contextBefore;
    private Spacing contextAfter;

    public static Spacing getDefaultInstance() {
        Spacing spacing = new Spacing();
        spacing.spacingAfter = 160;
        spacing.spacingLine = 259;
        spacing.spacingFactor = 1.0791666507720947;
        return spacing;
    }

    private Spacing() {
    }

    private Spacing(Spacing other) {
        this.spacingBefore = other.spacingBefore;
        this.spacingAfter = other.spacingAfter;
        this.spacingLine = other.spacingLine;
        this.spacingLineRule = other.spacingLineRule;
        this.spacingFactor = other.spacingFactor;
    }

    public Spacing(CTSpacing ctSpacing, Spacing parentSpacing) {
        if (ctSpacing != null) {
            if (Util.getBool(ctSpacing.xgetBeforeAutospacing())) {
                this.spacingBefore = AUTO_SPACING_VALUE;
            } else {
                Object beforeValue;
                Object object = beforeValue = ctSpacing.isSetBefore() ? ctSpacing.getBefore() : null;
                if (beforeValue != null) {
                    this.spacingBefore = Util.getInt(beforeValue);
                } else if (parentSpacing != null) {
                    this.spacingBefore = parentSpacing.spacingBefore;
                }
            }
            Object lineValue = null;
            try {
                lineValue = ctSpacing.isSetLine() ? ctSpacing.getLine() : null;
            }
            catch (XmlValueOutOfRangeException valueOutOfRangeException) {
                Util.LOGGER.error((Object)("Out of Range Exception: " + String.valueOf((Object)valueOutOfRangeException)));
            }
            if (lineValue != null) {
                this.spacingLine = Util.getInt(lineValue);
            } else if (parentSpacing != null) {
                this.spacingLine = parentSpacing.spacingLine;
            }
            if (Util.getBool(ctSpacing.xgetAfterAutospacing())) {
                this.spacingAfter = AUTO_SPACING_VALUE;
            } else {
                Object afterValue;
                Object object = afterValue = ctSpacing.isSetAfter() ? ctSpacing.getAfter() : null;
                if (afterValue != null) {
                    this.spacingAfter = Util.getInt(afterValue);
                } else if (parentSpacing != null) {
                    this.spacingAfter = parentSpacing.spacingAfter;
                }
            }
            STLineSpacingRule.Enum enum_ = this.spacingLineRule = ctSpacing.isSetLineRule() ? ctSpacing.getLineRule() : null;
            if (this.spacingLineRule == null && parentSpacing != null) {
                this.spacingLineRule = parentSpacing.getLineRule();
            }
            if (this.spacingLine != null) {
                this.spacingFactor = (float)this.spacingLine.intValue() / 240.0f;
            }
        } else if (parentSpacing != null) {
            this.spacingBefore = parentSpacing.spacingBefore;
            this.spacingAfter = parentSpacing.spacingAfter;
            this.spacingLine = parentSpacing.spacingLine;
            this.spacingLineRule = parentSpacing.spacingLineRule;
            this.spacingFactor = parentSpacing.spacingFactor;
        }
    }

    public Spacing(CTTextParagraphProperties tpp, double height) {
        this.spacingLine = this.getValue(tpp.getLnSpc(), height);
        this.spacingBefore = this.getValue(tpp.getSpcBef(), height);
        this.spacingAfter = this.getValue(tpp.getSpcAft(), height);
        if (this.spacingLine != null) {
            this.spacingFactor = Util.getDouble(this.spacingLine) / height;
        }
    }

    private Integer getValue(CTTextSpacing ts, double height) {
        CTTextSpacingPoint spacePts = ts.getSpcPts();
        if (spacePts != null) {
            return spacePts.getVal() / 5;
        }
        CTTextSpacingPercent tsp = ts.getSpcPct();
        if (tsp != null) {
            return (int)(Util.getDouble(tsp.getVal()) * height / 100000.0);
        }
        return null;
    }

    public double getSpacingFactor() {
        if (this.spacingLineRule == STLineSpacingRule.AUTO && this.spacingFactor != null) {
            return this.spacingFactor;
        }
        return 1.0;
    }

    public int getAfter() {
        if (this.spacingAfter != null) {
            return this.spacingAfter;
        }
        return 0;
    }

    public int getBefore() {
        if (this.spacingBefore != null) {
            return this.spacingBefore;
        }
        return 0;
    }

    public int getLine() {
        if (this.spacingLine != null) {
            return this.spacingLine;
        }
        return 0;
    }

    public STLineSpacingRule.Enum getLineRule() {
        return this.spacingLineRule;
    }

    public String toString() {
        return "Spacing{spacingAfter=" + this.spacingAfter + ", spacingLine=" + this.spacingLine + ", spacingBefore=" + this.spacingBefore + ", spacingFactor=" + this.spacingFactor + ", spacingLineRule=" + String.valueOf(this.spacingLineRule) + ", contextBefore=" + String.valueOf(this.contextBefore) + ", contextAfter=" + String.valueOf(this.contextAfter) + "}";
    }

    public double calcLineOffset(double lineHeight) {
        return this.getSpacingFactor() * lineHeight;
    }

    public Spacing getContextBefore() {
        if (this.contextBefore == null) {
            this.contextBefore = new Spacing(this);
            this.contextBefore.spacingBefore = 0;
        }
        return this.contextBefore;
    }

    public Spacing getContextAfter() {
        if (this.contextAfter == null) {
            this.contextAfter = new Spacing(this);
            this.contextAfter.spacingAfter = 0;
        }
        return this.contextAfter;
    }

    public static Spacing getDefaultSpacing() {
        return new Spacing();
    }

    public static Spacing mergeSpacing(Spacing primSpacing, Spacing secSpacing) {
        if (primSpacing == null) {
            return secSpacing;
        }
        if (secSpacing == null) {
            return primSpacing;
        }
        Spacing spMix = new Spacing();
        if (primSpacing.spacingLine != null) {
            spMix.spacingLine = primSpacing.spacingLine;
            spMix.spacingFactor = primSpacing.spacingFactor;
        } else {
            spMix.spacingLine = secSpacing.spacingLine;
            spMix.spacingFactor = secSpacing.spacingFactor;
        }
        spMix.spacingAfter = primSpacing.spacingAfter != null ? primSpacing.spacingAfter : secSpacing.spacingAfter;
        spMix.spacingBefore = primSpacing.spacingBefore != null ? primSpacing.spacingBefore : secSpacing.spacingBefore;
        spMix.contextBefore = primSpacing.contextBefore != null ? primSpacing.contextBefore : secSpacing.contextBefore;
        spMix.contextAfter = primSpacing.contextAfter != null ? primSpacing.contextAfter : secSpacing.contextAfter;
        spMix.spacingLineRule = primSpacing.spacingLineRule != null ? primSpacing.spacingLineRule : secSpacing.spacingLineRule;
        return spMix;
    }
}

