/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.document.elements.style;

import com.inet.docx.document.DocumentProperties;
import com.inet.docx.document.elements.style.LineProperties;
import com.inet.docx.document.elements.style.LineStyle;
import com.inet.docx.document.elements.style.ParagraphAndRunStyle;
import com.inet.docx.document.elements.style.RenderFont;
import com.inet.docx.document.utilities.Util;
import com.inet.docx.xwpf.usermodel.XWPFStyleDefaults;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.poi.xssf.model.ThemesTable;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.openxmlformats.schemas.drawingml.x2006.main.CTLineProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextBody;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextCharacterProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextFont;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextParagraph;
import org.openxmlformats.schemas.drawingml.x2006.main.STTextCapsType;
import org.openxmlformats.schemas.officeDocument.x2006.sharedTypes.STVerticalAlignRun;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBooleanProperty;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFont;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTUnderlineProperty;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTVerticalAlignFontProperty;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STUnderlineValues;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTColor;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHighlight;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHpsMeasure;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTOnOff;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTParaRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTShd;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSignedHpsMeasure;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSignedTwipsMeasure;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTString;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTextScale;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTUnderline;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTVerticalAlignRun;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STUnderline;

public class RunRenderInformations {
    public static final Color AUTO = new Color(0);
    private static final RunRenderInformations EMPTY = new RunRenderInformations(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    public static final RunRenderInformations DEFAULT = new RunRenderInformations(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    private Float fontSize;
    private Float spacing;
    private String fontName;
    private Color fontColor;
    private Color fontBackgroundColor;
    private Boolean bold;
    private Boolean italic;
    private Boolean caps;
    private Boolean smallCaps;
    private Boolean vanish;
    private LineProperties underline;
    private Boolean strikethrough;
    private STVerticalAlignRun.Enum vertAlign;
    private Float textScale;
    private Integer textVerticalPosition;

    private static RunRenderInformations createDefault() {
        return new RunRenderInformations(Float.valueOf(11.0f), "Calibri", null, Float.valueOf(0.0f), null, null, null, null, null, null, null, null, null, null, null);
    }

    private RunRenderInformations(Float fontSize, String fontName, Color fontColor, Float spacing, Color fontBackgroundColor, Boolean bold, Boolean italic, Boolean caps, Boolean smallCaps, Boolean vanish, LineProperties underline, Boolean strikethrough, STVerticalAlignRun.Enum vertAlign, Float textScale, Integer textVerticalPosition) {
        this.fontSize = fontSize;
        this.fontName = fontName;
        this.fontColor = fontColor;
        this.spacing = spacing;
        this.fontBackgroundColor = fontBackgroundColor;
        this.bold = bold;
        this.italic = italic;
        this.caps = caps;
        this.smallCaps = smallCaps;
        this.vanish = vanish;
        this.underline = underline;
        this.strikethrough = strikethrough;
        this.vertAlign = vertAlign;
        this.textScale = textScale;
        this.textVerticalPosition = textVerticalPosition;
    }

    public Float getFontSpacing() {
        return this.spacing;
    }

    public Float getFontSize() {
        return this.fontSize;
    }

    public String getFontName() {
        return this.fontName;
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public Color getFontBackgroundColor() {
        return this.fontBackgroundColor;
    }

    public Boolean getBold() {
        return this.bold;
    }

    public Boolean getItalic() {
        return this.italic;
    }

    public Boolean getCaps() {
        return this.caps;
    }

    public Boolean getSmallCaps() {
        return this.smallCaps;
    }

    public boolean isUppercase() {
        return this.caps != null && this.caps != false;
    }

    public Boolean getVanish() {
        return this.vanish;
    }

    public LineProperties getUnderline() {
        return this.underline;
    }

    public Boolean getStrikethrough() {
        return this.strikethrough;
    }

    public STVerticalAlignRun.Enum getVerticalAlign() {
        return this.vertAlign;
    }

    public Float getTextScale() {
        return this.textScale;
    }

    public Integer getVerticalPosition() {
        return this.textVerticalPosition;
    }

    public RenderFont createFont(DocumentProperties docProps) {
        return this.createFont(docProps.getStandardStyleFont());
    }

    public RenderFont createFont(ParagraphAndRunStyle defaults) {
        String fn = this.getValue(this.fontName, defaults.getFontName(), defaults.getDefaultStyle().getFontName());
        float fs = this.getValue(this.fontSize, defaults.getFontSize(), defaults.getDefaultStyle().getFontSize()).floatValue();
        int fontStyle = 0;
        if (RunRenderInformations.value(this.bold, defaults.getBold(), defaults.getDefaultStyle().getBold())) {
            fontStyle = 1;
        }
        if (RunRenderInformations.value(this.italic, defaults.getItalic(), defaults.getDefaultStyle().getItalic())) {
            fontStyle += 2;
        }
        LineProperties underl = RunRenderInformations.mergeLineProperties(this.underline, defaults.getUnderline());
        boolean striket = RunRenderInformations.value(this.strikethrough, defaults.getStrikethrough(), defaults.getDefaultStyle().getStrikethrough());
        boolean vanishFlag = RunRenderInformations.value(this.vanish, defaults.getVanish(), defaults.getDefaultStyle().getVanish());
        boolean smallCapsFlag = RunRenderInformations.value(this.smallCaps, defaults.getSmallCaps(), defaults.getDefaultStyle().getSmallCaps());
        float fspacing = Util.getFloat(this.getValue(this.spacing, defaults.getFontSpacing(), defaults.getDefaultStyle().getFontSpacing()));
        Float fscale = this.textScale != null ? this.textScale : defaults.getTextScale();
        float ftextScale = fscale != null ? fscale.floatValue() : 1.0f;
        int verticalOffset = this.textVerticalPosition != null ? this.textVerticalPosition : 0;
        RenderFont rf = new RenderFont(fn, fs, fontStyle, underl, striket, vanishFlag, smallCapsFlag, fspacing, ftextScale, verticalOffset);
        if (this.vertAlign != null) {
            rf.setVerticalAlign(this.vertAlign);
        }
        return rf;
    }

    private Float getValue(Float primary, Float secondary, Float defaultFlt) {
        if (primary != null) {
            return primary;
        }
        if (secondary != null) {
            return secondary;
        }
        return defaultFlt;
    }

    private String getValue(String primary, String secondary, String defaultStr) {
        if (primary != null) {
            return primary;
        }
        if (secondary != null) {
            return secondary;
        }
        return defaultStr;
    }

    private static boolean value(Boolean prim, Boolean sec, Boolean terz) {
        Boolean val = RunRenderInformations.mergeBooleanValues(prim, sec);
        return (val = RunRenderInformations.mergeBooleanValues(val, terz)) != null ? val : false;
    }

    public static RunRenderInformations getDefault(XWPFStyleDefaults styleDefaults) {
        if (styleDefaults == null) {
            return RunRenderInformations.createDefault();
        }
        return new RunRenderInformations(Float.valueOf(styleDefaults.getDefaultFontSize()), styleDefaults.getMinorLatinFont(), null, Float.valueOf(0.0f), null, null, null, null, null, null, null, null, null, null, null);
    }

    public static boolean handleFontColor(RunRenderInformations rri, CTFont font, ThemesTable tableThemes) {
        if (font.sizeOfColorArray() > 0) {
            rri.fontColor = Util.convertCtColor(font.getColorArray(0), tableThemes);
            return true;
        }
        return false;
    }

    public static boolean handleUnderline(RunRenderInformations rri, CTFont font) {
        if (font.sizeOfUArray() > 0) {
            CTUnderlineProperty ulp = font.getUArray(0);
            if (ulp.getVal() == STUnderlineValues.SINGLE || ulp.getVal() == STUnderlineValues.SINGLE_ACCOUNTING) {
                rri.underline = new LineProperties(Color.BLACK, LineStyle.SINGLE, false, 10, 0.0);
            } else if (ulp.getVal() == STUnderlineValues.DOUBLE || ulp.getVal() == STUnderlineValues.DOUBLE_ACCOUNTING) {
                rri.underline = new LineProperties(Color.BLACK, LineStyle.DOUBLE, false, 30, 0.0);
            }
            return true;
        }
        return false;
    }

    public static boolean handleBold(RunRenderInformations rri, CTFont font, Boolean boldDefault) {
        if (font.sizeOfBArray() > 0) {
            CTBooleanProperty bold = font.getBArray(0);
            rri.bold = bold.getVal();
            return true;
        }
        if (boldDefault != null) {
            rri.bold = boldDefault;
        }
        return false;
    }

    public static boolean handleItalic(RunRenderInformations rri, CTFont font, Boolean italicDefault) {
        if (font.sizeOfIArray() > 0) {
            CTBooleanProperty italic = font.getIArray(0);
            rri.italic = italic.getVal();
            return true;
        }
        if (italicDefault != null) {
            rri.italic = italicDefault;
        }
        return false;
    }

    public static boolean handleStrikeout(RunRenderInformations rri, CTFont font, Boolean strikeoutDefault) {
        if (font.sizeOfStrikeArray() > 0) {
            CTBooleanProperty strikeout = font.getStrikeArray(0);
            rri.strikethrough = strikeout.getVal();
            return true;
        }
        if (strikeoutDefault != null) {
            rri.strikethrough = strikeoutDefault;
        }
        return false;
    }

    public static RunRenderInformations createRenderInformations(XSSFFont fontDef, ThemesTable tableThemes) {
        STVerticalAlignRun.Enum vertAlign = null;
        CTFont ctFont = fontDef.getCTFont();
        List vertAlignList = ctFont.getVertAlignList();
        if (vertAlignList.size() > 0) {
            if ("superscript".equals(((CTVerticalAlignFontProperty)vertAlignList.get(0)).toString())) {
                vertAlign = STVerticalAlignRun.SUPERSCRIPT;
            } else if ("subscript".equals(((CTVerticalAlignFontProperty)vertAlignList.get(0)).toString())) {
                vertAlign = STVerticalAlignRun.SUBSCRIPT;
            } else if ("baseline".equals(((CTVerticalAlignFontProperty)vertAlignList.get(0)).toString())) {
                vertAlign = STVerticalAlignRun.BASELINE;
            }
        }
        RunRenderInformations rri = new RunRenderInformations(Float.valueOf(fontDef.getFontHeightInPoints()), fontDef.getFontName(), null, Float.valueOf(0.0f), null, null, null, null, null, null, null, null, vertAlign, null, null);
        RunRenderInformations.handleFontColor(rri, ctFont, tableThemes);
        RunRenderInformations.handleUnderline(rri, ctFont);
        RunRenderInformations.handleBold(rri, ctFont, Boolean.FALSE);
        RunRenderInformations.handleItalic(rri, ctFont, Boolean.FALSE);
        RunRenderInformations.handleStrikeout(rri, ctFont, Boolean.FALSE);
        return rri;
    }

    public static RunRenderInformations mergeRenderInformations(RunRenderInformations primaryRenderInfos, ParagraphAndRunStyle secondaryRenderInfos) {
        if (secondaryRenderInfos != null) {
            String fontName = primaryRenderInfos.getFontName() != null ? primaryRenderInfos.getFontName() : secondaryRenderInfos.getFontName();
            Float fontSize = RunRenderInformations.mergeFloatValues(primaryRenderInfos.getFontSize(), secondaryRenderInfos.getFontSize());
            Float spacing = RunRenderInformations.mergeFloatValues(primaryRenderInfos.getFontSpacing(), secondaryRenderInfos.getFontSpacing());
            Boolean bold = RunRenderInformations.mergeBooleanValues(primaryRenderInfos.getBold(), secondaryRenderInfos.getBold());
            Boolean italic = RunRenderInformations.mergeBooleanValues(primaryRenderInfos.getItalic(), secondaryRenderInfos.getItalic());
            Boolean caps = RunRenderInformations.mergeBooleanValues(primaryRenderInfos.getCaps(), secondaryRenderInfos.getCaps());
            Boolean smallCaps = RunRenderInformations.mergeBooleanValues(primaryRenderInfos.getSmallCaps(), secondaryRenderInfos.getSmallCaps());
            Boolean vanish = RunRenderInformations.mergeBooleanValues(primaryRenderInfos.getVanish(), secondaryRenderInfos.getVanish());
            LineProperties underline = RunRenderInformations.mergeLineProperties(primaryRenderInfos.getUnderline(), secondaryRenderInfos.getUnderline());
            Boolean strikethrough = RunRenderInformations.mergeBooleanValues(primaryRenderInfos.getStrikethrough(), secondaryRenderInfos.getStrikethrough());
            Color fontBackgroundColor = RunRenderInformations.mergeColorValues(primaryRenderInfos.getFontBackgroundColor(), secondaryRenderInfos.getFontBackgroundColor());
            Color fontColor = RunRenderInformations.mergeColorValues(primaryRenderInfos.getFontColor(), secondaryRenderInfos.getFontColor());
            STVerticalAlignRun.Enum vertAlign = primaryRenderInfos.getVerticalAlign() != null ? primaryRenderInfos.getVerticalAlign() : secondaryRenderInfos.getVerticalAlign();
            Float textScale = primaryRenderInfos.getTextScale() != null ? primaryRenderInfos.getTextScale() : secondaryRenderInfos.getTextScale();
            Integer textVerticalPosition = primaryRenderInfos.getVerticalPosition() != null ? primaryRenderInfos.getVerticalPosition() : secondaryRenderInfos.getVerticalPosition();
            return new RunRenderInformations(fontSize, fontName, fontColor, spacing, fontBackgroundColor, bold, italic, caps, smallCaps, vanish, underline, strikethrough, vertAlign, textScale, textVerticalPosition);
        }
        return primaryRenderInfos;
    }

    public static RunRenderInformations mergeRenderInformations(ParagraphAndRunStyle primaryFontStyle, ParagraphAndRunStyle secondaryFontStyle) {
        if (primaryFontStyle == null) {
            return secondaryFontStyle.getTextRenderInformations();
        }
        if (secondaryFontStyle == null) {
            return primaryFontStyle.getTextRenderInformations();
        }
        String fontName = primaryFontStyle.getFontName() != null ? primaryFontStyle.getFontName() : secondaryFontStyle.getFontName();
        Float fontSize = RunRenderInformations.mergeFloatValues(primaryFontStyle.getFontSize(), secondaryFontStyle.getFontSize());
        Float spacing = RunRenderInformations.mergeFloatValues(primaryFontStyle.getFontSpacing(), secondaryFontStyle.getFontSpacing());
        Boolean bold = RunRenderInformations.mergeBooleanValues(primaryFontStyle.getBold(), secondaryFontStyle.getBold());
        Boolean italic = RunRenderInformations.mergeBooleanValues(primaryFontStyle.getItalic(), secondaryFontStyle.getItalic());
        Boolean caps = RunRenderInformations.mergeBooleanValues(primaryFontStyle.getCaps(), secondaryFontStyle.getCaps());
        Boolean smallCaps = RunRenderInformations.mergeBooleanValues(primaryFontStyle.getSmallCaps(), secondaryFontStyle.getSmallCaps());
        Boolean vanish = RunRenderInformations.mergeBooleanValues(primaryFontStyle.getVanish(), secondaryFontStyle.getVanish());
        LineProperties underline = RunRenderInformations.mergeLineProperties(primaryFontStyle.getUnderline(), secondaryFontStyle.getUnderline());
        Boolean strikethrough = RunRenderInformations.mergeBooleanValues(primaryFontStyle.getStrikethrough(), secondaryFontStyle.getStrikethrough());
        Color fontBackgroundColor = RunRenderInformations.mergeColorValues(primaryFontStyle.getFontBackgroundColor(), secondaryFontStyle.getFontBackgroundColor());
        Color fontColor = RunRenderInformations.mergeColorValues(primaryFontStyle.getFontColor(), secondaryFontStyle.getFontColor());
        STVerticalAlignRun.Enum vertAlign = primaryFontStyle.getVerticalAlign() != null ? primaryFontStyle.getVerticalAlign() : secondaryFontStyle.getVerticalAlign();
        Float textScale = primaryFontStyle.getTextScale() != null ? primaryFontStyle.getTextScale() : secondaryFontStyle.getTextScale();
        Integer textVerticalPosition = primaryFontStyle.getVerticalPosition() != null ? primaryFontStyle.getVerticalPosition() : secondaryFontStyle.getVerticalPosition();
        return new RunRenderInformations(fontSize, fontName, fontColor, spacing, fontBackgroundColor, bold, italic, caps, smallCaps, vanish, underline, strikethrough, vertAlign, textScale, textVerticalPosition);
    }

    public static RunRenderInformations mergeRenderInformations(ParagraphAndRunStyle pimaeryRenderInfos, RunRenderInformations secondaryRenderInfos) {
        if (secondaryRenderInfos != null) {
            String fontName = pimaeryRenderInfos.getFontName() != null ? pimaeryRenderInfos.getFontName() : secondaryRenderInfos.getFontName();
            Float fontSize = RunRenderInformations.mergeFloatValues(pimaeryRenderInfos.getFontSize(), secondaryRenderInfos.getFontSize());
            Float spacing = RunRenderInformations.mergeFloatValues(pimaeryRenderInfos.getFontSpacing(), secondaryRenderInfos.getFontSpacing());
            Boolean bold = RunRenderInformations.mergeBooleanValues(pimaeryRenderInfos.getBold(), secondaryRenderInfos.getBold());
            Boolean italic = RunRenderInformations.mergeBooleanValues(pimaeryRenderInfos.getItalic(), secondaryRenderInfos.getItalic());
            Boolean caps = RunRenderInformations.mergeBooleanValues(pimaeryRenderInfos.getCaps(), secondaryRenderInfos.getCaps());
            Boolean smallCaps = RunRenderInformations.mergeBooleanValues(pimaeryRenderInfos.getSmallCaps(), secondaryRenderInfos.getSmallCaps());
            Boolean vanish = RunRenderInformations.mergeBooleanValues(pimaeryRenderInfos.getVanish(), secondaryRenderInfos.getVanish());
            LineProperties underline = RunRenderInformations.mergeLineProperties(pimaeryRenderInfos.getUnderline(), secondaryRenderInfos.getUnderline());
            Boolean strikethrough = RunRenderInformations.mergeBooleanValues(pimaeryRenderInfos.getStrikethrough(), secondaryRenderInfos.getStrikethrough());
            Color fontBackgroundColor = RunRenderInformations.mergeColorValues(pimaeryRenderInfos.getFontBackgroundColor(), secondaryRenderInfos.getFontBackgroundColor());
            Color fontColor = RunRenderInformations.mergeColorValues(pimaeryRenderInfos.getFontColor(), secondaryRenderInfos.getFontColor());
            STVerticalAlignRun.Enum vertAlign = pimaeryRenderInfos.getVerticalAlign() != null ? pimaeryRenderInfos.getVerticalAlign() : secondaryRenderInfos.getVerticalAlign();
            Float textScale = pimaeryRenderInfos.getTextScale() != null ? pimaeryRenderInfos.getTextScale() : secondaryRenderInfos.getTextScale();
            Integer textVerticalPosition = pimaeryRenderInfos.getVerticalPosition() != null ? pimaeryRenderInfos.getVerticalPosition() : secondaryRenderInfos.getVerticalPosition();
            return new RunRenderInformations(fontSize, fontName, fontColor, spacing, fontBackgroundColor, bold, italic, caps, smallCaps, vanish, underline, strikethrough, vertAlign, textScale, textVerticalPosition);
        }
        return pimaeryRenderInfos.getTextRenderInformations();
    }

    public static RunRenderInformations mergeRenderInformations(RunRenderInformations primaeryRenderInfos, RunRenderInformations secondaryRenderInfos) {
        if (secondaryRenderInfos != null) {
            String fontName = primaeryRenderInfos.getFontName() != null ? primaeryRenderInfos.getFontName() : secondaryRenderInfos.getFontName();
            Float fontSize = RunRenderInformations.mergeFloatValues(primaeryRenderInfos.getFontSize(), secondaryRenderInfos.getFontSize());
            Float spacing = RunRenderInformations.mergeFloatValues(primaeryRenderInfos.getFontSpacing(), secondaryRenderInfos.getFontSpacing());
            Boolean bold = RunRenderInformations.mergeBooleanValues(primaeryRenderInfos.getBold(), secondaryRenderInfos.getBold());
            Boolean italic = RunRenderInformations.mergeBooleanValues(primaeryRenderInfos.getItalic(), secondaryRenderInfos.getItalic());
            Boolean caps = RunRenderInformations.mergeBooleanValues(primaeryRenderInfos.getCaps(), secondaryRenderInfos.getCaps());
            Boolean smallCaps = RunRenderInformations.mergeBooleanValues(primaeryRenderInfos.getSmallCaps(), secondaryRenderInfos.getSmallCaps());
            Boolean vanish = RunRenderInformations.mergeBooleanValues(primaeryRenderInfos.getVanish(), secondaryRenderInfos.getVanish());
            LineProperties underline = RunRenderInformations.mergeLineProperties(primaeryRenderInfos.getUnderline(), secondaryRenderInfos.getUnderline());
            Boolean strikethrough = RunRenderInformations.mergeBooleanValues(primaeryRenderInfos.getStrikethrough(), secondaryRenderInfos.getStrikethrough());
            Color fontBackgroundColor = RunRenderInformations.mergeColorValues(primaeryRenderInfos.getFontBackgroundColor(), secondaryRenderInfos.getFontBackgroundColor());
            Color fontColor = RunRenderInformations.mergeColorValues(primaeryRenderInfos.getFontColor(), secondaryRenderInfos.getFontColor());
            STVerticalAlignRun.Enum vertAlign = primaeryRenderInfos.getVerticalAlign() != null ? primaeryRenderInfos.getVerticalAlign() : secondaryRenderInfos.getVerticalAlign();
            Float textScale = primaeryRenderInfos.getTextScale() != null ? primaeryRenderInfos.getTextScale() : secondaryRenderInfos.getTextScale();
            Integer textVerticalPosition = primaeryRenderInfos.getVerticalPosition() != null ? primaeryRenderInfos.getVerticalPosition() : secondaryRenderInfos.getVerticalPosition();
            return new RunRenderInformations(fontSize, fontName, fontColor, spacing, fontBackgroundColor, bold, italic, caps, smallCaps, vanish, underline, strikethrough, vertAlign, textScale, textVerticalPosition);
        }
        return primaeryRenderInfos;
    }

    public static RunRenderInformations getRenderInformations(CTTextBody txBody, HashMap<String, String> colorAiasMap, DocumentProperties docProps, RunRenderInformations defaultRenderInfo) {
        if (txBody != null) {
            CTTextParagraph para = (CTTextParagraph)txBody.getPList().get(0);
            return RunRenderInformations.getRenderInformations(para.getPPr().getDefRPr(), colorAiasMap, docProps, defaultRenderInfo);
        }
        return defaultRenderInfo;
    }

    public static RunRenderInformations getRenderInformations(CTTextCharacterProperties tchp, HashMap<String, String> colorAiasMap, DocumentProperties docProps, RunRenderInformations defaultRenderInfo) {
        if (tchp != null) {
            CTTextFont tf = tchp.getLatin();
            String fontName = tf != null ? docProps.handleFontKeys(tf.getTypeface()) : null;
            Color fontColor = Util.getColorFromSolidFill(tchp.getSolidFill(), docProps, colorAiasMap);
            Float fontSize = tchp.isSetSz() ? Float.valueOf(tchp.getSz() / 100) : null;
            Boolean bold = tchp.isSetB() ? Boolean.valueOf(tchp.getB()) : null;
            Boolean italic = tchp.isSetI() ? Boolean.valueOf(tchp.getI()) : null;
            Float spacing = tchp.isSetKern() ? Float.valueOf(tchp.getKern()) : null;
            Boolean caps = null;
            Boolean smallCaps = null;
            if (tchp.isSetCap()) {
                STTextCapsType.Enum capType = tchp.getCap();
                if (capType == STTextCapsType.ALL) {
                    caps = Boolean.TRUE;
                    smallCaps = Boolean.FALSE;
                } else if (capType == STTextCapsType.SMALL) {
                    caps = Boolean.FALSE;
                    smallCaps = Boolean.TRUE;
                } else {
                    caps = smallCaps = Boolean.FALSE;
                }
            }
            LineProperties underline = RunRenderInformations.getUnderline(tchp.getULn(), docProps, colorAiasMap);
            RunRenderInformations rf = new RunRenderInformations(fontSize, fontName, fontColor, spacing, null, bold, italic, caps, smallCaps, null, underline, null, null, null, null);
            return RunRenderInformations.mergeRenderInformations(rf, defaultRenderInfo);
        }
        return defaultRenderInfo;
    }

    public static RunRenderInformations getRenderInformations(CTParaRPr paraRpr, DocumentProperties docProps) {
        if (paraRpr != null) {
            String fontName = docProps.getStyleDefaults().getFontName(Util.getLast(paraRpr.getRFontsArray()));
            Float fontSize = RunRenderInformations.getFontSize(Util.getLast(paraRpr.getSzArray()));
            Float spacing = RunRenderInformations.getFontSpacing(Util.getLast(paraRpr.getSpacingArray()));
            Boolean bold = RunRenderInformations.getSetting(Util.getLast(paraRpr.getBArray()));
            Boolean italic = RunRenderInformations.getSetting(Util.getLast(paraRpr.getIArray()));
            Boolean caps = RunRenderInformations.getSetting(Util.getLast(paraRpr.getCapsArray()));
            Boolean smallCaps = RunRenderInformations.getSetting(Util.getLast(paraRpr.getSmallCapsArray()));
            Boolean vanish = RunRenderInformations.getSetting(Util.getLast(paraRpr.getVanishArray()));
            LineProperties underline = RunRenderInformations.getUnderline(Util.getLast(paraRpr.getUArray()));
            Boolean strikethrough = RunRenderInformations.getSetting(Util.getLast(paraRpr.getStrikeArray()));
            Color fontBackgroundColor = RunRenderInformations.getBackGroundColor(Util.getLast(paraRpr.getHighlightArray()), Util.getLast(paraRpr.getShdArray()));
            Color fontColor = RunRenderInformations.getFontColor(Util.getLast(paraRpr.getColorArray()));
            STVerticalAlignRun.Enum vAlign = RunRenderInformations.getVerticalAlign(Util.getLast(paraRpr.getVertAlignArray()));
            Float textScale = RunRenderInformations.getTextScale(Util.getLast(paraRpr.getWArray()));
            Integer textVerticalPositionTwips = RunRenderInformations.getTextPosition(Util.getLast(paraRpr.getPositionArray()));
            RunRenderInformations rf = new RunRenderInformations(fontSize, fontName, fontColor, spacing, fontBackgroundColor, bold, italic, caps, smallCaps, vanish, underline, strikethrough, vAlign, textScale, textVerticalPositionTwips);
            return RunRenderInformations.checkForRunStyle(rf, Util.getLast(paraRpr.getRStyleArray()), docProps);
        }
        return EMPTY;
    }

    public static RunRenderInformations getEmpty() {
        return EMPTY;
    }

    public static RunRenderInformations getRenderInformations(@Nullable CTRPr ctrpr, DocumentProperties docProps) {
        if (ctrpr != null) {
            String fontName = docProps.getStyleDefaults().getFontName(Util.getLast(ctrpr.getRFontsArray()));
            Float fontSize = RunRenderInformations.getFontSize(Util.getLast(ctrpr.getSzArray()));
            Float spacing = RunRenderInformations.getFontSpacing(Util.getLast(ctrpr.getSpacingArray()));
            Boolean bold = RunRenderInformations.getSetting(Util.getLast(ctrpr.getBArray()));
            Boolean italic = RunRenderInformations.getSetting(Util.getLast(ctrpr.getIArray()));
            Boolean caps = RunRenderInformations.getSetting(Util.getLast(ctrpr.getCapsArray()));
            Boolean smallCaps = RunRenderInformations.getSetting(Util.getLast(ctrpr.getSmallCapsArray()));
            Boolean vanish = RunRenderInformations.getSetting(Util.getLast(ctrpr.getVanishArray()));
            Boolean strikethrough = RunRenderInformations.getSetting(Util.getLast(ctrpr.getStrikeArray()));
            LineProperties underline = RunRenderInformations.getUnderline(Util.getLast(ctrpr.getUArray()));
            Color fontBackgroundColor = RunRenderInformations.getBackGroundColor(Util.getLast(ctrpr.getHighlightArray()), Util.getLast(ctrpr.getShdArray()));
            Color fontColor = RunRenderInformations.getFontColor(Util.getLast(ctrpr.getColorArray()));
            STVerticalAlignRun.Enum vertAlign = RunRenderInformations.getVerticalAlign(Util.getLast(ctrpr.getVertAlignArray()));
            Float textScale = RunRenderInformations.getTextScale(Util.getLast(ctrpr.getWArray()));
            Integer textVerticalPositionTwips = RunRenderInformations.getTextPosition(Util.getLast(ctrpr.getPositionArray()));
            RunRenderInformations rf = new RunRenderInformations(fontSize, fontName, fontColor, spacing, fontBackgroundColor, bold, italic, caps, smallCaps, vanish, underline, strikethrough, vertAlign, textScale, textVerticalPositionTwips);
            return RunRenderInformations.checkForRunStyle(rf, Util.getLast(ctrpr.getRStyleArray()), docProps);
        }
        return EMPTY;
    }

    private static Integer getTextPosition(CTSignedHpsMeasure position) {
        if (position != null) {
            return Util.getInt(position.getVal()) * 10;
        }
        return null;
    }

    private static Float getTextScale(CTTextScale tScale) {
        if (tScale != null) {
            return Float.valueOf((float)Util.getDouble(tScale.getVal()) / 100.0f);
        }
        return null;
    }

    private static LineProperties getUnderline(CTLineProperties underl, DocumentProperties docProps, HashMap<String, String> colorAiasMap) {
        if (underl != null) {
            Color color = Util.getColorFromSolidFill(underl.getSolidFill(), docProps, colorAiasMap);
            return new LineProperties(color, LineStyle.SINGLE, false, 10, 0.0);
        }
        return null;
    }

    private static LineProperties getUnderline(CTUnderline underl) {
        if (underl != null) {
            STUnderline.Enum style = underl.getVal();
            if (STUnderline.NONE.equals(style)) {
                return LineProperties.EMPTY_LINE;
            }
            String lineStyle = style != null ? style.toString() : "single";
            Color color = RunRenderInformations.getColor(underl.getColor());
            return new LineProperties(color, lineStyle, 0, 0.0);
        }
        return null;
    }

    private static RunRenderInformations checkForRunStyle(RunRenderInformations rf, CTString style, DocumentProperties docProps) {
        if (style != null) {
            ParagraphAndRunStyle sf = docProps.getStyleFont(style.getVal());
            return RunRenderInformations.mergeRenderInformations(rf, sf);
        }
        return rf;
    }

    private static STVerticalAlignRun.Enum getVerticalAlign(CTVerticalAlignRun var) {
        if (var != null) {
            return var.getVal();
        }
        return null;
    }

    private static Color getFontColor(CTColor ctCol) {
        if (ctCol != null) {
            return RunRenderInformations.getColor(ctCol.getVal());
        }
        return null;
    }

    private static Color getColor(Object value) {
        if (value instanceof byte[]) {
            byte[] col = (byte[])value;
            return new Color(col[0] & 0xFF, col[1] & 0xFF, col[2] & 0xFF);
        }
        if (value instanceof String && value.equals("auto")) {
            return AUTO;
        }
        return null;
    }

    private static Color getBackGroundColor(CTHighlight fontBg, CTShd shade) {
        if (fontBg != null) {
            return Util.getColorByName(fontBg);
        }
        if (shade != null && shade.isSetFill()) {
            return Util.getColorFromObject(shade.getFill(), null);
        }
        return null;
    }

    private static Boolean getSetting(CTOnOff value) {
        if (value != null) {
            return Util.getBool(value.getVal(), true);
        }
        return null;
    }

    private static Float getFontSpacing(CTSignedTwipsMeasure spacing) {
        if (spacing != null) {
            return Float.valueOf(Util.getFloat(spacing.getVal()));
        }
        return null;
    }

    private static Float getFontSize(CTHpsMeasure size) {
        if (size != null) {
            return Float.valueOf(Util.getFloat(size.getVal()) / 2.0f);
        }
        return null;
    }

    private static LineProperties mergeLineProperties(LineProperties prim, LineProperties sec) {
        if (prim != null) {
            return prim;
        }
        if (sec != null) {
            return sec;
        }
        return null;
    }

    private static Boolean mergeBooleanValues(Boolean prim, Boolean sec) {
        if (prim != null) {
            return prim;
        }
        if (sec != null) {
            return sec;
        }
        return null;
    }

    private static Color mergeColorValues(Color prim, Color sec) {
        if (prim != null) {
            return prim;
        }
        if (sec != null) {
            return sec;
        }
        return null;
    }

    private static Float mergeFloatValues(Float prim, Float sec) {
        if (prim != null) {
            return prim;
        }
        if (sec != null) {
            return sec;
        }
        return null;
    }

    public static void resetFontName(RunRenderInformations ri, String fontName) {
        ri.fontName = fontName;
    }
}

