/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.document;

import com.inet.docx.document.DocumentProperties;
import com.inet.docx.document.Section;
import com.inet.docx.document.elements.DocumentElement;
import com.inet.docx.document.elements.subelements.EmptyRow;
import com.inet.docx.document.elements.subelements.Field;
import com.inet.docx.document.elements.subelements.FieldPart;
import com.inet.docx.document.elements.subelements.ParagraphElement;
import com.inet.docx.document.elements.subelements.drawing.Anchor;
import com.inet.docx.document.paragraph.ParagraphData;
import com.inet.docx.document.paragraph.ParagraphFactory;
import com.inet.docx.document.table.TableFactory;
import com.inet.docx.document.utilities.Util;
import com.inet.docx.layout.DocumentLayouter;
import com.inet.docx.view.PageProperties;
import com.inet.docx.view.RenderPage;
import com.inet.docx.xwpf.XWPFDocumentOwnImpl;
import com.inet.docx.xwpf.XWPFUtilities;
import com.inet.docx.xwpf.usermodel.XWPFSDTimpl;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.imageio.ImageIO;
import org.apache.poi.hemf.usermodel.HemfPicture;
import org.apache.poi.ooxml.POIXMLDocumentPart;
import org.apache.poi.openxml4j.opc.PackagePartName;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.ISDTContent;
import org.apache.poi.xwpf.usermodel.XWPFHeader;
import org.apache.poi.xwpf.usermodel.XWPFHeaderFooter;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFPictureData;
import org.apache.poi.xwpf.usermodel.XWPFSDT;
import org.apache.poi.xwpf.usermodel.XWPFSDTContent;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.officeDocument.x2006.sharedTypes.STXAlign;
import org.openxmlformats.schemas.officeDocument.x2006.sharedTypes.STYAlign;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtContentRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblPPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STFldCharType;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STHAnchor;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STVAnchor;

public class DocumentAnalyzer {
    private DocumentProperties documentProperties;
    private List<RenderPage> pages;

    public DocumentAnalyzer(XWPFDocumentOwnImpl doc) {
        this.documentProperties = new DocumentProperties(doc);
        List<Section> sections = this.readSections(doc);
        this.pages = DocumentLayouter.splitPages(sections, this.documentProperties);
        this.documentProperties.close();
    }

    private List<Section> readSections(XWPFDocumentOwnImpl doc) {
        Set<String> keys = doc.getHeaderFooterKeys();
        for (String key : keys) {
            XWPFHeaderFooter hfValue = doc.getHeaderFooter(key);
            this.addImagesToCache((POIXMLDocumentPart)hfValue);
            List<DocumentElement> elements = this.fetchData(XWPFUtilities.getBodyElements(hfValue), hfValue.getOwner().getPackagePart().getPartName());
            for (DocumentElement ele : elements) {
                if (!(ele instanceof ParagraphData)) continue;
                while (((ParagraphData)ele).handleFields(this.documentProperties) != null) {
                }
            }
            this.documentProperties.addHeaderFooter(hfValue instanceof XWPFHeader, key, elements);
        }
        this.addImagesToCache((POIXMLDocumentPart)doc);
        List<DocumentElement> docElements = this.fetchData(doc.getBodyElements(), doc.getPackagePart().getPartName());
        List<Section> listPageParts = this.extractParts(docElements, this.documentProperties.getDefaultDocumentPageProperties());
        return listPageParts;
    }

    private void addImagesToCache(POIXMLDocumentPart documentPart) {
        for (POIXMLDocumentPart.RelationPart relation : documentPart.getRelationParts()) {
            POIXMLDocumentPart internDocPart = relation.getDocumentPart();
            if (!(internDocPart instanceof XWPFPictureData)) continue;
            String id = relation.getRelationship().getId() + "_" + String.valueOf(relation.getRelationship().getSource().getPartName());
            XWPFPictureData pictureData = (XWPFPictureData)internDocPart;
            byte[] data = pictureData.getData();
            this.documentProperties.putImageData(id, this.getImage(pictureData), data);
        }
    }

    public BufferedImage getImage(XWPFPictureData picData) {
        if (picData == null) {
            Util.LOGGER.warn((Object)"Docx Document has no Image data available!");
            return null;
        }
        if (picData.getPictureTypeEnum() == null) {
            Util.LOGGER.warn((Object)"Unknown image type in docx document");
            return null;
        }
        Object error = null;
        BufferedImage image = null;
        switch (picData.getPictureTypeEnum()) {
            case EMF: {
                try {
                    HemfPicture imageEmf = new HemfPicture((InputStream)new ByteArrayInputStream(picData.getData()));
                    Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, imageEmf.getSize().getWidth(), imageEmf.getSize().getHeight());
                    image = new BufferedImage((int)((RectangularShape)rect).getWidth(), (int)((RectangularShape)rect).getHeight(), 2);
                    imageEmf.draw(image.createGraphics(), (Rectangle2D)rect);
                }
                catch (Exception e) {
                    Util.LOGGER.error((Throwable)e);
                    error = e.getClass().getSimpleName() + ": " + e.getMessage();
                }
                break;
            }
            case JPEG: 
            case PNG: 
            case GIF: 
            case TIFF: 
            case BMP: {
                try {
                    image = ImageIO.read(new ByteArrayInputStream(picData.getData()));
                }
                catch (IOException e) {
                    Util.LOGGER.error((Throwable)e);
                    error = e.getClass().getSimpleName() + ": " + e.getMessage();
                }
                break;
            }
            case WMF: {
                error = "Unsupported Image Type WMF";
                break;
            }
            case PICT: {
                error = "Unsupported Image Type PICT";
                break;
            }
            case DIB: {
                error = "Unsupported Image Type DIB";
                break;
            }
            case EPS: {
                error = "Unsupported Image Type EPS";
                break;
            }
            case WPG: {
                error = "Unsupported Image Type WPG";
            }
        }
        if (image == null) {
            try {
                image = ImageIO.read(new ByteArrayInputStream(picData.getData()));
            }
            catch (Exception e) {
                error = "Unknow image type in docx for " + picData.getPictureType() + " " + String.valueOf(e);
            }
        }
        if (error != null) {
            Util.LOGGER.warn(error);
            int errorImageSize = 350;
            image = new BufferedImage(errorImageSize, errorImageSize, 6);
            Graphics g = image.getGraphics();
            g.setColor(Color.YELLOW);
            g.fillRect(0, 0, errorImageSize, errorImageSize);
            g.setColor(Color.RED);
            g.setFont(new Font("Arial", 1, 20));
            g.drawString((String)error, 10, 20);
        }
        return image;
    }

    public List<RenderPage> getPages() {
        return this.pages;
    }

    public Object getValue(Field.FieldNames key) {
        return this.documentProperties.getValue(key);
    }

    public static void handleGroups(List<DocumentElement> elements, List<ParagraphData> metaParagraphs, DocumentProperties documentProperties) {
        block0: for (DocumentElement element : elements) {
            ParagraphElement result;
            if (!(element instanceof ParagraphData)) continue;
            ParagraphData pd = (ParagraphData)element;
            while ((result = pd.handleFields(documentProperties)) != null) {
                if (!(result instanceof FieldPart)) continue;
                metaParagraphs.add(pd);
                continue block0;
            }
        }
        while (metaParagraphs.size() > 0) {
            ParagraphData startPara = DocumentAnalyzer.find(metaParagraphs, STFldCharType.BEGIN);
            ParagraphData endPara = DocumentAnalyzer.find(metaParagraphs, STFldCharType.END);
            if (startPara == null || endPara == null) {
                return;
            }
            metaParagraphs.remove(startPara);
            metaParagraphs.remove(endPara);
            ParagraphElement typeElement = DocumentAnalyzer.handleStartParagraph(startPara);
            DocumentAnalyzer.handleEndParagraph(endPara);
        }
    }

    private static ParagraphElement handleStartParagraph(ParagraphData startPara) {
        ParagraphElement typeElement = null;
        FieldPart peBegin = DocumentAnalyzer.find(startPara, STFldCharType.BEGIN);
        FieldPart peSeparate = DocumentAnalyzer.find(startPara, STFldCharType.SEPARATE);
        int beginIndex = startPara.getElements().indexOf(peBegin);
        if (peSeparate != null) {
            int separateIndex = startPara.getElements().indexOf(peSeparate);
            int index = separateIndex - 1;
            while (index > beginIndex) {
                typeElement = startPara.getElements().get(index--);
                startPara.removeElement(typeElement);
            }
            startPara.removeElement(peSeparate);
        } else if (beginIndex < startPara.getElements().size() - 2) {
            typeElement = startPara.getElements().get(beginIndex + 1);
            startPara.removeElement(typeElement);
        }
        startPara.removeElement(peBegin);
        return typeElement;
    }

    private static void handleEndParagraph(ParagraphData endPara) {
        FieldPart pe = DocumentAnalyzer.find(endPara, STFldCharType.END);
        endPara.removeElement(pe);
        if (endPara.getElements().size() == 0) {
            endPara.addElement(new EmptyRow(pe.getRenderFont()));
        }
    }

    private static ParagraphData find(List<ParagraphData> metaParagraphs, STFldCharType.Enum toFind) {
        ParagraphData found = null;
        for (ParagraphData pd : metaParagraphs) {
            if (DocumentAnalyzer.find(pd, toFind) == null) continue;
            if (toFind == STFldCharType.END) {
                return pd;
            }
            found = pd;
        }
        return found;
    }

    private static FieldPart find(ParagraphData paragraph, STFldCharType.Enum toFind) {
        for (ParagraphElement pe : paragraph.getElements()) {
            if (!(pe instanceof FieldPart) || !toFind.equals(((FieldPart)pe).getTypeMarker())) continue;
            return (FieldPart)pe;
        }
        return null;
    }

    private Anchor analyseOffset(CTTblPPr tppr, boolean vertical) {
        int offSet;
        String anchorAlign;
        String reference;
        if (vertical) {
            STVAnchor.Enum vAnch = tppr.getVertAnchor();
            reference = vAnch != null ? vAnch.toString() : "page";
            STYAlign.Enum vAlign = tppr.getTblpYSpec();
            anchorAlign = vAlign != null ? vAlign.toString() : "top";
            offSet = Util.getInt(tppr.getTblpY());
        } else {
            STHAnchor.Enum hAnch = tppr.getHorzAnchor();
            reference = hAnch != null ? hAnch.toString() : "page";
            STXAlign.Enum hAlign = tppr.getTblpXSpec();
            anchorAlign = hAlign != null ? hAlign.toString() : "left";
            offSet = Util.getInt(tppr.getTblpX());
        }
        return new Anchor(reference, anchorAlign, (double)offSet, false, vertical);
    }

    private List<XWPFTableRow> getTableRowsFromSdt(List<CTSdtRow> sdtRows, XWPFTable table) {
        ArrayList<XWPFTableRow> rows = new ArrayList<XWPFTableRow>();
        for (int rowNumber = 0; rowNumber < sdtRows.size(); ++rowNumber) {
            CTSdtContentRow xmlRow = sdtRows.get(rowNumber).getSdtContent();
            XmlCursor cursor = xmlRow.newCursor();
            cursor.selectPath("./*");
            while (cursor.toNextSelection()) {
                XmlObject o = cursor.getObject();
                if (o instanceof CTRow) {
                    rows.add(new XWPFTableRow((CTRow)o, table));
                    continue;
                }
                Util.LOGGER.error((Object)("No table row: " + String.valueOf(o)));
            }
            cursor.dispose();
        }
        return rows;
    }

    private List<DocumentElement> fetchData(List<IBodyElement> elements, PackagePartName partName) {
        this.documentProperties.setCurrentPartName(partName.toString());
        ArrayList<DocumentElement> mainDocumentElements = new ArrayList<DocumentElement>();
        this.convertElements(elements, mainDocumentElements);
        return mainDocumentElements;
    }

    protected void convertElements(List<? extends Object> elements, List<DocumentElement> mainDocumentElements) {
        for (Object object : elements) {
            if (object instanceof XWPFParagraph) {
                DocumentElement lastElement;
                ParagraphData pa = ParagraphFactory.readParagraph(this.documentProperties, (XWPFParagraph)object, true, this.documentProperties.getStandardStyleFont());
                if (mainDocumentElements.size() > 0 && (lastElement = mainDocumentElements.get(mainDocumentElements.size() - 1)) instanceof ParagraphData) {
                    ParagraphData paraBefore = (ParagraphData)lastElement;
                    if (Boolean.TRUE.equals(pa.getContextualSpacing()) && pa.getStyleName().equals(paraBefore.getStyleName())) {
                        pa.setSpacing(pa.getSpacing().getContextBefore());
                        paraBefore.setSpacing(paraBefore.getSpacing().getContextAfter());
                    }
                }
                mainDocumentElements.add(pa);
                continue;
            }
            if (object instanceof XWPFTable) {
                mainDocumentElements.add(TableFactory.readTable((XWPFTable)object, this.documentProperties));
                continue;
            }
            if (object instanceof XWPFSDTimpl) {
                XWPFSDTimpl contentTable = (XWPFSDTimpl)((Object)object);
                List<IBodyElement> contentListe = contentTable.getBodyElements();
                for (IBodyElement contentEle : contentListe) {
                    ParagraphData pa = ParagraphFactory.readParagraph(this.documentProperties, (XWPFParagraph)contentEle, false, null);
                    mainDocumentElements.add(pa);
                }
                continue;
            }
            if (object instanceof XWPFSDT) {
                XWPFSDT sdtElement = (XWPFSDT)object;
                ISDTContent content = sdtElement.getContent();
                if (!(content instanceof XWPFSDTContent)) continue;
                List<Object> contentElements = this.getSDTContent((XWPFSDTContent)content);
                this.convertElements(contentElements, mainDocumentElements);
                continue;
            }
            Util.LOGGER.info((Object)("######### " + String.valueOf(object) + " #########"));
        }
    }

    private List<Object> getSDTContent(XWPFSDTContent source) {
        if (source == null) {
            return null;
        }
        try {
            Field contentAccess = source.getClass().getDeclaredField("bodyElements");
            contentAccess.setAccessible(true);
            Object content = contentAccess.get(source);
            if (content instanceof List) {
                return (List)content;
            }
            Util.LOGGER.error((Object)"Cannot access SDT sub structures of the document since the POI parser API has been changed");
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            Util.LOGGER.error((Object)("Cannot access SDT sub structures of the document: " + e.getMessage()));
            Util.LOGGER.debug((Object)e);
        }
        return null;
    }

    private List<Section> extractParts(List<DocumentElement> elements, PageProperties defaultDocPageProps) {
        ArrayList<Section> sections = new ArrayList<Section>();
        ArrayList<DocumentElement> sectionElements = new ArrayList<DocumentElement>();
        PageProperties prevPageProps = null;
        ArrayList<ParagraphData> metaParagraphs = new ArrayList<ParagraphData>();
        for (DocumentElement element : elements) {
            ParagraphData paragraph;
            PageProperties newSectionProperties;
            if (element instanceof ParagraphData && (newSectionProperties = (paragraph = (ParagraphData)element).getPageProperties()) != null) {
                if (prevPageProps != null) {
                    prevPageProps.mergeHeaderAndFooterData(newSectionProperties);
                }
                if (!element.isEmpty()) {
                    sectionElements.add(element);
                }
                prevPageProps = newSectionProperties;
                DocumentAnalyzer.handleGroups(sectionElements, metaParagraphs, this.documentProperties);
                sections.add(new Section(newSectionProperties, sectionElements));
                sectionElements = new ArrayList();
                continue;
            }
            sectionElements.add(element);
        }
        if (metaParagraphs.size() > 0) {
            Util.LOGGER.error((Object)(metaParagraphs.size() + " unreferenced field parts!"));
        }
        if (sectionElements.size() > 0) {
            PageProperties newSectionProperties = defaultDocPageProps.clone();
            if (prevPageProps != null) {
                prevPageProps.mergeHeaderAndFooterData(newSectionProperties);
            }
            DocumentAnalyzer.handleGroups(sectionElements, metaParagraphs, this.documentProperties);
            sections.add(new Section(newSectionProperties, sectionElements));
        }
        return sections;
    }
}

