/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.xwpf.usermodel;

import com.inet.docx.document.utilities.Util;
import java.awt.Color;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.poi.ooxml.POIXMLTypeLoader;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.openxmlformats.schemas.drawingml.x2006.main.CTBaseStyles;
import org.openxmlformats.schemas.drawingml.x2006.main.CTColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTColorScheme;
import org.openxmlformats.schemas.drawingml.x2006.main.CTFontCollection;
import org.openxmlformats.schemas.drawingml.x2006.main.CTFontScheme;
import org.openxmlformats.schemas.drawingml.x2006.main.CTOfficeStyleSheet;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSRgbColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSupplementalFont;
import org.openxmlformats.schemas.drawingml.x2006.main.ThemeDocument;

public class XWPFThemeData {
    private static final String DEFAUL_FONT = "Calibri";
    private static final String WINDOWS_DEFAULT_FONT = "Times New Roman";
    private String majorLatinFont;
    private String minorLatinFont;
    private HashMap<String, Color> themeColors;
    private Map<String, String> language_typeface_minor = new HashMap<String, String>();
    private Map<String, String> language_typeface_major = new HashMap<String, String>();
    private Set<String> fontNames = new HashSet<String>();
    private static final Map<String, String> SCRIPT_LANGUAGE_KEY_MAP = Collections.unmodifiableMap(new HashMap<String, String>(){
        {
            this.put("Arab", "ar");
            this.put("Hebr", "he");
            this.put("Thai", "th");
            this.put("Ethi", "am");
            this.put("Beng", "bn");
            this.put("Gujr", "gu");
            this.put("Khmr", "km");
            this.put("Knda", "kn");
            this.put("Guru", "gu");
            this.put("Viet", "vi");
            this.put("Geor", "ka");
            this.put("Armn", "hy");
        }
    });

    public XWPFThemeData(PackagePart part) {
        this.fontNames.add(DEFAUL_FONT);
        this.fontNames.add(WINDOWS_DEFAULT_FONT);
        try (InputStream is = part.getInputStream();){
            String script;
            ThemeDocument theme = (ThemeDocument)ThemeDocument.Factory.parse(is, POIXMLTypeLoader.DEFAULT_XML_OPTIONS);
            CTOfficeStyleSheet oss = theme.getTheme();
            CTBaseStyles bs = oss.getThemeElements();
            CTFontScheme fs = bs.getFontScheme();
            CTColorScheme cs = bs.getClrScheme();
            this.themeColors = new HashMap();
            this.themeColors.put("accent1", this.convertToColor(cs.getAccent1()));
            this.themeColors.put("accent2", this.convertToColor(cs.getAccent2()));
            this.themeColors.put("accent3", this.convertToColor(cs.getAccent3()));
            this.themeColors.put("accent4", this.convertToColor(cs.getAccent4()));
            this.themeColors.put("accent5", this.convertToColor(cs.getAccent5()));
            this.themeColors.put("accent6", this.convertToColor(cs.getAccent6()));
            this.themeColors.put("dk1", this.convertToColor(cs.getDk1()));
            this.themeColors.put("tx1", this.themeColors.get("dk1"));
            this.themeColors.put("text1", this.themeColors.get("dk1"));
            this.themeColors.put("dk2", this.convertToColor(cs.getDk2()));
            this.themeColors.put("tx2", this.themeColors.get("dk2"));
            this.themeColors.put("lt1", this.convertToColor(cs.getLt1()));
            this.themeColors.put("bg1", this.themeColors.get("lt1"));
            this.themeColors.put("lt2", this.convertToColor(cs.getLt2()));
            this.themeColors.put("bg2", this.themeColors.get("lt2"));
            this.themeColors.put("hlink", this.convertToColor(cs.getHlink()));
            this.themeColors.put("folHlink", this.convertToColor(cs.getFolHlink()));
            CTFontCollection fc = fs.getMajorFont();
            this.majorLatinFont = fc.getLatin().getTypeface();
            this.fontNames.add(this.majorLatinFont);
            List sfs = fc.getFontList();
            for (CTSupplementalFont sf : sfs) {
                script = sf.getScript();
                if (SCRIPT_LANGUAGE_KEY_MAP.get(script) == null) continue;
                this.fontNames.add(sf.getTypeface());
                this.language_typeface_major.put(SCRIPT_LANGUAGE_KEY_MAP.get(script), sf.getTypeface());
            }
            fc = fs.getMinorFont();
            this.minorLatinFont = fc.getLatin().getTypeface();
            this.fontNames.add(this.minorLatinFont);
            sfs = fc.getFontList();
            for (CTSupplementalFont sf : sfs) {
                script = sf.getScript();
                if (SCRIPT_LANGUAGE_KEY_MAP.get(script) == null) continue;
                this.fontNames.add(sf.getTypeface());
                this.language_typeface_minor.put(SCRIPT_LANGUAGE_KEY_MAP.get(script), sf.getTypeface());
            }
        }
        catch (Exception e) {
            Util.LOGGER.error((Throwable)e);
            this.majorLatinFont = DEFAUL_FONT;
            this.minorLatinFont = DEFAUL_FONT;
        }
    }

    public Set<String> getFontNames() {
        return this.fontNames;
    }

    public Map<String, String> getTypefaceForLanguage(boolean isMajor) {
        return isMajor ? this.language_typeface_major : this.language_typeface_minor;
    }

    private Color convertToColor(CTColor col) {
        CTSRgbColor srgb = col.getSrgbClr();
        byte[] colorBytes = srgb == null ? col.getSysClr().getLastClr() : srgb.getVal();
        return new Color(0xFF & colorBytes[0], 0xFF & colorBytes[1], 0xFF & colorBytes[2]);
    }

    public String getMajorLatinFont() {
        return this.majorLatinFont;
    }

    public String getMinorLatinFont() {
        return this.minorLatinFont;
    }

    public HashMap<String, Color> getThemeColors() {
        return this.themeColors;
    }
}

