/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.xwpf.usermodel;

import com.inet.docx.document.DocumentProperties;
import com.inet.docx.document.RelationObject;
import com.inet.docx.document.utilities.NameSpaceHandler;
import com.inet.docx.document.utilities.Util;
import com.inet.docx.view.drawing.DrawingElement;
import com.inet.docx.xwpf.usermodel.XWPFDiagramDrawing;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.poi.ooxml.POIXMLTypeLoader;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.impl.values.XmlAnyTypeImpl;
import org.openxmlformats.schemas.drawingml.x2006.diagram.DataModelDocument;
import org.openxmlformats.schemas.drawingml.x2006.main.CTOfficeArtExtensionList;

public class XWPFDiagramData
extends RelationObject {
    private String drawingObjectKey;
    private XWPFDiagramDrawing drawingObject;

    public XWPFDiagramData(PackagePart part) {
        super(part);
        try {
            DataModelDocument dataModelDoc = (DataModelDocument)DataModelDocument.Factory.parse(part.getInputStream(), POIXMLTypeLoader.DEFAULT_XML_OPTIONS);
            CTOfficeArtExtensionList oael = dataModelDoc.getDataModel().getExtLst();
            XmlObject[] drawingObjects = NameSpaceHandler.examineNamespace("dsp", "dataModelExt", (XmlObject)oael.getExtList().get(0));
            this.drawingObjectKey = ((XmlAnyTypeImpl)drawingObjects[0].selectAttribute(new QName("", "relId"))).getStringValue();
        }
        catch (Exception io) {
            Util.LOGGER.error((Throwable)io);
        }
    }

    @Override
    public void init(DocumentProperties docProps, Rectangle2D bounds) {
        this.drawingObject = (XWPFDiagramDrawing)docProps.getRelation(this.drawingObjectKey, bounds);
    }

    @Override
    public List<DrawingElement> getDisplayElements() {
        if (this.drawingObject == null) {
            return new ArrayList<DrawingElement>();
        }
        return this.drawingObject.getDisplayElements();
    }
}

