/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.view.table;

import com.inet.docx.document.elements.style.CellBorder;
import com.inet.docx.document.elements.style.LineProperties;
import com.inet.docx.document.elements.style.LineStyle;
import com.inet.docx.document.elements.subelements.drawing.SimpleLine;
import com.inet.docx.document.elements.subelements.table.TableCell;
import com.inet.docx.document.utilities.Util;
import com.inet.docx.view.drawing.DrawingFactory;
import java.awt.Color;
import java.awt.Insets;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TableViewBorders {
    private int columns;
    private int rows;
    private LineProperties[][] lineMatrixHorizontal;
    private LineProperties[][] lineMatrixVertical;
    private List<DiagonalLine> diagonalLines = new ArrayList<DiagonalLine>();
    private static final Map<LineStyle, double[]> BORDER_STYLE = new HashMap<LineStyle, double[]>();

    public TableViewBorders(int columns, int rows) {
        this.columns = columns;
        this.rows = rows;
        this.lineMatrixHorizontal = new LineProperties[columns][rows + 1];
        this.lineMatrixVertical = new LineProperties[columns + 1][rows];
    }

    public CellBorders getCellBorders(TableCell tc, int rowOffset, boolean isXLStable) {
        int startRow = tc.getStartRow() - rowOffset;
        int startCol = tc.getStartColumn();
        int endRow = tc.getEndRow() + 1 - rowOffset;
        int endCol = tc.getEndColumn() + 1;
        return new CellBorders(startRow, startCol, endRow - startRow, endCol - startCol, isXLStable);
    }

    public void addTableCell(TableCell tc, int rowOffset) {
        int rowIndex;
        int colIndex;
        CellBorder cb = tc.getCellStyle().getBorder();
        LineProperties leftLine = cb.getLeftLine();
        LineProperties topLine = cb.getTopLine();
        LineProperties bottomLine = cb.getBottomLine();
        LineProperties rightLine = cb.getRightLine();
        int startRow = tc.getStartRow() - rowOffset;
        int startCol = tc.getStartColumn();
        int endRow = Math.min(tc.getEndRow() + 1 - rowOffset, this.rows);
        int endCol = tc.getEndColumn() + 1;
        if (DrawingFactory.isPrintable(topLine)) {
            for (colIndex = startCol; colIndex <= tc.getEndColumn(); ++colIndex) {
                this.addBorder(topLine, this.lineMatrixHorizontal, colIndex, startRow);
            }
        }
        if (DrawingFactory.isPrintable(leftLine)) {
            for (rowIndex = startRow; rowIndex < endRow; ++rowIndex) {
                this.addBorder(leftLine, this.lineMatrixVertical, startCol, rowIndex);
            }
        }
        if (DrawingFactory.isPrintable(bottomLine)) {
            for (colIndex = startCol; colIndex < endCol; ++colIndex) {
                this.addBorder(bottomLine, this.lineMatrixHorizontal, colIndex, endRow);
            }
        }
        if (DrawingFactory.isPrintable(rightLine)) {
            for (rowIndex = startRow; rowIndex < endRow; ++rowIndex) {
                this.addBorder(rightLine, this.lineMatrixVertical, endCol, rowIndex);
            }
        }
        if (DrawingFactory.isPrintable(cb.getTopLeft2BottomRightLine())) {
            this.diagonalLines.add(new DiagonalLine(startRow, startCol, endRow, endCol, false, cb.getTopLeft2BottomRightLine()));
        }
        if (DrawingFactory.isPrintable(cb.getTopRight2BottomLeftLine())) {
            this.diagonalLines.add(new DiagonalLine(startRow, startCol, endRow, endCol, true, cb.getTopRight2BottomLeftLine()));
        }
    }

    private void addBorder(LineProperties newBorder, LineProperties[][] target, int i1, int i2) {
        LineProperties[] row = target[i1];
        LineProperties current = TableViewBorders.resolveBorder(newBorder, row[i2]);
        LineProperties lineProperties = current.getStyle() != LineStyle.NIL ? current : null;
        row[i2] = lineProperties;
    }

    private static LineProperties resolveBorder(LineProperties l1, LineProperties l2) {
        boolean l1printable = DrawingFactory.isPrintable(l1);
        boolean l2printable = DrawingFactory.isPrintable(l2);
        if (!l1printable && !l2printable) {
            return null;
        }
        if (!l1printable || !l2printable) {
            return l1printable ? l1 : l2;
        }
        int order = TableViewBorders.getBorderOrder(l1, l2);
        return order < 0 ? l1 : l2;
    }

    private static int getBorderOrder(LineProperties l1, LineProperties l2) {
        int b2;
        int w2;
        boolean l1printable = DrawingFactory.isPrintable(l1);
        boolean l2printable = DrawingFactory.isPrintable(l2);
        if (!l1printable && !l2printable) {
            return 0;
        }
        if (!l1printable || !l2printable) {
            return l1printable ? -1 : 1;
        }
        int w1 = l1.getWidth() * l1.getStyle().getWeight();
        if (w1 != (w2 = l2.getWidth() * l2.getStyle().getWeight())) {
            return w2 > w1 ? 1 : -1;
        }
        w1 = l1.getStyle().getWeight();
        if (w1 != (w2 = l2.getStyle().getWeight())) {
            return w2 < w1 ? 1 : -1;
        }
        Color c1 = l1.getColor();
        Color c2 = l2.getColor();
        int b1 = c1.getRed() + c1.getBlue() + c1.getGreen() * 2;
        if (b1 != (b2 = c2.getRed() + c2.getBlue() + c2.getGreen() * 2)) {
            return b1 < b2 ? -1 : 1;
        }
        b1 = c1.getBlue() + c1.getGreen() * 2;
        if (b1 != (b2 = c2.getBlue() + c2.getGreen() * 2)) {
            return b1 < b2 ? -1 : 1;
        }
        if (c1.getGreen() != c2.getGreen()) {
            return c1.getGreen() < c2.getGreen() ? -1 : 1;
        }
        return 0;
    }

    public int getVerticalLineWidth(int lineNumber) {
        int maxWidth = 0;
        for (int rowIndex = 0; rowIndex < this.rows; ++rowIndex) {
            if (this.lineMatrixVertical[lineNumber][rowIndex] == null) continue;
            maxWidth = Math.max(maxWidth, this.lineMatrixVertical[lineNumber][rowIndex].getWidth());
        }
        return maxWidth;
    }

    public int getHorizontalLineHeight(int lineNumber) {
        if (lineNumber > this.rows) {
            return 0;
        }
        int maxWidth = 0;
        for (int colIndex = 0; colIndex < this.columns; ++colIndex) {
            if (this.lineMatrixHorizontal[colIndex][lineNumber] == null) continue;
            maxWidth = Math.max(maxWidth, this.lineMatrixHorizontal[colIndex][lineNumber].getWidth());
        }
        return maxWidth;
    }

    public int getVerticalBorderOffset(TableCell tc, int layoutOffset) {
        int result = tc.getStartRow() == 0 ? this.getHorizontalLineHeight(0) : 0;
        for (int rowIndex = tc.getStartRow(); rowIndex <= tc.getEndRow(); ++rowIndex) {
            result += this.getHorizontalLineHeight(rowIndex + 1 - layoutOffset);
        }
        return result;
    }

    public void createGridLines(ArrayList<SimpleLine> lines, double[] xPositions, double[] yPositions) {
        int row;
        TableVertex[][] vertices = new TableVertex[this.rows + 1][];
        for (row = 0; row < vertices.length; ++row) {
            vertices[row] = new TableVertex[this.columns + 1];
            for (int col = 0; col < this.columns + 1; ++col) {
                LineProperties left = col > 0 ? this.lineMatrixHorizontal[col - 1][row] : null;
                LineProperties right = col < this.columns ? this.lineMatrixHorizontal[col][row] : null;
                LineProperties top = row > 0 ? this.lineMatrixVertical[col][row - 1] : null;
                LineProperties bottom = row < this.rows ? this.lineMatrixVertical[col][row] : null;
                vertices[row][col] = new TableVertex(top, right, bottom, left);
            }
        }
        for (int col = 0; col < xPositions.length; ++col) {
            double posX = xPositions[col];
            for (int row2 = 0; row2 < yPositions.length - 1; ++row2) {
                int yGridPos = row2;
                LineProperties lineDef = this.lineMatrixVertical[col][yGridPos];
                if (!DrawingFactory.isPrintable(lineDef)) continue;
                double[] style = BORDER_STYLE.get(lineDef.getStyle());
                if (style != null) {
                    TableVertex vertex1 = vertices[row2][col];
                    TableVertex vertex2 = vertices[row2 + 1][col];
                    double yStart = yPositions[row2];
                    double yEnd = yPositions[row2 + 1];
                    lines.addAll(this.addMultiLineV(lineDef, posX, yStart, yEnd, vertex1, vertex2, style));
                    continue;
                }
                Util.LOGGER.error((Object)("Table grid line style not implemented: " + String.valueOf(lineDef.getStyle())));
            }
        }
        for (row = 0; row < yPositions.length; ++row) {
            double posY = yPositions[row];
            for (int col = 0; col < xPositions.length - 1; ++col) {
                LineProperties lineDef = this.lineMatrixHorizontal[col][row];
                if (!DrawingFactory.isPrintable(lineDef)) continue;
                double[] style = BORDER_STYLE.get(lineDef.getStyle());
                if (style != null) {
                    TableVertex vertex1 = vertices[row][col];
                    TableVertex vertex2 = vertices[row][col + 1];
                    double xStart = xPositions[col];
                    double xEnd = xPositions[col + 1];
                    lines.addAll(this.addMultiLineH(lineDef, posY, xStart, xEnd, vertex1, vertex2, style));
                    continue;
                }
                Util.LOGGER.error((Object)("Table grid line style not implemented: " + String.valueOf(lineDef.getStyle())));
            }
        }
        for (DiagonalLine dl : this.diagonalLines) {
            double posY2;
            double posY1;
            double posX1 = Util.convertTwipsToPoint(xPositions[dl.leftLineNumber]);
            double posX2 = Util.convertTwipsToPoint(xPositions[dl.rightLineNumber]);
            if (dl.ascendingLeftToRight) {
                posY1 = Util.convertTwipsToPoint(yPositions[dl.bottomLineNumber]);
                posY2 = Util.convertTwipsToPoint(yPositions[dl.topLineNumber]);
            } else {
                posY1 = Util.convertTwipsToPoint(yPositions[dl.topLineNumber]);
                posY2 = Util.convertTwipsToPoint(yPositions[dl.bottomLineNumber]);
            }
            lines.add(new SimpleLine(dl.lineDef, new Point2D.Double(posX1, posY1), new Point2D.Double(posX2, posY2)));
        }
    }

    private List<SimpleLine> addMultiLineV(LineProperties lineDef, double posX, double yStart, double yEnd, TableVertex start, TableVertex end, double ... ratios) {
        ArrayList<SimpleLine> lines = new ArrayList<SimpleLine>();
        int lineWidth = lineDef.getWidth();
        if (ratios.length == 1) {
            double lwStart = Math.max(start.getNextBorderWidth(DIRECTION.bottom, true, lineWidth), start.getNextBorderWidth(DIRECTION.bottom, false, lineWidth));
            double lwEnd = Math.max(end.getNextBorderWidth(DIRECTION.top, true, lineWidth), end.getNextBorderWidth(DIRECTION.top, false, lineWidth));
            double lineX = Util.convertTwipsToPoint(posX);
            double posY1 = Util.convertTwipsToPoint(yStart + ((double)lineWidth - lwStart) / 2.0);
            double posY2 = Util.convertTwipsToPoint(yEnd - ((double)lineWidth - lwEnd) / 2.0);
            lines.add(new SimpleLine(lineDef, new Point2D.Double(lineX, posY1), new Point2D.Double(lineX, posY2)));
            return lines;
        }
        double ratioSum = Arrays.stream(ratios).sum();
        BorderOffset offsetStart = new BorderOffset(start.getVertexOffsets(DIRECTION.bottom));
        BorderOffset offsetEnd = new BorderOffset(end.getVertexOffsets(DIRECTION.top));
        double ratio = 0.0;
        for (int i = 0; i < ratios.length; ++i) {
            double part = ratios[i] / ratioSum;
            if (i % 2 == 1) {
                ratio += part;
                continue;
            }
            double currentPosition = ratio + part / 2.0;
            double lwStart = start.getNextBorderWidth(DIRECTION.bottom, ratio < 0.5, lineWidth);
            double lwEnd = end.getNextBorderWidth(DIRECTION.top, ratio < 0.5, lineWidth);
            double totalOffsetStart = Math.max(offsetStart.getOffset(ratio), offsetStart.getOffset(ratio + part)) * lwStart;
            double totalOffsetEnd = Math.max(offsetEnd.getOffset(ratio), offsetEnd.getOffset(ratio + part)) * lwEnd;
            int singleLineW = (int)Math.max(1.0, (double)lineWidth * part);
            double posY1 = Util.convertTwipsToPoint(yStart - totalOffsetStart + (double)(singleLineW / 2));
            double posY2 = Util.convertTwipsToPoint(yEnd + totalOffsetEnd - (double)((singleLineW + 1) / 2));
            LineProperties newLine = new LineProperties(lineDef.getColor(), LineStyle.SINGLE, lineDef.isHeavy(), singleLineW, lineDef.getSpace());
            double lineX = Util.convertTwipsToPoint(posX - (double)(lineWidth / 2) + currentPosition * (double)lineWidth);
            lines.add(new SimpleLine(newLine, new Point2D.Double(lineX, posY1), new Point2D.Double(lineX, posY2)));
            ratio += part;
        }
        return lines;
    }

    private List<SimpleLine> addMultiLineH(LineProperties lineDef, double posY, double xStart, double xEnd, TableVertex start, TableVertex end, double ... ratios) {
        ArrayList<SimpleLine> lines = new ArrayList<SimpleLine>();
        int lineWidth = lineDef.getWidth();
        if (ratios.length == 1) {
            double lwStart = Math.max(start.getNextBorderWidth(DIRECTION.right, true, lineWidth), start.getNextBorderWidth(DIRECTION.right, false, lineWidth));
            double lwEnd = Math.max(end.getNextBorderWidth(DIRECTION.left, true, lineWidth), end.getNextBorderWidth(DIRECTION.left, false, lineWidth));
            double lineY = Util.convertTwipsToPoint(posY);
            double posX1 = Util.convertTwipsToPoint(xStart + ((double)lineWidth - lwStart) / 2.0);
            double posX2 = Util.convertTwipsToPoint(xEnd - ((double)lineWidth - lwEnd) / 2.0);
            lines.add(new SimpleLine(lineDef, new Point2D.Double(posX1, lineY), new Point2D.Double(posX2, lineY)));
            return lines;
        }
        double ratioSum = Arrays.stream(ratios).sum();
        BorderOffset offsetStart = new BorderOffset(start.getVertexOffsets(DIRECTION.right));
        BorderOffset offsetEnd = new BorderOffset(end.getVertexOffsets(DIRECTION.left));
        double ratio = 0.0;
        for (int i = 0; i < ratios.length; ++i) {
            double part = ratios[i] / ratioSum;
            if (i % 2 == 1) {
                ratio += part;
                continue;
            }
            double currentPosition = ratio + part / 2.0;
            double lwStart = start.getNextBorderWidth(DIRECTION.right, ratio < 0.5, lineWidth);
            double lwEnd = end.getNextBorderWidth(DIRECTION.left, ratio < 0.5, lineWidth);
            double totalOffsetStart = Math.max(offsetStart.getOffset(ratio), offsetStart.getOffset(ratio + part)) * lwStart;
            double totalOffsetEnd = Math.max(offsetEnd.getOffset(ratio), offsetEnd.getOffset(ratio + part)) * lwEnd;
            int singleLineW = (int)Math.max(1.0, (double)lineWidth * part);
            double posX1 = Util.convertTwipsToPoint(xStart - totalOffsetStart + (double)(singleLineW / 2));
            double posX2 = Util.convertTwipsToPoint(xEnd + totalOffsetEnd - (double)((singleLineW + 1) / 2));
            LineProperties newLine = new LineProperties(lineDef.getColor(), LineStyle.SINGLE, lineDef.isHeavy(), singleLineW, lineDef.getSpace());
            double lineY = Util.convertTwipsToPoint(posY - (double)(lineWidth / 2) + currentPosition * (double)lineWidth);
            lines.add(new SimpleLine(newLine, new Point2D.Double(posX1, lineY), new Point2D.Double(posX2, lineY)));
            ratio += part;
        }
        return lines;
    }

    static {
        double[] singleLine = new double[]{1.0};
        BORDER_STYLE.put(LineStyle.DASHDOTSTROKED, singleLine);
        BORDER_STYLE.put(LineStyle.DASHED, singleLine);
        BORDER_STYLE.put(LineStyle.DASHEDSMALL, singleLine);
        BORDER_STYLE.put(LineStyle.DASHLONG, singleLine);
        BORDER_STYLE.put(LineStyle.DASHSMALLGAP, singleLine);
        BORDER_STYLE.put(LineStyle.DOT, singleLine);
        BORDER_STYLE.put(LineStyle.DOTDASH, singleLine);
        BORDER_STYLE.put(LineStyle.DOTDASHLONG, singleLine);
        BORDER_STYLE.put(LineStyle.DOTDOTDASH, singleLine);
        BORDER_STYLE.put(LineStyle.DOTTED, singleLine);
        BORDER_STYLE.put(LineStyle.SINGLE, singleLine);
        BORDER_STYLE.put(LineStyle.THICK, singleLine);
        BORDER_STYLE.put(LineStyle.WAVE, singleLine);
        BORDER_STYLE.put(LineStyle.DOUBLE, new double[]{1.0, 1.0, 1.0});
        BORDER_STYLE.put(LineStyle.DOUBLEWAVE, new double[]{1.0, 1.0, 1.0});
        BORDER_STYLE.put(LineStyle.THICKTHINSMALLGAP, new double[]{1.0, 1.0, 5.0});
        BORDER_STYLE.put(LineStyle.THICKTHINMEDIUMGAP, new double[]{1.0, 2.0, 4.0});
        BORDER_STYLE.put(LineStyle.THICKTHINLARGEGAP, new double[]{1.0, 3.0, 3.0});
        BORDER_STYLE.put(LineStyle.THINTHICKSMALLGAP, new double[]{5.0, 1.0, 1.0});
        BORDER_STYLE.put(LineStyle.THINTHICKMEDIUMGAP, new double[]{4.0, 2.0, 1.0});
        BORDER_STYLE.put(LineStyle.THINTHICKLARGEGAP, new double[]{3.0, 3.0, 1.0});
        BORDER_STYLE.put(LineStyle.TRIPLE, new double[]{1.0, 1.0, 1.0, 1.0, 1.0});
        BORDER_STYLE.put(LineStyle.THINTHICKTHINLARGEGAP, new double[]{1.0, 3.0, 3.0, 3.0, 1.0});
        BORDER_STYLE.put(LineStyle.THINTHICKTHINMEDIUMGAP, new double[]{1.0, 2.0, 5.0, 2.0, 1.0});
        BORDER_STYLE.put(LineStyle.THINTHICKTHINSMALLGAP, new double[]{1.0, 1.0, 7.0, 1.0, 1.0});
    }

    public class CellBorders {
        private int row;
        private int column;
        private int rowCount;
        private int colCount;
        private boolean isXLStable;

        public CellBorders(int row, int column, int rowCount, int colCount, boolean isXLStable) {
            this.row = row;
            this.column = column;
            this.rowCount = rowCount;
            this.colCount = colCount;
            this.isXLStable = isXLStable;
        }

        public Insets getBorderSizes() {
            Insets insets = new Insets(TableViewBorders.this.getHorizontalLineHeight(this.row) / 2, TableViewBorders.this.getVerticalLineWidth(this.column) / 2, (TableViewBorders.this.getHorizontalLineHeight(this.row + this.rowCount) + 1) / 2, (TableViewBorders.this.getVerticalLineWidth(this.column + this.colCount) + 1) / 2);
            if (this.isXLStable) {
                insets.top = 0;
                insets.bottom = 0;
            }
            return insets;
        }
    }

    private class DiagonalLine {
        private int topLineNumber;
        private int leftLineNumber;
        private int bottomLineNumber;
        private int rightLineNumber;
        private boolean ascendingLeftToRight;
        private LineProperties lineDef;

        private DiagonalLine(int top, int left, int bottom, int right, boolean ascendingLeftToRight, LineProperties lineDef) {
            this.topLineNumber = top;
            this.leftLineNumber = left;
            this.bottomLineNumber = bottom;
            this.rightLineNumber = right;
            this.ascendingLeftToRight = ascendingLeftToRight;
            this.lineDef = lineDef;
        }
    }

    private static class TableVertex {
        private Map<DIRECTION, Boolean> prio = new HashMap<DIRECTION, Boolean>();
        private Map<DIRECTION, LineProperties> lines = new HashMap<DIRECTION, LineProperties>();
        private long prioCount = 0L;
        private static final double SHORT = -0.5;
        private static final double LONG = 0.5;
        private static final double CENTER = 0.0;

        public TableVertex(LineProperties borderTop, LineProperties borderRight, LineProperties borderBottom, LineProperties borderLeft) {
            LineProperties[] borders = new LineProperties[]{borderTop, borderRight, borderBottom, borderLeft};
            Arrays.sort(borders, LinePropSorter.INSTANCE);
            LineProperties maxPrio = borders[0];
            this.prio.put(DIRECTION.top, TableViewBorders.getBorderOrder(maxPrio, borderTop) >= 0);
            this.prio.put(DIRECTION.bottom, TableViewBorders.getBorderOrder(maxPrio, borderBottom) >= 0);
            this.prio.put(DIRECTION.left, TableViewBorders.getBorderOrder(maxPrio, borderLeft) >= 0);
            this.prio.put(DIRECTION.right, TableViewBorders.getBorderOrder(maxPrio, borderRight) >= 0);
            this.lines.put(DIRECTION.top, borderTop);
            this.lines.put(DIRECTION.bottom, borderBottom);
            this.lines.put(DIRECTION.left, borderLeft);
            this.lines.put(DIRECTION.right, borderRight);
            this.prioCount = this.prio.values().stream().filter(b -> b).count();
        }

        public double[] getVertexOffsets(DIRECTION direction) {
            if (!this.prio.get((Object)direction).booleanValue()) {
                return new double[]{-0.5, -0.5, -0.5};
            }
            if (this.prioCount == 1L) {
                return new double[]{0.5, 0.5, 0.5};
            }
            if (this.prioCount == 4L) {
                return new double[]{-0.5, 0.0, -0.5};
            }
            double[] ratios = new double[3];
            DIRECTION left = DIRECTION.values()[(direction.ordinal() + 1) % 4];
            DIRECTION right = DIRECTION.values()[(direction.ordinal() + 3) % 4];
            DIRECTION opposite = DIRECTION.values()[(direction.ordinal() + 2) % 4];
            boolean reverse = direction != DIRECTION.right && direction != DIRECTION.top;
            ratios[1] = 0.0;
            boolean prioLeft = this.prio.get((Object)left);
            boolean prioRight = this.prio.get((Object)right);
            boolean prioOpposite = this.prio.get((Object)opposite);
            if (this.prioCount == 3L) {
                reverse = !reverse;
                ratios[reverse ? 2 : 0] = prioLeft ? -0.5 : (prioOpposite ? 0.0 : -0.5);
                ratios[reverse ? 0 : 2] = prioRight ? -0.5 : (prioOpposite ? 0.0 : -0.5);
            } else {
                ratios[reverse ? 0 : 2] = prioLeft ? -0.5 : (prioOpposite ? 0.0 : 0.5);
                ratios[reverse ? 2 : 0] = prioRight ? -0.5 : (prioOpposite ? 0.0 : 0.5);
            }
            return ratios;
        }

        public int getNextBorderWidth(DIRECTION direction, boolean forward, int fallback) {
            if (this.prioCount != 1L || !this.prio.get((Object)direction).booleanValue()) {
                return fallback;
            }
            DIRECTION next = DIRECTION.values()[(direction.ordinal() + (forward ? 1 : 3)) % 4];
            LineProperties nextBorder = this.lines.get((Object)next);
            if (nextBorder != null) {
                return nextBorder.getWidth();
            }
            DIRECTION prev = DIRECTION.values()[(direction.ordinal() + (forward ? 3 : 1)) % 4];
            LineProperties prevBorder = this.lines.get((Object)prev);
            return prevBorder != null ? prevBorder.getWidth() : fallback;
        }
    }

    private static enum DIRECTION {
        left,
        top,
        right,
        bottom;

    }

    private static class BorderOffset {
        private double[] offsets;

        public BorderOffset(double[] offsets) {
            this.offsets = offsets;
        }

        public double getOffset(double ratio) {
            if (ratio <= 0.0) {
                return this.offsets[0];
            }
            if (ratio == 0.5) {
                return this.offsets[1];
            }
            if (ratio >= 1.0) {
                return this.offsets[2];
            }
            if (ratio < 0.5) {
                return this.offsets[0] + (this.offsets[1] - this.offsets[0]) * ratio * 2.0;
            }
            return this.offsets[1] + (this.offsets[2] - this.offsets[1]) * (ratio - 0.5) * 2.0;
        }
    }

    private static class LinePropSorter
    implements Comparator<LineProperties> {
        private static LinePropSorter INSTANCE = new LinePropSorter();

        private LinePropSorter() {
        }

        @Override
        public int compare(LineProperties o1, LineProperties o2) {
            return TableViewBorders.getBorderOrder(o1, o2);
        }
    }
}

