/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.view.paragraph;

import com.inet.docx.document.elements.subelements.Drawing;
import com.inet.docx.document.elements.subelements.Positionable;
import com.inet.docx.document.paragraph.FontDimensionsTwips;
import com.inet.docx.document.paragraph.ParagraphData;
import com.inet.docx.document.utilities.Util;
import com.inet.docx.view.PageElement;
import com.inet.docx.view.paragraph.ParagraphPageBreakPosition;
import com.inet.docx.view.paragraph.ParagraphView;
import com.inet.docx.view.paragraph.RowTextPiece;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public class ParagraphRow
extends Positionable
implements PageElement {
    private List<Positionable> rowElements = new ArrayList<Positionable>();
    private double rowHeight = 0.0;
    private double rowLeading = 0.0;
    private double rowBaseline = 0.0;
    private double rowDescent = 0.0;
    private ParagraphView parent;
    private ParagraphPageBreakPosition startBreak;
    private boolean calculated = false;

    public ParagraphRow(ParagraphView parent, ParagraphPageBreakPosition startBreak) {
        this.parent = parent;
        this.startBreak = startBreak;
    }

    public ParagraphPageBreakPosition getStartBreak() {
        return this.startBreak;
    }

    public void addElement(Positionable element) {
        this.rowElements.add(element);
        this.calculated = false;
    }

    private void calculateRow() {
        FontDimensionsTwips fdt;
        if (this.calculated) {
            return;
        }
        this.rowHeight = 0.0;
        this.rowLeading = 0.0;
        this.rowBaseline = 0.0;
        this.rowDescent = 0.0;
        if (this.rowElements.isEmpty()) {
            return;
        }
        boolean allEmpty = true;
        for (Positionable element : this.rowElements) {
            if (element instanceof RowTextPiece) {
                if (((RowTextPiece)element).isEmpty()) continue;
                allEmpty = false;
                break;
            }
            allEmpty = false;
            break;
        }
        for (Positionable element : this.rowElements) {
            if (element instanceof RowTextPiece) {
                RowTextPiece rtp = (RowTextPiece)element;
                fdt = rtp.getParent().getRenderFont().getRenderDimensions();
                this.rowLeading = Math.max(this.rowLeading, fdt.getLeading());
                this.rowDescent = Math.max(this.rowDescent, fdt.getDescent());
                if (!allEmpty && rtp.isEmpty()) continue;
                this.rowHeight = Math.max(this.rowHeight, element.getHeight());
                this.rowBaseline = Math.max(this.rowBaseline, element.getBaseline());
                continue;
            }
            if (element instanceof Drawing && ((Drawing)element).isAnchored()) continue;
            this.rowHeight = Math.max(this.rowHeight, element.getHeight());
            this.rowBaseline = Math.max(this.rowBaseline, element.getBaseline());
        }
        if (this.rowHeight == 0.0) {
            ParagraphData paragraphData = this.parent.getSource();
            double lineFactor = paragraphData.getSpacing().getSpacingFactor();
            fdt = paragraphData.getMarkerRenderFont().getRenderDimensions();
            this.rowLeading = Math.max(this.rowLeading, fdt.getLeading());
            this.rowDescent = Math.max(this.rowDescent, fdt.getDescent());
            this.rowHeight = Math.max(this.rowHeight, fdt.getRowHeight() * lineFactor);
            this.rowBaseline = Math.max(this.rowBaseline, fdt.getBaselineHeight());
        }
        this.calculated = true;
    }

    @Override
    public double getHeight() {
        this.calculateRow();
        return this.rowHeight;
    }

    public double getDescent() {
        this.calculateRow();
        return this.rowDescent;
    }

    public double getLeading() {
        this.calculateRow();
        return this.rowLeading;
    }

    @Override
    public double getBaseline() {
        this.calculateRow();
        return this.rowBaseline;
    }

    @Override
    public int getSpacingTop(boolean isFirstRow) {
        return 0;
    }

    @Override
    public int getSpacingBottom() {
        return 0;
    }

    @Override
    public double getWidth() {
        return this.getBounds().getWidth();
    }

    @Override
    public Rectangle2D getBounds() {
        if (this.rowElements.isEmpty()) {
            return new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        }
        Positionable e0 = this.rowElements.get(0);
        Rectangle2D.Double bounds = new Rectangle2D.Double(e0.getPageX(), e0.getPageY(), e0.getWidth(), e0.getHeight());
        for (int i = 1; i < this.rowElements.size(); ++i) {
            e0 = this.rowElements.get(i);
            Rectangle2D.Double moreBounds = new Rectangle2D.Double(e0.getPageX(), e0.getPageY(), e0.getWidth(), e0.getHeight());
            Rectangle2D.union(bounds, moreBounds, bounds);
        }
        return bounds;
    }

    @Override
    public void collectElements(List<Positionable> elements) {
        elements.add(this);
    }

    @Override
    public void move(double xOffset, double yOffset) {
        for (Positionable pe : this.rowElements) {
            pe.move(xOffset, yOffset);
        }
    }

    public void handleTransform(AffineTransform transform) {
        for (Positionable pe : this.rowElements) {
            if (!(pe instanceof RowTextPiece)) continue;
            RowTextPiece rtp = (RowTextPiece)pe;
            Point2D p = new Point2D.Double(Util.convertTwipsToPoint(rtp.getPageX()), Util.convertTwipsToPoint(rtp.getPageY()));
            p = transform.transform(p, null);
            rtp.setPageX(p.getX() * 20.0);
            rtp.setPageY(p.getY() * 20.0);
        }
    }

    public int getElementCount() {
        return this.rowElements.size();
    }

    public Positionable getElement(int index) {
        return this.rowElements.get(index);
    }

    public ArrayList<RowTextPiece> getElementsInRow() {
        ArrayList<RowTextPiece> pieces = new ArrayList<RowTextPiece>();
        for (Positionable pe : this.rowElements) {
            if (!(pe instanceof RowTextPiece)) continue;
            pieces.add((RowTextPiece)pe);
        }
        return pieces;
    }

    @Override
    public double getMinKeepTogetherHeight() {
        return this.getHeight();
    }

    public String toString() {
        Object toString = "";
        for (Positionable rowElement : this.rowElements) {
            toString = (String)toString + rowElement.toString() + " ,";
        }
        return "ParagraphRow{" + (String)toString + "}";
    }

    @Override
    public ParagraphData getSource() {
        return this.parent.getSource();
    }
}

