/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.view.paragraph;

import com.inet.docx.document.elements.style.ShapeBodyProperties;
import com.inet.docx.document.elements.subelements.BorderLines;
import com.inet.docx.document.utilities.Util;
import com.inet.docx.view.AreaObjects;
import com.inet.docx.view.drawing.DrawingFactory;
import com.inet.docx.view.paragraph.ParagraphView;
import java.awt.geom.Rectangle2D;

public class ParagraphBorder {
    private double paragraphTopPosition;
    private ShapeBodyProperties shapeContentProperties;
    private ParagraphView paragraphView;

    public ParagraphBorder(ParagraphView paragraphView, double yStartPosition, ShapeBodyProperties shapeContentProperties) {
        this.paragraphTopPosition = yStartPosition;
        this.paragraphView = paragraphView;
        this.shapeContentProperties = shapeContentProperties;
    }

    public void collectElements(AreaObjects elements) {
        BorderLines borders = this.paragraphView.getSource().getBorder();
        Rectangle2D bounds = this.paragraphView.getBounds();
        double x = bounds.getX();
        double y = this.paragraphTopPosition;
        double width = bounds.getWidth();
        double height = bounds.getHeight();
        if (DrawingFactory.isPrintable(borders.getTopLine())) {
            y -= borders.getTopLine().getSpace();
            height += borders.getTopLine().getSpace();
            if (this.shapeContentProperties != null) {
                y -= (double)this.shapeContentProperties.getTopMargin();
                height += (double)this.shapeContentProperties.getTopMargin();
            }
        }
        if (DrawingFactory.isPrintable(borders.getBottomLine())) {
            height += borders.getBottomLine().getSpace();
            if (this.shapeContentProperties != null) {
                height += (double)this.shapeContentProperties.getBottomMargin();
            }
        }
        if (DrawingFactory.isPrintable(borders.getLeftLine())) {
            x -= borders.getLeftLine().getSpace();
            width += borders.getLeftLine().getSpace();
            if (this.shapeContentProperties != null) {
                x -= (double)this.shapeContentProperties.getLeftMargin();
                width += (double)this.shapeContentProperties.getLeftMargin();
            }
        }
        if (DrawingFactory.isPrintable(borders.getRightLine())) {
            width += borders.getRightLine().getSpace();
            if (this.shapeContentProperties != null) {
                x -= (double)this.shapeContentProperties.getRightMargin();
                width += (double)this.shapeContentProperties.getRightMargin();
            }
        }
        bounds = new Rectangle2D.Double(Util.convertTwipsToPoint(x), Util.convertTwipsToPoint(y), Util.convertTwipsToPoint(width), Util.convertTwipsToPoint(height));
        DrawingFactory.createBorderLines(borders, bounds, elements);
    }
}

