/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.view.drawing;

import com.inet.docx.document.elements.style.LineProperties;
import com.inet.docx.document.elements.style.LineStyle;
import com.inet.docx.document.elements.style.ShapeBodyProperties;
import com.inet.docx.document.utilities.Util;
import com.inet.docx.view.drawing.AbstractDrawingElement;
import com.inet.docx.view.drawing.BasicStrokeData;
import com.inet.docx.view.drawing.BorderLineExternalWidths;
import com.inet.docx.view.drawing.CustomRectangle2D;
import com.inet.docx.view.drawing.DrawingElement;
import com.inet.docx.view.drawing.DrawingFactory;
import com.inet.docx.view.drawing.DrawingReflection;
import com.inet.docx.view.drawing.GradientData;
import com.inet.docx.view.drawing.PictureFillData;
import com.inet.docx.view.drawing.RectangleCornerStyle;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SimpleShape
extends AbstractDrawingElement {
    public static final double DEFAULT_LINE_WIDTH = 20.0;
    private boolean noFill = false;
    private Paint backGround;
    private GradientData gradient;
    private PictureFillData pictureFillData;
    private ShapeBodyProperties contentProperties;
    private Shape shape;
    private boolean autoFit = false;
    private ArrayList<Path2D.Double> lines;
    private ShapeType type = ShapeType.rect;
    private String hrAlign;
    private HashMap<String, String> geometricParameters;
    private double alternativeWidth = 0.0;
    private double alternativeHeight = 0.0;
    private boolean isVML = false;
    private BasicStrokeData basicStrokeData = new BasicStrokeData();

    public SimpleShape(String type, Rectangle2D bounds, double rotation, double scaleX, double scaleY, DrawingReflection drawingReflection) {
        super(bounds, rotation, scaleX, scaleY, drawingReflection);
        this.setType(type);
        if (ShapeType.line.name().equalsIgnoreCase(this.getType().name())) {
            this.basicStrokeData.setLineStyle(LineStyle.NONE);
        }
        Util.LOGGER.debug((Object)("SimpleShape Type " + String.valueOf((Object)this.getType()) + "\t" + super.toString()));
    }

    public SimpleShape(String type, Rectangle2D bounds) {
        this(type, bounds, 0.0, 1.0, 1.0, DrawingReflection.NONE);
    }

    public SimpleShape(LineProperties lineProp, Point2D p1, Point2D p2) {
        this(ShapeType.line.name(), new Rectangle2D.Double(Math.min(p1.getX(), p2.getX()), Math.min(p1.getY(), p2.getY()), Math.abs(p1.getX() - p2.getX()), Math.abs(p1.getY() - p2.getY())));
        this.basicStrokeData.setBorderLineWidth(lineProp.getWidth());
        this.shape = new Line2D.Double(Util.convertTwipsToPoint(p1.getX()), Util.convertTwipsToPoint(p1.getY()), Util.convertTwipsToPoint(p2.getX()), Util.convertTwipsToPoint(p2.getY()));
        this.basicStrokeData.setLineStyle(lineProp.getStyle() != null ? lineProp.getStyle() : LineStyle.SINGLE);
        this.basicStrokeData.setBorderColor(lineProp.getColor());
    }

    public SimpleShape(Rectangle2D bounds, Color fillColor) {
        this(ShapeType.rect.name(), bounds);
        this.shape = bounds;
        this.backGround = fillColor;
    }

    public void addMultiLine(Path2D.Double multiL) {
        this.setType(ShapeType.multiline);
        if (this.lines == null) {
            this.lines = new ArrayList();
        }
        this.lines.add(multiL);
    }

    public Shape getShape() {
        return this.createShape(Util.convertTwipsToPoint(this.getWidth()), Util.convertTwipsToPoint(this.getHeight()), Util.convertTwipsToPoint(this.getPosition().getX()), Util.convertTwipsToPoint(this.getPosition().getY()));
    }

    public ShapeType getType() {
        return this.type;
    }

    public ShapeBodyProperties getContentProperties() {
        return this.contentProperties;
    }

    public void setContentProperties(ShapeBodyProperties contentProperties) {
        this.contentProperties = contentProperties;
    }

    public void setNoFill(boolean noFill) {
        this.noFill = noFill;
    }

    protected boolean needsBackground() {
        return this.gradient == null && this.backGround == null && !this.noFill;
    }

    protected void setGradient(GradientData gradient) {
        this.gradient = gradient;
    }

    protected void setPictureFillData(PictureFillData pictureFillData) {
        this.pictureFillData = pictureFillData;
    }

    public PictureFillData getPictureFillData() {
        return this.pictureFillData;
    }

    public Paint getBackgroundColor() {
        return this.backGround;
    }

    public void setBgColor(Paint bgColor) {
        this.backGround = bgColor;
    }

    protected ShapeType getShapeType() {
        return this.type;
    }

    protected void setType(ShapeType type) {
        this.type = type;
    }

    protected void setType(String type) {
        try {
            String typeNormalize = type.toLowerCase();
            if (typeNormalize.startsWith(ShapeType.star.name().toLowerCase())) {
                this.setType(ShapeType.star);
                int number = Util.getEndNumber(typeNormalize);
                if (number == -1) {
                    Util.LOGGER.warn((Object)("The number of corner for the star is not valid. The type description is " + type));
                } else {
                    this.type.setTypeDescription(Util.getEndNumber(typeNormalize));
                }
            } else {
                for (NCornerType value : NCornerType.values()) {
                    if (!value.name().equalsIgnoreCase(type)) continue;
                    this.setType(ShapeType.nCorner);
                    this.type.setTypeDescription(value.getNumOfCorner());
                    return;
                }
                this.setType(ShapeType.valueOf(type));
            }
        }
        catch (Exception e) {
            IllegalArgumentException ex = new IllegalArgumentException("Unknown shape type '" + type + "'");
            ex.initCause(e);
            Util.LOGGER.error((Throwable)ex);
        }
    }

    protected void setGeometricParameters(HashMap<String, String> geometricParameters) {
        this.geometricParameters = geometricParameters;
        if (this.getShapeType() == ShapeType.straightConnector1) {
            this.handelStraightConnectorSettings();
        }
    }

    private void handelStraightConnectorSettings() {
        Point2D.Double endP;
        Point2D.Double startP;
        String headType = this.geometricParameters.get("head_type");
        String tailType = this.geometricParameters.get("tail_type");
        double headWidth = (double)this.getValueFactor("head_w", headType) * 20.0;
        double headLength = (double)this.getValueFactor("head_len", headType) * 20.0;
        double tailWidth = (double)this.getValueFactor("tail_w", tailType) * 20.0;
        double tailLength = (double)this.getValueFactor("tail_len", tailType) * 20.0;
        double lineLength = Math.sqrt(this.getWidth() * this.getWidth() + this.getHeight() * this.getHeight());
        double angle = Math.asin(super.getHeight() / lineLength);
        if (super.getHeight() == 0.0) {
            this.alternativeHeight = Math.max(headWidth, tailWidth);
            startP = new Point2D.Double(0.0, this.getHeight() / 2.0);
            endP = new Point2D.Double(this.getWidth(), this.getHeight() / 2.0);
        } else if (super.getWidth() == 0.0) {
            this.alternativeWidth = Math.max(headWidth, tailWidth);
            startP = new Point2D.Double(this.getWidth() / 2.0, 0.0);
            endP = new Point2D.Double(this.getWidth() / 2.0, this.getHeight());
        } else {
            startP = new Point2D.Double(0.0, 0.0);
            endP = new Point2D.Double(this.getWidth(), this.getHeight());
        }
        SimpleShape.writePoint(this.geometricParameters, startP, this.getWidth(), this.getHeight(), "startP");
        SimpleShape.writePoint(this.geometricParameters, endP, this.getWidth(), this.getHeight(), "endP");
        if (tailType != null && !"none".equals(tailType)) {
            SimpleShape.writePoint(this.geometricParameters, SimpleShape.rotatePoint(new Point2D.Double(-tailLength, tailWidth / 2.0), endP, angle), this.getWidth(), this.getHeight(), "tailAP");
            SimpleShape.writePoint(this.geometricParameters, SimpleShape.rotatePoint(new Point2D.Double(-tailLength, -tailWidth / 2.0), endP, angle), this.getWidth(), this.getHeight(), "tailBP");
        }
        if (headType != null && !"none".equals(headType)) {
            SimpleShape.writePoint(this.geometricParameters, SimpleShape.rotatePoint(new Point2D.Double(headLength, headWidth / 2.0), startP, angle), this.getWidth(), this.getHeight(), "headAP");
            SimpleShape.writePoint(this.geometricParameters, SimpleShape.rotatePoint(new Point2D.Double(headLength, -headWidth / 2.0), startP, angle), this.getWidth(), this.getHeight(), "headBP");
        }
        this.setBgColor(this.basicStrokeData.getBorderColor());
    }

    private static void writePoint(HashMap<String, String> geometricParameters, Point2D.Double p, double width, double height, String name) {
        geometricParameters.put(name + "x", String.valueOf(p.getX() / width));
        geometricParameters.put(name + "y", String.valueOf(p.getY() / height));
    }

    private static Point2D.Double rotatePoint(Point2D.Double point, Point2D.Double relativePoint, double angleInRadians) {
        Point2D.Double result = new Point2D.Double();
        AffineTransform rotation = new AffineTransform();
        rotation.rotate(angleInRadians, 0.0, 0.0);
        rotation.transform(point, result);
        return new Point2D.Double(result.getX() + relativePoint.getX(), result.getY() + relativePoint.getY());
    }

    private int getValueFactor(String param, String type) {
        if ("none".equals(type) || param == null || this.geometricParameters.get(param) == null) {
            return 1;
        }
        switch (this.geometricParameters.get(param)) {
            case "sm": {
                return 5;
            }
            case "lg": {
                return 14;
            }
        }
        return 9;
    }

    protected HashMap<String, String> getGeometricParameters() {
        return this.geometricParameters;
    }

    public boolean isAutoFit() {
        return this.autoFit;
    }

    protected void setAutoFit(boolean autoFit) {
        this.autoFit = autoFit;
    }

    private Shape createShape(double width, double height, double x, double y) {
        Shape shape;
        Util.LOGGER.debug((Object)("\tType => " + String.valueOf((Object)this.getType()) + "\tx:y wxh " + x + ":" + y + "\t" + width + "x" + height));
        if (this.gradient != null) {
            this.backGround = this.gradient.createGradient(new Rectangle2D.Double(x, y, width, height));
        }
        switch (this.getShapeType()) {
            case round1Rect: {
                double arc = Math.min(width, height) * 0.35;
                shape = new CustomRectangle2D.Double(x, y, width, height, new double[]{0.0, arc, 0.0, 0.0}, new double[]{0.0, arc, 0.0, 0.0}, new RectangleCornerStyle[]{RectangleCornerStyle.NORMAL, RectangleCornerStyle.ROUND, RectangleCornerStyle.NORMAL, RectangleCornerStyle.NORMAL});
                break;
            }
            case snip1Rect: {
                double arc = Math.min(width, height) * 0.35;
                shape = new CustomRectangle2D.Double(x, y, width, height, new double[]{0.0, arc, 0.0, 0.0}, new double[]{0.0, arc, 0.0, 0.0}, new RectangleCornerStyle[]{RectangleCornerStyle.NORMAL, RectangleCornerStyle.BEVEL, RectangleCornerStyle.NORMAL, RectangleCornerStyle.NORMAL});
                break;
            }
            case round2DiagRect: {
                double arc = Math.min(width, height) * 0.35;
                shape = new CustomRectangle2D.Double(x, y, width, height, new double[]{arc, 0.0, arc, 0.0}, new double[]{arc, 0.0, arc, 0.0}, new RectangleCornerStyle[]{RectangleCornerStyle.ROUND, RectangleCornerStyle.NORMAL, RectangleCornerStyle.ROUND, RectangleCornerStyle.NORMAL});
                break;
            }
            case round2SameRect: {
                double arc = Math.min(width, height) * 0.35;
                shape = new CustomRectangle2D.Double(x, y, width, height, new double[]{arc, arc, 0.0, 0.0}, new double[]{arc, arc, 0.0, 0.0}, new RectangleCornerStyle[]{RectangleCornerStyle.ROUND, RectangleCornerStyle.ROUND, RectangleCornerStyle.NORMAL, RectangleCornerStyle.NORMAL});
                break;
            }
            case snip2DiagRect: {
                double arc = Math.min(width, height) * 0.35;
                shape = new CustomRectangle2D.Double(x, y, width, height, new double[]{0.0, arc, 0.0, arc}, new double[]{0.0, arc, 0.0, arc}, new RectangleCornerStyle[]{RectangleCornerStyle.NORMAL, RectangleCornerStyle.BEVEL, RectangleCornerStyle.NORMAL, RectangleCornerStyle.BEVEL});
                break;
            }
            case snip2SameRect: {
                double arc = Math.min(width, height) * 0.35;
                shape = new CustomRectangle2D.Double(x, y, width, height, new double[]{arc, arc, 0.0, 0.0}, new double[]{arc, arc, 0.0, 0.0}, new RectangleCornerStyle[]{RectangleCornerStyle.BEVEL, RectangleCornerStyle.BEVEL, RectangleCornerStyle.NORMAL, RectangleCornerStyle.NORMAL});
                break;
            }
            case snipRoundRect: {
                double arc = Math.min(width, height) * 0.35;
                shape = new CustomRectangle2D.Double(x, y, width, height, new double[]{arc, arc, 0.0, 0.0}, new double[]{arc, arc, 0.0, 0.0}, new RectangleCornerStyle[]{RectangleCornerStyle.ROUND, RectangleCornerStyle.BEVEL, RectangleCornerStyle.NORMAL, RectangleCornerStyle.NORMAL});
                break;
            }
            case roundRect: {
                double arc = Math.min(width, height) * 0.35;
                shape = new RoundRectangle2D.Double(x, y, width, height, arc, arc);
                break;
            }
            case bentConnector3: {
                Path2D.Double generalPath = new Path2D.Double();
                double percent = 0.5;
                if (this.geometricParameters != null && this.geometricParameters.get("adj") != null) {
                    String val = this.geometricParameters.get("adj");
                    if (val.startsWith("val ")) {
                        val = val.substring(4);
                    }
                    int value = Integer.parseInt(val);
                    percent = (double)value / 100000.0;
                }
                generalPath.moveTo(x, y);
                generalPath.lineTo(x + width * percent, y);
                generalPath.lineTo(x + width * percent, y + height);
                generalPath.lineTo(x + width, y + height);
                shape = generalPath;
                break;
            }
            case rect: {
                shape = new Rectangle2D.Double(x, y, width, height);
                break;
            }
            case triangle: {
                shape = DrawingFactory.triangle(x, y, width, height, this.geometricParameters);
                break;
            }
            case rtTriangle: {
                shape = DrawingFactory.rightTriangle(x, y, width, height);
                break;
            }
            case diamond: {
                shape = DrawingFactory.getDiamond(x, y, width, height, 0.0);
                break;
            }
            case nCorner: {
                shape = DrawingFactory.getShapeWithEdge(this.getShapeType().getTypeDescription(), x, y, width, height, 0.0);
                break;
            }
            case rightArrow: {
                shape = DrawingFactory.rightArrow(x, y, width, height, this.geometricParameters);
                break;
            }
            case star: {
                shape = DrawingFactory.createStar(this.getShapeType().getTypeDescription(), x, y, width, height, this.geometricParameters);
                break;
            }
            case straightConnector1: {
                shape = DrawingFactory.straightConnector(x, y, width, height, this.geometricParameters);
                break;
            }
            case multiline: {
                Path2D.Double path = new Path2D.Double();
                AffineTransform affineTransform = new AffineTransform(width, 0.0, 0.0, height, 0.0, 0.0);
                for (Path2D.Double line : this.lines) {
                    path.append(line.createTransformedShape(affineTransform), false);
                }
                shape = path;
                break;
            }
            case line: {
                if (!this.isMultiShape()) {
                    shape = this.shape != null ? this.shape : new Line2D.Double(x, y, x + width, y + height);
                    break;
                }
                double bLineWidth = Util.convertTwipsToPoint(this.basicStrokeData.getBorderLineWidth());
                shape = new Rectangle2D.Double(x += bLineWidth / 2.0, y, width -= bLineWidth, bLineWidth);
                break;
            }
            case ellipse: {
                shape = new Ellipse2D.Double(x, y, width, height);
                break;
            }
            default: {
                shape = new Rectangle2D.Double(x, y, width, height);
                Util.LOGGER.error((Object)("Not implemented shape type " + String.valueOf((Object)this.getShapeType())));
            }
        }
        return shape;
    }

    @Override
    public double getWidth() {
        double w = super.getWidth();
        return w != 0.0 ? w : this.alternativeWidth;
    }

    @Override
    public double getHeight() {
        double h = super.getHeight();
        return h != 0.0 ? h : this.alternativeHeight;
    }

    public boolean isCenteredShapeType() {
        switch (this.getShapeType()) {
            case flowChartAlternateProcess: {
                return true;
            }
        }
        return false;
    }

    public boolean isMultiShape() {
        String multiLineStyle = this.basicStrokeData.getMultiLineStyle();
        return this.getShapeType() == ShapeType.line && multiLineStyle != null && !multiLineStyle.equals("sng");
    }

    public SimpleShape[] getShapes() {
        SimpleShape[] result = null;
        if (this.getShapeType() == ShapeType.line) {
            double lineheight;
            double width = Util.convertTwipsToPoint(this.getBoundsShape().getBounds2D().getWidth());
            double xOffsetUnit = lineheight = this.basicStrokeData.getBorderLineWidth();
            double x = Util.convertTwipsToPoint(this.getTransformation().getTranslateX());
            double y = Util.convertTwipsToPoint(this.getTransformation().getTranslateY());
            String multiLineStyle = this.basicStrokeData.getMultiLineStyle();
            if ("dbl".equals(multiLineStyle)) {
                result = new SimpleShape[]{this.createSubLine(lineheight /= 3.0, x, x + width, y), this.createSubLine(lineheight, x, x + width, y += (xOffsetUnit /= 3.0) * 2.0)};
            } else if ("tri".equals(multiLineStyle)) {
                result = new SimpleShape[]{this.createSubLine(lineheight /= 6.0, x, x + width, y), this.createSubLine(lineheight * 2.0, x, x + width, y += (xOffsetUnit /= 6.0) * 2.5), this.createSubLine(lineheight, x, x + width, y += xOffsetUnit * 2.5)};
            } else if ("thickThin".equals(multiLineStyle)) {
                result = new SimpleShape[]{this.createSubLine((lineheight /= 4.0) * 2.0, x, x + width, y), this.createSubLine(lineheight, x, x + width, y += (xOffsetUnit /= 4.0) * 2.5)};
            } else if ("thinThick".equals(multiLineStyle)) {
                result = new SimpleShape[]{this.createSubLine(lineheight /= 4.0, x, x + width, y), this.createSubLine(lineheight * 2.0, x, x + width, y += (xOffsetUnit /= 4.0) * 2.5)};
            } else {
                Util.LOGGER.error((Object)("Not implemented line type " + multiLineStyle));
            }
        }
        return result;
    }

    public SimpleShape createSubLine(double lineWidth, double x, double x1, double y) {
        SimpleShape simSape = new SimpleShape(ShapeType.line.name(), new Rectangle2D.Double(x, y, Math.abs(x - x1), 1.0));
        simSape.getBasicStrokeData().setBorderColor(this.basicStrokeData.getBorderColor());
        simSape.backGround = this.getBackgroundColor();
        simSape.getBasicStrokeData().setLineStyle(this.basicStrokeData.getLineStyle());
        simSape.getBasicStrokeData().setBorderLineWidth(lineWidth);
        simSape.shape = new Line2D.Double(x, y, x1, y);
        return simSape;
    }

    public void setVML(boolean VML) {
        this.isVML = VML;
    }

    @Override
    public void setHeight(double height) {
        if (!this.isVML) {
            super.setHeight(height);
        }
    }

    @Override
    public void setWidth(double width) {
        if (!this.isVML) {
            super.setWidth(width);
        }
    }

    public void setPictAlign(String align) {
        this.hrAlign = align;
    }

    @Override
    public List<DrawingElement> getElements() {
        return new ArrayList<DrawingElement>();
    }

    @Override
    public Shape getBoundsShape() {
        Shape shape = this.createShape(this.getWidth(), this.getHeight(), this.getPosition().getX(), this.getPosition().getY());
        return this.getTransformation().createTransformedShape(shape);
    }

    @Override
    public BorderLineExternalWidths getBorderLineExternalWidths() {
        return new BorderLineExternalWidths(this.basicStrokeData.getBorderLineWidth() / 2.0);
    }

    public BasicStrokeData getBasicStrokeData() {
        return this.basicStrokeData;
    }

    @Override
    public String toString() {
        return "SimpleShape{lineStyle=" + String.valueOf((Object)this.getShapeType()) + "\tsize = (" + this.getBoundsShape().getBounds2D().getWidth() + " x " + this.getBoundsShape().getBounds2D().getHeight() + ") }";
    }

    protected static enum ShapeType {
        line,
        rect,
        multiline,
        star,
        ellipse,
        roundRect,
        rightArrow,
        flowChartAlternateProcess,
        diamond,
        bracketPair,
        straightConnector1,
        nCorner,
        bentConnector3,
        flowChartDecision,
        ellipseRibbon,
        triangle,
        rtTriangle,
        foldedCorner,
        horizontalScroll,
        snip1Rect,
        snip2DiagRect,
        snip2SameRect,
        snipRoundRect,
        round1Rect,
        round2DiagRect,
        round2SameRect,
        cloud,
        arc,
        quadArrow,
        leftArrow,
        cube;

        int typeDescription = 0;

        public int getTypeDescription() {
            return this.typeDescription;
        }

        public void setTypeDescription(int typeDescription) {
            this.typeDescription = typeDescription;
        }
    }

    protected static enum NCornerType {
        pentagon(5),
        hexagon(6),
        heptagon(7),
        octagon(8),
        decagon(10),
        dodecagon(12);

        private int numOfCorner;

        private NCornerType(int numOfCorner) {
            this.numOfCorner = numOfCorner;
        }

        public int getNumOfCorner() {
            return this.numOfCorner;
        }
    }
}

