/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.view.drawing;

import com.inet.docx.document.utilities.Util;
import com.inet.docx.view.drawing.AbstractDrawingElement;
import com.inet.docx.view.drawing.BasicStrokeData;
import com.inet.docx.view.drawing.BorderLineExternalWidths;
import com.inet.docx.view.drawing.DrawingElement;
import com.inet.docx.view.drawing.DrawingReflection;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.openxmlformats.schemas.drawingml.x2006.main.CTBlipFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTRelativeRect;

public class PictureElement
extends AbstractDrawingElement {
    private String referenceId;
    private RelativeRect sourceRect = new RelativeRect();
    private RelativeRect targetRect = new RelativeRect();
    private boolean rotateWithShape = true;
    private AffineTransform renderTransform;
    private BasicStrokeData basicStrokeData = new BasicStrokeData();

    public PictureElement(Rectangle2D bounds, double rotation, double scaleX, double scaleY, String referenceId, CTBlipFillProperties blip, DrawingReflection reflection) {
        super(bounds, rotation, scaleX, scaleY, reflection);
        this.referenceId = referenceId;
        if (blip != null) {
            if (blip.getSrcRect() != null) {
                this.sourceRect = new RelativeRect(blip.getSrcRect());
            }
            this.rotateWithShape = blip.getRotWithShape();
            if (blip.getStretch() != null && blip.getStretch().getFillRect() != null) {
                this.targetRect = new RelativeRect(blip.getStretch().getFillRect());
            }
        }
    }

    public PictureElement(Rectangle2D bounds, double rotation, double scaleX, double scaleY, String referenceId, CTBlipFillProperties blip) {
        this(bounds, rotation, scaleX, scaleY, referenceId, blip, DrawingReflection.NONE);
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    @Override
    public List<DrawingElement> getElements() {
        return new ArrayList<DrawingElement>();
    }

    public AffineTransform getRenderTransform() {
        if (this.renderTransform == null) {
            Util.LOGGER.warn((Object)"getRenderTransform is not set yet!");
            return new AffineTransform();
        }
        return new AffineTransform(this.renderTransform);
    }

    @Override
    public BorderLineExternalWidths getBorderLineExternalWidths() {
        return new BorderLineExternalWidths(this.basicStrokeData.getBorderLineWidth());
    }

    public BasicStrokeData getBasicStrokeData() {
        return this.basicStrokeData;
    }

    private static class RelativeRect {
        private double bottom;
        private double top;
        private double left;
        private double right;

        public RelativeRect() {
        }

        public RelativeRect(CTRelativeRect source) {
            this.bottom = Util.getDouble(source.getB());
            this.top = Util.getDouble(source.getT());
            this.left = Util.getDouble(source.getL());
            this.right = Util.getDouble(source.getR());
        }

        public Rectangle getTransformedRect(Rectangle input) {
            int temp;
            int x0 = input.x + (int)((double)input.width * this.left);
            int x1 = input.x + input.width - (int)((double)input.width * this.right);
            int y0 = input.y + (int)((double)input.height * this.top);
            int y1 = input.y + input.height - (int)((double)input.height * this.bottom);
            if (x0 > x1) {
                temp = x1;
                x1 = x0;
                x0 = temp;
            }
            if (y0 > y1) {
                temp = y1;
                y1 = y0;
                y0 = temp;
            }
            return new Rectangle(x0, y0, x1 - x0, y1 - y0);
        }

        public Rectangle2D getTransformedRect(Rectangle2D input) {
            double temp;
            double x0 = input.getX() + (double)((int)(input.getWidth() * this.left));
            double x1 = input.getX() + input.getWidth() - (double)((int)(input.getWidth() * this.right));
            double y0 = input.getY() + (double)((int)(input.getHeight() * this.top));
            double y1 = input.getY() + input.getHeight() - (double)((int)(input.getHeight() * this.bottom));
            if (x0 > x1) {
                temp = x1;
                x1 = x0;
                x0 = temp;
            }
            if (y0 > y1) {
                temp = y1;
                y1 = y0;
                y0 = temp;
            }
            return new Rectangle2D.Double(x0, y0, x1 - x0, y1 - y0);
        }

        public boolean isRelevant() {
            return this.bottom != 0.0 || this.top != 0.0 || this.left != 0.0 || this.right != 0.0;
        }
    }
}

