/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.document.excel.coditional;

import com.inet.docx.document.elements.subelements.table.TableCell;
import com.inet.docx.document.excel.WorkbookAnalyzer;
import com.inet.docx.document.excel.coditional.CellAddressAndValue;
import com.inet.docx.document.excel.coditional.ConditionalFormatingHandler;
import com.inet.docx.document.excel.coditional.FormatingHandler;
import com.inet.docx.document.excel.coditional.UpdateValueController;
import com.inet.docx.document.utilities.Util;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.poi.ss.util.CellAddress;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCfvo;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTColor;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTColorScale;

public class ColorScaleHandler
extends FormatingHandler {
    private HashMap<CellAddress, Color> settings;
    private List<Color> colors = new ArrayList<Color>();
    private List<Double> thresholdValues;

    protected ColorScaleHandler(int priority, ConditionalFormatingHandler formatingHandler, CTColorScale colScale, List<CellAddressAndValue> cellValues) {
        super(priority, formatingHandler, null);
        for (CTColor colorDef : colScale.getColorList()) {
            this.colors.add(Util.convertCtColor(colorDef, formatingHandler.getThemesTable()));
        }
        this.thresholdValues = new ArrayList<Double>();
        for (CTCfvo threshold : colScale.getCfvoList()) {
            this.thresholdValues.add(this.getThresholdValue(threshold.getType().toString(), threshold.getVal(), cellValues));
        }
        this.settings = new HashMap();
    }

    @Override
    protected void checkValues(List<CellAddressAndValue> cellValues, WorkbookAnalyzer.IndexSizeAndStyle[] rows, WorkbookAnalyzer.IndexSizeAndStyle[] columns) {
        for (CellAddressAndValue cellValue : cellValues) {
            if (!cellValue.isNumeric() || !ColorScaleHandler.isInDisplayedRange(rows, columns, cellValue.getAddress())) continue;
            Color color = this.getColorForValue(cellValue.getDoubleValue(), this.thresholdValues, this.colors);
            this.settings.put(cellValue.getAddress(), color);
        }
    }

    private Color getColorForAddress(CellAddress address) {
        return this.settings.get(address);
    }

    private Double getThresholdValue(String type, String value, List<CellAddressAndValue> values) {
        switch (type) {
            case "min": {
                return values.get(0).getDoubleValue();
            }
            case "max": {
                return this.getLastDoubleValue(values);
            }
            case "percentile": {
                Double min = values.get(0).getDoubleValue();
                if (min == null) {
                    return min;
                }
                Double max = this.getLastDoubleValue(values);
                double differenze = max - min;
                double pecentage = Double.parseDouble(value) / 100.0;
                return min + differenze * pecentage;
            }
        }
        Util.LOGGER.error((Object)("Unhandeld threshold value type: " + type));
        return null;
    }

    public Double getLastDoubleValue(List<CellAddressAndValue> values) {
        for (int i = values.size() - 1; i >= 0; --i) {
            if (!values.get(i).isNumeric()) continue;
            return values.get(i).getDoubleValue();
        }
        return null;
    }

    private Color getColorForValue(Double value, List<Double> thresholdValues, List<Color> colors) {
        if (value <= thresholdValues.get(1)) {
            return this.calculateColor(value, thresholdValues.get(0), thresholdValues.get(1), colors.get(0), colors.get(1));
        }
        return this.calculateColor(value, thresholdValues.get(1), thresholdValues.get(2), colors.get(1), colors.get(2));
    }

    private Color calculateColor(Double value, Double minValue, Double maxValue, Color colStart, Color colEnd) {
        if (value.doubleValue() == minValue.doubleValue()) {
            return colStart;
        }
        if (value.doubleValue() == maxValue.doubleValue()) {
            return colEnd;
        }
        double percentage = (value - minValue) / (maxValue - minValue);
        int red = this.colValue(percentage, colStart.getRed(), colEnd.getRed());
        int green = this.colValue(percentage, colStart.getGreen(), colEnd.getGreen());
        int blue = this.colValue(percentage, colStart.getBlue(), colEnd.getBlue());
        int alpha = this.colValue(percentage, colStart.getAlpha(), colEnd.getAlpha());
        return new Color(red, green, blue, alpha);
    }

    private int colValue(double percentage, int colMin, int colMax) {
        return (int)((double)(colMax - colMin) * percentage) + colMin;
    }

    @Override
    public boolean handleFormating(TableCell tc, CellAddress cellAddress, UpdateValueController updateController) {
        Color col = this.getColorForAddress(cellAddress);
        if (col != null) {
            tc.getCellStyle().setCellBackground(col);
            updateController.setBackgroundSet(true);
            return this.isStopIfTrue();
        }
        return false;
    }
}

