/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.document.elements.subelements.drawing;

import com.inet.docx.document.elements.style.Spacing;
import com.inet.docx.document.utilities.Util;
import com.inet.docx.view.PageProperties;
import com.inet.docx.view.drawing.BorderLineExternalWidths;
import javax.annotation.Nonnull;

public class Anchor {
    private Reference anchorPosition;
    private Align anchorAlign;
    private double anchorOffset;
    private boolean isPercentageValue;
    private boolean isVertical;

    public Anchor(String anchorPosition, String anchorAlign, double anchorOffset, boolean isPercentageValue, boolean isVertical) {
        this(Anchor.getReference(anchorPosition), Anchor.getAlign(anchorAlign), anchorOffset, isPercentageValue, isVertical);
    }

    public Anchor(Reference anchorPosition, @Nonnull Align anchorAlign, double anchorOffset, boolean isPercentageValue, boolean isVertical) {
        this.isVertical = isVertical;
        this.anchorPosition = anchorPosition;
        this.anchorAlign = anchorAlign;
        this.anchorOffset = anchorOffset;
        this.isPercentageValue = isPercentageValue;
    }

    public Align getAlign() {
        return this.anchorAlign;
    }

    public Reference getReferencePosition() {
        return this.anchorPosition;
    }

    public boolean isPercentageValue() {
        return this.isPercentageValue;
    }

    public boolean isAnchoredTop() {
        return this.anchorAlign == Align.top && this.anchorPosition == Reference.paragraph;
    }

    public double getOffsetValue() {
        return this.anchorOffset;
    }

    private double calculateRelativeValue(PageProperties pageProps, boolean oddPage, BorderLineExternalWidths borderLineWidths) {
        double result = 0.0;
        double pct = this.anchorOffset / 100000.0;
        boolean handleBorder = pct != 0.0;
        switch (this.simplifyReference(this.getReferencePosition(), oddPage)) {
            case page: {
                if (this.isVertical) {
                    result = (double)pageProps.getPageHeight() * pct;
                    if (!handleBorder) break;
                    result += borderLineWidths.getTop();
                    break;
                }
                result = (double)pageProps.getPageWidth() * pct;
                if (!handleBorder) break;
                result += borderLineWidths.getLeft();
                break;
            }
            case margin: {
                if (this.isVertical) {
                    double availableHeight = pageProps.getPageHeight() - pageProps.getMarginTop() - pageProps.getMarginBottom();
                    result = (double)pageProps.getMarginTop() + availableHeight * pct;
                    if (!handleBorder) break;
                    result += borderLineWidths.getTop();
                    break;
                }
                double availableWidth = pageProps.getPageWidth() - pageProps.getMarginLeft() - pageProps.getMarginRight();
                result = (double)pageProps.getMarginLeft() + availableWidth * pct;
                if (!handleBorder) break;
                result += borderLineWidths.getLeft();
                break;
            }
            case bottomMargin: {
                result = (double)(pageProps.getPageHeight() - pageProps.getMarginBottom()) + (double)pageProps.getMarginBottom() * pct;
                if (!handleBorder) break;
                result += borderLineWidths.getTop();
                break;
            }
            case topMargin: {
                result = (double)pageProps.getMarginTop() * pct;
                if (!handleBorder) break;
                result += borderLineWidths.getTop();
                break;
            }
            case leftMargin: {
                result = (double)pageProps.getMarginLeft() * pct;
                if (!handleBorder) break;
                result += borderLineWidths.getLeft();
                break;
            }
            case rightMargin: {
                result = (double)(pageProps.getPageWidth() - pageProps.getMarginRight()) + (double)pageProps.getMarginRight() * pct;
                if (!handleBorder) break;
                result += borderLineWidths.getLeft();
                break;
            }
            default: {
                Util.LOGGER.error((Object)("Anchor calculateRelativeValue " + String.valueOf((Object)this.getReferencePosition()) + " not implemented!"));
            }
        }
        if (Util.isDebugMode) {
            Util.LOGGER.debug((Object)("relative => " + result + " \tisVertical => " + this.isVertical + "\tpercent => " + pct));
        }
        return result;
    }

    private static Reference getReference(String reference) {
        try {
            if ("char".equals(reference)) {
                return Reference.character;
            }
            return Reference.valueOf(reference);
        }
        catch (Exception e) {
            IllegalArgumentException ex = new IllegalArgumentException("Unknown reference type '" + reference + "'");
            ex.initCause(e);
            Util.LOGGER.error((Throwable)ex);
            return Reference.bottomMargin;
        }
    }

    private static Align getAlign(String align) {
        try {
            return Align.valueOf(align);
        }
        catch (Exception e) {
            IllegalArgumentException ex = new IllegalArgumentException("Unknown align type '" + align + "'");
            ex.initCause(e);
            Util.LOGGER.error((Throwable)ex);
            return Align.bottom;
        }
    }

    public double getPositionValue(PageProperties pageProperties, double sizeValue, double position, boolean oddPage, BorderLineExternalWidths borderLineWidths) {
        if (this.isPercentageValue) {
            return this.calculateRelativeValue(pageProperties, oddPage, borderLineWidths);
        }
        double positionValue = 0.0;
        Reference referencePosition = this.getReferencePosition();
        if (referencePosition == null) {
            Util.LOGGER.debug((Object)("Drawing calculate position " + String.valueOf((Object)referencePosition) + " not implemented!"));
            return this.getOffsetValue();
        }
        referencePosition = this.simplifyReference(referencePosition, oddPage);
        if (this.isVertical) {
            block0 : switch (referencePosition) {
                case page: {
                    Align alignVertPage = this.getAlign();
                    if (Align.outside.equals((Object)alignVertPage)) {
                        alignVertPage = Align.inside;
                        oddPage = !oddPage;
                    }
                    switch (alignVertPage) {
                        case inside: {
                            if (oddPage) {
                                positionValue = (double)(pageProperties.getHeaderTop() / 2) + borderLineWidths.getTop();
                                break block0;
                            }
                            positionValue = (double)pageProperties.getPageHeight() - sizeValue - (double)(pageProperties.getFooterBottom() / 2) - borderLineWidths.getBottom();
                            break block0;
                        }
                        case center: {
                            positionValue = ((double)pageProperties.getPageHeight() - sizeValue) / 2.0;
                            break block0;
                        }
                        case bottom: {
                            positionValue = (double)pageProperties.getPageHeight() - sizeValue - borderLineWidths.getBottom();
                            break block0;
                        }
                        case absolute: {
                            positionValue = this.getOffsetValue();
                            break block0;
                        }
                    }
                    positionValue = borderLineWidths.getTop();
                    break;
                }
                case margin: {
                    switch (this.simplifyAlign(this.getAlign(), oddPage)) {
                        case center: {
                            positionValue = (double)pageProperties.getMarginTop() + ((double)(pageProperties.getPageHeight() - pageProperties.getMarginTop() - pageProperties.getMarginBottom()) - sizeValue) / 2.0;
                            break block0;
                        }
                        case bottom: {
                            positionValue = (double)(pageProperties.getPageHeight() - pageProperties.getMarginBottom()) - sizeValue - borderLineWidths.getBottom();
                            break block0;
                        }
                        case absolute: {
                            positionValue = (double)pageProperties.getMarginTop() + this.getOffsetValue();
                            break block0;
                        }
                    }
                    positionValue = (double)pageProperties.getMarginTop() + borderLineWidths.getTop();
                    break;
                }
                case paragraph: {
                    positionValue = position + this.getOffsetValue();
                    break;
                }
                case line: {
                    positionValue = position + this.getOffsetValue();
                    break;
                }
                case topMargin: {
                    switch (this.simplifyAlign(this.getAlign(), oddPage)) {
                        case center: {
                            positionValue = ((double)pageProperties.getMarginTop() - sizeValue) / 2.0;
                            break block0;
                        }
                        case bottom: {
                            positionValue = (double)pageProperties.getMarginTop() - sizeValue - borderLineWidths.getBottom();
                            break block0;
                        }
                        case absolute: {
                            positionValue = this.getOffsetValue();
                            break block0;
                        }
                    }
                    positionValue = borderLineWidths.getTop();
                    break;
                }
                case bottomMargin: {
                    switch (this.simplifyAlign(this.getAlign(), oddPage)) {
                        case center: {
                            positionValue = (double)(pageProperties.getPageHeight() - pageProperties.getMarginBottom()) + ((double)pageProperties.getMarginBottom() - sizeValue) / 2.0;
                            break block0;
                        }
                        case bottom: {
                            positionValue = (double)pageProperties.getPageHeight() - sizeValue - borderLineWidths.getBottom();
                            break block0;
                        }
                        case absolute: {
                            positionValue = (double)(pageProperties.getPageHeight() - pageProperties.getMarginBottom()) + this.getOffsetValue();
                            break block0;
                        }
                    }
                    positionValue = (double)(pageProperties.getPageHeight() - pageProperties.getMarginBottom()) + borderLineWidths.getTop();
                    break;
                }
                case text: {
                    positionValue = position + this.getOffsetValue();
                    break;
                }
                default: {
                    positionValue = this.getOffsetValue();
                    Util.LOGGER.error((Object)("Drawing calculate vertical position " + String.valueOf((Object)referencePosition) + " not implemented!"));
                    break;
                }
            }
        } else {
            block30 : switch (referencePosition) {
                case column: {
                    double columnXPos = pageProperties.getColumnXPos(0);
                    double columnWidth = pageProperties.getColumnWidth(0);
                    for (int i = 0; i < pageProperties.getColumnCount(); ++i) {
                        if (!((double)pageProperties.getColumnXPos(i) <= position)) continue;
                        columnXPos = pageProperties.getColumnXPos(i);
                        columnWidth = pageProperties.getColumnWidth(i);
                    }
                    switch (this.getAlign()) {
                        case right: {
                            positionValue = columnXPos + columnWidth - sizeValue - borderLineWidths.getRight();
                            break block30;
                        }
                        case center: {
                            positionValue = columnXPos + columnWidth / 2.0 - sizeValue / 2.0;
                            break block30;
                        }
                        case absolute: {
                            positionValue = columnXPos + this.getOffsetValue();
                            break block30;
                        }
                    }
                    positionValue = columnXPos + borderLineWidths.getLeft();
                    break;
                }
                case margin: {
                    switch (this.simplifyAlign(this.getAlign(), oddPage)) {
                        case right: {
                            positionValue = (double)(pageProperties.getPageWidth() - pageProperties.getMarginRight()) - sizeValue - borderLineWidths.getRight();
                            break block30;
                        }
                        case center: {
                            positionValue = (double)pageProperties.getMarginLeft() + ((double)(pageProperties.getPageWidth() - pageProperties.getMarginRight() - pageProperties.getMarginLeft()) - sizeValue) / 2.0;
                            break block30;
                        }
                        case absolute: {
                            positionValue = (double)pageProperties.getMarginLeft() + this.getOffsetValue();
                            break block30;
                        }
                    }
                    positionValue = (double)pageProperties.getMarginLeft() + borderLineWidths.getLeft();
                    break;
                }
                case page: {
                    switch (this.simplifyAlign(this.getAlign(), oddPage)) {
                        case right: {
                            positionValue = (double)pageProperties.getPageWidth() - sizeValue - borderLineWidths.getRight();
                            break block30;
                        }
                        case center: {
                            positionValue = ((double)pageProperties.getPageWidth() - sizeValue) / 2.0;
                            break block30;
                        }
                        case absolute: {
                            positionValue = this.getOffsetValue();
                            break block30;
                        }
                    }
                    positionValue = borderLineWidths.getLeft();
                    break;
                }
                case leftMargin: {
                    switch (this.getAlign()) {
                        case center: {
                            positionValue = ((double)pageProperties.getMarginLeft() - sizeValue) / 2.0;
                            break block30;
                        }
                        case right: {
                            positionValue = (double)pageProperties.getMarginLeft() - sizeValue - borderLineWidths.getRight();
                            break block30;
                        }
                        case absolute: {
                            positionValue = this.getOffsetValue();
                            break block30;
                        }
                    }
                    positionValue = borderLineWidths.getLeft();
                    break;
                }
                case rightMargin: {
                    switch (this.getAlign()) {
                        case center: {
                            positionValue = (double)(pageProperties.getPageWidth() - pageProperties.getMarginRight()) + ((double)pageProperties.getMarginRight() - sizeValue) / 2.0;
                            break block30;
                        }
                        case right: {
                            positionValue = (double)pageProperties.getPageWidth() - sizeValue - borderLineWidths.getRight();
                            break block30;
                        }
                        case absolute: {
                            positionValue = (double)(pageProperties.getPageWidth() - pageProperties.getMarginRight()) + this.getOffsetValue();
                            break block30;
                        }
                    }
                    positionValue = (double)(pageProperties.getPageWidth() - pageProperties.getMarginRight()) + borderLineWidths.getLeft();
                    break;
                }
                case character: {
                    switch (this.getAlign()) {
                        case center: {
                            positionValue = position - sizeValue / 2.0;
                            break block30;
                        }
                        case right: {
                            positionValue = position - sizeValue - borderLineWidths.getRight();
                            break block30;
                        }
                        case absolute: {
                            positionValue = position + this.getOffsetValue();
                            break block30;
                        }
                    }
                    positionValue = position + borderLineWidths.getLeft();
                    break;
                }
                default: {
                    positionValue = (double)pageProperties.getMarginLeft() + this.getOffsetValue();
                    Util.LOGGER.error((Object)("Drawing calculate horizontal position " + String.valueOf((Object)referencePosition) + " not implemented!"));
                }
            }
        }
        return positionValue;
    }

    public double calculateVerticalOffsetForElementAnchoredToLine(double lineHeight, Spacing spacing, LinePosition linePosition, double elementHeight, double borderLineWidth, boolean oddPage) {
        double offsetY = 0.0;
        if (Reference.line.equals((Object)this.getReferencePosition())) {
            block0 : switch (this.simplifyAlign(this.getAlign(), oddPage)) {
                case top: {
                    offsetY = borderLineWidth / 2.0;
                    switch (linePosition) {
                        case onlyLine: 
                        case firstLine: {
                            offsetY -= (double)spacing.getBefore();
                            break block0;
                        }
                    }
                    break;
                }
                case center: {
                    switch (linePosition) {
                        case onlyLine: {
                            offsetY = ((lineHeight += (double)(spacing.getBefore() + spacing.getAfter())) - elementHeight) / 2.0;
                            offsetY -= (double)spacing.getBefore();
                            break;
                        }
                        case firstLine: {
                            offsetY = ((lineHeight += (double)spacing.getBefore()) - elementHeight) / 2.0;
                            offsetY -= (double)spacing.getBefore();
                            break;
                        }
                        case middleLine: {
                            offsetY = (lineHeight - elementHeight) / 2.0;
                            break;
                        }
                        case lastLine: {
                            offsetY = ((lineHeight += (double)spacing.getAfter()) - elementHeight) / 2.0;
                        }
                    }
                    break;
                }
                case bottom: {
                    switch (linePosition) {
                        case onlyLine: 
                        case lastLine: {
                            lineHeight += (double)spacing.getAfter();
                            break;
                        }
                    }
                    offsetY = lineHeight - elementHeight - borderLineWidth / 2.0;
                    break;
                }
                case absolute: {
                    switch (linePosition) {
                        case onlyLine: 
                        case firstLine: {
                            offsetY -= (double)spacing.getBefore();
                            break block0;
                        }
                    }
                    break;
                }
            }
        }
        return offsetY;
    }

    private Reference simplifyReference(Reference reference, boolean oddPage) {
        if (this.isVertical) {
            if (Reference.insideMargin == reference) {
                return oddPage ? Reference.topMargin : Reference.bottomMargin;
            }
            if (Reference.outsideMargin == reference) {
                return oddPage ? Reference.bottomMargin : Reference.topMargin;
            }
        } else {
            if (Reference.insideMargin == reference) {
                return oddPage ? Reference.leftMargin : Reference.rightMargin;
            }
            if (Reference.outsideMargin == reference) {
                return oddPage ? Reference.rightMargin : Reference.leftMargin;
            }
        }
        return reference;
    }

    private Align simplifyAlign(Align align, boolean oddPage) {
        if (Align.inside.equals((Object)align)) {
            if (this.isVertical) {
                return oddPage ? Align.top : Align.bottom;
            }
            return oddPage ? Align.left : Align.right;
        }
        if (Align.outside.equals((Object)align)) {
            if (this.isVertical) {
                return oddPage ? Align.bottom : Align.top;
            }
            return oddPage ? Align.right : Align.left;
        }
        return align;
    }

    public String toString() {
        return "Anchor{anchorPosition=" + String.valueOf((Object)this.anchorPosition) + ", anchorAlign=" + String.valueOf((Object)this.anchorAlign) + ", anchorOffset=" + this.anchorOffset + ", isPercentageValue=" + this.isPercentageValue + ", isVertical=" + this.isVertical + "}";
    }

    public static enum Reference {
        page,
        margin,
        insideMargin,
        outsideMargin,
        text,
        paragraph,
        line,
        topMargin,
        bottomMargin,
        column,
        character,
        leftMargin,
        rightMargin;

    }

    public static enum Align {
        top,
        left,
        right,
        center,
        inside,
        outside,
        inline,
        bottom,
        absolute;

    }

    public static enum LinePosition {
        onlyLine,
        firstLine,
        middleLine,
        lastLine;


        public static LinePosition getLinePosition(boolean firstLine, boolean lastLine) {
            if (firstLine && lastLine) {
                return onlyLine;
            }
            if (firstLine) {
                return LinePosition.firstLine;
            }
            if (lastLine) {
                return LinePosition.lastLine;
            }
            return middleLine;
        }
    }
}

