/*
 * Decompiled with CFR 0.152.
 */
package com.inet.emf;

import com.inet.emf.EmfRecordExecutor;
import com.inet.emf.EmfRecords;
import com.inet.emf.EmfUtil;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;

public class EMFDecoder {
    private InputStream inputStream;
    private BufferedImage image;

    public EMFDecoder(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    private void read() {
        LinkedList<EmfRecords> bufferedRecords = new LinkedList<EmfRecords>();
        EmfRecords header = null;
        EmfRecordExecutor executor = new EmfRecordExecutor();
        block4: while (true) {
            try {
                while (this.inputStream.available() >= 8) {
                    byte[] typeAndSize = new byte[8];
                    this.inputStream.read(typeAndSize, 0, typeAndSize.length);
                    int typeID = EmfUtil.read4BytesInteger(typeAndSize, 0);
                    int size = EmfUtil.read4BytesInteger(typeAndSize, 4);
                    byte[] data = new byte[size];
                    System.arraycopy(typeAndSize, 0, data, 0, typeAndSize.length);
                    this.inputStream.read(data, typeAndSize.length, size - typeAndSize.length);
                    EmfRecords record = EmfUtil.getRecords(typeID);
                    record.read(data, 0);
                    try {
                        if (typeID == 1) {
                            if (header == null) {
                                header = record;
                                header.execute(executor);
                                if (bufferedRecords.isEmpty()) continue block4;
                                for (EmfRecords bufferedRecord : bufferedRecords) {
                                    bufferedRecord.execute(executor);
                                }
                                bufferedRecords.clear();
                                continue block4;
                            }
                            EmfUtil.getLogger().error((Object)"More than 1 header record was founded");
                            continue block4;
                        }
                        if (header == null) {
                            bufferedRecords.add(record);
                            continue block4;
                        }
                        record.execute(executor);
                        continue block4;
                    }
                    catch (Throwable th) {
                        EmfUtil.getLogger().error((Object)("Exception in Execute a record = " + String.valueOf(th) + "\t" + String.valueOf(th.getStackTrace()[0])));
                    }
                }
                break;
            }
            catch (IOException e) {
                EmfUtil.getLogger().error((Object)("Inputstream can't read." + String.valueOf(e)));
                break;
            }
        }
        this.image = executor.getImage();
    }

    public BufferedImage getImage() {
        if (this.image == null) {
            this.read();
        }
        return this.image;
    }
}

