/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.xwpf.usermodel;

import com.inet.docx.document.elements.style.Spacing;
import com.inet.docx.document.utilities.Util;
import com.inet.docx.xwpf.usermodel.XWPFThemeData;
import java.util.HashMap;
import java.util.Map;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFonts;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHpsMeasure;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTJc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTLanguage;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPPrGeneral;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STJc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STTheme;

public class XWPFStyleDefaults {
    private int defaultFontSize = 11;
    private Spacing defaultSpacing;
    private STJc.Enum defaultHorizontalAlign;
    private String majorLatinThemeFont = null;
    private String minorLatinThemeFont = null;
    private String minorLatinFont = null;
    private String majorBidiFont = null;
    private String minorBidiFont = null;
    private String majorEastAsiaFont = null;
    private String minorEastAsiaFont = null;
    private String languageBidi;
    private String languageEastAsia;
    private String languageVal;
    private Map<String, String> language_typeface_minor;
    private Map<String, String> language_typeface_major;
    private static Map<String, String> default_typeface = new HashMap<String, String>();

    public static XWPFStyleDefaults getDefaultInstance() {
        XWPFStyleDefaults styleDefaults = new XWPFStyleDefaults();
        styleDefaults.defaultSpacing = Spacing.getDefaultInstance();
        styleDefaults.majorLatinThemeFont = "Calibri Light";
        styleDefaults.minorLatinThemeFont = "Calibri";
        styleDefaults.majorBidiFont = "Times New Roman";
        styleDefaults.minorBidiFont = "Arial";
        styleDefaults.languageBidi = "ar";
        styleDefaults.languageEastAsia = "de";
        styleDefaults.languageVal = "de";
        styleDefaults.language_typeface_minor = new HashMap<String, String>(default_typeface);
        styleDefaults.language_typeface_major = new HashMap<String, String>(default_typeface);
        return styleDefaults;
    }

    private XWPFStyleDefaults() {
    }

    public XWPFStyleDefaults(CTRPr runDefaults, CTPPrGeneral paragraphDefaults, CTLanguage themeFontLang) {
        CTJc jc;
        CTJc cTJc = jc = paragraphDefaults != null ? paragraphDefaults.getJc() : null;
        if (jc != null) {
            this.defaultHorizontalAlign = jc.getVal();
        }
        this.checkLanguageSettings(themeFontLang);
        if (runDefaults != null) {
            this.checkLanguageSettings(Util.getLast(runDefaults.getLangArray()));
            CTFonts fonts = Util.getLast(runDefaults.getRFontsArray());
            if (fonts != null) {
                CTHpsMeasure sz;
                if (fonts.getAscii() != null) {
                    this.minorLatinFont = fonts.getAscii();
                }
                if ((sz = Util.getLast(runDefaults.getSzArray())) != null) {
                    this.defaultFontSize = Util.getInt(sz.getVal()) / 2;
                }
            }
        }
        this.defaultSpacing = paragraphDefaults != null && paragraphDefaults.isSetSpacing() ? new Spacing(paragraphDefaults.getSpacing(), null) : new Spacing(null, null);
    }

    private void checkLanguageSettings(CTLanguage themeFontLang) {
        if (themeFontLang != null) {
            this.languageBidi = XWPFStyleDefaults.getLanguageKey(themeFontLang.getBidi(), this.languageBidi);
            this.languageEastAsia = XWPFStyleDefaults.getLanguageKey(themeFontLang.getEastAsia(), this.languageEastAsia);
            this.languageVal = XWPFStyleDefaults.getLanguageKey(themeFontLang.getVal(), this.languageVal);
        }
    }

    private static String getLanguageKey(Object lang, String langDefault) {
        String result;
        if (lang != null && (result = lang.toString()).length() > 2) {
            return result.substring(0, 2);
        }
        return langDefault;
    }

    public void handleThemeSettings(XWPFThemeData theme) {
        this.majorLatinThemeFont = theme.getMajorLatinFont();
        this.minorLatinThemeFont = theme.getMinorLatinFont();
        this.language_typeface_minor = theme.getTypefaceForLanguage(false);
        this.language_typeface_major = theme.getTypefaceForLanguage(true);
        if (this.languageBidi != null) {
            this.majorBidiFont = this.language_typeface_major.get(this.languageBidi);
            this.minorBidiFont = this.language_typeface_minor.get(this.languageBidi);
        }
        if (this.languageEastAsia != null) {
            this.majorEastAsiaFont = this.language_typeface_major.get(this.languageEastAsia);
            this.minorEastAsiaFont = this.language_typeface_minor.get(this.languageEastAsia);
        }
    }

    public String getFontName(CTFonts fonts) {
        if (fonts != null) {
            if (fonts.getHAnsi() != null) {
                return fonts.getHAnsi();
            }
            if (fonts.getAscii() != null) {
                return fonts.getAscii();
            }
            return this.getFontName(fonts.getAsciiTheme());
        }
        return null;
    }

    public String getFontName(STTheme.Enum theme) {
        if (STTheme.MAJOR_H_ANSI.equals(theme) || STTheme.MAJOR_ASCII.equals(theme)) {
            return this.getMajorLatinThemeFont();
        }
        if (STTheme.MINOR_H_ANSI.equals(theme) || STTheme.MINOR_ASCII.equals(theme)) {
            return this.getMinorLatinThemeFont();
        }
        if (STTheme.MAJOR_BIDI.equals(theme)) {
            return this.majorBidiFont;
        }
        if (STTheme.MINOR_BIDI.equals(theme)) {
            return this.minorBidiFont;
        }
        if (STTheme.MAJOR_EAST_ASIA.equals(theme)) {
            return this.majorEastAsiaFont;
        }
        if (STTheme.MINOR_EAST_ASIA.equals(theme)) {
            return this.minorEastAsiaFont;
        }
        return null;
    }

    public int getDefaultFontSize() {
        return this.defaultFontSize;
    }

    public Spacing getDefaultSpacing() {
        return this.defaultSpacing;
    }

    public STJc.Enum getDefaultHorizontalAlign() {
        return this.defaultHorizontalAlign;
    }

    public String getMinorLatinThemeFont() {
        return this.minorLatinThemeFont;
    }

    public String getMajorLatinThemeFont() {
        return this.majorLatinThemeFont;
    }

    public String getMinorLatinFont() {
        if (this.minorLatinFont != null) {
            return this.minorLatinFont;
        }
        return this.getMinorLatinThemeFont();
    }

    static {
        default_typeface.put("ar", "Arial");
        default_typeface.put("hy", "Arial");
        default_typeface.put("km", "DaunPenh");
        default_typeface.put("kn", "Tunga");
        default_typeface.put("vi", "Arial");
        default_typeface.put("th", "Cordia New");
        default_typeface.put("ka", "Sylfaen");
        default_typeface.put("am", "Nyala");
        default_typeface.put("bn", "Vrinda");
        default_typeface.put("he", "Arial");
        default_typeface.put("gu", "Raavi");
    }
}

