/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.xwpf.usermodel;

import com.inet.docx.document.utilities.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.IRunBody;
import org.apache.poi.xwpf.usermodel.ISDTContent;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFSDT;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtBlock;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtContentBlock;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtDocPart;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTString;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;

public class XWPFSDTimpl
extends XWPFSDT
implements IBodyElement,
IRunBody {
    private static final String[] KNOWN_SDT_TYPES = new String[]{"Table of Contents"};
    private ArrayList<IBodyElement> elements = new ArrayList();
    private String partGalleryName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XWPFSDTimpl(CTSdtBlock block, IBody part) {
        super(block, part);
        CTString sdpName;
        CTSdtDocPart docp;
        CTSdtPr sp = block.getSdtPr();
        if (sp != null && (docp = sp.getDocPartList()) != null && (sdpName = docp.getDocPartGallery()) != null) {
            this.checkGalleryType(sdpName.getVal());
        }
        CTSdtContentBlock sdtContent = block.getSdtContent();
        List paragraphs = sdtContent.getPList().stream().map(ctp -> new XWPFParagraph(ctp, part)).collect(Collectors.toList());
        List tables = sdtContent.getTblList().stream().map(tbl -> new XWPFTable(tbl, part)).collect(Collectors.toList());
        List subBlocks = sdtContent.getSdtList().stream().map(subBlock -> new XWPFSDTimpl((CTSdtBlock)subBlock, part)).collect(Collectors.toList());
        XmlCursor cursor = sdtContent.newCursor();
        try {
            cursor.selectPath("./*");
            while (cursor.toNextSelection()) {
                Object elem;
                XmlObject obj = cursor.getObject();
                if (obj instanceof CTP) {
                    elem = (XWPFParagraph)paragraphs.remove(0);
                    this.elements.add((IBodyElement)elem);
                    continue;
                }
                if (obj instanceof CTTbl) {
                    elem = (XWPFTable)tables.remove(0);
                    this.elements.add((IBodyElement)elem);
                    continue;
                }
                if (!(obj instanceof CTSdtBlock)) continue;
                elem = (XWPFSDTimpl)((Object)subBlocks.remove(0));
                this.elements.addAll(((XWPFSDTimpl)((Object)elem)).getBodyElements());
            }
        }
        finally {
            cursor.dispose();
        }
    }

    private void checkGalleryType(String partGalleryName) {
        this.partGalleryName = partGalleryName;
        for (String name : KNOWN_SDT_TYPES) {
            if (!name.equals(partGalleryName)) continue;
            return;
        }
        Util.LOGGER.info((Object)("Unknown Part Gallery " + partGalleryName));
    }

    public String getPartGalleryName() {
        return this.partGalleryName;
    }

    public List<IBodyElement> getBodyElements() {
        return this.elements;
    }

    public ISDTContent getContent() {
        return null;
    }
}

