/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.xwpf.usermodel;

import com.inet.docx.document.utilities.Util;
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ooxml.POIXMLTypeLoader;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFont;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.FontsDocument;
import org.openxmlformats.schemas.xpackage.x2006.relationships.CTRelationship;
import org.openxmlformats.schemas.xpackage.x2006.relationships.RelationshipsDocument;

public class XWPFFontInformation {
    private static final String WORD_PREFIX = "/word/";
    private String fontName;
    private String fontKey;
    private String targetFile;
    private Font font;

    private XWPFFontInformation(String fontName, String fontKey, String targetFile) {
        this.fontName = fontName;
        this.fontKey = fontKey.substring(1, fontKey.length() - 1);
        this.targetFile = targetFile;
    }

    public String getFontName() {
        return this.fontName;
    }

    public String getTargetFileName() {
        return this.targetFile;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFontData(byte[] fontData) throws IOException, FontFormatException {
        int n;
        char[] guidByteArray = XWPFFontInformation.guid_to_reverse_hex(this.fontKey);
        for (n = 0; n <= 15; ++n) {
            fontData[n] = (byte)(guidByteArray[n] ^ fontData[n]);
        }
        for (n = 16; n <= 31; ++n) {
            fontData[n] = (byte)(guidByteArray[n - 16] ^ fontData[n]);
        }
        this.font = Font.createFont(0, new ByteArrayInputStream(fontData));
    }

    public static Map<String, XWPFFontInformation> readFontInformations(PackagePart fontTable, PackagePart fontTableRelations) {
        HashMap<String, XWPFFontInformation> result = new HashMap<String, XWPFFontInformation>();
        if (fontTable != null && fontTableRelations != null) {
            try (InputStream isFont = fontTable.getInputStream();
                 InputStream isRel = fontTableRelations.getInputStream();){
                FontsDocument fontsDocument = (FontsDocument)FontsDocument.Factory.parse(isFont, POIXMLTypeLoader.DEFAULT_XML_OPTIONS);
                RelationshipsDocument relationsDocument = (RelationshipsDocument)RelationshipsDocument.Factory.parse(isRel, POIXMLTypeLoader.DEFAULT_XML_OPTIONS);
                List relations = relationsDocument.getRelationships().getRelationshipList();
                List fontsList = fontsDocument.getFonts().getFontList();
                for (CTFont font : fontsList) {
                    String id;
                    CTRelationship value = null;
                    String fontKey = null;
                    if (font.isSetEmbedRegular()) {
                        id = font.getEmbedRegular().getId();
                        fontKey = font.getEmbedRegular().getFontKey();
                    } else if (font.isSetEmbedBold()) {
                        id = font.getEmbedBold().getId();
                        fontKey = font.getEmbedBold().getFontKey();
                    } else if (font.isSetEmbedBoldItalic()) {
                        id = font.getEmbedBoldItalic().getId();
                        fontKey = font.getEmbedBoldItalic().getFontKey();
                    } else if (font.isSetEmbedItalic()) {
                        id = font.getEmbedItalic().getId();
                        fontKey = font.getEmbedItalic().getFontKey();
                    } else {
                        id = null;
                    }
                    if (id == null) continue;
                    value = relations.stream().filter(f -> f.getId().equals(id)).findFirst().orElse(null);
                    XWPFFontInformation fontInfo = new XWPFFontInformation(font.getName(), fontKey, WORD_PREFIX + value.getTarget());
                    result.put(fontInfo.getFontName(), fontInfo);
                }
            }
            catch (Throwable ex) {
                Util.LOGGER.error(ex);
            }
        }
        return result;
    }

    private static char[] guid_to_reverse_hex(String guidString) {
        char[] guid_hex = new char[]{(char)Integer.parseInt(guidString.substring(34, 36), 16), (char)Integer.parseInt(guidString.substring(32, 34), 16), (char)Integer.parseInt(guidString.substring(30, 32), 16), (char)Integer.parseInt(guidString.substring(28, 30), 16), (char)Integer.parseInt(guidString.substring(26, 28), 16), (char)Integer.parseInt(guidString.substring(24, 26), 16), (char)Integer.parseInt(guidString.substring(21, 23), 16), (char)Integer.parseInt(guidString.substring(19, 21), 16), (char)Integer.parseInt(guidString.substring(16, 18), 16), (char)Integer.parseInt(guidString.substring(14, 16), 16), (char)Integer.parseInt(guidString.substring(11, 13), 16), (char)Integer.parseInt(guidString.substring(9, 11), 16), (char)Integer.parseInt(guidString.substring(6, 8), 16), (char)Integer.parseInt(guidString.substring(4, 6), 16), (char)Integer.parseInt(guidString.substring(2, 4), 16), (char)Integer.parseInt(guidString.substring(0, 2), 16)};
        return guid_hex;
    }
}

