/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.xwpf.usermodel;

import com.inet.docx.document.DocumentProperties;
import com.inet.docx.document.RelationObject;
import com.inet.docx.document.utilities.NameSpaceHandler;
import com.inet.docx.document.utilities.Util;
import com.inet.docx.view.drawing.DrawingElement;
import com.inet.docx.view.drawing.DrawingFactory;
import com.inet.docx.view.drawing.ShapeGroup;
import com.inet.docx.view.drawing.SimpleShape;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ooxml.POIXMLTypeLoader;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.drawingml.x2006.main.CTShapeProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTShapeStyle;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextBody;
import org.openxmlformats.schemas.presentationml.x2006.main.CTGroupShape;

public class XWPFDiagramDrawing
extends RelationObject {
    private List<DrawingObject> elements;
    private List<DrawingElement> content = new ArrayList<DrawingElement>();
    private Rectangle2D bounds;

    public XWPFDiagramDrawing(PackagePart part) {
        super(part);
        try {
            CTGroupShape dataModelDoc = (CTGroupShape)CTGroupShape.Factory.parse(this.getPackagePart().getInputStream(), POIXMLTypeLoader.DEFAULT_XML_OPTIONS);
            XmlObject[] xmlObjs = NameSpaceHandler.examineNamespace("dsp", "drawing", (XmlObject)dataModelDoc);
            xmlObjs = NameSpaceHandler.examineNamespace("dsp", "spTree", xmlObjs[0]);
            XmlObject[] drawingObjects = NameSpaceHandler.examineNamespace("dsp", "sp", xmlObjs[0]);
            this.elements = new ArrayList<DrawingObject>();
            for (XmlObject obj : drawingObjects) {
                this.createDrawingObject(obj);
            }
        }
        catch (XmlException xmle) {
            Util.LOGGER.error((Throwable)xmle);
        }
        catch (IOException ioex) {
            Util.LOGGER.error((Throwable)ioex);
        }
    }

    private void createDrawingObject(XmlObject obj) {
        CTShapeProperties shapeProps = null;
        try {
            shapeProps = (CTShapeProperties)CTShapeProperties.Factory.parse(NameSpaceHandler.examineNamespace("dsp", "spPr", obj)[0].toString(), new XmlOptions(POIXMLTypeLoader.DEFAULT_XML_OPTIONS));
        }
        catch (Exception io) {
            Util.LOGGER.error((Throwable)io);
        }
        CTShapeStyle style = null;
        try {
            style = (CTShapeStyle)CTShapeStyle.Factory.parse(NameSpaceHandler.examineNamespace("dsp", "style", obj)[0].toString(), new XmlOptions(POIXMLTypeLoader.DEFAULT_XML_OPTIONS));
        }
        catch (Exception io) {
            Util.LOGGER.error((Throwable)io);
        }
        CTTextBody txtbody = null;
        try {
            XmlObject[] txbData = NameSpaceHandler.examineNamespace("dsp", "txBody", obj);
            if (txbData.length > 0) {
                txtbody = (CTTextBody)CTTextBody.Factory.parse(txbData[0].toString(), new XmlOptions(POIXMLTypeLoader.DEFAULT_XML_OPTIONS));
            }
        }
        catch (Exception io) {
            Util.LOGGER.error((Throwable)io);
        }
        this.elements.add(new DrawingObject(shapeProps, style, txtbody));
    }

    @Override
    public void init(DocumentProperties docProps, Rectangle2D bounds) {
        this.bounds = bounds;
        for (DrawingObject element : this.elements) {
            SimpleShape simShape = DrawingFactory.createSimpleShape(element.shapeProps, element.style, element.txtbody, docProps);
            if (simShape == null) continue;
            this.content.add(simShape);
        }
        this.elements = null;
    }

    @Override
    public List<DrawingElement> getDisplayElements() {
        ShapeGroup sg = new ShapeGroup(this.bounds, this.content);
        ArrayList<DrawingElement> elementList = new ArrayList<DrawingElement>();
        elementList.add(sg);
        return elementList;
    }

    private class DrawingObject {
        private CTShapeProperties shapeProps;
        private CTShapeStyle style;
        private CTTextBody txtbody;

        private DrawingObject(CTShapeProperties shapeProps, CTShapeStyle style, CTTextBody txtbody) {
            this.shapeProps = shapeProps;
            this.style = style;
            this.txtbody = txtbody;
        }
    }
}

