/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.xwpf.usermodel;

import com.inet.docx.document.elements.Comment;
import com.inet.docx.document.utilities.Util;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.apache.poi.ooxml.POIXMLTypeLoader;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTComment;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CommentsDocument;

public class XWPFCommentData {
    private ArrayList<Comment> comments = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XWPFCommentData(PackagePart part, XWPFDocument document) {
        InputStream is = null;
        try {
            is = part.getInputStream();
            CommentsDocument cmntdoc = (CommentsDocument)CommentsDocument.Factory.parse(is, POIXMLTypeLoader.DEFAULT_XML_OPTIONS);
            for (CTComment ctcomment : cmntdoc.getComments().getCommentList()) {
                BigInteger id = ctcomment.getId();
                String author = ctcomment.getAuthor();
                String initials = ctcomment.getInitials();
                Calendar cal = ctcomment.getDate();
                ArrayList<XWPFParagraph> paragraphs = new ArrayList<XWPFParagraph>();
                Date date = null;
                if (cal != null) {
                    date = cal.getTime();
                }
                for (CTP ctp : ctcomment.getPList()) {
                    paragraphs.add(new XWPFParagraph(ctp, (IBody)document));
                }
                this.comments.add(new Comment(id, author, initials, date, paragraphs));
            }
        }
        catch (Exception ex) {
            Util.LOGGER.error((Throwable)ex);
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
    }

    public ArrayList<Comment> getComments() {
        return this.comments;
    }
}

