/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.xwpf;

import com.inet.docx.document.RelationObject;
import com.inet.docx.document.elements.Comment;
import com.inet.docx.document.utilities.Util;
import com.inet.docx.xwpf.usermodel.XWPFCommentData;
import com.inet.docx.xwpf.usermodel.XWPFDiagramData;
import com.inet.docx.xwpf.usermodel.XWPFDiagramDrawing;
import com.inet.docx.xwpf.usermodel.XWPFFontInformation;
import com.inet.docx.xwpf.usermodel.XWPFSettings;
import com.inet.docx.xwpf.usermodel.XWPFStyleDefaults;
import com.inet.docx.xwpf.usermodel.XWPFThemeData;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.poi.ooxml.POIXMLDocumentPart;
import org.apache.poi.ooxml.POIXMLFactory;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.poifs.crypt.HashAlgorithm;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFHeaderFooter;
import org.apache.poi.xwpf.usermodel.XWPFRelation;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDocDefaults;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTStyle;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTStyles;

public class XWPFDocumentOwnImpl
extends XWPFDocument {
    private XWPFThemeData theme;
    private XWPFStyleDefaults styleDefaults;
    private XWPFSettings settings;
    private ArrayList<Comment> comments;
    private Map<String, ArrayList<String>> preserveTexts;
    private HashMap<String, XWPFHeaderFooter> header_footer;
    private HashMap<String, PackagePart> workbooks;
    private Map<String, RelationObject> internalRelations;
    private Boolean hasSetting = null;
    private Map<String, XWPFFontInformation> trueTypeFontInformations = new HashMap<String, XWPFFontInformation>();

    public XWPFDocumentOwnImpl(InputStream is) throws IOException {
        super(is);
    }

    protected void read(POIXMLFactory factory, Map<PackagePart, POIXMLDocumentPart> context) throws OpenXML4JException {
        super.read(factory, context);
        this.preserveTexts = new HashMap<String, ArrayList<String>>();
        this.header_footer = new HashMap();
        this.internalRelations = new HashMap<String, RelationObject>();
        List rels = this.getRelationParts();
        for (POIXMLDocumentPart.RelationPart rel : rels) {
            PackagePart pp = rel.getDocumentPart().getPackagePart();
            PackageRelationship prs = rel.getRelationship();
            String id = prs.getId();
            Util.LOGGER.info((Object)("RELATION: - " + String.valueOf(pp.getPartName()) + " " + id + " " + String.valueOf(prs.getTargetURI()) + " " + prs.getRelationshipType()));
            if ("application/vnd.openxmlformats-officedocument.drawingml.chart+xml".equals(pp.getContentType())) continue;
            if ("application/vnd.openxmlformats-officedocument.drawingml.diagramData+xml".equals(pp.getContentType())) {
                this.internalRelations.put(id, new XWPFDiagramData(pp));
                continue;
            }
            if ("application/vnd.ms-office.drawingml.diagramDrawing+xml".equals(pp.getContentType())) {
                this.internalRelations.put(id, new XWPFDiagramDrawing(pp));
                continue;
            }
            if (XWPFRelation.WORKBOOK.getRelation().equals(rel.getRelationship().getRelationshipType())) {
                if (this.workbooks == null) {
                    this.workbooks = new HashMap();
                }
                this.workbooks.put(id, pp);
                continue;
            }
            if (XWPFRelation.FONT_TABLE.getRelation().equals(rel.getRelationship().getRelationshipType())) {
                PackagePart fontTableRelations = this.getPackagePartByName("/word/_rels/fontTable.xml.rels");
                this.trueTypeFontInformations = XWPFFontInformation.readFontInformations(pp, fontTableRelations);
                for (Map.Entry<String, XWPFFontInformation> fiEntry : this.trueTypeFontInformations.entrySet()) {
                    XWPFFontInformation fi = fiEntry.getValue();
                    PackagePart pp2 = this.getPackagePartByName(fi.getTargetFileName());
                    try {
                        InputStream stm = pp2.getInputStream();
                        try {
                            byte[] dta = new byte[stm.available()];
                            stm.read(dta, 0, dta.length);
                            fi.setFontData(dta);
                        }
                        finally {
                            if (stm == null) continue;
                            stm.close();
                        }
                    }
                    catch (Exception ex) {
                        Util.LOGGER.warn((Object)ex);
                    }
                }
                continue;
            }
            if (XWPFRelation.THEME.getRelation().equals(rel.getRelationship().getRelationshipType())) {
                this.theme = new XWPFThemeData(pp);
                continue;
            }
            if (XWPFRelation.COMMENT.getRelation().equals(rel.getRelationship().getRelationshipType())) {
                this.comments = new XWPFCommentData(pp, this).getComments();
                continue;
            }
            if (XWPFRelation.SETTINGS.getRelation().equals(rel.getRelationship().getRelationshipType())) {
                this.settings = new XWPFSettings(pp);
                continue;
            }
            if (XWPFRelation.HEADER.getRelation().equals(rel.getRelationship().getRelationshipType())) {
                this.header_footer.put(id, (XWPFHeaderFooter)rel.getDocumentPart());
                this.preserveTexts.put(pp.getPartName().toString(), XWPFDocumentOwnImpl.getPreserveTexts(pp));
                continue;
            }
            if (XWPFRelation.FOOTER.getRelation().equals(rel.getRelationship().getRelationshipType())) {
                this.header_footer.put(id, (XWPFHeaderFooter)rel.getDocumentPart());
                this.preserveTexts.put(pp.getPartName().toString(), XWPFDocumentOwnImpl.getPreserveTexts(pp));
                continue;
            }
            if (XWPFRelation.FOOTNOTE.getRelation().equals(rel.getRelationship().getRelationshipType())) {
                this.preserveTexts.put("footnote", XWPFDocumentOwnImpl.getPreserveTexts(pp));
                continue;
            }
            if (XWPFRelation.STYLES.getRelation().equals(rel.getRelationship().getRelationshipType()) || XWPFRelation.WEB_SETTINGS.getRelation().equals(rel.getRelationship().getRelationshipType())) continue;
            Util.LOGGER.warn((Object)("RELATION not supported: - " + String.valueOf(pp.getPartName()) + " " + id + " " + String.valueOf(prs.getTargetURI()) + " " + prs.getRelationshipType()));
        }
        if (this.settings == null) {
            this.settings = new XWPFSettings();
        }
        try {
            CTStyles style = this.getStyle();
            CTDocDefaults docDefaults = style.getDocDefaults();
            if (docDefaults != null && docDefaults.getRPrDefault() != null && docDefaults.getPPrDefault() != null) {
                this.styleDefaults = new XWPFStyleDefaults(docDefaults.getRPrDefault().getRPr(), docDefaults.getPPrDefault().getPPr(), this.settings.getThemeFontLang());
            } else {
                List styleList = style.getStyleList();
                if (styleList != null && styleList.size() > 0) {
                    CTStyle style0 = (CTStyle)styleList.get(0);
                    this.styleDefaults = new XWPFStyleDefaults(style0.getRPr(), style0.getPPr(), this.settings.getThemeFontLang());
                } else {
                    this.styleDefaults = new XWPFStyleDefaults(null, null, this.settings.getThemeFontLang());
                }
            }
        }
        catch (Exception ex) {
            Util.LOGGER.warn((Object)ex);
        }
    }

    private PackagePart getPackagePartByName(String name) throws InvalidFormatException {
        ArrayList parts = this.getPackage().getParts();
        for (PackagePart part : parts) {
            if (!name.equals(part.getPartName().getName())) continue;
            return part;
        }
        return null;
    }

    private void updateSetting() {
        try {
            super.getEvenAndOddHeadings();
            this.hasSetting = Boolean.TRUE;
        }
        catch (Exception ex) {
            this.hasSetting = Boolean.FALSE;
            Util.LOGGER.warn((Object)"No setting data available ");
        }
    }

    public boolean getHasSetting() {
        if (this.hasSetting == null) {
            this.updateSetting();
        }
        return this.hasSetting;
    }

    public boolean isEnforcedProtection() {
        if (this.getHasSetting()) {
            return super.isEnforcedProtection();
        }
        return false;
    }

    public boolean isEnforcedReadonlyProtection() {
        if (this.getHasSetting()) {
            return super.isEnforcedReadonlyProtection();
        }
        return false;
    }

    public boolean isEnforcedFillingFormsProtection() {
        if (this.getHasSetting()) {
            return super.isEnforcedFillingFormsProtection();
        }
        return false;
    }

    public boolean isEnforcedCommentsProtection() {
        if (this.getHasSetting()) {
            return super.isEnforcedCommentsProtection();
        }
        return false;
    }

    public boolean isEnforcedTrackedChangesProtection() {
        if (this.getHasSetting()) {
            return super.isEnforcedTrackedChangesProtection();
        }
        return false;
    }

    public boolean isEnforcedUpdateFields() {
        if (this.getHasSetting()) {
            return super.isEnforcedUpdateFields();
        }
        return false;
    }

    public void enforceReadonlyProtection() {
        if (this.getHasSetting()) {
            super.enforceReadonlyProtection();
        }
    }

    public void enforceReadonlyProtection(String password, HashAlgorithm hashAlgo) {
        if (this.getHasSetting()) {
            super.enforceReadonlyProtection(password, hashAlgo);
        }
    }

    public void enforceFillingFormsProtection() {
        if (this.getHasSetting()) {
            super.enforceFillingFormsProtection();
        }
    }

    public void enforceFillingFormsProtection(String password, HashAlgorithm hashAlgo) {
        if (this.getHasSetting()) {
            super.enforceFillingFormsProtection(password, hashAlgo);
        }
    }

    public void enforceCommentsProtection() {
        if (this.getHasSetting()) {
            super.enforceCommentsProtection();
        }
    }

    public void enforceCommentsProtection(String password, HashAlgorithm hashAlgo) {
        if (this.getHasSetting()) {
            super.enforceCommentsProtection(password, hashAlgo);
        }
    }

    public void enforceTrackedChangesProtection() {
        if (this.getHasSetting()) {
            super.enforceTrackedChangesProtection();
        }
    }

    public void enforceTrackedChangesProtection(String password, HashAlgorithm hashAlgo) {
        if (this.getHasSetting()) {
            super.enforceTrackedChangesProtection(password, hashAlgo);
        }
    }

    public boolean validateProtectionPassword(String password) {
        if (this.getHasSetting()) {
            return super.validateProtectionPassword(password);
        }
        return false;
    }

    public void removeProtectionEnforcement() {
        if (this.getHasSetting()) {
            super.removeProtectionEnforcement();
        }
    }

    public void enforceUpdateFields() {
        if (this.getHasSetting()) {
            super.enforceUpdateFields();
        }
    }

    public boolean isTrackRevisions() {
        if (this.getHasSetting()) {
            return super.isTrackRevisions();
        }
        return false;
    }

    public void setTrackRevisions(boolean enable) {
        if (this.getHasSetting()) {
            super.setTrackRevisions(enable);
        }
    }

    public long getZoomPercent() {
        if (this.getHasSetting()) {
            return super.getZoomPercent();
        }
        return 1L;
    }

    public void setZoomPercent(long zoomPercent) {
        if (this.getHasSetting()) {
            super.setZoomPercent(zoomPercent);
        }
    }

    public boolean getEvenAndOddHeadings() {
        if (this.getHasSetting()) {
            return super.getEvenAndOddHeadings();
        }
        return false;
    }

    public void setEvenAndOddHeadings(boolean enable) {
        if (this.getHasSetting()) {
            super.setEvenAndOddHeadings(enable);
        }
    }

    public boolean getMirrorMargins() {
        if (this.getHasSetting()) {
            return super.getMirrorMargins();
        }
        return false;
    }

    public void setMirrorMargins(boolean enable) {
        if (this.getHasSetting()) {
            super.setMirrorMargins(enable);
        }
    }

    public Map<String, ArrayList<String>> getPreserveTexts() {
        return this.preserveTexts;
    }

    protected void onDocumentCreate() {
        super.onDocumentCreate();
        this.updateSetting();
    }

    protected void onDocumentRead() throws IOException {
        PackagePart part = this.getPackagePart();
        this.preserveTexts.put(part.getPartName().toString(), XWPFDocumentOwnImpl.getPreserveTexts(part));
        super.onDocumentRead();
        this.updateSetting();
    }

    public Map<String, RelationObject> getInternalRelations() {
        return this.internalRelations;
    }

    public XWPFStyleDefaults getStyleDefaults() {
        return this.styleDefaults;
    }

    public Set<String> getHeaderFooterKeys() {
        return this.header_footer.keySet();
    }

    public XWPFHeaderFooter getHeaderFooter(String key) {
        return this.header_footer.get(key);
    }

    public HashMap<String, PackagePart> getWorkbooks() {
        return this.workbooks;
    }

    public XWPFThemeData getThemeData() {
        return this.theme;
    }

    public ArrayList<Comment> getCommentsInternal() {
        return this.comments;
    }

    public XWPFSettings getDocumentSettings() {
        return this.settings;
    }

    public Map<String, XWPFFontInformation> getEmbeddedFontInformations() {
        return this.trueTypeFontInformations;
    }

    private static ArrayList<String> getPreserveTexts(PackagePart part) {
        ArrayList<String> preserveText = new ArrayList<String>();
        try (InputStream is = part.getInputStream();
             InputStreamReader isr = new InputStreamReader(is);){
            int ch;
            StringBuilder strBuf = new StringBuilder();
            while ((ch = isr.read()) != -1) {
                strBuf.append((char)ch);
                if (ch == 60 && strBuf.length() > 1 && strBuf.charAt(0) == '<') {
                    for (int i = 25; i < strBuf.length(); ++i) {
                        if (strBuf.charAt(i) != '>') continue;
                        preserveText.add(strBuf.substring(i + 1, strBuf.length() - 1));
                        break;
                    }
                    strBuf.setLength(0);
                    continue;
                }
                if (ch != 62 || strBuf.indexOf("xml:space=\"preserve\"") != -1) continue;
                strBuf.setLength(0);
            }
        }
        catch (Exception ex) {
            Util.LOGGER.error((Throwable)ex);
        }
        return preserveText;
    }
}

