/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.view.table;

import com.inet.docx.document.elements.subelements.Positionable;
import com.inet.docx.document.elements.subelements.table.TableCell;
import com.inet.docx.document.table.TableData;
import com.inet.docx.document.utilities.Util;
import com.inet.docx.view.PageElement;
import com.inet.docx.view.RenderContext;
import com.inet.docx.view.paragraph.ParagraphPageBreakPosition;
import com.inet.docx.view.paragraph.ParagraphRow;
import com.inet.docx.view.paragraph.ParagraphView;
import com.inet.docx.view.table.CellPageBreakPosition;
import com.inet.docx.view.table.TableCellView;
import com.inet.docx.view.table.TablePageBreakPosition;
import com.inet.docx.view.table.TableViewBorders;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TableView
extends Positionable
implements PageElement {
    private TableData source;
    private TablePageBreakPosition startPosition;
    private TablePageBreakPosition endPosition;
    private double tableHeight;
    private List<TableRow> rows;
    private RenderContext context;
    private TableViewBorders borders;

    public List<TableRow> getRows() {
        return this.rows;
    }

    public TableViewBorders getBorders() {
        return this.borders;
    }

    public TableView(TableData table, double marginLeft, double availableWidth, TablePageBreakPosition startPosition, TablePageBreakPosition endPosition, RenderContext context) {
        this.source = table;
        this.startPosition = startPosition;
        this.endPosition = endPosition;
        this.context = context;
        this.rows = this.createViews();
        this.tableHeight = this.calcTableViewHeight();
    }

    public TableView(TableView table, double marginLeft, double availableWidth, TablePageBreakPosition startPosition, TablePageBreakPosition endPosition, RenderContext context) {
        this(table.source, marginLeft, availableWidth, startPosition, endPosition, context);
    }

    public boolean isSameSubtable(TablePageBreakPosition startPosition, TablePageBreakPosition endPosition) {
        if (startPosition != null ? !startPosition.equals(this.startPosition) : this.startPosition != null) {
            return false;
        }
        return endPosition != null ? endPosition.equals(this.endPosition) : this.endPosition == null;
    }

    private List<TableRow> createViews() {
        TableCell tc;
        int column;
        int row;
        int header = this.source.getRepeatingHeaderRowCount();
        int startRow = Math.max(header, this.getStartPosition(this.startPosition));
        int endRow = this.getEndRow(this.endPosition);
        this.borders = new TableViewBorders(this.source.getColumnCount(), header + (endRow - startRow) + 1);
        for (row = 0; row < header; ++row) {
            for (column = 0; column < this.source.getColumnCount(); ++column) {
                tc = this.source.getCell(column, row);
                if (tc == null || tc.getStartColumn() != column || tc.getStartRow() != row) continue;
                this.borders.addTableCell(tc, 0);
            }
        }
        for (row = startRow; row <= endRow; ++row) {
            for (column = 0; column < this.source.getColumnCount(); ++column) {
                tc = this.source.getCell(column, row);
                if (tc == null || tc.getStartColumn() != column || tc.getStartRow() != row) continue;
                this.borders.addTableCell(tc, startRow - header);
            }
        }
        ArrayList<TableRow> viewModel = new ArrayList<TableRow>();
        for (int row2 = 0; row2 < header; ++row2) {
            TableRow rowModel = new TableRow(row2);
            viewModel.add(rowModel);
            for (int column2 = 0; column2 < this.source.getColumnCount(); ++column2) {
                TableCell tc2 = this.source.getCell(column2, row2);
                if (tc2 != null && tc2.getStartColumn() == column2 && tc2.getStartRow() == row2) {
                    TableViewBorders.CellBorders cellBorder = this.borders.getCellBorders(tc2, 0, this.source.isExcelStyle());
                    rowModel.add(new TableCellView(tc2, null, null, cellBorder, this.context));
                    continue;
                }
                rowModel.add(null);
            }
        }
        int startRowOffset = 0;
        if (this.startPosition != null && !this.startPosition.hasDisplayableContent()) {
            startRowOffset = 1;
        }
        for (int row3 = startRow + startRowOffset; row3 <= endRow; ++row3) {
            TableRow rowModel = new TableRow(row3);
            viewModel.add(rowModel);
            for (int column3 = 0; column3 < this.source.getColumnCount(); ++column3) {
                boolean cellOnLastPage;
                TableCell tc3 = this.source.getCell(column3, row3);
                boolean bl = cellOnLastPage = row3 == startRow && this.startPosition != null && this.startPosition.getCellBreak(column3) == null;
                if (tc3 != null && tc3.getStartColumn() == column3 && tc3.getStartRow() == row3) {
                    TableViewBorders.CellBorders cellBorder = this.borders.getCellBorders(tc3, startRow - header, this.source.isExcelStyle());
                    if (cellOnLastPage) {
                        rowModel.add(new TableCellView(tc3, cellBorder));
                        continue;
                    }
                    CellPageBreakPosition cpdpStart = row3 == startRow && this.startPosition != null ? this.startPosition.getCellBreak(column3) : null;
                    CellPageBreakPosition cpdpEnd = row3 == endRow && this.endPosition != null ? this.endPosition.getCellBreak(column3) : null;
                    rowModel.add(new TableCellView(tc3, cpdpStart, cpdpEnd, cellBorder, this.context));
                    continue;
                }
                rowModel.add(null);
            }
        }
        return viewModel;
    }

    @Override
    public double getWidth() {
        return this.getBounds().getWidth();
    }

    @Override
    public double getHeight() {
        return this.tableHeight;
    }

    @Override
    public double getBaseline() {
        return 0.0;
    }

    @Override
    public int getSpacingTop(boolean isFirstRow) {
        return 0;
    }

    @Override
    public int getSpacingBottom() {
        return 0;
    }

    @Override
    public void collectElements(List<Positionable> elements) {
        elements.add(this);
    }

    @Override
    public void move(double xOffset, double yOffset) {
        super.move(xOffset, yOffset);
        this.updateCellPositions();
    }

    @Override
    public void setPageX(double pageX) {
        super.setPageX(pageX);
        this.updateCellPositions();
    }

    @Override
    public void setPageY(double pageY) {
        if (!this.source.isExcelStyle()) {
            pageY += (double)(this.borders.getHorizontalLineHeight(0) / 2);
        }
        super.setPageY(pageY);
        this.updateCellPositions();
    }

    private void updateCellPositions() {
        double x = this.getPageX();
        double y = this.getPageY();
        for (int column = 0; column < this.source.getColumnCount(); ++column) {
            if (column > 0) {
                x += (double)this.source.getColumnSize(column - 1);
            }
            double pos = y;
            for (TableRow row : this.rows) {
                TableCellView tc = (TableCellView)row.get(column);
                if (tc != null) {
                    tc.setComponentPosition(x, pos);
                }
                pos += row.getRowHeight();
            }
        }
    }

    public Rectangle2D getBoundsInPoints() {
        int firstLine = this.startPosition != null ? this.startPosition.getBreakRow() : 0;
        int lastLine = this.endPosition != null ? this.endPosition.getBreakRow() : this.source.getRowCount();
        int topOff = this.borders.getHorizontalLineHeight(Math.max(firstLine, 0));
        int bottomOff = this.borders.getHorizontalLineHeight(lastLine);
        int leftOff = this.borders.getVerticalLineWidth(0);
        double height = Util.convertTwipsToPoint(this.getHeight() + (double)topOff + (double)bottomOff);
        double width = Util.convertTwipsToPoint(this.source.getWidth());
        double x = Util.convertTwipsToPoint(this.getPageX() - (double)leftOff);
        double y = Util.convertTwipsToPoint(this.getPageY() - (double)topOff);
        return new Rectangle2D.Double(x, y, width, height);
    }

    @Override
    public double getMinKeepTogetherHeight() {
        return this.rows.size() > 0 ? this.rows.get(0).getRowHeight() : 0.0;
    }

    private TableCellView getCell(int row, int column) {
        int index = Collections.binarySearch(this.rows, new TableRow(row));
        if (index < 0) {
            return null;
        }
        return (TableCellView)this.rows.get(index).get(column);
    }

    private int getEndRow(TablePageBreakPosition endPosition) {
        int endRow = this.source.getRowCount() - 1;
        if (endPosition != null && endRow >= endPosition.getBreakRow()) {
            endRow = endPosition.getBreakRow();
        }
        return endRow;
    }

    private int getStartPosition(TablePageBreakPosition startPosition) {
        int startRow = 0;
        if (startPosition != null && startPosition.getBreakRow() > 0) {
            startRow = startPosition.getBreakRow();
        }
        return startRow;
    }

    private double calcTableViewHeight() {
        ArrayList<CellMergeData> mergedRowCells = new ArrayList<CellMergeData>();
        for (TableRow row : this.rows) {
            double maxRowHeight = 0.0;
            for (int column = 0; column < row.size(); ++column) {
                TableCellView tca = (TableCellView)row.get(column);
                if (tca == null) continue;
                if (tca.getRowSpan() > 1) {
                    mergedRowCells.add(new CellMergeData(tca, row.getRowIndex(), column));
                    continue;
                }
                maxRowHeight = Math.max(maxRowHeight, tca.getHeight());
            }
            row.setRowHeight(maxRowHeight);
        }
        boolean updateCellSizes = false;
        int breakOffset = this.startPosition != null ? this.startPosition.getBreakRow() : 0;
        for (CellMergeData mergeCell : mergedRowCells) {
            double cellHeight;
            double colHeight = this.calculateRowHeight(mergeCell);
            if (!(colHeight < (cellHeight = mergeCell.cell.getHeight()))) continue;
            double diff = cellHeight - colHeight;
            int lastRow = Math.min(this.rows.size() - 1, mergeCell.getEndRow() - breakOffset);
            if (lastRow < 0) {
                Util.LOGGER.error((Object)("The endrow is " + mergeCell.getEndRow() + " the breakOffset is " + breakOffset));
                lastRow = this.rows.size() - 1;
            }
            this.rows.get((int)lastRow).rowHeight += diff;
            updateCellSizes = true;
        }
        if (updateCellSizes) {
            for (TableRow row : this.rows) {
                for (TableCellView cell : row) {
                    if (cell == null || cell.getRowSpan() != 1 || cell.getHeight() == row.getRowHeight()) continue;
                    cell.setRowHeight(row.getRowHeight());
                }
            }
        }
        for (CellMergeData mergeCell : mergedRowCells) {
            mergeCell.cell.setRowHeight(this.calculateRowHeight(mergeCell));
        }
        double totalHeight = this.rows.stream().mapToDouble(r -> r.getRowHeight()).sum();
        if (!this.source.isExcelStyle()) {
            totalHeight += (double)(this.borders.getHorizontalLineHeight(0) / 2);
            totalHeight += (double)(this.borders.getHorizontalLineHeight(this.rows.size()) / 2);
        }
        return totalHeight;
    }

    protected double calculateRowHeight(CellMergeData mergeCell) {
        double colHeight = 0.0;
        if (this.startPosition == null && this.endPosition == null) {
            for (int row = mergeCell.startRow; row <= mergeCell.getEndRow(); ++row) {
                colHeight += this.rows.get((int)row).rowHeight;
            }
        } else {
            for (TableRow row : this.rows) {
                if (row.rowIndex < mergeCell.startRow || row.rowIndex > mergeCell.getEndRow()) continue;
                colHeight += row.rowHeight;
            }
        }
        return colHeight;
    }

    public TablePageBreakPosition calculateNextBreak(double availableHeight, TablePageBreakPosition modelToViewOffset) {
        int cols = this.source.getColumnCount();
        for (TableRow row : this.rows) {
            double rowHeight = row.getRowHeight();
            int currentRow = row.getRowIndex();
            if (availableHeight > rowHeight || modelToViewOffset != null && modelToViewOffset.isRestartOnNextPage() && currentRow == 0) {
                availableHeight -= rowHeight;
                continue;
            }
            boolean atLeastOneRow = this.checkAtLeastOneObjetInRow(currentRow, availableHeight);
            if (!atLeastOneRow) {
                return new TablePageBreakPosition(cols, currentRow - 1);
            }
            TablePageBreakPosition tableBreak = new TablePageBreakPosition(cols, currentRow);
            block1: for (int column = 0; column < cols; ++column) {
                double availableForCell;
                CellMergeData tca = this.getView(currentRow, column);
                if (tca == null || tca.startCol != column || tca.getEndRow() != currentRow) continue;
                if (atLeastOneRow) {
                    int index;
                    availableForCell = availableHeight;
                    for (int pos = currentRow - 1; pos >= tca.startRow && (index = Collections.binarySearch(this.rows, new TableRow(pos))) >= 0; --pos) {
                        availableForCell += this.rows.get(pos).getRowHeight();
                    }
                } else {
                    availableForCell = 0.0;
                }
                CellPageBreakPosition inCellBreak = modelToViewOffset != null ? modelToViewOffset.getCellBreak(column) : null;
                List<PageElement> elements = tca.cell.getContent();
                double remaining = availableForCell;
                for (int i = 0; i < elements.size(); ++i) {
                    PageElement element = elements.get(i);
                    Rectangle2D bounds = element.getBounds();
                    if (bounds.getHeight() > remaining) {
                        CellPageBreakPosition cellBreak;
                        if (element instanceof ParagraphView) {
                            ParagraphView paragraph = (ParagraphView)element;
                            ParagraphPageBreakPosition breakPosition = paragraph.getBreakPosition(availableForCell - bounds.getY());
                            cellBreak = breakPosition != null ? new CellPageBreakPosition(paragraph.getSource(), breakPosition, i > 0 || breakPosition.getContinueIndex() > 0 || breakPosition.getInTextIndex() > 0) : null;
                        } else {
                            TableView innerTable = (TableView)element;
                            TablePageBreakPosition lastBreak = i == 0 && inCellBreak != null ? inCellBreak.getTableBreakInfo() : new TablePageBreakPosition(innerTable.source.getColumnCount(), -1);
                            TablePageBreakPosition breakPosition = innerTable.calculateNextBreak(availableForCell - bounds.getY(), lastBreak);
                            cellBreak = breakPosition != null ? new CellPageBreakPosition(innerTable.getSource(), breakPosition, i > 0 || breakPosition.hasDisplayableContent()) : null;
                        }
                        tableBreak.setBreak(tca.startCol, tca.getEndColumn(), cellBreak);
                        continue block1;
                    }
                    remaining -= bounds.getHeight();
                }
            }
            return tableBreak;
        }
        return null;
    }

    private boolean checkAtLeastOneObjetInRow(int currentRow, double availableHeight) {
        int cols = this.source.getColumnCount();
        for (int column = 0; column < cols; ++column) {
            ParagraphView pv;
            ParagraphRow pr;
            PageElement element;
            List<PageElement> elements;
            CellMergeData tca = this.getView(currentRow, column);
            if (tca == null || tca.startCol != column || tca.startRow != currentRow || (elements = tca.cell.getContent()).size() <= 0 || !((element = elements.get(0)) instanceof ParagraphView ? (pr = (pv = (ParagraphView)element).getRow(0)).getHeight() > availableHeight : !((TableView)element).checkAtLeastOneObjetInRow(0, availableHeight))) continue;
            return false;
        }
        return true;
    }

    @Override
    public TableData getSource() {
        return this.source;
    }

    @Override
    public Rectangle2D getBounds() {
        int firstLine = this.startPosition != null ? this.startPosition.getBreakRow() : 0;
        int lastLine = this.endPosition != null ? this.endPosition.getBreakRow() : this.source.getRowCount();
        int topOff = this.borders.getHorizontalLineHeight(Math.max(firstLine, 0));
        int bottomOff = this.borders.getHorizontalLineHeight(Math.max(lastLine, 0));
        int leftOff = this.borders.getVerticalLineWidth(0);
        double height = this.getHeight() + (double)topOff + (double)bottomOff;
        double width = this.source.getWidth();
        double x = this.getPageX() - (double)leftOff;
        double y = this.getPageY() - (double)topOff;
        return new Rectangle2D.Double(x, y, width, height);
    }

    private CellMergeData getView(int row, int col) {
        TableCellView cell = this.getCell(row, col);
        if (cell != null) {
            return new CellMergeData(cell, row, col);
        }
        return null;
    }

    private static class TableRow
    extends ArrayList<TableCellView>
    implements Comparable<TableRow> {
        private int rowIndex;
        private double rowHeight = 0.0;

        public TableRow(int rowIndex) {
            this.rowIndex = rowIndex;
        }

        public void setRowHeight(double height) {
            this.rowHeight = height;
            this.stream().filter(c -> c != null && c.getRowSpan() == 1).forEach((? super T c) -> c.setRowHeight(this.rowHeight));
        }

        public double getRowHeight() {
            return this.rowHeight;
        }

        public int getRowIndex() {
            return this.rowIndex;
        }

        @Override
        public String toString() {
            return "Row #" + this.rowIndex + ", height=" + this.rowHeight;
        }

        @Override
        public int compareTo(TableRow o) {
            return this.rowIndex - o.rowIndex;
        }
    }

    private static class CellMergeData {
        private TableCellView cell;
        private int startRow;
        private int startCol;

        public CellMergeData(TableCellView cell, int startRow, int startCol) {
            this.cell = cell;
            this.startRow = startRow;
            this.startCol = startCol;
        }

        public int getEndRow() {
            return this.startRow + this.cell.getRowSpan() - 1;
        }

        public int getEndColumn() {
            return this.startCol + this.cell.getColSpan() - 1;
        }
    }
}

