/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.view.render;

import com.inet.cache.image.SerializableImage;
import com.inet.docx.document.elements.style.LineProperties;
import com.inet.docx.document.elements.style.LineStyle;
import com.inet.docx.document.elements.style.RenderFont;
import com.inet.docx.document.elements.subelements.BorderLines;
import com.inet.docx.document.elements.subelements.Drawing;
import com.inet.docx.document.elements.subelements.Positionable;
import com.inet.docx.document.elements.subelements.TablePanel;
import com.inet.docx.document.elements.subelements.TextRowElement;
import com.inet.docx.document.elements.subelements.drawing.Anchor;
import com.inet.docx.document.elements.subelements.drawing.SimpleLine;
import com.inet.docx.document.elements.subelements.drawing.TextBoxShape;
import com.inet.docx.document.paragraph.StringLayouter;
import com.inet.docx.document.utilities.Util;
import com.inet.docx.view.PageProperties;
import com.inet.docx.view.RenderPage;
import com.inet.docx.view.drawing.BasicStrokeData;
import com.inet.docx.view.drawing.BorderLineExternalWidths;
import com.inet.docx.view.drawing.DrawingElement;
import com.inet.docx.view.drawing.DrawingFactory;
import com.inet.docx.view.drawing.ImagePaint;
import com.inet.docx.view.drawing.PictureElement;
import com.inet.docx.view.drawing.PictureFillData;
import com.inet.docx.view.drawing.ShapeGroup;
import com.inet.docx.view.drawing.SimpleShape;
import com.inet.docx.view.paragraph.ParagraphRow;
import com.inet.docx.view.paragraph.ParagraphView;
import com.inet.docx.view.paragraph.RowTextPiece;
import com.inet.docx.view.render.RenderBaseObject;
import com.inet.docx.view.render.RenderContainer;
import com.inet.docx.view.render.RenderImage;
import com.inet.docx.view.render.RenderShape;
import com.inet.docx.view.render.RenderText;
import com.inet.docx.view.table.TableCellView;
import com.inet.docx.view.table.TableView;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class RenderUtil {
    public static RenderContainer convertToDrawobject(RenderPage renderPage) {
        ArrayList<RenderBaseObject> elementList = new ArrayList<RenderBaseObject>();
        RenderContainer container = new RenderContainer(elementList, "page");
        PageProperties properties = renderPage.getPageLayout();
        if (!Color.WHITE.equals(renderPage.getDocumentProperties().getPageBackground().getBackGroundColor())) {
            elementList.add(new RenderShape(new Rectangle2D.Double(0.0, 0.0, Util.convertTwipsToPoint(properties.getPageWidth()), Util.convertTwipsToPoint(properties.getPageHeight())), null, renderPage.getDocumentProperties().getPageBackground().getBackGroundColor(), new BasicStroke(0.0f)));
        }
        ArrayList<Drawing> positionables = new ArrayList<Drawing>();
        BorderLines borders = properties.getBorders();
        if (borders != null) {
            double y = Util.convertTwipsToPoint(properties.getBorders().getTopLine() != null ? properties.getBorders().getTopLine().getSpace() : 0.0);
            double x = Util.convertTwipsToPoint(properties.getBorders().getLeftLine() != null ? properties.getBorders().getLeftLine().getSpace() : 0.0);
            double height = Util.convertTwipsToPoint((double)properties.getPageHeight() - (borders.getBottomLine() != null ? borders.getBottomLine().getSpace() : 0.0) - y) - y;
            double width = Util.convertTwipsToPoint((double)properties.getPageWidth() - (borders.getRightLine() != null ? borders.getRightLine().getSpace() : 0.0)) - x;
            Rectangle2D.Double bounds = new Rectangle2D.Double(x, y, width, height);
            positionables.add(DrawingFactory.createBorderLinesDrawing(borders, bounds));
        }
        renderPage.getColumns().forEach(list -> list.forEach(col -> col.getLines().forEach(e -> e.collectElements(positionables))));
        if (renderPage.getHeader() != null && !renderPage.getHeader().isEmpty()) {
            ArrayList<Positionable> headers = new ArrayList<Positionable>();
            renderPage.getHeader().collectElements(headers);
            RenderUtil.collectAndCreateStructure(renderPage, elementList, headers, "header", new AffineTransform());
        }
        if (renderPage.getFooter() != null && !renderPage.getFooter().isEmpty()) {
            ArrayList<Positionable> footers = new ArrayList<Positionable>();
            renderPage.getFooter().collectElements(footers);
            RenderUtil.collectAndCreateStructure(renderPage, elementList, footers, "footer", new AffineTransform());
        }
        for (Positionable positionable : positionables) {
            RenderUtil.collectRenderObjects(renderPage, positionable, elementList, new AffineTransform());
        }
        return container;
    }

    private static void collectRenderObjects(RenderPage renderPage, Positionable positionable, ArrayList<RenderBaseObject> elementList, AffineTransform transformation) {
        if (positionable instanceof Drawing) {
            RenderUtil.collectPositionableDrawing(renderPage, (Drawing)positionable, elementList, transformation);
        } else if (positionable instanceof ParagraphView) {
            ParagraphView view = (ParagraphView)positionable;
            for (int i = 0; i < view.getRowCount(); ++i) {
                RenderUtil.collectParagraphRow(renderPage, view.getRow(i), elementList, transformation);
            }
        } else if (positionable instanceof TableView) {
            RenderUtil.collectTableView(renderPage, (TableView)positionable, elementList, transformation);
        } else if (positionable instanceof ParagraphRow) {
            RenderUtil.collectParagraphRow(renderPage, (ParagraphRow)positionable, elementList, transformation);
        } else if (positionable instanceof RowTextPiece) {
            RenderUtil.collectRowTextPiece(renderPage, (RowTextPiece)positionable, elementList, transformation);
        }
    }

    private static void collectPositionableDrawing(RenderPage renderPage, Drawing drawing, ArrayList<RenderBaseObject> elementList, AffineTransform transformation) {
        RenderContainer container = RenderUtil.collectAndCreateDrawingStructure(renderPage, elementList, Collections.singletonList(drawing), "drawing", transformation);
        container.setzOrder(drawing.getzOrder());
        switch (drawing.getTextWrapping()) {
            case POLYGON: 
            case SQUARE: 
            case THROUGH: 
            case TIGHT: 
            case TOPANDBOTTOM: {
                break;
            }
            case NONE: {
                if (!drawing.isBackground()) break;
                container.setzOrder(0L);
                break;
            }
            case NONEONTOP: {
                container.setzOrder(Long.MAX_VALUE);
            }
        }
    }

    private static void collectParagraphRow(RenderPage renderPage, ParagraphRow row, ArrayList<RenderBaseObject> elementList, AffineTransform transformation) {
        LineProperties line;
        int i;
        HashMap<Positionable, RenderFont> objectToFont = new HashMap<Positionable, RenderFont>();
        HashMap<Positionable, LineProperties> objectToLineStyle = new HashMap<Positionable, LineProperties>();
        HashMap<Positionable, Color> fallbackColor = new HashMap<Positionable, Color>();
        LinkedList<Positionable[]> underlineSegments = new LinkedList<Positionable[]>();
        LineProperties currentUnderline = null;
        Positionable startForUnderline = null;
        Positionable endForUnderline = null;
        double yPositionUnderline = 0.0;
        double baselineHeight = 0.0;
        double lineThick = 0.0;
        for (i = 0; i < row.getElementCount(); ++i) {
            Positionable rowElement = row.getElement(i);
            RenderUtil.collectRenderObjects(renderPage, rowElement, elementList, transformation);
            RenderFont renderFont = null;
            if (rowElement instanceof RowTextPiece) {
                TextRowElement parent = ((RowTextPiece)rowElement).getParent();
                renderFont = parent.getRenderFont();
                fallbackColor.put(rowElement, parent.getColor());
            } else if (rowElement instanceof Drawing) {
                renderFont = ((Drawing)rowElement).getRenderFont();
            } else {
                Util.LOGGER.warn((Object)("Instance of " + String.valueOf(rowElement.getClass()) + " is not implemented for underline"));
            }
            if (renderFont == null) continue;
            objectToFont.put(rowElement, renderFont);
            line = renderFont.getUnderline();
            if (line != null) {
                if (line.getStyle() != LineStyle.NIL && line.getStyle() != LineStyle.NONE && renderFont.getRenderDimensions() != null) {
                    baselineHeight = Math.max(baselineHeight, renderFont.getRenderDimensions().getBaselineHeight());
                    yPositionUnderline = Math.max(yPositionUnderline, rowElement.getPageY());
                    lineThick = Math.max((double)renderFont.getFontSize() * 1.2, lineThick);
                }
                if (line.getColor() == null) {
                    Color fallbackColorLine = (Color)fallbackColor.get(rowElement);
                    if (fallbackColorLine == null) {
                        fallbackColorLine = Color.BLACK;
                    }
                    line = new LineProperties(fallbackColorLine, line.getStyle(), line.isHeavy(), line.getWidth(), line.getSpace());
                }
                objectToLineStyle.put(rowElement, line);
                if (currentUnderline == null) {
                    currentUnderline = line;
                    startForUnderline = rowElement;
                    endForUnderline = rowElement;
                    continue;
                }
                if (currentUnderline.equals(line)) {
                    endForUnderline = rowElement;
                    continue;
                }
                underlineSegments.add(new Positionable[]{startForUnderline, endForUnderline});
                currentUnderline = line;
                startForUnderline = rowElement;
                endForUnderline = rowElement;
                continue;
            }
            if (currentUnderline == null) continue;
            underlineSegments.add(new Positionable[]{startForUnderline, endForUnderline});
            currentUnderline = null;
            startForUnderline = null;
            endForUnderline = null;
        }
        if (currentUnderline != null) {
            underlineSegments.add(new Positionable[]{startForUnderline, endForUnderline});
        }
        for (i = 0; i < underlineSegments.size(); ++i) {
            Positionable[] positionablePair = (Positionable[])underlineSegments.get(i);
            startForUnderline = positionablePair[0];
            endForUnderline = positionablePair[1];
            AffineTransform affineTransform = new AffineTransform(1.0, 0.0, 0.0, -1.0, Util.convertTwipsToPoint(startForUnderline.getPageX()), Util.convertTwipsToPoint(yPositionUnderline + baselineHeight));
            affineTransform.preConcatenate(transformation);
            line = (LineProperties)objectToLineStyle.get(startForUnderline);
            double linwWidth = endForUnderline.getPageX() + endForUnderline.getWidth() - startForUnderline.getPageX();
            if (line.getStyle() == LineStyle.NIL || line.getStyle() == LineStyle.NONE) continue;
            Color lineColor = line.getColor() != null ? line.getColor() : Color.BLACK;
            double width = lineThick;
            if (line.isLineStyle(LineStyle.DOUBLE) || line.getStyle().getLineCount() == 2) {
                RenderUtil.getLineElement(renderPage, elementList, line, lineColor, affineTransform, linwWidth, width, width);
                RenderUtil.getLineElement(renderPage, elementList, line, lineColor, affineTransform, linwWidth, width, width * 3.0);
                continue;
            }
            if (line.isHeavy()) {
                width *= 2.0;
            }
            RenderUtil.getLineElement(renderPage, elementList, line, lineColor, affineTransform, linwWidth, width, width * 2.5);
        }
    }

    private static void collectRowTextPiece(RenderPage renderPage, RowTextPiece row, ArrayList<RenderBaseObject> elementList, AffineTransform transformation) {
        TextRowElement tre = row.getParent();
        RenderFont renderFont = tre.getRenderFont();
        StringLayouter stringLayouter = renderPage.getDocumentProperties().getLayouter(renderFont);
        elementList.add(new RenderText(row, stringLayouter, transformation, renderPage.getDocumentProperties().getPageBackground().getBackGroundColor()));
    }

    private static void collectTableView(RenderPage renderPage, TableView table, ArrayList<RenderBaseObject> elementList, AffineTransform transformation) {
        int i;
        ArrayList<Positionable> elements = new ArrayList<Positionable>();
        int colCount = table.getSource().getColumnCount();
        int rowCount = table.getRows().size();
        double[] xPositions = new double[colCount + 1];
        double[] yPositions = new double[rowCount + 1];
        xPositions[0] = table.getPageX();
        yPositions[0] = table.getPageY();
        xPositions[colCount] = table.getPageX() + table.getWidth();
        yPositions[rowCount] = table.getPageY() + table.getHeight();
        int rowPos = 0;
        int colPos = 0;
        for (List list : table.getRows()) {
            for (TableCellView tc : list) {
                if (tc == null) {
                    ++colPos;
                    continue;
                }
                xPositions[colPos] = tc.getPositionX();
                yPositions[rowPos] = tc.getPositionY();
                xPositions[colPos + tc.getColSpan()] = tc.getPositionX() + tc.getWidth();
                int endRow = Math.min(rowPos + tc.getRowSpan(), rowCount);
                yPositions[endRow] = tc.getPositionY() + tc.getHeight();
                tc.collectElements(elements);
                ++colPos;
            }
            ++rowPos;
            colPos = 0;
        }
        for (i = 1; i < xPositions.length; ++i) {
            xPositions[i] = Math.max(xPositions[i - 1], xPositions[i]);
        }
        for (i = 1; i < yPositions.length; ++i) {
            yPositions[i] = Math.max(yPositions[i - 1], yPositions[i]);
        }
        ArrayList<SimpleLine> lines = new ArrayList<SimpleLine>();
        table.getBorders().createGridLines(lines, xPositions, yPositions);
        Drawing drawing = DrawingFactory.createLines(lines);
        if (drawing != null) {
            elements.add(drawing);
        }
        if (elements.isEmpty()) {
            return;
        }
        RenderUtil.collectAndCreateStructure(renderPage, elementList, elements, "table", transformation);
    }

    private static void getLineElement(RenderPage context, ArrayList<RenderBaseObject> elementList, LineProperties line, Color lineColor, AffineTransform affineTransform, double width, double lineThick, double offSetY) {
        double xPos = affineTransform.getTranslateX();
        double yPos = affineTransform.getTranslateY() + Util.convertTwipsToPoint(offSetY);
        Point2D.Double p1 = new Point2D.Double(0.0, -offSetY);
        Point2D.Double p2 = new Point2D.Double(width, -offSetY);
        SimpleShape simS = DrawingFactory.createLine(new LineProperties(lineColor, line.getStyle(), line.isHeavy(), (int)lineThick, 0.0), p1, p2);
        RenderUtil.collectElements(context, simS, elementList, affineTransform);
    }

    private static void collectElements(RenderPage renderPage, DrawingElement drawingElement, ArrayList<RenderBaseObject> elementList, AffineTransform transform) {
        if (drawingElement instanceof ShapeGroup) {
            RenderUtil.collectShapeGroup(renderPage, (ShapeGroup)drawingElement, elementList, transform);
        } else if (drawingElement instanceof TextBoxShape) {
            RenderUtil.collectTextBox(renderPage, (TextBoxShape)drawingElement, elementList, transform);
        } else if (drawingElement instanceof SimpleShape) {
            RenderUtil.collectSimpleShape(renderPage, (SimpleShape)drawingElement, elementList, transform);
        } else if (drawingElement instanceof PictureElement) {
            RenderUtil.collectPictureElement(renderPage, (PictureElement)drawingElement, elementList, transform);
        } else if (drawingElement instanceof TablePanel) {
            RenderUtil.collectTablePanel(renderPage, (TablePanel)drawingElement, elementList, transform);
        } else if (drawingElement instanceof Drawing) {
            RenderUtil.collectDrawing(renderPage, (Drawing)drawingElement, elementList, transform);
        }
    }

    private static void collectShapeGroup(RenderPage renderPage, ShapeGroup shapeGroup, ArrayList<RenderBaseObject> elementList, AffineTransform transform) {
        AffineTransform transformation = shapeGroup.getTransformation(Util.convertTwipsToPoint(shapeGroup.getPosition().getX()), Util.convertTwipsToPoint(shapeGroup.getPosition().getY()), Util.convertTwipsToPoint(shapeGroup.getWidth()), Util.convertTwipsToPoint(shapeGroup.getHeight()));
        transformation.preConcatenate(transform);
        RenderUtil.collectAndCreateDrawingStructure(renderPage, elementList, shapeGroup.getElements(), "shapegroup", transformation);
    }

    private static void collectTextBox(RenderPage renderPage, TextBoxShape textBoxShape, ArrayList<RenderBaseObject> elementList, AffineTransform transform) {
        AffineTransform transformation = textBoxShape.getTransformation(Util.convertTwipsToPoint(textBoxShape.getPosition().getX()), Util.convertTwipsToPoint(textBoxShape.getPosition().getY()), Util.convertTwipsToPoint(textBoxShape.getWidth()), Util.convertTwipsToPoint(textBoxShape.getHeight()), textBoxShape.getRotation());
        transformation.preConcatenate(transform);
        List<Positionable> elements = textBoxShape.getElements(renderPage, transformation);
        RenderUtil.collectElements(renderPage, textBoxShape.getSimShape(), elementList, transform);
        RenderContainer textboxconent = RenderUtil.collectAndCreateStructure(renderPage, elementList, elements, "textboxconent", transformation);
        SimpleShape simpleShape = textBoxShape.getSimShape();
        textboxconent.setClip(transformation.createTransformedShape(simpleShape.getShape()));
    }

    private static void collectSimpleShape(RenderPage renderPage, SimpleShape simpleShape, ArrayList<RenderBaseObject> elementList, AffineTransform transform) {
        AffineTransform transformation = simpleShape.getTransformation(Util.convertTwipsToPoint(simpleShape.getPosition().getX()), Util.convertTwipsToPoint(simpleShape.getPosition().getY()), Util.convertTwipsToPoint(simpleShape.getWidth()), Util.convertTwipsToPoint(simpleShape.getHeight()));
        transformation.preConcatenate(transform);
        Shape previousShape = simpleShape.getShape();
        Shape transformed = transformation.createTransformedShape(previousShape);
        Paint backgroundPaint = simpleShape.getBackgroundColor();
        PictureFillData pictureFillData = simpleShape.getPictureFillData();
        if (pictureFillData != null) {
            String refID = pictureFillData.getReferenceID();
            SerializableImage imageData = renderPage.getDocumentProperties().getImageData(refID);
            if (imageData == null) {
                Util.LOGGER.error((Object)("Image for ID = " + refID + " not found!\tProperties => " + String.valueOf(renderPage.getDocumentProperties())));
            } else {
                BufferedImage bufferedImage = imageData.getBufferedImage();
                PictureFillData.TileData tileData = pictureFillData.getTileData();
                if (tileData == null) {
                    backgroundPaint = new ImagePaint(bufferedImage, previousShape.getBounds2D());
                } else {
                    double sx = 15.0 * tileData.getSx() * (double)bufferedImage.getWidth() / 100.0;
                    double sy = 15.0 * tileData.getSy() * (double)bufferedImage.getHeight() / 100.0;
                    Rectangle2D.Double rect = new Rectangle2D.Double(tileData.getTx(), tileData.getTy(), sx, sy);
                    backgroundPaint = new TexturePaint(bufferedImage, rect);
                }
            }
        }
        if (backgroundPaint instanceof LinearGradientPaint) {
            LinearGradientPaint gradientPaint = (LinearGradientPaint)backgroundPaint;
            Point2D start = gradientPaint.getStartPoint();
            Point2D end = gradientPaint.getEndPoint();
            Point2D.Double newStart = new Point2D.Double();
            Point2D.Double newEnd = new Point2D.Double();
            transformation.transform(start, newStart);
            transformation.transform(end, newEnd);
            gradientPaint.getStartPoint().setLocation(newStart);
            gradientPaint.getEndPoint().setLocation(newEnd);
            backgroundPaint = new LinearGradientPaint(newStart, newEnd, gradientPaint.getFractions(), gradientPaint.getColors());
        } else if (backgroundPaint instanceof TexturePaint) {
            TexturePaint texturePaint = (TexturePaint)backgroundPaint;
            AffineTransform twipsToPoints = new AffineTransform(Util.convertTwipsToPoint(1.0), 0.0, 0.0, Util.convertTwipsToPoint(1.0), 0.0, 0.0);
            transformation.concatenate(twipsToPoints);
            Rectangle2D rect = texturePaint.getAnchorRect();
            Point2D.Double start = new Point2D.Double(rect.getMinX() + simpleShape.getPosition().getX(), rect.getMinY() + simpleShape.getPosition().getY());
            Point2D.Double end = new Point2D.Double(rect.getMaxX() + simpleShape.getPosition().getX(), rect.getMaxY() + simpleShape.getPosition().getY());
            transformation.transform(start, start);
            transformation.transform(end, end);
            Rectangle2D.Double newBounds = new Rectangle2D.Double(((Point2D)start).getX(), ((Point2D)start).getY(), ((Point2D)end).getX() - ((Point2D)start).getX(), ((Point2D)end).getY() - ((Point2D)start).getY());
            backgroundPaint = backgroundPaint instanceof ImagePaint ? new ImagePaint(texturePaint.getImage(), newBounds) : new TexturePaint(texturePaint.getImage(), newBounds);
        }
        if (simpleShape.isMultiShape()) {
            SimpleShape[] subShapes;
            for (SimpleShape subShape : subShapes = simpleShape.getShapes()) {
                BasicStrokeData basicStrokeData = subShape.getBasicStrokeData();
                elementList.add(new RenderShape(transformed, basicStrokeData.getBorderColor(), backgroundPaint, basicStrokeData.getBasicStroke()));
            }
        } else {
            BasicStrokeData basicStrokeData = simpleShape.getBasicStrokeData();
            elementList.add(new RenderShape(transformed, basicStrokeData.getBorderColor(), backgroundPaint, basicStrokeData.getBasicStroke()));
        }
    }

    private static void collectPictureElement(RenderPage renderPage, PictureElement pictureElement, ArrayList<RenderBaseObject> elementList, AffineTransform transform) {
        SerializableImage imageData = renderPage.getDocumentProperties().getImageData(pictureElement.getReferenceId());
        if (imageData == null) {
            Util.LOGGER.error((Object)("Image for ID = " + pictureElement.getReferenceId() + " not found!\tProperties => " + String.valueOf(renderPage.getDocumentProperties())));
        } else {
            AffineTransform transformation = pictureElement.getTransformation(Util.convertTwipsToPoint(pictureElement.getPosition().getX()), Util.convertTwipsToPoint(pictureElement.getPosition().getY()), Util.convertTwipsToPoint(pictureElement.getWidth()), Util.convertTwipsToPoint(pictureElement.getHeight()), pictureElement.getRotation());
            transformation.preConcatenate(transform);
            transformation.scale(Util.convertTwipsToPoint(pictureElement.getWidth()), Util.convertTwipsToPoint(pictureElement.getHeight()));
            BasicStrokeData strokeData = pictureElement.getBasicStrokeData();
            elementList.add(new RenderImage(transformation, imageData, strokeData.getBorderColor(), strokeData.getBasicStroke()));
        }
    }

    private static void collectTablePanel(RenderPage renderPage, TablePanel tablePanel, ArrayList<RenderBaseObject> elementList, AffineTransform transform) {
        TableView view = tablePanel.getView(renderPage);
        RenderUtil.collectTableView(renderPage, view, elementList, transform);
    }

    private static void collectDrawing(RenderPage renderPage, Drawing drawing, ArrayList<RenderBaseObject> elementList, AffineTransform transform) {
        double pageY;
        PageProperties pageProps = renderPage.getPageLayout();
        Anchor anchorHorizontal = drawing.getAnchorHorizontal();
        Anchor anchorVertical = drawing.getAnchorVertical();
        boolean oddPage = renderPage.getInSectionPageNumber() % 2 != 0;
        BorderLineExternalWidths borderLineWidths = drawing.getBorderLineExternalWidths();
        double pageX = anchorHorizontal == null ? drawing.getPageX() : anchorHorizontal.getPositionValue(pageProps, drawing.getWidthValue().calculateValue(pageProps, oddPage), drawing.getPageX(), oddPage, borderLineWidths);
        double d = pageY = anchorVertical == null ? drawing.getPageY() : anchorVertical.getPositionValue(pageProps, drawing.getHeightValue().calculateValue(pageProps, oddPage), drawing.getPageY(), oddPage, borderLineWidths);
        if (drawing.getContent() != null) {
            ArrayList<RenderBaseObject> renderList = new ArrayList<RenderBaseObject>();
            RenderContainer container = new RenderContainer(renderList, "drawing");
            container.setzOrder(drawing.getzOrder());
            elementList.add(container);
            AffineTransform contentTransform = new AffineTransform(transform);
            contentTransform.concatenate(new AffineTransform(1.0, 0.0, 0.0, 1.0, pageX / 20.0, pageY / 20.0));
            DrawingElement content = drawing.getContent();
            content.setHeight(drawing.getHeightValue().calculateValue(pageProps, oddPage));
            content.setWidth(drawing.getWidthValue().calculateValue(pageProps, oddPage));
            RenderUtil.collectElements(renderPage, content, renderList, contentTransform);
        }
    }

    private static RenderContainer collectAndCreateStructure(RenderPage renderPage, ArrayList<RenderBaseObject> elementList, List<Positionable> elements, String structureName, AffineTransform transformation) {
        ArrayList<RenderBaseObject> renderTable = new ArrayList<RenderBaseObject>();
        RenderContainer container = new RenderContainer(renderTable, structureName);
        elementList.add(container);
        for (Positionable positionable : elements) {
            RenderUtil.collectRenderObjects(renderPage, positionable, renderTable, transformation);
        }
        return container;
    }

    private static RenderContainer collectAndCreateDrawingStructure(RenderPage renderPage, ArrayList<RenderBaseObject> elementList, List<DrawingElement> elements, String structureName, AffineTransform transformation) {
        ArrayList<RenderBaseObject> renderList = new ArrayList<RenderBaseObject>();
        RenderContainer container = new RenderContainer(renderList, structureName);
        elementList.add(container);
        for (DrawingElement positionable : elements) {
            RenderUtil.collectElements(renderPage, positionable, renderList, transformation);
        }
        return container;
    }
}

