/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.view.render;

import com.inet.cache.image.SerializableImage;
import com.inet.docx.view.render.RenderBaseObject;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import javax.annotation.Nonnull;

public class RenderImage
extends RenderBaseObject {
    private final AffineTransform transform;
    private final SerializableImage image;
    private final Paint strokePaint;
    private final BasicStroke stroke;

    public AffineTransform getTransform() {
        return this.transform;
    }

    public SerializableImage getImage() {
        return this.image;
    }

    public RenderImage(@Nonnull AffineTransform transform, @Nonnull SerializableImage image, Paint strokePaint, BasicStroke stroke) {
        this.transform = transform;
        this.image = image;
        this.strokePaint = strokePaint;
        this.stroke = stroke;
    }

    @Override
    public void renderPage(Graphics2D graphics, Rectangle2D imgBounds) {
        Graphics2D sub = (Graphics2D)graphics.create();
        if (this.strokePaint != null) {
            sub.setPaint(this.strokePaint);
            if (this.stroke.getLineWidth() > 0.0f) {
                sub.setStroke(this.stroke);
            }
            AffineTransform transformForBorder = new AffineTransform(this.transform);
            double newScaleX = 1.0 / this.transform.getScaleX();
            double newScaleY = 1.0 / this.transform.getScaleY();
            transformForBorder.concatenate(AffineTransform.getScaleInstance(newScaleX, newScaleY));
            sub.transform(transformForBorder);
            sub.draw(new Rectangle2D.Double(-this.image.getWidth() / 2, -this.image.getHeight() / 2, (float)this.image.getWidth() + this.stroke.getLineWidth(), (float)this.image.getHeight() + this.stroke.getLineWidth()));
            sub = (Graphics2D)graphics.create();
        }
        sub.transform(this.transform);
        sub.drawImage((Image)this.image, 0, 0, 1, 1, null);
        sub.dispose();
    }
}

