/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.view.render;

import com.inet.docx.view.render.RenderBaseObject;
import com.inet.docx.view.render.RenderObject;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class RenderContainer
extends RenderBaseObject {
    private final List<RenderBaseObject> renderObjectList;
    private final String containerType;
    private int size = 0;
    private Shape clip = null;

    public RenderContainer(List<RenderBaseObject> renderObjectList, String typ) {
        this.renderObjectList = renderObjectList;
        this.containerType = typ;
    }

    public void setClip(Shape clip) {
        this.clip = clip;
    }

    public String getContainerType() {
        return this.containerType;
    }

    public List<RenderObject> getRenderObjectList() {
        this.sort();
        return new ArrayList<RenderObject>(this.renderObjectList);
    }

    @Override
    public void renderPage(Graphics2D graphics, Rectangle2D imgBounds) {
        this.sort();
        Graphics2D sub = (Graphics2D)graphics.create();
        if (this.clip != null) {
            sub.clip(this.clip);
        }
        for (RenderBaseObject renderObject : this.renderObjectList) {
            renderObject.renderPage(sub, imgBounds);
        }
    }

    private void sort() {
        if (this.size != this.renderObjectList.size()) {
            this.renderObjectList.sort(Comparator.comparingLong(RenderObject::getzOrder));
            this.size = this.renderObjectList.size();
        }
    }
}

