/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.view.paragraph;

import com.inet.docx.document.elements.subelements.Positionable;
import com.inet.docx.document.paragraph.ParagraphData;
import com.inet.docx.document.utilities.Util;
import com.inet.docx.view.PageElement;
import com.inet.docx.view.paragraph.ParagraphPageBreakPosition;
import com.inet.docx.view.paragraph.ParagraphRow;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public class ParagraphView
extends Positionable
implements PageElement {
    private List<ParagraphRow> rows = new ArrayList<ParagraphRow>();
    private ParagraphData parentParagraph;
    private double width;
    private double height = Double.NaN;

    public ParagraphView(ParagraphData parentParagraph, double x, double y, double paragraphWidth) {
        this.parentParagraph = parentParagraph;
        this.setPageX(x);
        this.setPageY(y);
        this.width = paragraphWidth;
    }

    @Override
    public void move(double xOffset, double yOffset) {
        super.move(xOffset, yOffset);
        this.rows.forEach(row -> row.move(xOffset, yOffset));
    }

    @Override
    public Rectangle2D getBounds() {
        return new Rectangle2D.Double(this.getPageX(), this.getPageY(), this.width, this.getHeight());
    }

    public boolean hasBorder() {
        return this.parentParagraph.getBorder() != null;
    }

    @Override
    public double getWidth() {
        return this.getBounds().getWidth();
    }

    @Override
    public double getBaseline() {
        return 0.0;
    }

    public boolean isEmpty() {
        return this.rows == null;
    }

    public int getRowCount() {
        if (this.rows == null) {
            return 0;
        }
        return this.rows.size();
    }

    public ParagraphRow getRow(int index) {
        return index >= 0 && index < this.rows.size() ? this.rows.get(index) : null;
    }

    private double getRowsHeight() {
        if (this.rows == null) {
            Util.LOGGER.info((Object)("row null " + this.parentParagraph.getElements().size()));
            return 0.0;
        }
        double endY = 0.0;
        for (ParagraphRow row : this.rows) {
            endY = Math.max(endY, row.getPageY() + row.getHeight());
        }
        return endY - this.getPageY();
    }

    @Override
    public double getHeight() {
        if (Double.isNaN(this.height)) {
            this.height = this.getRowsHeight();
        }
        return this.height;
    }

    public double getDescent() {
        if (this.rows != null) {
            return this.rows.get(0).getDescent();
        }
        return 0.0;
    }

    public double getLeading() {
        if (this.rows != null) {
            return this.rows.get(0).getLeading();
        }
        return 0.0;
    }

    public void addRow(ParagraphRow row) {
        this.rows.add(row);
    }

    public ParagraphPageBreakPosition getBreakPosition(double yLimit) {
        double yPos = 0.0;
        for (ParagraphRow row : this.rows) {
            if (!((yPos += row.getHeight()) > yLimit)) continue;
            return row.getStartBreak();
        }
        return null;
    }

    @Override
    public double getMinKeepTogetherHeight() {
        int spacing = this.getSource().getSpacing() != null ? this.getSource().getSpacing().getBefore() : 0;
        return Math.min(this.getHeight(), this.getRow(0).getHeight() + (double)spacing);
    }

    @Override
    public int getSpacingTop(boolean isFirstRow) {
        return isFirstRow && this.getSource().getSpacing() != null ? this.getSource().getSpacing().getBefore() : 0;
    }

    @Override
    public int getSpacingBottom() {
        return this.getSource().getSpacing() != null ? this.getSource().getSpacing().getAfter() : 0;
    }

    @Override
    public void collectElements(List<Positionable> elements) {
        this.rows.forEach(r -> r.collectElements(elements));
    }

    @Override
    public ParagraphData getSource() {
        return this.parentParagraph;
    }

    public String toString() {
        Object toString = "";
        for (ParagraphRow rowElement : this.rows) {
            toString = (String)toString + rowElement.toString() + " ,";
        }
        return "ParagraphView{" + (String)toString + ", height = " + this.getHeight() + "}";
    }
}

