/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.view.drawing;

import com.inet.docx.document.DocumentProperties;
import com.inet.docx.document.elements.subelements.drawing.DrawingContent;
import com.inet.docx.document.utilities.ParseOperations;
import com.inet.docx.document.utilities.Util;
import com.inet.docx.view.drawing.DrawingFactory;
import com.inet.docx.view.drawing.SimpleShape;
import com.inet.docx.view.drawing.VmlFill;
import com.microsoft.schemas.vml.CTF;
import com.microsoft.schemas.vml.CTFill;
import com.microsoft.schemas.vml.CTFormulas;
import com.microsoft.schemas.vml.CTPath;
import com.microsoft.schemas.vml.CTShape;
import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.openxmlformats.schemas.officeDocument.x2006.sharedTypes.STTrueFalse;

public class VmlShapeConverter {
    private static final String[] COMMANDS = new String[]{"qb", "qy", "qx", "wr", "wa", "ar", "at", "al", "ae", "ns", "nf", "m", "l", "c", "x", "e", "t", "r", "v"};
    private List<PathOperation> pathCommands;
    private List<Formula> equations = new ArrayList<Formula>();
    private int[] adjustValues;
    private int[] coordinates;
    private Point2D origin;
    private Double tempParam = null;

    public static SimpleShape createShape(CTShape ctShape, DrawingContent dc, DocumentProperties docProps) {
        return VmlShapeConverter.createShape(ctShape, dc, docProps, null);
    }

    public static SimpleShape createShape(CTShape ctShape, DrawingContent dc, DocumentProperties docProps, @Nullable DrawingContent groupContent) {
        double scaleY;
        List pathList = ctShape.getPathList();
        String pathV = ctShape.getPath2();
        if (!pathList.isEmpty()) {
            CTPath path = (CTPath)pathList.get(pathList.size() - 1);
            if (ctShape.isSetPath2()) {
                pathV = ctShape.xgetPath2().getStringValue();
            }
            if (path.isSetV()) {
                pathV = path.xgetV().getStringValue();
            }
        }
        String coordSize = "1000,1000";
        if (ctShape.isSetCoordsize()) {
            coordSize = ctShape.getCoordsize();
        }
        String origin = ctShape.getCoordorigin();
        String adjust = ctShape.getAdj();
        VmlShapeConverter converter = new VmlShapeConverter(pathV, coordSize, origin, adjust, new ArrayList<CTFormulas>());
        Path2D.Double shapePath = converter.getShape();
        double coordSizeScaleX = 1.0;
        double coordSizeScaleY = 1.0;
        double scaleX = dc.getWidth() == null || dc.getWidth().getValue() == 0.0 ? 1.0 : dc.getWidth().getValue();
        double d = scaleY = dc.getHeight() == null || dc.getHeight().getValue() == 0.0 ? 1.0 : dc.getHeight().getValue();
        if (groupContent != null) {
            double width = groupContent.getWidth().getValue();
            double height = groupContent.getWidth().getValue();
            double sizeX = groupContent.getCoordinateSize().getX();
            double sizeY = groupContent.getCoordinateSize().getY();
            double shiftX = groupContent.getScaleX() * (groupContent.getCoordinateOrigin().getX() * -1.0) / scaleX;
            double shiftY = groupContent.getScaleY() * (groupContent.getCoordinateOrigin().getY() * -1.0) / scaleY;
            double unitFactorX = dc.getWidth().getValueWithUnit().getUnit().getTwipsFactor();
            double unitFactorY = dc.getHeight().getValueWithUnit().getUnit().getTwipsFactor();
            coordSizeScaleX = groupContent.getWidth().getValue() / dc.getCoordinateSize().getX() / unitFactorX;
            coordSizeScaleY = groupContent.getHeight().getValue() / dc.getCoordinateSize().getY() / unitFactorY;
            AffineTransform groupTransformation = new AffineTransform(coordSizeScaleX, 0.0, 0.0, coordSizeScaleY, shiftX, shiftY);
            shapePath.transform(groupTransformation);
            coordSizeScaleX = dc.getCoordinateSize().getX() / groupContent.getCoordinateSize().getX();
            coordSizeScaleY = dc.getCoordinateSize().getY() / groupContent.getCoordinateSize().getY();
        }
        Rectangle2D bounds = shapePath.getBounds2D();
        scaleX = dc.getWidth() == null || dc.getWidth().getValue() == 0.0 ? 1.0 : coordSizeScaleX * dc.getWidth().getValue() / bounds.getWidth();
        scaleY = dc.getHeight() == null || dc.getHeight().getValue() == 0.0 ? 1.0 : coordSizeScaleY * dc.getHeight().getValue() / bounds.getHeight();
        double xOff = dc.getLeft() / scaleX;
        double yOff = dc.getTop() / scaleY;
        shapePath.transform(new AffineTransform(1.0, 0.0, 0.0, 1.0, xOff, yOff));
        SimpleShape simShape = new SimpleShape(SimpleShape.ShapeType.multiline.name(), bounds, dc.getRotation(), scaleX, scaleY, dc.getReflection());
        simShape.addMultiLine(shapePath);
        List fillList = ctShape.getFillList();
        Paint fillPaint = null;
        CTFill ctFill = null;
        if (!fillList.isEmpty()) {
            ctFill = (CTFill)fillList.get(fillList.size() - 1);
        }
        if (ctFill != null) {
            fillPaint = VmlFill.getPaint(ctFill, bounds, docProps, dc);
        }
        if (fillPaint == null) {
            fillPaint = DrawingFactory.getColor(ctShape.getFillcolor(), null);
        }
        boolean noFill = false;
        if (!pathList.isEmpty()) {
            CTPath path = (CTPath)pathList.get(pathList.size() - 1);
            if (path.isSetStrokeok() && path.getStrokeok() == STTrueFalse.T) {
                String strokeW = ctShape.getStrokeweight();
                double borderLineWidth = strokeW != null ? ParseOperations.handleValues(strokeW) : 15.0;
                simShape.getBasicStrokeData().setBorderLineWidth(borderLineWidth);
                Color bg = DrawingFactory.getColor(ctShape.getFillcolor(), DrawingFactory.getColor(ctFill == null ? null : ctFill.getColor(), null));
                simShape.getBasicStrokeData().setBorderColor(DrawingFactory.getStrokeColor(ctShape.getStrokecolor(), ctShape.getStrokeList(), bg == null ? Color.BLACK : Color.WHITE));
            }
            noFill = path.getFillok() != STTrueFalse.T;
        }
        simShape.setBgColor(fillPaint);
        simShape.setNoFill(noFill);
        dc.addElement(simShape);
        return simShape;
    }

    public VmlShapeConverter(String path, String coordinateString, String coordinateOrigin, @Nullable String adjustValueString, List<CTFormulas> formulas) {
        this.coordinates = VmlShapeConverter.convertValues(coordinateString);
        this.adjustValues = VmlShapeConverter.convertValues(adjustValueString);
        this.origin = VmlShapeConverter.convertOrigin(coordinateOrigin);
        this.pathCommands = this.splitOperations(path);
        if (formulas.size() > 0) {
            List fms = formulas.get(0).getFList();
            for (CTF fm : fms) {
                this.equations.add(new Formula(fm.getEqn()));
            }
        }
    }

    public static int[] convertValues(String input) {
        if (input != null) {
            String[] parts = input.split(",");
            int[] result = new int[parts.length];
            for (int i = 0; i < parts.length; ++i) {
                result[i] = parts[i].trim().isEmpty() ? 0 : Integer.parseInt(parts[i]);
            }
            return result;
        }
        return new int[0];
    }

    public Point2D getCoordinateOrigin() {
        return this.origin;
    }

    private static Point2D convertOrigin(String coordinateOrigin) {
        double x = 0.0;
        double y = 0.0;
        if (coordinateOrigin != null && coordinateOrigin.indexOf(44) > -1) {
            x = ParseOperations.handleValues(coordinateOrigin.substring(0, coordinateOrigin.indexOf(44)));
            y = ParseOperations.handleValues(coordinateOrigin.substring(coordinateOrigin.indexOf(44) + 1));
        }
        return new Point2D.Double(x, y);
    }

    private List<PathOperation> splitOperations(String path) {
        ArrayList<PathOperation> operations = new ArrayList<PathOperation>();
        if (path == null) {
            return operations;
        }
        int position = 0;
        int off = 1;
        while (position > -1) {
            int nextStart = -1;
            int nextOff = -1;
            for (String comand : COMMANDS) {
                int pos = path.indexOf(comand, position + off);
                if (pos <= -1 || nextStart != -1 && pos >= nextStart) continue;
                nextStart = pos;
                nextOff = comand.length();
            }
            String command = nextStart > -1 ? path.substring(position, nextStart) : path.substring(position);
            if (!command.trim().isEmpty()) {
                operations.add(new PathOperation(command));
            }
            position = nextStart;
            off = nextOff;
        }
        return operations;
    }

    public Path2D.Double getShape() {
        Point2D currentP = new Point2D.Double(this.coordinates[0] == 0 ? 0.0 : -this.getCoordinateOrigin().getX() / (double)this.coordinates[0], this.coordinates[1] == 0 ? 0.0 : -this.getCoordinateOrigin().getY() / (double)this.coordinates[1]);
        Path2D.Double shape = new Path2D.Double();
        boolean stroke = true;
        block42: for (PathOperation pop : this.pathCommands) {
            switch (pop.command) {
                case "m": {
                    Point2D startP = pop.getPoints().get(0);
                    shape.moveTo(startP.getX(), startP.getY());
                    currentP = startP;
                    break;
                }
                case "l": {
                    if (!this.canDraw(stroke, shape, currentP)) continue block42;
                    List<Point2D> ps = pop.getPoints();
                    for (Point2D someP : ps) {
                        shape.lineTo(someP.getX(), someP.getY());
                        currentP = someP;
                    }
                    continue block42;
                }
                case "c": {
                    Point2D end;
                    Object ct1;
                    if (!this.canDraw(stroke, shape, currentP)) continue block42;
                    List<Point2D> ps = pop.getPoints();
                    while (!ps.isEmpty()) {
                        ct1 = ps.get(0);
                        Point2D ct2 = ps.get(1);
                        end = ps.get(2);
                        shape.curveTo(((Point2D)ct1).getX(), ((Point2D)ct1).getY(), ct2.getX(), ct2.getY(), end.getX(), end.getY());
                        currentP = end;
                        ps.remove(ct1);
                        ps.remove(ct2);
                        ps.remove(end);
                    }
                    continue block42;
                }
                case "t": {
                    Point2D startP = pop.getPoints().get(0);
                    shape.moveTo(currentP.getX() + startP.getX(), currentP.getY() + startP.getY());
                    currentP = startP;
                    break;
                }
                case "r": {
                    if (!this.canDraw(stroke, shape, currentP)) continue block42;
                    List<Point2D> ps = pop.getPoints(true);
                    for (Point2D someP : ps) {
                        currentP = new Point2D.Double(currentP.getX() + someP.getX(), currentP.getY() + someP.getY());
                        shape.lineTo(currentP.getX(), currentP.getY());
                    }
                    continue block42;
                }
                case "v": {
                    Point2D end;
                    Object ct1;
                    if (!this.canDraw(stroke, shape, currentP)) continue block42;
                    List<Point2D> ps = pop.getPoints(true);
                    while (!ps.isEmpty()) {
                        ct1 = ps.get(0);
                        Point2D ct2 = ps.get(1);
                        end = ps.get(2);
                        ps.remove(ct1);
                        ps.remove(ct2);
                        ps.remove(end);
                        ct1 = new Point2D.Double(currentP.getX() + ((Point2D)ct1).getX(), currentP.getY() + ((Point2D)ct1).getY());
                        ct2 = new Point2D.Double(currentP.getX() + ct2.getX(), currentP.getY() + ct2.getY());
                        end = new Point2D.Double(currentP.getX() + end.getX(), currentP.getY() + end.getY());
                        shape.curveTo(((Point2D)ct1).getX(), ((Point2D)ct1).getY(), ct2.getX(), ct2.getY(), end.getX(), end.getY());
                        currentP = end;
                    }
                    continue block42;
                }
                case "ae": {
                    Point2D end;
                    Object ct1;
                    if (!this.canDraw(stroke, shape, currentP)) continue block42;
                    List<Point2D> ps = pop.getPoints();
                    while (!ps.isEmpty()) {
                        ct1 = ps.get(0);
                        Point2D ct2 = ps.get(1);
                        end = ps.get(2);
                        ps.remove(ct1);
                        ps.remove(ct2);
                        ps.remove(end);
                        currentP = end;
                    }
                    continue block42;
                }
                case "al": {
                    Point2D end;
                    Object ct1;
                    if (!this.canDraw(stroke, shape, currentP)) continue block42;
                    List<Point2D> ps = pop.getPoints();
                    while (!ps.isEmpty()) {
                        ct1 = ps.get(0);
                        Point2D ct2 = ps.get(1);
                        end = ps.get(2);
                        ps.remove(ct1);
                        ps.remove(ct2);
                        ps.remove(end);
                        currentP = end;
                    }
                    continue block42;
                }
                case "at": {
                    Point2D end;
                    Point2D start;
                    Point2D p2;
                    if (!this.canDraw(stroke, shape, currentP)) continue block42;
                    List<Point2D> points = pop.getPoints();
                    while (!points.isEmpty()) {
                        Point2D p1 = points.get(0);
                        p2 = points.get(1);
                        start = points.get(2);
                        end = points.get(3);
                        points.remove(p1);
                        points.remove(p2);
                        points.remove(start);
                        points.remove(end);
                        currentP = end;
                    }
                    continue block42;
                }
                case "ar": {
                    Point2D end;
                    Point2D start;
                    Point2D p2;
                    if (!this.canDraw(stroke, shape, currentP)) continue block42;
                    List<Point2D> points = pop.getPoints();
                    while (!points.isEmpty()) {
                        Point2D p1 = points.get(0);
                        p2 = points.get(1);
                        start = points.get(2);
                        end = points.get(3);
                        points.remove(p1);
                        points.remove(p2);
                        points.remove(start);
                        points.remove(end);
                        currentP = end;
                    }
                    continue block42;
                }
                case "wa": {
                    Point2D end;
                    Point2D start;
                    Point2D p2;
                    if (!this.canDraw(stroke, shape, currentP)) continue block42;
                    List<Point2D> points = pop.getPoints();
                    while (!points.isEmpty()) {
                        Point2D p1 = points.get(0);
                        p2 = points.get(1);
                        start = points.get(2);
                        end = points.get(3);
                        points.remove(p1);
                        points.remove(p2);
                        points.remove(start);
                        points.remove(end);
                        currentP = end;
                    }
                    continue block42;
                }
                case "wr": {
                    Point2D end;
                    Point2D start;
                    Point2D p2;
                    if (!this.canDraw(stroke, shape, currentP)) continue block42;
                    List<Point2D> points = pop.getPoints();
                    while (!points.isEmpty()) {
                        Point2D p1 = points.get(0);
                        p2 = points.get(1);
                        start = points.get(2);
                        end = points.get(3);
                        points.remove(p1);
                        points.remove(p2);
                        points.remove(start);
                        points.remove(end);
                        currentP = end;
                    }
                    continue block42;
                }
                case "qx": {
                    Point2D.Double middleP;
                    Point2D endP;
                    Point2D startP;
                    if (!this.canDraw(stroke, shape, currentP)) continue block42;
                    List<Point2D> points = pop.getPoints();
                    int count = 0;
                    while (!points.isEmpty()) {
                        startP = shape.getCurrentPoint();
                        endP = points.get(0);
                        points.remove(endP);
                        middleP = count % 2 == 0 ? new Point2D.Double(endP.getX(), startP.getY()) : new Point2D.Double(startP.getX(), endP.getY());
                        shape.curveTo(startP.getX(), startP.getY(), ((Point2D)middleP).getX(), ((Point2D)middleP).getY(), endP.getX(), endP.getY());
                        currentP = endP;
                        ++count;
                    }
                    continue block42;
                }
                case "qy": {
                    Point2D.Double middleP;
                    Point2D endP;
                    Point2D startP;
                    if (!this.canDraw(stroke, shape, currentP)) continue block42;
                    List<Point2D> points = pop.getPoints();
                    int count = 0;
                    while (!points.isEmpty()) {
                        startP = shape.getCurrentPoint();
                        endP = points.get(0);
                        points.remove(endP);
                        middleP = count % 2 == 0 ? new Point2D.Double(startP.getX(), endP.getY()) : new Point2D.Double(endP.getX(), startP.getY());
                        shape.curveTo(startP.getX(), startP.getY(), ((Point2D)middleP).getX(), ((Point2D)middleP).getY(), endP.getX(), endP.getY());
                        currentP = endP;
                        ++count;
                    }
                    continue block42;
                }
                case "qb": {
                    Point2D endP;
                    Point2D startP;
                    if (!this.canDraw(stroke, shape, currentP)) continue block42;
                    List<Point2D> points = pop.getPoints();
                    while (!points.isEmpty()) {
                        startP = shape.getCurrentPoint();
                        endP = pop.getPoints().get(0);
                        points.remove(endP);
                        currentP = endP;
                    }
                    continue block42;
                }
                case "nf": {
                    break;
                }
                case "ns": {
                    stroke = false;
                    break;
                }
                case "e": {
                    stroke = true;
                    break;
                }
                case "x": {
                    shape.closePath();
                    break;
                }
                default: {
                    Util.LOGGER.error((Object)("Unhandled path operation " + pop.command));
                }
            }
        }
        return shape;
    }

    private boolean canDraw(boolean stroke, Path2D.Double shape, Point2D origin) {
        if (stroke) {
            if (shape.getCurrentPoint() == null) {
                shape.moveTo(origin.getX(), origin.getY());
            }
            return true;
        }
        return false;
    }

    private double getValue(String param) {
        if ((param = param.trim()).isEmpty()) {
            return 0.0;
        }
        if (param.charAt(0) == '@') {
            int formulaIndex = Integer.parseInt(param.substring(1));
            Formula formula = this.equations.get(formulaIndex);
            return formula.getResult();
        }
        if (param.charAt(0) == '#') {
            int adjustIndex = Integer.parseInt(param.substring(1));
            return this.adjustValues[adjustIndex];
        }
        if (param.equals("height")) {
            return this.coordinates[1];
        }
        if (param.equals("width")) {
            return this.coordinates[0];
        }
        return Integer.parseInt(param);
    }

    private class Formula {
        private String equation;
        private String[] parts;

        private Formula(String equation) {
            this.equation = equation;
            this.parts = equation.split(" ");
        }

        private double getResult() {
            switch (this.parts[0]) {
                case "val": {
                    return VmlShapeConverter.this.getValue(this.parts[1]);
                }
                case "sum": {
                    return VmlShapeConverter.this.getValue(this.parts[1]) + VmlShapeConverter.this.getValue(this.parts[2]) - VmlShapeConverter.this.getValue(this.parts[3]);
                }
                case "product": {
                    return VmlShapeConverter.this.getValue(this.parts[1]) * VmlShapeConverter.this.getValue(this.parts[2]) / VmlShapeConverter.this.getValue(this.parts[3]);
                }
                case "mid": {
                    return (VmlShapeConverter.this.getValue(this.parts[1]) + VmlShapeConverter.this.getValue(this.parts[2])) / 2.0;
                }
                case "abs": {
                    return Math.abs(VmlShapeConverter.this.getValue(this.parts[1]));
                }
                case "min": {
                    return Math.min(VmlShapeConverter.this.getValue(this.parts[1]), VmlShapeConverter.this.getValue(this.parts[2]));
                }
                case "max": {
                    return Math.max(VmlShapeConverter.this.getValue(this.parts[1]), VmlShapeConverter.this.getValue(this.parts[2]));
                }
                case "if": {
                    return VmlShapeConverter.this.getValue(this.parts[1]) > 0.0 ? VmlShapeConverter.this.getValue(this.parts[2]) : VmlShapeConverter.this.getValue(this.parts[3]);
                }
            }
            Util.LOGGER.error((Object)("Unhandled path function " + this.parts[0]));
            return 0.0;
        }
    }

    private class PathOperation {
        private String command;
        private String[] params;

        private PathOperation(String chunk) {
            for (String aCommand : COMMANDS) {
                if (!chunk.startsWith(aCommand)) continue;
                this.command = aCommand;
                break;
            }
            this.params = this.splitParams(chunk.substring(this.command.length()));
        }

        private List<Point2D> getPoints() {
            return this.getPoints(false);
        }

        private List<Point2D> getPoints(boolean isRelative) {
            ArrayList<Point2D> points = new ArrayList<Point2D>();
            for (int i = 0; i < this.params.length; i += 2) {
                double param2;
                double param1;
                if (VmlShapeConverter.this.tempParam != null && i == 0) {
                    param1 = VmlShapeConverter.this.tempParam;
                    param2 = VmlShapeConverter.this.getValue(this.params[i]);
                    --i;
                    VmlShapeConverter.this.tempParam = null;
                } else if (i + 1 < this.params.length) {
                    param1 = VmlShapeConverter.this.getValue(this.params[i]);
                    param2 = VmlShapeConverter.this.getValue(this.params[i + 1]);
                } else {
                    VmlShapeConverter.this.tempParam = new Double(VmlShapeConverter.this.getValue(this.params[i]));
                    continue;
                }
                if (isRelative) {
                    points.add(new Point2D.Double((param1 - VmlShapeConverter.this.getCoordinateOrigin().getX()) / (double)VmlShapeConverter.this.coordinates[0] + VmlShapeConverter.this.getCoordinateOrigin().getX() / (double)VmlShapeConverter.this.coordinates[0], (param2 - VmlShapeConverter.this.getCoordinateOrigin().getY()) / (double)VmlShapeConverter.this.coordinates[1] + VmlShapeConverter.this.getCoordinateOrigin().getY() / (double)VmlShapeConverter.this.coordinates[1]));
                    continue;
                }
                points.add(new Point2D.Double((param1 - VmlShapeConverter.this.getCoordinateOrigin().getX()) / (double)VmlShapeConverter.this.coordinates[0], (param2 - VmlShapeConverter.this.getCoordinateOrigin().getY()) / (double)VmlShapeConverter.this.coordinates[1]));
            }
            if (points.isEmpty()) {
                points.add(new Point2D.Double(0.0, 0.0));
            }
            return points;
        }

        private String[] splitParams(String params) {
            if (params.length() > 0) {
                StringBuilder buf = new StringBuilder();
                for (int i = 0; i < params.length(); ++i) {
                    if (params.charAt(i) == ',' && (i == 0 || params.charAt(i - 1) == ',')) {
                        buf.append('0');
                    }
                    if (params.charAt(i) == '@' && i > 0 && params.charAt(i - 1) >= '0' && params.charAt(i - 1) <= '9') {
                        buf.append(',');
                    }
                    buf.append(params.charAt(i));
                    if (params.charAt(i) != ',' || i != params.length() - 1) continue;
                    buf.append('0');
                }
                return buf.toString().split(",");
            }
            return new String[0];
        }
    }
}

