/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.view.drawing;

import com.inet.docx.document.DocumentProperties;
import com.inet.docx.document.elements.DocumentElement;
import com.inet.docx.document.elements.style.RenderFont;
import com.inet.docx.document.elements.subelements.TextRowElement;
import com.inet.docx.document.elements.subelements.drawing.DrawingContent;
import com.inet.docx.document.elements.subelements.drawing.TextBoxShape;
import com.inet.docx.document.paragraph.ParagraphData;
import com.inet.docx.document.utilities.ParseOperations;
import com.inet.docx.document.utilities.UnitNumber;
import com.inet.docx.document.utilities.Util;
import com.inet.docx.view.drawing.DrawingFactory;
import com.inet.docx.view.drawing.DrawingReflection;
import com.inet.docx.view.drawing.SimpleShape;
import com.inet.docx.view.drawing.VmlFill;
import com.inet.docx.view.drawing.VmlShapeConverter;
import com.microsoft.schemas.office.office.STHrAlign;
import com.microsoft.schemas.vml.CTArc;
import com.microsoft.schemas.vml.CTCurve;
import com.microsoft.schemas.vml.CTFill;
import com.microsoft.schemas.vml.CTGroup;
import com.microsoft.schemas.vml.CTImage;
import com.microsoft.schemas.vml.CTImageData;
import com.microsoft.schemas.vml.CTLine;
import com.microsoft.schemas.vml.CTOval;
import com.microsoft.schemas.vml.CTPolyLine;
import com.microsoft.schemas.vml.CTRect;
import com.microsoft.schemas.vml.CTRoundRect;
import com.microsoft.schemas.vml.CTShape;
import com.microsoft.schemas.vml.CTShapetype;
import com.microsoft.schemas.vml.CTStroke;
import com.microsoft.schemas.vml.CTTextPath;
import com.microsoft.schemas.vml.CTTextbox;
import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.officeDocument.x2006.sharedTypes.STTrueFalse;

public class VmlObject {
    private final TYPE type;
    private String id;
    private String style;
    private String coordSize;
    private String coordOrigin;
    private String fillColor;
    private String strokeColor;
    private String strokeWidth;
    private List<CTFill> fillList = new ArrayList<CTFill>();
    private List<CTStroke> strokeList = new ArrayList<CTStroke>();
    private List<CTImageData> imageList = new ArrayList<CTImageData>();
    private List<CTTextPath> textPathList = new ArrayList<CTTextPath>();
    private CTShape shape;
    private CTShapetype shapetype;
    private CTArc arc;
    private CTCurve curve;
    private CTRect rect;
    private CTOval oval;
    private CTRoundRect roundrect;
    private CTGroup group;
    private CTLine line;
    private CTPolyLine polyline;
    private CTImage image;

    private VmlObject(TYPE type, String id, @Nullable String style, @Nullable String coordSize, @Nullable String coordOrigin, @Nullable String fillColor, @Nullable String strokeColor, @Nullable String strokeWidth, @Nullable List<CTFill> fillList, @Nullable List<CTStroke> strokeList, @Nullable List<CTImageData> imageList, @Nullable List<CTTextPath> textPathList) {
        this.type = type;
        this.id = id;
        this.style = style;
        this.coordSize = coordSize == null ? "1000,1000" : coordSize;
        this.coordOrigin = coordOrigin == null ? "0,0" : coordOrigin;
        this.fillColor = fillColor;
        this.strokeColor = strokeColor;
        this.strokeWidth = strokeWidth;
        this.fillList = fillList;
        this.strokeList = strokeList;
        this.imageList = imageList;
        this.textPathList = textPathList;
    }

    public VmlObject(CTShape rawObject) {
        this(TYPE.SHAPE, rawObject.getId(), rawObject.getStyle(), rawObject.getCoordsize(), rawObject.getCoordorigin(), rawObject.getFillcolor(), rawObject.getStrokecolor(), rawObject.getStrokeweight(), rawObject.getFillList(), rawObject.getStrokeList(), rawObject.getImagedataList(), rawObject.getTextpathList());
        this.shape = rawObject;
    }

    public VmlObject(CTShapetype rawObject) {
        this(TYPE.SHAPETYPE, rawObject.getId(), rawObject.getStyle(), rawObject.getCoordsize(), rawObject.getCoordorigin(), rawObject.getFillcolor(), rawObject.getStrokecolor(), rawObject.getStrokeweight(), rawObject.getFillList(), rawObject.getStrokeList(), rawObject.getImagedataList(), rawObject.getTextpathList());
        this.shapetype = rawObject;
    }

    public VmlObject(CTRect rawObject) {
        this(TYPE.RECT, rawObject.getId(), rawObject.getStyle(), rawObject.getCoordsize(), rawObject.getCoordorigin(), rawObject.getFillcolor(), rawObject.getStrokecolor(), rawObject.getStrokeweight(), rawObject.getFillList(), rawObject.getStrokeList(), rawObject.getImagedataList(), rawObject.getTextpathList());
        this.rect = rawObject;
    }

    public VmlObject(CTOval rawObject) {
        this(TYPE.OVAL, rawObject.getId(), rawObject.getStyle(), rawObject.getCoordsize(), rawObject.getCoordorigin(), rawObject.getFillcolor(), rawObject.getStrokecolor(), rawObject.getStrokeweight(), rawObject.getFillList(), rawObject.getStrokeList(), rawObject.getImagedataList(), rawObject.getTextpathList());
        this.oval = rawObject;
    }

    public VmlObject(CTRoundRect rawObject) {
        this(TYPE.ROUNDRECT, rawObject.getId(), rawObject.getStyle(), rawObject.getCoordsize(), rawObject.getCoordorigin(), rawObject.getFillcolor(), rawObject.getStrokecolor(), rawObject.getStrokeweight(), rawObject.getFillList(), rawObject.getStrokeList(), rawObject.getImagedataList(), rawObject.getTextpathList());
        this.roundrect = rawObject;
    }

    public VmlObject(CTLine rawObject) {
        this(TYPE.LINE, rawObject.getId(), rawObject.getStyle(), rawObject.getCoordsize(), rawObject.getCoordorigin(), rawObject.getFillcolor(), rawObject.getStrokecolor(), rawObject.getStrokeweight(), rawObject.getFillList(), rawObject.getStrokeList(), rawObject.getImagedataList(), rawObject.getTextpathList());
        this.line = rawObject;
    }

    public VmlObject(CTPolyLine rawObject) {
        this(TYPE.POLYLINE, rawObject.getId(), rawObject.getStyle(), rawObject.getCoordsize(), rawObject.getCoordorigin(), rawObject.getFillcolor(), rawObject.getStrokecolor(), rawObject.getStrokeweight(), rawObject.getFillList(), rawObject.getStrokeList(), rawObject.getImagedataList(), rawObject.getTextpathList());
        this.polyline = rawObject;
    }

    public VmlObject(CTImage rawObject) {
        this(TYPE.IMAGE, rawObject.getId(), rawObject.getStyle(), rawObject.getCoordsize(), rawObject.getCoordorigin(), rawObject.getFillcolor(), rawObject.getStrokecolor(), rawObject.getStrokeweight(), rawObject.getFillList(), rawObject.getStrokeList(), rawObject.getImagedataList(), rawObject.getTextpathList());
        this.image = rawObject;
    }

    public VmlObject(CTArc rawObject) {
        this(TYPE.ARC, rawObject.getId(), rawObject.getStyle(), rawObject.getCoordsize(), rawObject.getCoordorigin(), rawObject.getFillcolor(), rawObject.getStrokecolor(), rawObject.getStrokeweight(), rawObject.getFillList(), rawObject.getStrokeList(), rawObject.getImagedataList(), rawObject.getTextpathList());
        this.arc = rawObject;
    }

    public VmlObject(CTCurve rawObject) {
        this(TYPE.CURVE, rawObject.getId(), rawObject.getStyle(), rawObject.getCoordsize(), rawObject.getCoordorigin(), rawObject.getFillcolor(), rawObject.getStrokecolor(), rawObject.getStrokeweight(), rawObject.getFillList(), rawObject.getStrokeList(), rawObject.getImagedataList(), rawObject.getTextpathList());
        this.curve = rawObject;
    }

    public VmlObject(CTGroup rawObject) {
        this(TYPE.GROUP, rawObject.getId(), rawObject.getStyle(), rawObject.getCoordsize(), rawObject.getCoordorigin(), rawObject.getFillcolor(), null, null, rawObject.getFillList(), rawObject.getStrokeList(), rawObject.getImagedataList(), rawObject.getTextpathList());
        this.group = rawObject;
    }

    @SuppressFBWarnings(value={"UNSAFE_HASH_EQUALS"}, justification="simple string check, no secure hash check")
    public void createVmlObject(DrawingContent dc, IBody part, DocumentProperties docProps, DrawingContent groupContent) {
        DrawingFactory.handleShapeStyle(this.style, docProps, dc, this.coordSize, this.coordOrigin);
        if ((this.style == null || this.style.isEmpty()) && groupContent != null) {
            dc = groupContent;
            groupContent = null;
        }
        double width = dc.getWidth().getValue();
        double height = dc.getHeight().getValue();
        double shiftX = width / dc.getCoordinateSize().getX() * -1.0 * dc.getCoordinateOrigin().getX() + dc.getLeft();
        double shiftY = height / dc.getCoordinateSize().getX() * -1.0 * dc.getCoordinateOrigin().getX() + dc.getTop();
        if (groupContent != null) {
            width = groupContent.getWidth().getValue();
            height = groupContent.getHeight().getValue();
            shiftX = width / groupContent.getCoordinateSize().getX() * -1.0 * groupContent.getCoordinateOrigin().getX() + groupContent.getLeft();
            shiftY = height / groupContent.getCoordinateSize().getX() * -1.0 * groupContent.getCoordinateOrigin().getX() + groupContent.getTop();
        }
        Rectangle2D.Double bounds = new Rectangle2D.Double(shiftX, shiftY, width, height);
        SimpleShape shape = null;
        boolean handImageData = DrawingFactory.handleImageData(this.imageList, dc, this.id);
        if (handImageData) {
            return;
        }
        int elementCount = 0;
        for (CTTextPath tp : this.textPathList) {
            SimpleShape simShape = new SimpleShape(SimpleShape.ShapeType.rect.name(), new Rectangle2D.Double(0.0, 0.0, width, height), dc.getRotation(), 1.0, 1.0, dc.getReflection());
            Map<String, String> textInfos = DrawingFactory.getStyleInformation(tp.getStyle(), docProps.getSettings().getListSeparator());
            String text = tp.getString();
            if (text == null || text.isEmpty()) continue;
            ParagraphData pd = new ParagraphData();
            pd.setSpacing(docProps.getDefaultSpacing());
            Color color = DrawingFactory.getFillColor(this.fillColor, this.fillList);
            RenderFont rf = DrawingFactory.getWatermarkRenderFont(text, docProps, textInfos, (float)simShape.getHeight(), (float)simShape.getWidth());
            TextRowElement tre = new TextRowElement(text, rf, color, null);
            pd.addElement(tre);
            ArrayList<DocumentElement> sourceModel = new ArrayList<DocumentElement>();
            sourceModel.add(pd);
            shape = new TextBoxShape(simShape, sourceModel);
            ++elementCount;
        }
        switch (this.type) {
            case SHAPETYPE: {
                dc.addShapeType("#" + this.id, new VmlShapeConverter(this.shapetype.getPath2(), this.coordSize, this.coordOrigin, this.shapetype.getAdj(), this.shapetype.getFormulasList()));
                break;
            }
            case SHAPE: {
                SimpleShape simpleShape = VmlShapeConverter.createShape(this.shape, dc, docProps, groupContent);
                if (simpleShape != null) {
                    shape = simpleShape;
                    ++elementCount;
                    dc.getContent().remove(dc.getContent().size() - 1);
                }
                if (elementCount == 0) {
                    double xOff = dc.getLeft();
                    double yOff = dc.getTop();
                    String type = this.shape.getType();
                    VmlShapeConverter vml = type != null ? dc.getShapeType(type) : null;
                    Path2D.Double multiL = null;
                    if (vml != null) {
                        xOff = dc.getLeft() - vml.getCoordinateOrigin().getX();
                        yOff = dc.getTop() - vml.getCoordinateOrigin().getY();
                        multiL = vml.getShape();
                    }
                    shape = new SimpleShape(SimpleShape.ShapeType.rect.name(), new Rectangle2D.Double(xOff, yOff, width, height), dc.getRotation(), 1.0, 1.0, dc.getReflection());
                    if (multiL != null) {
                        shape.addMultiLine(multiL);
                    }
                }
                shape.setVML(true);
                break;
            }
            case GROUP: {
                DrawingContent innerDc = DrawingFactory.handleDrawing((XmlObject)this.group, part, docProps, groupContent == null ? dc : groupContent);
                dc.getContent().addAll(innerDc.getContent());
                break;
            }
            case RECT: {
                shape = new SimpleShape(SimpleShape.ShapeType.rect.name(), bounds, 0.0, 1.0, 1.0, DrawingReflection.NONE);
                if (handImageData && STTrueFalse.T.equals(this.rect.getHr()) && STTrueFalse.T.equals(this.rect.getHrstd())) {
                    STHrAlign.Enum align = this.rect.getHralign();
                    if (align == null || "left".equals(align.toString())) break;
                    dc.setHorizontalAnchor(DrawingFactory.getAnchor(align.toString(), "margin", null, false, false));
                    break;
                }
                List tbl = this.rect.getTextboxList();
                if (tbl.size() > 0) {
                    dc.addElement(DrawingFactory.handleTextboxData((CTTextbox)tbl.get(0), shape, docProps, Color.BLACK, part));
                    break;
                }
                Util.LOGGER.info((Object)("Rect not implemented: " + String.valueOf(this.rect)));
                break;
            }
            case ROUNDRECT: {
                shape = new SimpleShape(SimpleShape.ShapeType.roundRect.name(), bounds, 0.0, 1.0, 1.0, DrawingReflection.NONE);
                break;
            }
            case OVAL: {
                shape = new SimpleShape(SimpleShape.ShapeType.ellipse.name(), bounds, 0.0, 1.0, 1.0, DrawingReflection.NONE);
                break;
            }
            case ARC: {
                double halfwidth = ((RectangularShape)bounds).getWidth() / 2.0;
                double halfheight = ((RectangularShape)bounds).getHeight() / 2.0;
                bounds = new Rectangle2D.Double(((RectangularShape)bounds).getX() + halfwidth, ((RectangularShape)bounds).getY() + halfheight, halfwidth, halfheight);
                shape = new SimpleShape(SimpleShape.ShapeType.ellipse.name(), bounds, 0.0, 1.0, 1.0, DrawingReflection.NONE);
                break;
            }
            case IMAGE: {
                break;
            }
            case LINE: {
                shape = new SimpleShape(SimpleShape.ShapeType.line.name(), bounds, 0.0, 1.0, 1.0, DrawingReflection.NONE);
                break;
            }
            case POLYLINE: {
                shape = new SimpleShape(SimpleShape.ShapeType.multiline.name(), bounds, dc.getRotation(), 1.0, 1.0, dc.getReflection());
                String points = this.polyline.getPoints();
                Path2D.Double linePath = new Path2D.Double();
                String[] lines = points.split(" ");
                for (int i = 0; i < lines.length; ++i) {
                    String[] position = lines[i].split(",");
                    if (position.length == 2) {
                        UnitNumber x = new UnitNumber(position[0]);
                        UnitNumber y = new UnitNumber(position[1]);
                        if (i == 0) {
                            linePath.moveTo(x.getAsTwips() / width, y.getAsTwips() / height);
                            continue;
                        }
                        linePath.lineTo(x.getAsTwips() / width, y.getAsTwips() / height);
                        continue;
                    }
                    Util.LOGGER.error((Object)("Polyline coordinate can not recognition for value '" + points + "'"));
                }
                linePath.clone();
                shape.addMultiLine(linePath);
                break;
            }
            default: {
                shape = new SimpleShape(SimpleShape.ShapeType.rect.name(), bounds, 0.0, 1.0, 1.0, DrawingReflection.NONE);
            }
        }
        if (shape != null) {
            Paint fillPaint = null;
            CTFill ctFill = null;
            if (!this.fillList.isEmpty()) {
                ctFill = this.fillList.get(this.fillList.size() - 1);
            }
            if (ctFill != null) {
                fillPaint = VmlFill.getPaint(ctFill, shape.getShape().getBounds(), docProps, dc);
            }
            if (fillPaint == null) {
                fillPaint = DrawingFactory.getColor(this.fillColor, null);
            }
            Color bg = DrawingFactory.getColor(this.strokeColor, null);
            double borderLineWidth = this.strokeWidth != null ? ParseOperations.handleValues(this.strokeWidth) : 15.0;
            shape.getBasicStrokeData().setBorderLineWidth(borderLineWidth);
            shape.getBasicStrokeData().setBorderColor(DrawingFactory.getStrokeColor(this.strokeColor, this.strokeList, bg == null ? Color.BLACK : Color.WHITE));
            shape.setBgColor(fillPaint);
            dc.addElement(shape);
        }
    }

    public static enum TYPE {
        SHAPETYPE,
        SHAPE,
        GROUP,
        RECT,
        ROUNDRECT,
        OVAL,
        IMAGE,
        LINE,
        ARC,
        CURVE,
        POLYLINE;

    }
}

