/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.view.drawing;

import com.inet.cache.image.SerializableImage;
import com.inet.docx.document.DocumentProperties;
import com.inet.docx.document.elements.subelements.drawing.DrawingContent;
import com.inet.docx.document.utilities.ParseOperations;
import com.inet.docx.document.utilities.UnitNumber;
import com.inet.docx.document.utilities.Util;
import com.inet.docx.view.drawing.DrawingFactory;
import com.inet.docx.view.drawing.ImagePaint;
import com.microsoft.schemas.vml.CTFill;
import com.microsoft.schemas.vml.STFillMethod;
import com.microsoft.schemas.vml.STImageAspect;
import java.awt.Color;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.TexturePaint;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.math.BigDecimal;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openxmlformats.schemas.officeDocument.x2006.sharedTypes.STTrueFalse;

public class VmlFill {
    public static Paint getPaint(CTFill ctFill, Rectangle2D bounds, DocumentProperties docProps, DrawingContent dc) {
        if (ctFill != null) {
            try {
                double opa;
                String opacity;
                SerializableImage imageData = null;
                Type type = Type.solid;
                if (ctFill.isSetType()) {
                    type = Type.valueOf(ctFill.getType().toString().toLowerCase());
                }
                STTrueFalse.Enum alignshape = ctFill.getAlignshape();
                STImageAspect.Enum aspect = ctFill.getAspect();
                Color color = DrawingFactory.getColor(ctFill.getColor(), null);
                Color color2 = DrawingFactory.getColor(ctFill.getColor2(), null);
                IntermediateColor intermediateColor = null;
                if (ctFill.isSetColors()) {
                    intermediateColor = VmlFill.parseIntermediateColor(ctFill.getColors());
                }
                String src = ctFill.getSrc();
                String href = ctFill.getHref();
                String id1 = ctFill.getId();
                if (ctFill.isSetId2()) {
                    imageData = docProps.getImageData(ctFill.getId2() + "_" + docProps.getCurrentPartName());
                }
                STFillMethod.Enum method = ctFill.getMethod();
                if (ctFill.isSetOn() && (ctFill.getOn().intValue() == 1 || ctFill.getOn().intValue() == 3)) {
                    return new Color(0, 0, 0, 0);
                }
                if (ctFill.isSetOpacity() && color != null) {
                    opacity = ctFill.getOpacity();
                    opa = new UnitNumber(opacity).getAsTwips();
                    color = new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(255.0 * opa));
                }
                if (ctFill.isSetOpacity2() && color2 != null) {
                    opacity = ctFill.getOpacity2();
                    opa = new UnitNumber(opacity).getAsTwips();
                    color2 = new Color(color2.getRed(), color2.getGreen(), color2.getBlue(), (int)(255.0 * opa));
                }
                STTrueFalse.Enum recolor = ctFill.getRecolor();
                String relid = ctFill.getRelid();
                boolean rotate = false;
                if (ctFill.isSetRotate()) {
                    rotate = ctFill.getRotate().intValue() == 1 || ctFill.getRotate().intValue() == 3;
                }
                switch (type) {
                    case solid: {
                        return color;
                    }
                    case gradient: {
                        double focus = 0.0;
                        if (ctFill.isSetFocus()) {
                            focus = new UnitNumber(ctFill.getFocus()).getAsTwips();
                        }
                        BigDecimal angle = new BigDecimal(0);
                        if (ctFill.isSetAngle()) {
                            angle = ctFill.getAngle();
                        }
                        if (color == null || color2 == null) break;
                        IntermediateColor intermediateColors = VmlFill.calculateIntermediate(ctFill, intermediateColor, color, color2, focus);
                        Point2D[] point2DPair = VmlFill.calculatePosition(angle.doubleValue(), bounds);
                        Point2D start = point2DPair[1];
                        Point2D end = point2DPair[0];
                        return new LinearGradientPaint((float)start.getX(), (float)start.getY(), (float)end.getX(), (float)end.getY(), intermediateColors.getIntermediateFractions(), intermediateColors.getIntermediateColors());
                    }
                    case gradientradial: {
                        String focusposition = ctFill.getFocusposition();
                        String focussize = ctFill.getFocussize();
                        if (color == null || color2 == null) break;
                        return new RadialGradientPaint(0.0f, 0.0f, 0.0f, new float[]{0.0f, 0.5f, 1.0f}, new Color[]{color, color2});
                    }
                    case tile: {
                        if (imageData != null) {
                            bounds = VmlFill.calculateImageBounds(ctFill, bounds, dc, imageData);
                            return new TexturePaint(imageData.getBufferedImage(), bounds);
                        }
                        Util.LOGGER.warn((Object)"VML Fill Type tile can not found the image.");
                        break;
                    }
                    case pattern: {
                        Util.LOGGER.warn((Object)"VML Fill Typ 'pattern' is not supported. A fallback variant will be use.");
                        break;
                    }
                    case frame: {
                        if (imageData != null) {
                            bounds = VmlFill.calculateImageBounds(ctFill, bounds, dc, imageData);
                            return new ImagePaint(imageData.getBufferedImage(), bounds);
                        }
                        Util.LOGGER.warn((Object)("VML Fill Type " + String.valueOf((Object)type) + " or pattern can not found the image."));
                    }
                }
            }
            catch (IllegalArgumentException ex) {
                Util.LOGGER.warn((Object)("The vml fill type is unknow for '" + String.valueOf(ctFill.getType()) + "'. Alternate color black will be used."));
            }
        }
        return Color.BLACK;
    }

    @Nonnull
    private static Rectangle2D calculateImageBounds(CTFill ctFill, Rectangle2D bounds, DrawingContent dc, @Nullable SerializableImage imageData) {
        double shiftY;
        Point2D.Double size = new Point2D.Double(dc.getWidth().getValue(), dc.getHeight().getValue());
        if (ctFill.isSetSize()) {
            String[] split = ctFill.getSize().split(",");
            if (split.length == 2) {
                size = new Point2D.Double(ParseOperations.handleValues(split[0]), ParseOperations.handleValues(split[1]));
            } else {
                Util.LOGGER.warn((Object)("VML position can not be read, the value was " + ctFill.getSize()));
            }
        } else if (imageData != null) {
            size = new Point2D.Double((double)imageData.getWidth() * 15.0, (double)imageData.getHeight() * 15.0);
        }
        Point2D.Double origin = new Point2D.Double(0.0, 0.0);
        if (ctFill.isSetOrigin()) {
            String[] split = ctFill.getOrigin().split(",");
            if (split.length == 2) {
                origin = new Point2D.Double(ParseOperations.handleValues(split[0]), ParseOperations.handleValues(split[1]));
            } else {
                Util.LOGGER.warn((Object)("VML origin can not be read, the value was " + ctFill.getOrigin()));
            }
        }
        Point2D.Double position = new Point2D.Double(0.0, 0.0);
        if (ctFill.isSetPosition()) {
            String[] split = ctFill.getPosition().split(",");
            if (split.length == 2) {
                position = new Point2D.Double(ParseOperations.handleValues(split[0]), ParseOperations.handleValues(split[1]));
            } else {
                Util.LOGGER.warn((Object)("VML position can not be read, the value was " + ctFill.getPosition()));
            }
        }
        if (((Point2D)position).getX() != 0.0 || ((Point2D)position).getY() != 0.0) {
            double shiftX = ((Point2D)position).getX() * bounds.getWidth();
            shiftY = ((Point2D)position).getY() * bounds.getHeight();
            bounds = new Rectangle2D.Double(bounds.getX() + shiftX, bounds.getY() + shiftY, bounds.getWidth(), bounds.getHeight());
        }
        if (dc.getWidth().getValue() != ((Point2D)size).getX() || dc.getHeight().getValue() != ((Point2D)size).getY()) {
            double scaleX = ((Point2D)size).getX() / dc.getWidth().getValue();
            double scaleY = ((Point2D)size).getY() / dc.getHeight().getValue();
            bounds = new Rectangle2D.Double(bounds.getX(), bounds.getY(), bounds.getWidth() * scaleX, bounds.getHeight() * scaleY);
        }
        if (((Point2D)origin).getX() != 0.0 || ((Point2D)origin).getY() != 0.0) {
            double shiftX = ((Point2D)origin).getX() * bounds.getWidth();
            shiftY = ((Point2D)origin).getY() * bounds.getHeight();
            bounds = new Rectangle2D.Double(bounds.getX() - shiftX, bounds.getY() - shiftY, bounds.getWidth(), bounds.getHeight());
        }
        return bounds;
    }

    @Nonnull
    private static IntermediateColor calculateIntermediate(CTFill ctFill, @Nullable IntermediateColor intermediateColor, Color color, Color color2, double focus) {
        Color[] colors;
        float[] fractions;
        if (intermediateColor == null) {
            if (ctFill.isSetFocus() && Math.abs(focus) < 1.0) {
                Color[] colorArray;
                fractions = new float[]{0.0f, (float)Math.abs(focus), 1.0f};
                if (focus > 0.0) {
                    Color[] colorArray2 = new Color[3];
                    colorArray2[0] = color;
                    colorArray2[1] = color2;
                    colorArray = colorArray2;
                    colorArray2[2] = color;
                } else {
                    Color[] colorArray3 = new Color[3];
                    colorArray3[0] = color2;
                    colorArray3[1] = color;
                    colorArray = colorArray3;
                    colorArray3[2] = color2;
                }
                colors = colorArray;
            } else {
                Color[] colorArray;
                fractions = new float[]{0.0f, 1.0f};
                if (Math.abs(focus) <= 1.0) {
                    Color[] colorArray4 = new Color[2];
                    colorArray4[0] = color;
                    colorArray = colorArray4;
                    colorArray4[1] = color2;
                } else {
                    Color[] colorArray5 = new Color[2];
                    colorArray5[0] = color2;
                    colorArray = colorArray5;
                    colorArray5[1] = color;
                }
                colors = colorArray;
            }
        } else if (ctFill.isSetFocus()) {
            fractions = new float[3 + intermediateColor.getIntermediateFractions().length * 2];
            colors = new Color[3 + intermediateColor.getIntermediateColors().length * 2];
            fractions[0] = 0.0f;
            fractions[intermediateColor.getIntermediateColors().length + 1] = (float)Math.abs(focus);
            fractions[fractions.length - 1] = 1.0f;
            if (focus > 0.0) {
                colors[0] = color;
                colors[intermediateColor.getIntermediateColors().length + 1] = color2;
                colors[colors.length - 1] = color;
                for (int i = 0; i < intermediateColor.getIntermediateColors().length; ++i) {
                    fractions[i + 1] = (float)((double)intermediateColor.getIntermediateFractions()[i] * focus);
                    colors[i + 1] = intermediateColor.getIntermediateColors()[i];
                    fractions[fractions.length - i - 2] = (float)((double)intermediateColor.getIntermediateFractions()[intermediateColor.getIntermediateColors().length - i - 1] * focus + focus);
                    colors[colors.length - i - 2] = intermediateColor.getIntermediateColors()[i];
                }
            } else {
                colors[0] = color2;
                colors[intermediateColor.getIntermediateColors().length + 1] = color;
                colors[colors.length - 1] = color2;
                for (int i = 0; i < intermediateColor.getIntermediateColors().length; ++i) {
                    fractions[i + 1] = (float)Math.abs((double)intermediateColor.getIntermediateFractions()[i] * focus);
                    colors[i + 1] = intermediateColor.getIntermediateColors()[intermediateColor.getIntermediateColors().length - i - 1];
                    fractions[fractions.length - i - 2] = (float)Math.abs((double)intermediateColor.getIntermediateFractions()[intermediateColor.getIntermediateColors().length - i - 1] * focus + focus);
                    colors[colors.length - i - 2] = intermediateColor.getIntermediateColors()[intermediateColor.getIntermediateColors().length - i - 1];
                }
            }
        } else {
            int i;
            ArrayList<Float> fractionList = new ArrayList<Float>();
            ArrayList<Color> colorList = new ArrayList<Color>();
            fractionList.add(Float.valueOf(0.0f));
            for (i = 0; i < intermediateColor.getIntermediateColors().length; ++i) {
                float fraction = intermediateColor.getIntermediateFractions()[i];
                Color fractionColor = intermediateColor.getIntermediateColors()[i];
                if (fraction < 1.0f && colorList.isEmpty()) {
                    colorList.add(fraction <= 0.0f ? color2 : color);
                }
                colorList.add(fractionColor);
                if (fraction > 0.0f && fraction < 1.0f) {
                    fractionList.add(Float.valueOf(fraction));
                }
                if (!(fraction >= 1.0f)) continue;
                colorList.add(color);
            }
            fractionList.add(Float.valueOf(1.0f));
            colorList.add(color2);
            fractions = new float[fractionList.size()];
            colors = new Color[fractionList.size()];
            for (i = 0; i < fractions.length; ++i) {
                fractions[i] = ((Float)fractionList.get(i)).floatValue();
                colors[i] = (Color)colorList.get(i);
            }
        }
        return new IntermediateColor(colors, VmlFill.checkFraction(fractions));
    }

    @Nonnull
    private static Point2D[] calculatePosition(double degree, Rectangle2D bounds) {
        Point2D.Double endPoint;
        Point2D.Double start;
        double ration;
        Point2D[] points = new Point2D[2];
        while (degree < 0.0) {
            degree += 360.0;
        }
        double d = ration = (degree %= 360.0) % 45.0 == 0.0 ? 0.0 : degree % 45.0 / 45.0;
        if (degree == 0.0) {
            start = new Point2D.Double(bounds.getMinX(), bounds.getMinY());
            endPoint = new Point2D.Double(bounds.getMinX(), bounds.getMaxY());
        } else if (degree <= 90.0) {
            start = new Point2D.Double(bounds.getMinX(), bounds.getMinY());
            endPoint = degree < 45.0 ? new Point2D.Double(bounds.getMinX() + Math.abs(bounds.getWidth() * ration), bounds.getMaxY()) : (degree == 45.0 ? new Point2D.Double(bounds.getMaxX(), bounds.getMaxY()) : new Point2D.Double(bounds.getMaxX(), bounds.getMinY() + Math.abs(bounds.getWidth() * ration)));
        } else if (degree <= 180.0) {
            start = new Point2D.Double(bounds.getMinX(), bounds.getMaxY());
            endPoint = degree < 135.0 ? new Point2D.Double(bounds.getMaxX(), bounds.getMaxY() - Math.abs(bounds.getWidth() * ration)) : (degree == 135.0 ? new Point2D.Double(bounds.getMaxX(), bounds.getMinY()) : new Point2D.Double(bounds.getMinX() + Math.abs(bounds.getWidth() * ration), bounds.getMinY()));
        } else if (degree <= 270.0) {
            start = new Point2D.Double(bounds.getMaxX(), bounds.getMaxY());
            endPoint = degree < 225.0 ? new Point2D.Double(bounds.getMaxX() - Math.abs(bounds.getWidth() * ration), bounds.getMinY()) : (degree == 225.0 ? new Point2D.Double(bounds.getMinX(), bounds.getMinY()) : new Point2D.Double(bounds.getMinX(), bounds.getMaxY() - Math.abs(bounds.getWidth() * ration)));
        } else {
            start = new Point2D.Double(bounds.getMaxX(), bounds.getMinY());
            endPoint = degree < 315.0 ? new Point2D.Double(bounds.getMinX(), bounds.getMinY() + Math.abs(bounds.getWidth() * ration)) : (degree == 315.0 ? new Point2D.Double(bounds.getMinX(), bounds.getMaxY()) : new Point2D.Double(bounds.getMaxX() - Math.abs(bounds.getWidth() * ration), bounds.getMaxY()));
        }
        points[0] = start;
        points[1] = endPoint;
        return points;
    }

    @Nullable
    private static IntermediateColor parseIntermediateColor(@Nonnull String rawText) {
        String[] splitted = rawText.split(",");
        float[] intermediateFractions = new float[splitted.length];
        Color[] intermediateColors = new Color[splitted.length];
        for (int i = 0; i < splitted.length; ++i) {
            String[] rawColorDatas = splitted[i].split(" ");
            intermediateFractions[i] = (float)ParseOperations.handleValues(rawColorDatas[0]);
            intermediateColors[i] = DrawingFactory.getColor(rawColorDatas[1], null);
            if (intermediateColors[i] != null) continue;
            Util.LOGGER.warn((Object)("Color can not be parsed: " + splitted[i]));
            return null;
        }
        return splitted.length == 0 ? null : new IntermediateColor(intermediateColors, intermediateFractions);
    }

    private static float[] checkFraction(float[] intermediateFractions) {
        int i;
        float[] fixIntermediateFractions = new float[intermediateFractions.length];
        for (i = 0; i < fixIntermediateFractions.length; ++i) {
            float intermediateFraction = intermediateFractions[i];
            if (i != 0 && fixIntermediateFractions[i - 1] >= intermediateFraction) {
                intermediateFraction = fixIntermediateFractions[i - 1] + 1.0E-4f;
            }
            fixIntermediateFractions[i] = intermediateFraction;
        }
        if (fixIntermediateFractions[fixIntermediateFractions.length - 1] > 1.0f) {
            for (i = fixIntermediateFractions.length - 1; i > 0; --i) {
                if (i == fixIntermediateFractions.length - 1) {
                    fixIntermediateFractions[i] = 1.0f;
                    continue;
                }
                if (!(fixIntermediateFractions[i] > fixIntermediateFractions[i + 1])) break;
                fixIntermediateFractions[i] = fixIntermediateFractions[i + 1] - 1.0E-4f;
            }
        }
        return fixIntermediateFractions;
    }

    private static enum Type {
        solid,
        gradient,
        gradientradial,
        tile,
        pattern,
        frame;

    }

    private static class IntermediateColor {
        private final Color[] intermediateColors;
        private final float[] intermediateFractions;

        private IntermediateColor(Color[] intermediateColors, float[] intermediateFractions) {
            this.intermediateColors = intermediateColors;
            this.intermediateFractions = intermediateFractions;
        }

        public Color[] getIntermediateColors() {
            return this.intermediateColors;
        }

        public float[] getIntermediateFractions() {
            return this.intermediateFractions;
        }
    }
}

