/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.view.drawing;

import java.awt.Color;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class GradientData {
    private float angle;
    private boolean scale;
    ArrayList<GradientStopData> gratientStops = new ArrayList();

    public GradientData(float angle, boolean scale) {
        this.angle = angle;
        this.scale = scale;
    }

    public void addGradientStop(Color gradientStopCol, float gradientStopPercentagePosition) {
        this.gratientStops.add(new GradientStopData(gradientStopCol, gradientStopPercentagePosition));
    }

    public Paint createGradient(Rectangle2D rect) {
        Point2D.Double pt2;
        Point2D.Double pt1;
        if (this.angle == 0.0f) {
            double y = rect.getY() + rect.getHeight() / 2.0;
            pt1 = new Point2D.Double(rect.getX(), y);
            pt2 = new Point2D.Double(rect.getX() + rect.getWidth(), y);
        } else {
            double tanDiagonal = rect.getHeight() / rect.getWidth();
            double rad = Math.atan(tanDiagonal);
            double diagonalDegrees = Math.toDegrees(rad);
            if ((double)this.angle > diagonalDegrees && (double)this.angle < 180.0 - diagonalDegrees) {
                tan = Math.tan(Math.toRadians(90.0f - this.angle));
                deltaX = rect.getHeight() / 2.0 * tan;
                middle = rect.getX() + rect.getWidth() / 2.0;
                pt2 = new Point2D.Double(middle - deltaX, rect.getY() + rect.getHeight());
                pt1 = new Point2D.Double(middle + deltaX, rect.getY());
            } else if ((double)this.angle < 180.0 + diagonalDegrees) {
                tan = Math.tan(Math.toRadians(180.0f - this.angle));
                deltaY = rect.getWidth() / 2.0 * tan;
                middle = rect.getY() + rect.getHeight() / 2.0;
                pt1 = new Point2D.Double(rect.getX() + rect.getWidth(), middle + deltaY);
                pt2 = new Point2D.Double(rect.getX(), middle - deltaY);
            } else if ((double)this.angle < 360.0 - diagonalDegrees) {
                tan = Math.tan(Math.toRadians(270.0f - this.angle));
                deltaX = rect.getHeight() / 2.0 * tan;
                middle = rect.getX() + rect.getWidth() / 2.0;
                pt2 = new Point2D.Double(middle + deltaX, rect.getY());
                pt1 = new Point2D.Double(middle - deltaX, rect.getY() + rect.getHeight());
            } else {
                tan = Math.tan(Math.toRadians(this.angle));
                deltaY = rect.getWidth() / 2.0 * tan;
                middle = rect.getY() + rect.getHeight() / 2.0;
                pt1 = new Point2D.Double(rect.getX(), middle + deltaY);
                pt2 = new Point2D.Double(rect.getX() + rect.getWidth(), middle - deltaY);
            }
        }
        float[] fractions = new float[this.gratientStops.size()];
        Color[] colors = new Color[this.gratientStops.size()];
        for (int index = 0; index < this.gratientStops.size(); ++index) {
            GradientStopData stop = this.gratientStops.get(index);
            fractions[index] = stop.gradientStopPercentagePosition;
            colors[index] = stop.gradientStopCol;
        }
        return new LinearGradientPaint((float)((Point2D)pt1).getX(), (float)((Point2D)pt1).getY(), (float)((Point2D)pt2).getX(), (float)((Point2D)pt2).getY(), fractions, colors);
    }

    private class GradientStopData {
        private Color gradientStopCol;
        private float gradientStopPercentagePosition;

        private GradientStopData(Color gradientStopCol, float gradientStopPercentagePosition) {
            this.gradientStopCol = gradientStopCol;
            this.gradientStopPercentagePosition = gradientStopPercentagePosition;
        }
    }
}

