/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.view.drawing;

import com.inet.docx.document.DocumentProperties;
import com.inet.docx.document.RelationObject;
import com.inet.docx.document.elements.DocumentElement;
import com.inet.docx.document.elements.style.LineProperties;
import com.inet.docx.document.elements.style.LineStyle;
import com.inet.docx.document.elements.style.RenderFont;
import com.inet.docx.document.elements.style.RunRenderInformations;
import com.inet.docx.document.elements.style.ShapeBodyProperties;
import com.inet.docx.document.elements.style.Spacing;
import com.inet.docx.document.elements.style.TextFrame;
import com.inet.docx.document.elements.subelements.BorderLines;
import com.inet.docx.document.elements.subelements.Drawing;
import com.inet.docx.document.elements.subelements.ParagraphElement;
import com.inet.docx.document.elements.subelements.TablePanel;
import com.inet.docx.document.elements.subelements.TextRowElement;
import com.inet.docx.document.elements.subelements.drawing.Anchor;
import com.inet.docx.document.elements.subelements.drawing.DimensionDefinition;
import com.inet.docx.document.elements.subelements.drawing.DrawingContent;
import com.inet.docx.document.elements.subelements.drawing.SimpleLine;
import com.inet.docx.document.elements.subelements.drawing.TextBoxShape;
import com.inet.docx.document.elements.subelements.drawing.TextWrapping;
import com.inet.docx.document.excel.WorkbookAnalyzer;
import com.inet.docx.document.paragraph.ParagraphData;
import com.inet.docx.document.paragraph.ParagraphFactory;
import com.inet.docx.document.paragraph.StringLayouter;
import com.inet.docx.document.table.TableData;
import com.inet.docx.document.table.TableFactory;
import com.inet.docx.document.utilities.NameSpaceHandler;
import com.inet.docx.document.utilities.ParseOperations;
import com.inet.docx.document.utilities.UnitNumber;
import com.inet.docx.document.utilities.Util;
import com.inet.docx.view.AreaObjects;
import com.inet.docx.view.ObjectSizeAndPosition;
import com.inet.docx.view.drawing.BasicStrokeData;
import com.inet.docx.view.drawing.DrawingElement;
import com.inet.docx.view.drawing.DrawingReflection;
import com.inet.docx.view.drawing.GradientData;
import com.inet.docx.view.drawing.PictureElement;
import com.inet.docx.view.drawing.PictureFillData;
import com.inet.docx.view.drawing.ShapeGroup;
import com.inet.docx.view.drawing.SimpleShape;
import com.inet.docx.view.drawing.VmlObject;
import com.inet.docx.view.drawing.VmlShapeConverter;
import com.inet.docx.xwpf.usermodel.XWPFSDTimpl;
import com.microsoft.schemas.office.office.impl.CTOLEObjectImpl;
import com.microsoft.schemas.vml.CTArc;
import com.microsoft.schemas.vml.CTCurve;
import com.microsoft.schemas.vml.CTFill;
import com.microsoft.schemas.vml.CTGroup;
import com.microsoft.schemas.vml.CTImage;
import com.microsoft.schemas.vml.CTImageData;
import com.microsoft.schemas.vml.CTLine;
import com.microsoft.schemas.vml.CTOval;
import com.microsoft.schemas.vml.CTPolyLine;
import com.microsoft.schemas.vml.CTRect;
import com.microsoft.schemas.vml.CTRoundRect;
import com.microsoft.schemas.vml.CTShape;
import com.microsoft.schemas.vml.CTShapetype;
import com.microsoft.schemas.vml.CTStroke;
import com.microsoft.schemas.vml.CTTextbox;
import java.awt.Color;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;
import javax.xml.namespace.QName;
import org.apache.poi.ooxml.POIXMLTypeLoader;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.impl.values.XmlAnyTypeImpl;
import org.apache.xmlbeans.impl.values.XmlObjectBase;
import org.openxmlformats.schemas.drawingml.x2006.chart.impl.CTRelIdImpl;
import org.openxmlformats.schemas.drawingml.x2006.diagram.impl.CTRelIdsImpl;
import org.openxmlformats.schemas.drawingml.x2006.main.CTAdjPoint2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTBlipFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTCustomGeometry2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTFontReference;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGeomGuide;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGradientFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGradientStop;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGraphicalObjectData;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGroupShapeProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTLineEndProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTLineProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTLinearShadeProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPath2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPath2DArcTo;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPath2DCubicBezierTo;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPath2DList;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPath2DMoveTo;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPoint2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPositiveSize2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPresetGeometry2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPresetLineDashProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTRegularTextRun;
import org.openxmlformats.schemas.drawingml.x2006.main.CTShapeProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTShapeStyle;
import org.openxmlformats.schemas.drawingml.x2006.main.CTStyleMatrixReference;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextBody;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextBodyProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextParagraph;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextParagraphProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTileInfoProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTransform2D;
import org.openxmlformats.schemas.drawingml.x2006.main.STLineCap;
import org.openxmlformats.schemas.drawingml.x2006.main.STLineEndLength;
import org.openxmlformats.schemas.drawingml.x2006.main.STLineEndType;
import org.openxmlformats.schemas.drawingml.x2006.main.STLineEndWidth;
import org.openxmlformats.schemas.drawingml.x2006.main.impl.CTPath2DCloseImpl;
import org.openxmlformats.schemas.drawingml.x2006.main.impl.CTPath2DLineToImpl;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.CTAnchor;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.CTInline;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.CTPosH;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.CTPosV;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.CTWrapPath;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTControl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDrawing;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTObject;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPicture;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtBlock;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTxbxContent;

public class DrawingFactory {
    private static final QName RELATIVEFROM = new QName("", "relativeFrom");
    private static final QName PIC = new QName(NameSpaceHandler.getNamespaceURI("wp14"), "pic");
    private static final QName PCTWIDTH = new QName(NameSpaceHandler.getNamespaceURI("wp14"), "pctWidth");
    private static final QName PCTHEIGHT = new QName(NameSpaceHandler.getNamespaceURI("wp14"), "pctHeight");
    private static final QName PCTPOSVOFFSET = new QName(NameSpaceHandler.getNamespaceURI("wp14"), "pctPosVOffset");
    private static final QName PCTPOSHOFFSET = new QName(NameSpaceHandler.getNamespaceURI("wp14"), "pctPosHOffset");
    private static final String defaultListSeparator = ";";

    public static Drawing createDrawing(CTDrawing drawing, DocumentProperties documentProperties, IBody part, RenderFont renderFont) {
        XmlObject o;
        List inl = drawing.getInlineList();
        CTAnchor anchor = inl.size() == 0 ? (CTAnchor)drawing.getAnchorList().get(0) : null;
        CTPositiveSize2D ext = anchor != null ? anchor.getExtent() : ((CTInline)inl.get(0)).getExtent();
        DimensionDefinition widthValue = new DimensionDefinition(new UnitNumber(ext.getCx(), UnitNumber.Unit.EMU));
        DimensionDefinition heightValue = new DimensionDefinition(new UnitNumber(ext.getCy(), UnitNumber.Unit.EMU));
        Anchor verticalAnchor = null;
        Anchor horizontalAnchor = null;
        if (anchor != null) {
            XmlObject[] alternates;
            CTPoint2D point = anchor.getSimplePos();
            CTPosH ctPosH = DrawingFactory.readCTPosH(anchor);
            CTPosV ctPosV = DrawingFactory.readCTPosV(anchor);
            for (XmlObject alternate : alternates = NameSpaceHandler.examineNamespace("mc", "AlternateContent", (XmlObject)anchor)) {
                XmlObject[] choices;
                for (XmlObject choice : choices = NameSpaceHandler.examineNamespace("mc", "Choice", alternate)) {
                    String contentName = choice.getDomNode().getFirstChild().getNodeName();
                    try {
                        if ("wp:positionH".equals(contentName)) {
                            XmlObject[] horizontal = NameSpaceHandler.examineNamespace("wp", "positionH", choice);
                            ctPosH = (CTPosH)CTPosH.Factory.parse(horizontal[0].toString(), new XmlOptions(POIXMLTypeLoader.DEFAULT_XML_OPTIONS));
                            continue;
                        }
                        if ("wp:positionV".equals(contentName)) {
                            XmlObject[] vertical = NameSpaceHandler.examineNamespace("wp", "positionV", choice);
                            ctPosV = (CTPosV)CTPosV.Factory.parse(vertical[0].toString(), new XmlOptions(POIXMLTypeLoader.DEFAULT_XML_OPTIONS));
                            continue;
                        }
                        Util.LOGGER.error((Object)("Unhandled alternate choice: " + contentName));
                    }
                    catch (Exception ex) {
                        Util.LOGGER.error((Throwable)ex);
                    }
                }
            }
            if (point != null) {
                int x = (int)Util.convertEmuToTwips(Util.getLong(point.xgetX()));
                int y = (int)Util.convertEmuToTwips(Util.getLong(point.xgetY()));
                verticalAnchor = new Anchor(Anchor.Reference.page, Anchor.Align.top, (double)y, false, true);
                horizontalAnchor = new Anchor(Anchor.Reference.page, Anchor.Align.left, (double)x, false, false);
            }
            if (ctPosV != null) {
                verticalAnchor = DrawingFactory.handleVerticalSettings(ctPosV);
            }
            if (ctPosH != null) {
                horizontalAnchor = DrawingFactory.handleHorizontalSettings(ctPosH);
            }
            heightValue = DrawingFactory.checkForRelativeDimensions(anchor, false, heightValue);
            widthValue = DrawingFactory.checkForRelativeDimensions(anchor, true, widthValue);
        }
        Drawing drawingModel = new Drawing(widthValue, heightValue, renderFont, verticalAnchor, horizontalAnchor);
        if (anchor != null) {
            Polygon polygon;
            drawingModel.setzOrder(anchor.getRelativeHeight());
            drawingModel.setBackground(anchor.getBehindDoc());
            CTWrapPath wrapPath = null;
            if (anchor.getWrapSquare() != null) {
                drawingModel.setTextWrapping(TextWrapping.SQUARE);
                drawingModel.setTextWrappingSide(Util.getWrappingSide(anchor.getWrapSquare().getWrapText()));
            } else if (anchor.getWrapTopAndBottom() != null) {
                drawingModel.setTextWrapping(TextWrapping.TOPANDBOTTOM);
            } else if (anchor.getWrapThrough() != null) {
                drawingModel.setTextWrapping(TextWrapping.THROUGH);
                drawingModel.setTextWrappingSide(Util.getWrappingSide(anchor.getWrapThrough().getWrapText()));
                wrapPath = anchor.getWrapThrough().getWrapPolygon();
            } else if (anchor.getWrapTight() != null) {
                drawingModel.setTextWrapping(TextWrapping.TIGHT);
                drawingModel.setTextWrappingSide(Util.getWrappingSide(anchor.getWrapTight().getWrapText()));
                wrapPath = anchor.getWrapTight().getWrapPolygon();
            }
            if (wrapPath != null && (polygon = DrawingFactory.createPolygon(wrapPath)) != null) {
                drawingModel.setWrappingPolygon(polygon);
            }
            int wrappingTop = 0;
            int wrappingRight = 0;
            int wrappingBottom = 0;
            int wrappingLeft = 0;
            if (anchor.isSetDistT()) {
                wrappingTop = (int)Util.convertEmuToTwips(anchor.getDistT());
            }
            if (anchor.isSetDistR()) {
                wrappingRight = (int)Util.convertEmuToTwips(anchor.getDistR());
            }
            if (anchor.isSetDistB()) {
                wrappingBottom = (int)Util.convertEmuToTwips(anchor.getDistB());
            }
            if (anchor.isSetDistL()) {
                wrappingLeft = (int)Util.convertEmuToTwips(anchor.getDistL());
            }
            drawingModel.setTextWrappingInsets(new Insets(wrappingTop, wrappingLeft, wrappingBottom, wrappingRight));
        } else {
            Util.LOGGER.warn((Object)"Anchor is not available.");
        }
        ArrayList<DrawingElement> content = new ArrayList<DrawingElement>();
        CTGraphicalObjectData gra = anchor != null ? anchor.getGraphic().getGraphicData() : ((CTInline)inl.get(0)).getGraphic().getGraphicData();
        XmlCursor cursor = gra.newCursor();
        ObjectSizeAndPosition geometricDataGroup = null;
        cursor.selectPath("./*");
        if (cursor.toNextSelection() && !((o = cursor.getObject()) instanceof CTRelIdImpl)) {
            if (o instanceof org.openxmlformats.schemas.drawingml.x2006.picture.CTPicture) {
                content.add(DrawingFactory.createPicture((org.openxmlformats.schemas.drawingml.x2006.picture.CTPicture)o, documentProperties));
            } else if (o instanceof CTRelIdsImpl) {
                CTRelIdsImpl relationIds = (CTRelIdsImpl)o;
                RelationObject relObj = documentProperties.getRelation(relationIds.getDm(), new Rectangle2D.Double(0.0, 0.0, drawingModel.getWidth(), drawingModel.getHeight()));
                if (relObj == null) {
                    Util.LOGGER.error((Object)("Unhandled relation data: " + relationIds.getDm() + " layout: " + relationIds.getLo() + " ...."));
                } else {
                    content.addAll(relObj.getDisplayElements());
                }
            } else if ("wps:wsp".equals(o.getDomNode().getNodeName())) {
                SimpleShape sims = DrawingFactory.parseShapeElement(o, documentProperties, part, drawingModel, null);
                content.add(sims);
            } else if ("wpg:wgp".equals(o.getDomNode().getNodeName())) {
                XmlCursor oCursor = o.newCursor();
                oCursor.selectPath("./*");
                Color groupFillColor = null;
                while (oCursor.toNextSelection()) {
                    XmlObject oS = oCursor.getObject();
                    if ("wpg:grpSpPr".equals(oS.getDomNode().getNodeName())) {
                        try {
                            CTGroupShapeProperties gsp = (CTGroupShapeProperties)CTGroupShapeProperties.Factory.parse(oS.toString(), new XmlOptions(POIXMLTypeLoader.DEFAULT_XML_OPTIONS));
                            groupFillColor = Util.getColorFromSolidFill(gsp.getSolidFill(), documentProperties, null);
                            geometricDataGroup = new ObjectSizeAndPosition(gsp.getXfrm());
                        }
                        catch (Throwable ex) {
                            Util.LOGGER.error(ex);
                        }
                        continue;
                    }
                    if ("wps:wsp".equals(oS.getDomNode().getNodeName())) {
                        SimpleShape sims = DrawingFactory.parseShapeElement(oS, documentProperties, part, drawingModel, groupFillColor);
                        content.add(sims);
                        continue;
                    }
                    if ("wpg:grpSp".equals(oS.getDomNode().getNodeName())) {
                        content.add(DrawingFactory.parseShapeGroup(oS, documentProperties, part, drawingModel));
                        continue;
                    }
                    if ("pic:pic".equals(oS.getDomNode().getNodeName())) {
                        try {
                            org.openxmlformats.schemas.drawingml.x2006.picture.CTPicture pic = (org.openxmlformats.schemas.drawingml.x2006.picture.CTPicture)org.openxmlformats.schemas.drawingml.x2006.picture.CTPicture.Factory.parse(oS.toString(), POIXMLTypeLoader.DEFAULT_XML_OPTIONS);
                            content.add(DrawingFactory.createPicture(pic, documentProperties));
                        }
                        catch (Exception ex) {
                            Util.LOGGER.error((Throwable)ex);
                        }
                        continue;
                    }
                    if (oS.getDomNode().getNodeName().endsWith(":cNvGrpSpPr")) continue;
                    oS.selectPath("./*");
                    XmlObject[] xmlObjects = oS.selectChildren(PIC);
                    Util.LOGGER.error((Object)("Unknown inner content \tclass => " + String.valueOf(oS.getClass()) + "\tclass2 => " + String.valueOf(o.getClass()) + "\tnodename => " + oS.getDomNode().getNodeName()));
                }
                oCursor.dispose();
            } else if ("wpc:wpc".equals(o.getDomNode().getNodeName())) {
                XmlObject[] subObj = NameSpaceHandler.examineNamespace("wps", "wsp", o);
                for (int i = 0; i < subObj.length; ++i) {
                    SimpleShape sims = DrawingFactory.parseShapeElement(subObj[i], documentProperties, part, drawingModel, null);
                    content.add(sims);
                }
            } else {
                Util.LOGGER.error((Object)("Unknown content \tclass => " + String.valueOf(o.getClass()) + "\tclass2 => " + String.valueOf(o.getClass()) + "\tnodename => " + o.getDomNode().getNodeName()));
            }
        }
        cursor.dispose();
        if (content.size() == 1 && geometricDataGroup == null) {
            drawingModel.setContent((DrawingElement)content.get(0));
        } else if (!content.isEmpty()) {
            double rotation = geometricDataGroup == null ? 0.0 : geometricDataGroup.getRotation();
            double scaleX = geometricDataGroup == null ? 0.0 : geometricDataGroup.getScalingX();
            double scaleY = geometricDataGroup == null ? 0.0 : geometricDataGroup.getScalingY();
            DrawingReflection reflection = geometricDataGroup == null ? DrawingReflection.NONE : geometricDataGroup.getReflection();
            drawingModel.setContent(new ShapeGroup(content, DrawingFactory.calculateBounds(content), rotation, scaleX, scaleY, reflection));
        } else {
            SimpleShape sims = new SimpleShape(SimpleShape.ShapeType.rect.name(), new Rectangle2D.Double(0.0, 0.0, drawingModel.getWidth(), drawingModel.getHeight()), 0.0, 1.0, 1.0, DrawingReflection.NONE);
            Path2D.Double shape = new Path2D.Double();
            shape.moveTo(0.0, 0.0);
            shape.lineTo(1.0, 1.0);
            shape.lineTo(1.0, 0.0);
            shape.lineTo(0.0, 1.0);
            shape.lineTo(1.0, 1.0);
            shape.moveTo(1.0, 0.0);
            shape.lineTo(0.0, 0.0);
            shape.lineTo(0.0, 1.0);
            sims.addMultiLine(shape);
            sims.getBasicStrokeData().setBorderColor(Color.RED);
            drawingModel.setContent(sims);
        }
        return drawingModel;
    }

    private static DimensionDefinition checkForRelativeDimensions(CTAnchor anchor, boolean horizontal, DimensionDefinition absoluteValue) {
        int value;
        XmlObject[] relartive = NameSpaceHandler.examineNamespace("wp", horizontal ? "sizeRelH" : "sizeRelV", (XmlObject)anchor);
        if ((relartive.length > 0 || (relartive = NameSpaceHandler.examineNamespace("wp14", horizontal ? "sizeRelH" : "sizeRelV", (XmlObject)anchor)).length > 0) && (value = Util.getIntValue((XmlObjectBase)relartive[0], horizontal ? PCTWIDTH : PCTHEIGHT, Integer.MIN_VALUE)) > 0) {
            return new DimensionDefinition(new UnitNumber((double)value / 1000.0, UnitNumber.Unit.PERCENTAGE), ((XmlAnyTypeImpl)relartive[0].selectAttribute(RELATIVEFROM)).getStringValue(), horizontal);
        }
        return absoluteValue;
    }

    public static Drawing convertToDrawing(ParagraphData content, TextFrame textFrame) {
        ArrayList<DocumentElement> sourceModel = new ArrayList<DocumentElement>();
        sourceModel.add(content);
        double x = textFrame.getX() != null ? textFrame.getX() : 0.0;
        double y = textFrame.getY() != null ? textFrame.getY() : 0.0;
        Anchor vertAnch = new Anchor(textFrame.getVerticalAnchor(), textFrame.getVerticalAlign(), y, false, true);
        Anchor horzAnch = new Anchor(textFrame.getHorizontalAnchor(), textFrame.getHorizontalAlign(), x, false, false);
        double width = textFrame.getWidth() != null ? textFrame.getWidth() : 0.0;
        double height = textFrame.getHeight() != null ? textFrame.getHeight() : 0.0;
        Drawing draw = new Drawing(new DimensionDefinition(width), new DimensionDefinition(height), content.getMarkerRenderFont(), vertAnch, horzAnch);
        draw.setTextWrapping(textFrame.getTextWrap());
        SimpleShape simShape = new SimpleShape("rect", new Rectangle2D.Double(0.0, 0.0, width, height));
        simShape.setAutoFit(true);
        draw.setContent(new TextBoxShape(simShape, sourceModel));
        return draw;
    }

    private static Polygon createPolygon(CTWrapPath ctWrapPath) {
        Polygon polygon = new Polygon();
        polygon.addPoint((int)(Util.convertEmuToTwips(Util.getLong(ctWrapPath.getStart().getX())) * 20.0), (int)(Util.convertEmuToTwips(Util.getLong(ctWrapPath.getStart().getY())) * 20.0));
        for (CTPoint2D ctPoint2D : ctWrapPath.getLineToList()) {
            polygon.addPoint((int)(Util.convertEmuToTwips(Util.getLong(ctPoint2D.getX())) * 20.0), (int)(Util.convertEmuToTwips(Util.getLong(ctPoint2D.getY())) * 20.0));
        }
        return polygon.npoints >= 3 ? polygon : null;
    }

    private static PictureElement createPicture(org.openxmlformats.schemas.drawingml.x2006.picture.CTPicture pic, DocumentProperties documentProperties) {
        String referenceId = pic.getBlipFill().getBlip().getEmbed() + "_" + documentProperties.getCurrentPartName();
        CTShapeProperties sp = pic.getSpPr();
        CTTransform2D bounds = sp.getXfrm();
        ObjectSizeAndPosition objectSizeAndPosition = new ObjectSizeAndPosition(bounds);
        CTBlipFillProperties blip = pic.getBlipFill();
        PictureElement picture = new PictureElement(objectSizeAndPosition.getBounds(), objectSizeAndPosition.getRotation(), objectSizeAndPosition.getScalingX(), objectSizeAndPosition.getScalingY(), referenceId, blip, objectSizeAndPosition.getReflection());
        if (sp.isSetLn()) {
            DrawingFactory.updateBasicStrokeDataWithInfoFromProperties(picture.getBasicStrokeData(), sp.getLn(), documentProperties);
        }
        return picture;
    }

    private static void updateBasicStrokeDataWithInfoFromProperties(BasicStrokeData data, CTLineProperties lnProp, DocumentProperties documentProperties) {
        STLineCap.Enum cap = lnProp.getCap();
        if (STLineCap.SQ.equals(cap)) {
            data.setLineCap(2);
        } else if (STLineCap.RND.equals(cap)) {
            data.setLineCap(1);
        } else if (STLineCap.FLAT.equals(cap)) {
            data.setLineCap(0);
        }
        if (lnProp.getRound() != null) {
            data.setLineJoin(1);
        } else if (lnProp.getBevel() != null) {
            data.setLineJoin(2);
        }
        if (lnProp.isSetW()) {
            data.setBorderLineWidth(lnProp.getW());
        }
        if (lnProp.isSetNoFill()) {
            data.setPaintBorders(false);
        } else {
            data.setBorderColor(Util.getColorFromSolidFill(lnProp.getSolidFill(), documentProperties, null));
            double emuWidth = lnProp.getW();
            if (emuWidth == 0.0) {
                emuWidth = 6350.0;
            }
            if (lnProp.isSetCmpd()) {
                data.setMultiLineStyle(lnProp.getCmpd().toString());
            }
            data.setBorderLineWidth(emuWidth / 635.0);
            CTPresetLineDashProperties pldp = lnProp.getPrstDash();
            String style = pldp != null ? pldp.getVal().toString() : "";
            data.setLineStyle(LineStyle.getStyle(style));
        }
    }

    private static CTPosV readCTPosV(CTAnchor anchor) {
        XmlObject[] posV;
        CTPosV verticalPos = anchor.getPositionV();
        if (verticalPos == null && (posV = NameSpaceHandler.examineNamespace("wp", "positionV", (XmlObject)anchor)).length > 0) {
            try {
                verticalPos = (CTPosV)CTPosV.Factory.parse(posV[0].toString(), new XmlOptions(POIXMLTypeLoader.DEFAULT_XML_OPTIONS));
            }
            catch (XmlException xe) {
                Util.LOGGER.error((Throwable)xe);
            }
        }
        return verticalPos;
    }

    private static CTPosH readCTPosH(CTAnchor anchor) {
        CTPosH horizontalPos = anchor.getPositionH();
        if (horizontalPos == null) {
            XmlObject[] posH = NameSpaceHandler.examineNamespace("wp", "positionH", (XmlObject)anchor);
            if (posH.length > 0) {
                try {
                    return (CTPosH)CTPosH.Factory.parse(posH[0].toString(), new XmlOptions(POIXMLTypeLoader.DEFAULT_XML_OPTIONS));
                }
                catch (XmlException xe) {
                    Util.LOGGER.error((Throwable)xe);
                }
            }
        } else {
            return horizontalPos;
        }
        return null;
    }

    private static Anchor handleHorizontalSettings(CTPosH horizontalPos) {
        boolean percebtage = false;
        int x = 0;
        Object allignH = horizontalPos.getAlign();
        if (horizontalPos.isSetPosOffset()) {
            x = (int)Util.convertEmuToTwips(horizontalPos.getPosOffset());
            allignH = Anchor.Align.absolute.toString();
        } else {
            int value = Util.getIntValue((XmlObjectBase)horizontalPos, PCTPOSHOFFSET, Integer.MIN_VALUE);
            if (value > Integer.MIN_VALUE) {
                percebtage = true;
                x = value;
            }
        }
        return new Anchor(horizontalPos.getRelativeFrom().toString(), allignH == null ? Anchor.Align.left.toString() : allignH.toString(), (double)x, percebtage, false);
    }

    private static Anchor handleVerticalSettings(CTPosV verticalPos) {
        boolean percebtage = false;
        Object allignV = verticalPos.getAlign();
        int y = 0;
        if (verticalPos.isSetPosOffset()) {
            y = (int)Util.convertEmuToTwips(verticalPos.getPosOffset());
            allignV = Anchor.Align.absolute.toString();
        } else {
            int value = Util.getIntValue((XmlObjectBase)verticalPos, PCTPOSVOFFSET, Integer.MIN_VALUE);
            if (value > Integer.MIN_VALUE) {
                percebtage = true;
                y = value;
            }
        }
        return new Anchor(verticalPos.getRelativeFrom().toString(), allignV == null ? Anchor.Align.top.toString() : allignV.toString(), (double)y, percebtage, true);
    }

    private static ShapeGroup parseShapeGroup(XmlObject shapeGroupContent, DocumentProperties documentProperties, IBody part, Drawing parent) {
        try {
            ArrayList<DrawingElement> elements = new ArrayList<DrawingElement>();
            XmlObject[] internalShapeProperties = NameSpaceHandler.examineNamespace("wpg", "grpSpPr", shapeGroupContent);
            CTGroupShapeProperties spInner = (CTGroupShapeProperties)CTGroupShapeProperties.Factory.parse(internalShapeProperties[0].toString(), new XmlOptions(POIXMLTypeLoader.DEFAULT_XML_OPTIONS));
            ObjectSizeAndPosition geometricData = new ObjectSizeAndPosition(spInner.getXfrm());
            Point2D relativePunkt = geometricData.getChPosition();
            double off = relativePunkt != null ? relativePunkt.getX() : 0.0;
            XmlObject[] internalShapeObj = NameSpaceHandler.examineNamespace("wps", "wsp", shapeGroupContent);
            double minX = Double.MAX_VALUE;
            double maxX = 0.0;
            double minY = Double.MAX_VALUE;
            double maxY = 0.0;
            for (int i = 0; i < internalShapeObj.length; ++i) {
                SimpleShape shape = DrawingFactory.parseShapeElement(internalShapeObj[i], documentProperties, part, parent, null);
                minX = Math.min(minX, shape.getPosition().getX());
                minX = Math.min(minX, shape.getPosition().getX() + shape.getBoundsShape().getBounds2D().getWidth());
                maxX = Math.max(maxX, shape.getPosition().getX());
                maxX = Math.max(maxX, shape.getPosition().getX() + shape.getBoundsShape().getBounds2D().getWidth());
                minY = Math.min(minY, shape.getPosition().getY());
                minY = Math.min(minY, shape.getPosition().getY() + shape.getBoundsShape().getBounds2D().getHeight());
                maxY = Math.max(maxY, shape.getPosition().getY());
                maxY = Math.max(maxY, shape.getPosition().getY() + shape.getBoundsShape().getBounds2D().getHeight());
                elements.add(shape);
            }
            if (off < 0.0) {
                geometricData.getSize().width -= (int)off;
                relativePunkt.setLocation(0.0, relativePunkt.getY());
            }
            return new ShapeGroup(elements, new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY), geometricData.getRotation(), geometricData.getScalingX(), geometricData.getScalingY(), geometricData.getReflection());
        }
        catch (Throwable th) {
            Util.LOGGER.error(th);
            return null;
        }
    }

    private static SimpleShape createShapeFromProperties(CTShapeProperties shapeProps, DocumentProperties documentProperties) {
        CTGradientFillProperties gradFill;
        CTLinearShadeProperties lsp;
        CTTransform2D transform = shapeProps.getXfrm();
        ObjectSizeAndPosition geometricData = null;
        String type = "";
        HashMap<String, String> params = new HashMap<String, String>();
        ArrayList<Path2D.Double> shapes = new ArrayList<Path2D.Double>();
        if (transform != null) {
            geometricData = new ObjectSizeAndPosition(transform);
        }
        if (shapeProps.isSetPrstGeom()) {
            CTPresetGeometry2D geoStyle = shapeProps.getPrstGeom();
            type = geoStyle.xgetPrst().getStringValue();
            List geomList = geoStyle.getAvLst().getGdList();
            if (geomList.size() > 0) {
                for (CTGeomGuide gg : geomList) {
                    params.put(gg.getName(), gg.getFmla());
                }
            }
        } else if (shapeProps.isSetCustGeom()) {
            type = SimpleShape.ShapeType.multiline.name();
            CTCustomGeometry2D customGeo = shapeProps.getCustGeom();
            CTPath2DList pathLists = customGeo.getPathLst();
            List paths = pathLists.getPathList();
            for (CTPath2D path : paths) {
                long x = path.isSetW() ? path.getW() : transform.getExt().getCx();
                long y = path.isSetH() ? path.getH() : transform.getExt().getCy();
                Path2D.Double shape = new Path2D.Double();
                XmlCursor cursor = path.newCursor();
                cursor.selectPath("./*");
                while (cursor.toNextSelection()) {
                    XmlObject o = cursor.getObject();
                    if (o instanceof CTPath2DMoveTo) {
                        Point2D movePt = DrawingFactory.convertPoint(((CTPath2DMoveTo)o).getPt(), x, y);
                        shape.moveTo(movePt.getX(), movePt.getY());
                        continue;
                    }
                    if (o instanceof CTPath2DCubicBezierTo) {
                        List pointList = ((CTPath2DCubicBezierTo)o).getPtList();
                        if (pointList.size() == 3) {
                            Point2D[] points = new Point2D[3];
                            for (int i = 0; i < points.length; ++i) {
                                points[i] = DrawingFactory.convertPoint((CTAdjPoint2D)pointList.get(i), x, y);
                            }
                            shape.curveTo(points[0].getX(), points[0].getY(), points[1].getX(), points[1].getY(), points[2].getX(), points[2].getY());
                            continue;
                        }
                        Util.LOGGER.error((Object)("To few or much points for a CubicCurve2D. It was " + pointList.size() + " points available"));
                        continue;
                    }
                    if (o instanceof CTPath2DCloseImpl) {
                        shape.closePath();
                        continue;
                    }
                    if (o instanceof CTPath2DLineToImpl) {
                        CTAdjPoint2D pointRaw = ((CTPath2DLineToImpl)o).getPt();
                        Point2D point = DrawingFactory.convertPoint(pointRaw, x, y);
                        shape.lineTo(point.getX(), point.getY());
                        continue;
                    }
                    if (o instanceof CTPath2DArcTo) {
                        CTPath2DArcTo arcTo = (CTPath2DArcTo)o;
                        float oeffnungsWinkel = -((Number)arcTo.getSwAng()).floatValue() / 60000.0f;
                        float startWinkel = 360.0f - ((Number)arcTo.getStAng()).floatValue() / 60000.0f;
                        double rectwidth = ((Number)arcTo.getWR()).doubleValue() * 2.0 / (double)x;
                        double rectheight = ((Number)arcTo.getHR()).doubleValue() * 2.0 / (double)y;
                        shape.append(new Arc2D.Double(0.0, 0.0, rectwidth, rectheight, startWinkel, oeffnungsWinkel, 0), true);
                        continue;
                    }
                    Util.LOGGER.error((Object)("Unknown path object: " + o.getClass().getName()));
                }
                cursor.dispose();
                shapes.add(shape);
            }
        }
        SimpleShape simShape = new SimpleShape(type, geometricData.getBounds(), geometricData.getRotation(), geometricData.getScalingX(), geometricData.getScalingY(), geometricData.getReflection());
        for (Path2D.Double shape : shapes) {
            simShape.addMultiLine(shape);
        }
        simShape.setNoFill(shapeProps.isSetNoFill());
        if (simShape.needsBackground()) {
            simShape.setBgColor(Util.getColorFromSolidFill(shapeProps.getSolidFill(), documentProperties, null));
        }
        if (shapeProps.isSetLn()) {
            CTLineProperties lnProp = shapeProps.getLn();
            DrawingFactory.updateBasicStrokeDataWithInfoFromProperties(simShape.getBasicStrokeData(), lnProp, documentProperties);
            if ("straightConnector1".equals(type)) {
                DrawingFactory.handleLineEnds(lnProp.getHeadEnd(), params, "head_");
                DrawingFactory.handleLineEnds(lnProp.getTailEnd(), params, "tail_");
            }
        }
        if (shapeProps.isSetGradFill() && (lsp = (gradFill = shapeProps.getGradFill()).getLin()) != null) {
            GradientData grDa = new GradientData((float)lsp.getAng() / 60000.0f, lsp.getScaled());
            List gratientParts = gradFill.getGsLst().getGsList();
            for (CTGradientStop gratientStop : gratientParts) {
                grDa.addGradientStop(Util.getColorFrom(gratientStop.getSchemeClr(), gratientStop.getSrgbClr(), gratientStop.getPrstClr(), documentProperties, null), Util.getFloat(gratientStop.getPos()) / 100000.0f);
            }
            simShape.setGradient(grDa);
        }
        if (shapeProps.isSetBlipFill()) {
            CTBlipFillProperties blipFill = shapeProps.getBlipFill();
            String refID = blipFill.getBlip().getEmbed() + "_" + documentProperties.getCurrentPartName();
            PictureFillData.TileData tileData = null;
            if (blipFill.isSetTile()) {
                CTTileInfoProperties tile = blipFill.getTile();
                Function<Object, Double> parseValue = value -> {
                    String val = String.valueOf(value);
                    if (val.endsWith("%")) {
                        return Double.valueOf(val.substring(0, val.length() - 1));
                    }
                    return Double.valueOf(val);
                };
                try {
                    double tx = parseValue.apply(tile.getTx()) / 635.0;
                    double ty = parseValue.apply(tile.getTy()) / 635.0;
                    double sx = parseValue.apply(tile.getSx()) / 1000.0;
                    double sy = parseValue.apply(tile.getSy()) / 1000.0;
                    tileData = new PictureFillData.TileData(tx, ty, sx, sy);
                }
                catch (Exception ex) {
                    Util.LOGGER.error((Throwable)ex);
                }
            }
            PictureFillData pictureFillData = new PictureFillData(refID, tileData);
            simShape.setPictureFillData(pictureFillData);
        }
        simShape.setGeometricParameters(params);
        return simShape;
    }

    private static void handleLineEnds(CTLineEndProperties lep, HashMap<String, String> params, String type) {
        if (lep != null) {
            STLineEndType.Enum let = lep.getType();
            if (let == null) {
                params.put(type + "type", "none");
            } else {
                params.put(type + "type", let.toString());
                STLineEndWidth.Enum w = lep.getW();
                params.put(type + "w", w != null ? w.toString() : "med");
                STLineEndLength.Enum len = lep.getLen();
                params.put(type + "len", len != null ? len.toString() : "med");
            }
        }
    }

    private static Color handleShapeStyle(SimpleShape simShape, CTShapeStyle style, DocumentProperties documentProperties) {
        CTFontReference fontRef;
        CTStyleMatrixReference colorRef;
        BasicStrokeData basicStrokeData;
        CTStyleMatrixReference fillRef;
        if (simShape.needsBackground() && (fillRef = style.getFillRef()) != null) {
            Color col = Util.getColorFrom(fillRef.getSchemeClr(), fillRef.getSrgbClr(), fillRef.getPrstClr(), documentProperties, null);
            simShape.setBgColor(col);
        }
        if ((basicStrokeData = simShape.getBasicStrokeData()).getBorderColor() == null && basicStrokeData.needsBorderColor() && (colorRef = style.getLnRef()) != null) {
            Color col = Util.getColorFrom(colorRef.getSchemeClr(), colorRef.getSrgbClr(), colorRef.getPrstClr(), documentProperties, null);
            basicStrokeData.setBorderColor(col);
        }
        if ((fontRef = style.getFontRef()) != null) {
            return Util.getColorFrom(fontRef.getSchemeClr(), fontRef.getSrgbClr(), fontRef.getPrstClr(), documentProperties, null);
        }
        return null;
    }

    private static SimpleShape parseShapeElement(XmlObject wsp, DocumentProperties documentProperties, IBody part, DrawingElement parent, Color groupColor) {
        SimpleShape simShape = null;
        XmlObject[] shapePropertiesObj = NameSpaceHandler.examineNamespace("wps", "spPr", wsp);
        try {
            if (shapePropertiesObj.length > 0) {
                XmlObject[] txbxObj;
                XmlObject[] bodyprObj;
                CTShapeProperties sp = (CTShapeProperties)CTShapeProperties.Factory.parse(shapePropertiesObj[0].toString(), new XmlOptions(POIXMLTypeLoader.DEFAULT_XML_OPTIONS));
                simShape = DrawingFactory.createShapeFromProperties(sp, documentProperties);
                if (sp.isSetGrpFill() && groupColor != null) {
                    simShape.setBgColor(groupColor);
                }
                if ((bodyprObj = NameSpaceHandler.examineNamespace("wps", "bodyPr", wsp)).length > 0) {
                    CTTextBodyProperties bodypr = (CTTextBodyProperties)CTTextBodyProperties.Factory.parse(bodyprObj[0].toString(), new XmlOptions(POIXMLTypeLoader.DEFAULT_XML_OPTIONS));
                    simShape.setContentProperties(new ShapeBodyProperties(bodypr));
                    simShape.setAutoFit(bodypr.isSetSpAutoFit());
                }
                Color defaultFontColor = null;
                XmlObject[] styleObj = NameSpaceHandler.examineNamespace("wps", "style", wsp);
                if (styleObj.length > 0) {
                    defaultFontColor = DrawingFactory.handleShapeStyle(simShape, (CTShapeStyle)CTShapeStyle.Factory.parse(styleObj[0].toString(), new XmlOptions(POIXMLTypeLoader.DEFAULT_XML_OPTIONS)), documentProperties);
                }
                if ((txbxObj = NameSpaceHandler.examineNamespace("wps", "txbx", wsp)).length > 0) {
                    CTTextbox tbp = (CTTextbox)CTTextbox.Factory.parse(txbxObj[0].toString(), new XmlOptions(POIXMLTypeLoader.DEFAULT_XML_OPTIONS));
                    simShape = DrawingFactory.handleTextboxData(tbp, simShape, documentProperties, defaultFontColor, part);
                }
                simShape.setTextWrapping(parent.getTextWrapping());
                simShape.setTextWrappingSide(parent.getTextWrappingSide());
                simShape.setBackground(parent.isBackground());
            }
        }
        catch (XmlException ex) {
            Util.LOGGER.error((Throwable)ex);
        }
        return simShape;
    }

    public static SimpleShape createSimpleShape(CTShapeProperties shapeProps, CTShapeStyle style, CTTextBody txtbody, DocumentProperties docProps) {
        SimpleShape simShape = DrawingFactory.createShapeFromProperties(shapeProps, docProps);
        Color defaultFontColor = DrawingFactory.handleShapeStyle(simShape, style, docProps);
        if (txtbody != null) {
            List paragraphList = txtbody.getPList();
            ArrayList<DocumentElement> textContent = new ArrayList<DocumentElement>();
            for (CTTextParagraph paragraph : paragraphList) {
                if (paragraph.getRList().size() <= 0) continue;
                ParagraphData pa = new ParagraphData();
                XmlCursor cursor = paragraph.newCursor();
                cursor.selectPath("./*");
                CTTextParagraphProperties tpp = null;
                double maxHeight = 0.0;
                while (cursor.toNextSelection()) {
                    XmlObject o = cursor.getObject();
                    if (o instanceof CTTextParagraphProperties) {
                        tpp = (CTTextParagraphProperties)o;
                        continue;
                    }
                    if (!(o instanceof CTRegularTextRun)) continue;
                    CTRegularTextRun rtr = (CTRegularTextRun)o;
                    String text = rtr.getT();
                    RunRenderInformations rri = RunRenderInformations.getRenderInformations(rtr.getRPr(), null, docProps, docProps.getStandardStyleFont().getTextRenderInformations());
                    Color fontColor = rri.getFontColor() != null ? rri.getFontColor() : defaultFontColor;
                    RenderFont renderFont = rri.createFont(docProps);
                    pa.addElement(new TextRowElement(text, renderFont, fontColor, rri.getFontBackgroundColor()));
                    maxHeight = Math.max(maxHeight, docProps.getLayouter(renderFont).getFontDimensions().getRowHeight());
                }
                cursor.dispose();
                Spacing spacing = tpp != null && maxHeight > 0.0 ? new Spacing(tpp, maxHeight) : docProps.getDefaultSpacing();
                pa.setSpacing(spacing);
                String align = tpp != null ? tpp.getAlgn() : "center";
                pa.setHorizontalAlign(align != null ? align.toString() : "center");
                textContent.add(pa);
            }
            if (textContent.size() > 0) {
                simShape = new TextBoxShape(simShape, textContent);
                simShape.setContentProperties(new ShapeBodyProperties(txtbody.getBodyPr()));
            }
        }
        return simShape;
    }

    private static Point2D convertPoint(CTAdjPoint2D point, long width, long height) {
        Object xEmu = point.getX();
        Object yEmu = point.getY();
        float xPos = DrawingFactory.calcPercentage(xEmu, width);
        float yPos = DrawingFactory.calcPercentage(yEmu, height);
        return new Point2D.Double(xPos, yPos);
    }

    private static float calcPercentage(Object value, float base) {
        float calc = value instanceof Number ? (float)((Number)value).longValue() : 0.0f;
        return calc / base;
    }

    public static Shape createStar(int edgePoint, double x, double y, double width, double height, HashMap<String, String> geometricParameters) {
        double tipFactor = 0.75;
        switch (edgePoint) {
            case 4: {
                tipFactor = 0.252;
                break;
            }
            case 5: {
                tipFactor = 0.386;
                break;
            }
            case 6: {
                tipFactor = 0.572;
                break;
            }
            case 7: {
                tipFactor = 0.692;
                break;
            }
            case 8: {
                tipFactor = 0.746;
                break;
            }
            case 10: {
                tipFactor = 0.852;
            }
        }
        if (geometricParameters != null && geometricParameters.get("adj") != null) {
            String val = geometricParameters.get("adj");
            if (val.startsWith("val ")) {
                val = val.substring(4);
            }
            int value = Integer.parseInt(val);
            tipFactor = (double)value / 50000.0;
        }
        List<Point2D.Double> points = DrawingFactory.getEdgePointsForNEdge(edgePoint * 2, width, height, 0.0, false);
        if (tipFactor < 1.0) {
            for (int i = 1; i < points.size(); i += 2) {
                Point2D.Double point = points.get(i);
                AffineTransform affineTransform = new AffineTransform(tipFactor, 0.0, 0.0, tipFactor, 0.0, 0.0);
                Point2D.Double scaledPoint = (Point2D.Double)affineTransform.transform(point, null);
                points.set(i, scaledPoint);
            }
        }
        points = DrawingFactory.toFitShapeToBounds(points, width, height);
        points = DrawingFactory.movePoints(points, x, y);
        return DrawingFactory.createShape(points);
    }

    private static Point2D.Double getPoint(HashMap<String, String> geometricParameters, double shapeWidth, double shapeHeight, String name) {
        String xVal = geometricParameters.get(name + "x");
        if (xVal != null) {
            double x = Double.parseDouble(xVal) * shapeWidth;
            double y = Double.parseDouble(geometricParameters.get(name + "y")) * shapeHeight;
            return new Point2D.Double(x, y);
        }
        return null;
    }

    public static Shape straightConnector(double x, double y, double shapeWidth, double shapeHeight, HashMap<String, String> geometricParameters) {
        Point2D.Double startP = DrawingFactory.getPoint(geometricParameters, shapeWidth, shapeHeight, "startP");
        Point2D.Double endP = DrawingFactory.getPoint(geometricParameters, shapeWidth, shapeHeight, "endP");
        Path2D.Double path = new Path2D.Double();
        ((Path2D)path).moveTo(x + startP.getX(), y + startP.getY());
        Point2D.Double headP = DrawingFactory.getPoint(geometricParameters, shapeWidth, shapeHeight, "headAP");
        if (headP != null) {
            ((Path2D)path).lineTo(x + headP.getX(), y + headP.getY());
            headP = DrawingFactory.getPoint(geometricParameters, shapeWidth, shapeHeight, "headBP");
            ((Path2D)path).lineTo(x + headP.getX(), y + headP.getY());
            ((Path2D)path).lineTo(x + startP.getX(), y + startP.getY());
        }
        ((Path2D)path).lineTo(x + endP.getX(), y + endP.getY());
        Point2D.Double tailP = DrawingFactory.getPoint(geometricParameters, shapeWidth, shapeHeight, "tailAP");
        if (tailP != null) {
            ((Path2D)path).lineTo(x + tailP.getX(), y + tailP.getY());
            tailP = DrawingFactory.getPoint(geometricParameters, shapeWidth, shapeHeight, "tailBP");
            ((Path2D)path).lineTo(x + tailP.getX(), y + tailP.getY());
            ((Path2D)path).lineTo(x + endP.getX(), y + endP.getY());
        }
        ((Path2D)path).moveTo(shapeWidth, shapeHeight);
        return path;
    }

    public static Shape triangle(double x, double y, double shapeWidth, double shapeHeight, HashMap<String, String> geometricParameters) {
        float tipFactor = geometricParameters == null ? 1.0f : DrawingFactory.getPercentage(geometricParameters.get("adj"));
        double xTop = (double)tipFactor * shapeWidth;
        Path2D.Double path = new Path2D.Double();
        ((Path2D)path).moveTo(x + xTop, y);
        ((Path2D)path).lineTo(x + shapeWidth, y + shapeHeight);
        ((Path2D)path).lineTo(x, y + shapeHeight);
        ((Path2D)path).lineTo(x + xTop, y);
        path.closePath();
        return path;
    }

    public static Shape rightTriangle(double x, double y, double shapeWidth, double shapeHeight) {
        Path2D.Double path = new Path2D.Double();
        ((Path2D)path).moveTo(x, y);
        ((Path2D)path).lineTo(x + shapeWidth, y + shapeHeight);
        ((Path2D)path).lineTo(x, y + shapeHeight);
        ((Path2D)path).lineTo(x, y);
        path.closePath();
        return path;
    }

    public static Shape rightArrow(double x, double y, double shapeWidth, double shapeHeight, HashMap<String, String> geometricParameters) {
        Path2D.Double path = new Path2D.Double();
        if (geometricParameters == null) {
            geometricParameters = new HashMap();
            geometricParameters.put("adj1", "50000");
            geometricParameters.put("adj2", "50000");
        }
        float shaftFactor = DrawingFactory.getPercentage(geometricParameters.get("adj1"));
        float headFactor = DrawingFactory.getPercentage(geometricParameters.get("adj2"));
        double yDist = (double)((1.0f - shaftFactor) / 2.0f) * shapeHeight;
        double xDist = shapeWidth - shapeHeight * (double)headFactor;
        ((Path2D)path).moveTo(x, y + yDist);
        ((Path2D)path).lineTo(x, y + shapeHeight - yDist);
        ((Path2D)path).lineTo(x + xDist, y + shapeHeight - yDist);
        ((Path2D)path).lineTo(x + xDist, y + shapeHeight);
        ((Path2D)path).lineTo(x + shapeWidth, y + shapeHeight / 2.0);
        ((Path2D)path).lineTo(x + xDist, y);
        ((Path2D)path).lineTo(x + xDist, y + yDist);
        ((Path2D)path).lineTo(x, y + yDist);
        path.closePath();
        return path;
    }

    private static float getPercentage(String val) {
        if (val == null) {
            return 1.0f;
        }
        if (val.startsWith("val ")) {
            val = val.substring(4);
        }
        int value = Integer.parseInt(val);
        return (float)value / 100000.0f;
    }

    public static void createBorderLines(BorderLines borders, Rectangle2D bounds, AreaObjects elements) {
        elements.addDrawing(DrawingFactory.createBorderLinesDrawing(borders, bounds));
    }

    public static Drawing createBorderLinesDrawing(BorderLines borders, Rectangle2D bounds) {
        Point2D.Double topLeft = new Point2D.Double(bounds.getX(), bounds.getY());
        Point2D.Double topRight = new Point2D.Double(bounds.getX() + bounds.getWidth(), bounds.getY());
        Point2D.Double bottomLeft = new Point2D.Double(bounds.getX(), bounds.getY() + bounds.getHeight());
        Point2D.Double bottomRight = new Point2D.Double(bounds.getX() + bounds.getWidth(), bounds.getY() + bounds.getHeight());
        ArrayList<SimpleLine> lines = new ArrayList<SimpleLine>();
        lines.add(new SimpleLine(borders.getTopLine(), topLeft, topRight));
        lines.add(new SimpleLine(borders.getBottomLine(), bottomLeft, bottomRight));
        lines.add(new SimpleLine(borders.getLeftLine(), topLeft, bottomLeft));
        lines.add(new SimpleLine(borders.getRightLine(), topRight, bottomRight));
        return DrawingFactory.createLines(lines);
    }

    public static Drawing createLines(ArrayList<SimpleLine> lines) {
        for (int i = lines.size() - 1; i >= 0; --i) {
            LineProperties lineProp = lines.get(i).getLineProperty();
            if (DrawingFactory.isPrintable(lineProp)) continue;
            lines.remove(i);
        }
        if (lines.size() > 0) {
            double minX = Double.MAX_VALUE;
            double maxX = 0.0;
            double minY = Double.MAX_VALUE;
            double maxY = 0.0;
            for (SimpleLine line : lines) {
                minX = Math.min(minX, line.getStartPoint().getX());
                maxX = Math.max(maxX, line.getStartPoint().getX());
                minY = Math.min(minY, line.getStartPoint().getY());
                maxY = Math.max(maxY, line.getStartPoint().getY());
                minX = Math.min(minX, line.getEndPoint().getX());
                maxX = Math.max(maxX, line.getEndPoint().getX());
                minY = Math.min(minY, line.getEndPoint().getY());
                maxY = Math.max(maxY, line.getEndPoint().getY());
            }
            Drawing lineDraw = new Drawing(Util.convertPointToTwips(Math.abs(minX - maxX)), Util.convertPointToTwips(Math.abs(minY - maxY)));
            ArrayList<DrawingElement> elements = new ArrayList<DrawingElement>();
            for (SimpleLine line : lines) {
                Point2D.Double startPointInTwips = new Point2D.Double(Util.convertPointToTwips(line.getStartPoint().getX()), Util.convertPointToTwips(line.getStartPoint().getY()));
                Point2D.Double endPointInTwips = new Point2D.Double(Util.convertPointToTwips(line.getEndPoint().getX()), Util.convertPointToTwips(line.getEndPoint().getY()));
                elements.add(DrawingFactory.createLine(line.getLineProperty(), startPointInTwips, endPointInTwips));
            }
            lineDraw.setContent(new ShapeGroup(DrawingFactory.calculateBounds(elements), elements));
            lineDraw.setPageX(0.0);
            lineDraw.setPageY(0.0);
            return lineDraw;
        }
        return null;
    }

    public static Rectangle2D calculateBounds(List<DrawingElement> elements) {
        Rectangle2D union = null;
        for (DrawingElement element : elements) {
            if (union == null) {
                union = new Rectangle2D.Double(element.getPosition().getX(), element.getPosition().getY(), element.getWidth(), element.getHeight());
                continue;
            }
            union = ((Rectangle2D)union).createUnion(new Rectangle2D.Double(element.getPosition().getX(), element.getPosition().getY(), element.getWidth(), element.getHeight()));
        }
        return union;
    }

    public static SimpleShape createLine(LineProperties lineProp, Point2D p1, Point2D p2) {
        return new SimpleShape(lineProp, p1, p2);
    }

    public static boolean isPrintable(LineProperties lp) {
        return lp != null && (LineStyle.NIL == lp.getStyle() || lp.getColor() != null && lp.getWidth() > 0 && LineStyle.NONE != lp.getStyle());
    }

    static Shape getShapeWithEdge(int edgeNumber, double x, double y, double width, double height, double rotation) {
        return DrawingFactory.createShape(x, y, width, height, DrawingFactory.getEdgePointsForNEdge(edgeNumber, width, height, rotation, true));
    }

    private static Shape createShape(double x, double y, double width, double height, List<Point2D.Double> points) {
        points = DrawingFactory.toFitShapeToBounds(points, width, height);
        points = DrawingFactory.movePoints(points, x, y);
        return DrawingFactory.createShape(points);
    }

    private static Shape createShape(List<Point2D.Double> points) {
        Path2D.Double path = new Path2D.Double();
        ((Path2D)path).moveTo(points.get(points.size() - 1).getX(), points.get(points.size() - 1).getY());
        for (int i = 0; i < points.size() - 1; ++i) {
            Point2D.Double p = points.get(i);
            ((Path2D)path).lineTo(p.getX(), p.getY());
        }
        path.closePath();
        return path;
    }

    public static Shape getDiamond(double x, double y, double width, double height, double rotation) {
        return DrawingFactory.createShape(x, y, width, height, DrawingFactory.getEdgePointsForNEdge(4, width, height, rotation, false));
    }

    private static List<Point2D.Double> getEdgePointsForNEdge(int edgeNumber, double width, double height, double rotation, boolean evenEdgeOnTop) {
        double degree;
        ArrayList<Point2D.Double> points = new ArrayList<Point2D.Double>();
        double xCenter = width / 2.0;
        Point2D.Double startPoint = new Point2D.Double(xCenter, 0.0);
        if (edgeNumber % 2 == 0 && evenEdgeOnTop) {
            degree = 360.0 / (double)edgeNumber / 2.0;
            startPoint = DrawingFactory.getNextPoint(startPoint, degree);
        }
        if (rotation != 0.0) {
            degree = -Math.toDegrees(rotation);
            startPoint = DrawingFactory.getNextPoint(startPoint, degree);
        }
        degree = 360.0 / (double)edgeNumber;
        for (int i = 0; i < edgeNumber; ++i) {
            Point2D.Double nextPoint = DrawingFactory.getNextPoint(startPoint, degree * (double)i + 90.0);
            points.add(nextPoint);
        }
        return points;
    }

    private static Point2D.Double getNextPoint(Point2D.Double startPoint, double degree) {
        AffineTransform affineTransform = new AffineTransform(Math.cos(Math.toRadians(degree)), -Math.sin(Math.toRadians(degree)), Math.sin(Math.toRadians(degree)), Math.cos(Math.toRadians(degree)), 0.0, 0.0);
        Point2D.Double target = new Point2D.Double();
        affineTransform.transform(startPoint, target);
        return target;
    }

    private static List<Point2D.Double> toFitShapeToBounds(List<Point2D.Double> points, double width, double height) {
        points = DrawingFactory.scale(points, width, height);
        points = DrawingFactory.moveToCenter(points, width, height);
        return points;
    }

    private static List<Point2D.Double> moveToCenter(List<Point2D.Double> points, double width, double height) {
        Rectangle2D.Double minMax = DrawingFactory.getMinMaxPoints(points);
        double centerShapeX = (minMax.getMaxX() + minMax.getMinX()) / -2.0;
        double centerShapeY = (minMax.getMaxY() + minMax.getMinY()) / -2.0;
        double distanceToCenterX = centerShapeX + width / 2.0;
        double distanceToCenterY = centerShapeY + height / 2.0;
        return DrawingFactory.movePoints(points, distanceToCenterX, distanceToCenterY);
    }

    private static Rectangle2D.Double getMinMaxPoints(List<Point2D.Double> points) {
        double minX = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        double minY = Double.MAX_VALUE;
        double maxY = Double.MIN_VALUE;
        for (Point2D.Double point : points) {
            minX = Math.min(minX, point.getX());
            maxX = Math.max(maxX, point.getX());
            minY = Math.min(minY, point.getY());
            maxY = Math.max(maxY, point.getY());
        }
        return new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
    }

    private static List<Point2D.Double> scale(List<Point2D.Double> points, double width, double height) {
        Rectangle2D.Double minMax = DrawingFactory.getMinMaxPoints(points);
        double widthShape = minMax.getMaxX() - minMax.getMinX();
        double heightShape = minMax.getMaxY() - minMax.getMinY();
        double scaleX = (width - 1.0) / widthShape;
        double scaleY = (height - 1.0) / heightShape;
        AffineTransform transformToCenter = new AffineTransform(scaleX, 0.0, 0.0, scaleY, 0.0, 0.0);
        ArrayList<Point2D.Double> resultPoints = new ArrayList<Point2D.Double>();
        for (Point2D.Double point : points) {
            resultPoints.add((Point2D.Double)transformToCenter.transform(point, null));
        }
        return resultPoints;
    }

    private static List<Point2D.Double> movePoints(List<Point2D.Double> points, double translateX, double translateY) {
        AffineTransform transformToCenter = new AffineTransform(1.0, 0.0, 0.0, 1.0, translateX, translateY);
        ArrayList<Point2D.Double> resultPoints = new ArrayList<Point2D.Double>();
        for (Point2D.Double point : points) {
            resultPoints.add((Point2D.Double)transformToCenter.transform(point, null));
        }
        return resultPoints;
    }

    public static ParagraphElement createDrawing(CTObject ctobj, IBody part, DocumentProperties documentProperties) {
        DrawingContent dc = new DrawingContent();
        XmlCursor cursor = ctobj.newCursor();
        cursor.selectPath("./*");
        while (cursor.toNextSelection()) {
            CTOLEObjectImpl oleObj;
            XmlObject o = cursor.getObject();
            if (o instanceof CTShape) {
                new VmlObject((CTShape)o).createVmlObject(dc, part, documentProperties, null);
                continue;
            }
            if (o instanceof CTOLEObjectImpl) {
                oleObj = (CTOLEObjectImpl)o;
                dc.setOleObject(oleObj.getId(), oleObj.getProgID(), oleObj.getShapeID(), oleObj.getType(), oleObj.getDrawAspect());
                continue;
            }
            if (o instanceof CTRect) {
                new VmlObject((CTRect)o).createVmlObject(dc, part, documentProperties, null);
                continue;
            }
            if (o instanceof CTShapetype) continue;
            if (o instanceof CTControl) {
                oleObj = (CTControl)o;
                continue;
            }
            Util.LOGGER.error((Object)ctobj);
            Util.LOGGER.error((Object)("Unhandled data " + o.getClass().getName() + "!"));
        }
        cursor.dispose();
        DrawingContent.OleObjectData oleInfo = dc.getOleData();
        Drawing drawingModel = new Drawing(dc.getWidth(), dc.getHeight(), null, dc.getVerticalAnchor(), dc.getHorizontalAnchor());
        drawingModel.setzOrder(dc.getzIndex());
        if (oleInfo != null && oleInfo.isExcelSheet() && !oleInfo.displayAsIcon()) {
            PackagePart pp = documentProperties.getWorkbookReference(oleInfo.getOleRefKey());
            WorkbookAnalyzer wa = new WorkbookAnalyzer(pp, dc, documentProperties);
            TablePanel tablePanel = new TablePanel(wa.getTable(), new Rectangle2D.Double(0.0, 0.0, dc.getWidth().getValue(), dc.getHeight().getValue()), dc.getRotation(), 1.0, 1.0);
            drawingModel.setContent(tablePanel);
        } else if (dc.getImageKey() != null) {
            drawingModel.setContent(new PictureElement(new Rectangle2D.Double(0.0, 0.0, dc.getWidth().getValue(), dc.getHeight().getValue()), dc.getRotation(), 1.0, 1.0, dc.getImageKey() + "_" + documentProperties.getCurrentPartName(), null));
        } else {
            Util.LOGGER.error((Object)"Unhandled content!");
        }
        return drawingModel;
    }

    public static Drawing createDrawing(CTPicture pict, IBody part, DocumentProperties documentProperties) {
        DrawingContent dc = DrawingFactory.handleDrawing((XmlObject)pict, part, documentProperties, null);
        Drawing drawingModel = new Drawing(dc.getWidth(), dc.getHeight(), null, dc.getVerticalAnchor(), dc.getHorizontalAnchor());
        drawingModel.setzOrder(dc.getzIndex());
        List<DrawingElement> content = dc.getContent();
        if (content.size() == 1) {
            drawingModel.setContent(content.get(0));
        } else if (!content.isEmpty()) {
            Rectangle2D.Double bounds = new Rectangle2D.Double(0.0, 0.0, dc.getWidth().getValue(), dc.getHeight().getValue());
            ShapeGroup shapeGroup = new ShapeGroup(bounds, content);
            drawingModel.setContent(shapeGroup);
        }
        return drawingModel;
    }

    static DrawingContent handleDrawing(XmlObject examineObject, IBody part, DocumentProperties docProps, DrawingContent groupContent) {
        DrawingContent dc = new DrawingContent();
        for (VmlObject.TYPE value : VmlObject.TYPE.values()) {
            XmlObject[] objects = NameSpaceHandler.examineNamespace("v", value.name().toLowerCase(), examineObject);
            block14: for (int i = 0; i < objects.length; ++i) {
                switch (value) {
                    case SHAPETYPE: {
                        new VmlObject((CTShapetype)objects[0]).createVmlObject(dc, part, docProps, groupContent);
                        continue block14;
                    }
                    case SHAPE: {
                        new VmlObject((CTShape)objects[i]).createVmlObject(dc, part, docProps, groupContent);
                        continue block14;
                    }
                    case GROUP: {
                        new VmlObject((CTGroup)objects[i]).createVmlObject(dc, part, docProps, groupContent);
                        continue block14;
                    }
                    case RECT: {
                        new VmlObject((CTRect)objects[i]).createVmlObject(dc, part, docProps, groupContent);
                        continue block14;
                    }
                    case OVAL: {
                        new VmlObject((CTOval)objects[i]).createVmlObject(dc, part, docProps, groupContent);
                        continue block14;
                    }
                    case ROUNDRECT: {
                        new VmlObject((CTRoundRect)objects[i]).createVmlObject(dc, part, docProps, groupContent);
                        continue block14;
                    }
                    case IMAGE: {
                        new VmlObject((CTImage)objects[i]).createVmlObject(dc, part, docProps, groupContent);
                        continue block14;
                    }
                    case LINE: {
                        new VmlObject((CTLine)objects[i]).createVmlObject(dc, part, docProps, groupContent);
                        continue block14;
                    }
                    case ARC: {
                        new VmlObject((CTArc)objects[i]).createVmlObject(dc, part, docProps, groupContent);
                        continue block14;
                    }
                    case CURVE: {
                        new VmlObject((CTCurve)objects[i]).createVmlObject(dc, part, docProps, groupContent);
                        continue block14;
                    }
                    case POLYLINE: {
                        new VmlObject((CTPolyLine)objects[i]).createVmlObject(dc, part, docProps, groupContent);
                    }
                }
            }
        }
        return dc;
    }

    protected static Color getColor(String colorDefinition, Color defaultCol) {
        if (colorDefinition != null) {
            if (colorDefinition.startsWith("#")) {
                return Util.getColorFromString(colorDefinition.substring(1), Color.BLACK);
            }
            return Util.getColorByName(colorDefinition);
        }
        return defaultCol;
    }

    protected static Color getStrokeColor(String colorDefinition, List<CTStroke> strokeList, Color defaultCol) {
        CTStroke stroke;
        String opac;
        Color color = DrawingFactory.getColor(colorDefinition, defaultCol);
        if (strokeList != null && strokeList.size() > 0 && (opac = (stroke = strokeList.get(0)).getOpacity()) != null) {
            int alpha = (int)(255.0f * (1.0f - Float.parseFloat(opac)));
            color = new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
        }
        return color;
    }

    static Color getFillColor(String colorDefinition, List<CTFill> fillList) {
        CTFill fill;
        String opac;
        Color color = colorDefinition != null ? (colorDefinition.startsWith("#") ? Util.getColorFromString(colorDefinition.substring(1), Color.BLACK) : Util.getColorByName(colorDefinition)) : Color.BLACK;
        if (fillList != null && fillList.size() > 0 && (opac = (fill = fillList.get(0)).getOpacity()) != null) {
            int alpha = (int)(255.0f * (1.0f - Float.parseFloat(opac)));
            color = new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
        }
        return color;
    }

    static boolean handleImageData(List<CTImageData> imageDataList, DrawingContent dc, String shapeId) {
        if (imageDataList.size() > 0) {
            for (CTImageData imageData : imageDataList) {
                dc.setImage(imageData.getId2(), imageData.getTitle(), shapeId);
            }
            return true;
        }
        return false;
    }

    @SuppressFBWarnings(value={"UNSAFE_HASH_EQUALS"}, justification="simple string check, no secure hash check")
    static void handleShapeStyle(@Nullable String shapeStyle, DocumentProperties docProps, DrawingContent dc, @Nullable String coordinateSize, @Nullable String coordinateOrigin) {
        Map<String, String> shapeInfos;
        int[] coordOrigin;
        int[] coordSize;
        if (coordinateSize != null && !coordinateSize.trim().isEmpty() && (coordSize = VmlShapeConverter.convertValues(coordinateSize)).length == 2) {
            dc.setCoordinateSize(new Point2D.Double(coordSize[0], coordSize[1]));
        }
        if (coordinateOrigin != null && !coordinateOrigin.trim().isEmpty() && (coordOrigin = VmlShapeConverter.convertValues(coordinateOrigin)).length == 2) {
            dc.setCoordinateOrigin(new Point2D.Double(coordOrigin[0], coordOrigin[1]));
        }
        if ((shapeInfos = DrawingFactory.getStyleInformation(shapeStyle, docProps.getSettings().getListSeparator())).isEmpty()) {
            dc.setWidth(new DimensionDefinition(new UnitNumber(1000.0, UnitNumber.Unit.NONE)));
            dc.setHeight(new DimensionDefinition(new UnitNumber(1000.0, UnitNumber.Unit.NONE)));
        } else {
            String positionHorizontalRelative;
            boolean ignoreLeftAndTop = shapeInfos.get("position") == null || shapeInfos.get("position").equalsIgnoreCase("static");
            boolean ignoreLeft = "inside".equalsIgnoreCase(shapeInfos.get("mso-position-horizontal")) || "outside".equalsIgnoreCase(shapeInfos.get("mso-position-horizontal"));
            dc.setTop(ignoreLeftAndTop ? 0.0 : ParseOperations.handleValues(shapeInfos.get("top")));
            dc.setLeft(ignoreLeftAndTop || ignoreLeft ? 0.0 : ParseOperations.handleValues(shapeInfos.get("left")));
            if (shapeInfos.get("width") == null) {
                dc.setWidth(new DimensionDefinition(new UnitNumber(1000.0, UnitNumber.Unit.NONE)));
            } else {
                dc.setWidth(new DimensionDefinition(new UnitNumber(shapeInfos.get("width"), 15.0)));
            }
            if (shapeInfos.get("height") == null) {
                dc.setHeight(new DimensionDefinition(new UnitNumber(1000.0, UnitNumber.Unit.NONE)));
            } else {
                dc.setHeight(new DimensionDefinition(new UnitNumber(shapeInfos.get("height"), 15.0)));
            }
            dc.setRotation(shapeInfos.get("rotation") != null ? Double.parseDouble(shapeInfos.get("rotation")) : 0.0);
            dc.setReflection(shapeInfos.get("flip"));
            dc.setzIndex(shapeInfos.get("z-index") != null ? Long.parseLong(shapeInfos.get("z-index")) : 0L);
            String positionVertical = shapeInfos.get("position-vertical") != null ? shapeInfos.get("position-vertical") : shapeInfos.get("mso-position-vertical");
            String positionHorizontal = shapeInfos.get("position-horizontal") != null ? shapeInfos.get("position-horizontal") : shapeInfos.get("mso-position-horizontal");
            String positionVerticalRelative = shapeInfos.get("position-vertical-relative") != null ? shapeInfos.get("position-vertical-relative") : shapeInfos.get("mso-position-vertical-relative");
            String string = positionHorizontalRelative = shapeInfos.get("position-horizontal-relative") != null ? shapeInfos.get("position-horizontal-relative") : shapeInfos.get("mso-position-horizontal-relative");
            if ("page".equalsIgnoreCase(positionVerticalRelative) && shapeInfos.get("position-vertical-relative") == null && shapeInfos.get("position") != null && shapeInfos.get("position").equalsIgnoreCase("static")) {
                positionVerticalRelative = null;
            }
            if ("page".equalsIgnoreCase(positionHorizontalRelative) && shapeInfos.get("position-horizontal-relative") == null && shapeInfos.get("position") != null && shapeInfos.get("position").equalsIgnoreCase("static")) {
                positionHorizontalRelative = null;
            }
            dc.setVerticalAnchor(DrawingFactory.getAnchor(positionVertical, positionVerticalRelative, shapeInfos.get("margin-top"), true, "absolute".equals(shapeInfos.get("position"))));
            dc.setHorizontalAnchor(DrawingFactory.getAnchor(positionHorizontal, positionHorizontalRelative, shapeInfos.get("margin-left"), false, "absolute".equals(shapeInfos.get("position"))));
        }
    }

    @Nonnull
    static Map<String, String> getStyleInformation(@Nullable String style, String defaultListSeparator) {
        String[] retry;
        if (style == null) {
            return new HashMap<String, String>();
        }
        String[] entries = style.split(defaultListSeparator);
        if (entries.length == 1 && (retry = style.split(defaultListSeparator)).length > entries.length) {
            entries = retry;
        }
        return ParseOperations.splitKeyValuePairs(entries, ':');
    }

    static Anchor getAnchor(String anchorAlign, String relative, String ptValue, boolean isVertical, boolean absolute) {
        if (relative == null) {
            if (absolute) {
                relative = isVertical ? "paragraph" : "margin";
            } else {
                return null;
            }
        }
        if (anchorAlign == null) {
            anchorAlign = isVertical ? "top" : "left";
        }
        double anchorOffset = ParseOperations.handleValues(ptValue);
        return new Anchor(relative, anchorAlign, anchorOffset, false, isVertical);
    }

    static RenderFont getWatermarkRenderFont(String text, DocumentProperties docProps, Map<String, String> textInfos, float height, float length) {
        StringLayouter sl;
        RenderFont renderFont;
        float fontSize = (float)(ParseOperations.handleValues(textInfos.get("font-size")) / 20.0);
        String fontName = textInfos.get("font-family");
        if (fontName != null) {
            fontName = fontName.substring(1, fontName.length() - 1);
            fontName = docProps.getCaseSensitiveFontName(fontName);
        } else {
            fontName = docProps.getStyleDefaults().getMinorLatinFont();
        }
        String bold = textInfos.get("font-weight");
        String italic = textInfos.get("font-style");
        int fontStyle = ("bold".equals(bold) ? 1 : 0) + ("italic".equals(italic) ? 2 : 0);
        String[] rows = text.split("\n");
        if (fontSize <= 1.0f) {
            double differnce;
            height /= (float)rows.length;
            float min = 10.0f;
            float max = 600.0f;
            do {
                float current = (min + max) / 2.0f;
                renderFont = new RenderFont(fontName, current, fontStyle, null, false, false, false, 0.0, 1.0, 0);
                sl = docProps.getLayouter(renderFont);
                double calcHeight = renderFont.getRenderDimensions().getRowHeight() - 20.0;
                if ((double)height > calcHeight) {
                    differnce = (double)height - calcHeight;
                    min = current;
                    continue;
                }
                differnce = calcHeight - (double)height;
                max = current;
            } while (!(differnce < 2.0));
        } else {
            renderFont = new RenderFont(fontName, fontSize, fontStyle, null, false, false, false, 0.0, 1.0, 0);
            sl = docProps.getLayouter(renderFont);
        }
        float textLength = 0.0f;
        for (String rowText : rows) {
            textLength = Math.max(textLength, (float)sl.getTextLength(rowText));
        }
        return new RenderFont(fontName, renderFont.getFontSize(), fontStyle, null, false, false, false, 0.0, length / textLength, 0);
    }

    static TextBoxShape handleTextboxData(CTTextbox tbp, SimpleShape simShape, DocumentProperties docProps, Color defaultFontColor, IBody part) {
        CTTxbxContent tbContent = tbp.getTxbxContent();
        ArrayList<DocumentElement> textContent = new ArrayList<DocumentElement>();
        XmlCursor curs = tbContent.newCursor();
        curs.selectPath("./*");
        while (curs.toNextSelection()) {
            XmlObject obj = curs.getObject();
            if (obj instanceof CTP) {
                ParagraphData para = ParagraphFactory.readParagraph(docProps, new XWPFParagraph((CTP)obj, part), false, null);
                if (defaultFontColor != null) {
                    for (ParagraphElement pe : para.getElements()) {
                        if (!(pe instanceof TextRowElement) || ((TextRowElement)pe).getColor() != null) continue;
                        ((TextRowElement)pe).setColor(defaultFontColor);
                    }
                }
                textContent.add(para);
                continue;
            }
            if (obj instanceof CTTbl) {
                XWPFTable table = new XWPFTable((CTTbl)obj, part);
                TableData td = TableFactory.readTable(table, docProps);
                textContent.add(td);
                continue;
            }
            if (obj instanceof CTSdtBlock) {
                XWPFSDTimpl sdt = new XWPFSDTimpl((CTSdtBlock)obj, part);
                List<IBodyElement> bodyEles = sdt.getBodyElements();
                for (IBodyElement bodyEle : bodyEles) {
                    if (bodyEle instanceof XWPFTable) {
                        TableData td = TableFactory.readTable((XWPFTable)bodyEle, docProps);
                        textContent.add(td);
                        continue;
                    }
                    textContent.add(ParagraphFactory.readParagraph(docProps, (XWPFParagraph)bodyEle, false, null));
                }
                continue;
            }
            Util.LOGGER.error((Object)("Unknown Textbox sub element: " + obj.getClass().getName()));
        }
        curs.dispose();
        for (DocumentElement pa : textContent) {
            if (!(pa instanceof ParagraphData)) continue;
            while (((ParagraphData)pa).handleFields(docProps) != null) {
            }
        }
        return new TextBoxShape(simShape, textContent);
    }

    public static Drawing createRectangle(Rectangle2D bounds, Color fillColor) {
        Drawing lineDraw = new Drawing(bounds.getWidth(), bounds.getHeight());
        lineDraw.setContent(new SimpleShape(bounds, fillColor));
        lineDraw.setPageX(0.0);
        lineDraw.setPageY(0.0);
        return lineDraw;
    }
}

