/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.view;

import com.inet.docx.document.DocumentProperties;
import com.inet.docx.document.elements.DocumentElement;
import com.inet.docx.document.elements.HeaderFooter;
import com.inet.docx.document.elements.subelements.Positionable;
import com.inet.docx.document.utilities.Util;
import com.inet.docx.layout.AnchorManager;
import com.inet.docx.layout.DocumentLayouter;
import com.inet.docx.layout.LayoutArea;
import com.inet.docx.layout.LayoutElement;
import com.inet.docx.view.DefaultRenderContext;
import com.inet.docx.view.HeaderFooterView;
import com.inet.docx.view.PageElement;
import com.inet.docx.view.PageProperties;
import com.inet.docx.view.RenderContext;
import com.inet.docx.view.render.RenderBaseObject;
import com.inet.docx.view.render.RenderContainer;
import com.inet.docx.view.render.RenderUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RenderPage
extends RenderBaseObject
implements RenderContext {
    private DocumentProperties documentProperties;
    private PageProperties layout;
    private List<List<Column>> columns = new ArrayList<List<Column>>();
    private HeaderFooterView header;
    private HeaderFooterView footer;
    private int currentColumnNr;
    private Column currentColumn;
    private double currentYOffset;
    private double maxYOffset;
    private double sectionStartOffset = 0.0;
    private AnchorManager anchoredContent;
    private int inSectionPageNr;
    private int displayPageNr;
    private int totalPageNumber;
    private RenderContext.CONTEXT_TYPE contextType = RenderContext.CONTEXT_TYPE.page;
    private boolean isRelayout = false;
    private RenderContainer container = null;

    public boolean isRelayout() {
        return this.isRelayout;
    }

    public void setRelayout(boolean relayout) {
        this.isRelayout = relayout;
    }

    public HeaderFooterView getHeader() {
        return this.header;
    }

    public HeaderFooterView getFooter() {
        return this.footer;
    }

    public List<List<Column>> getColumns() {
        return this.columns;
    }

    public RenderPage(RenderContext source) {
        this(source, 0);
    }

    public RenderPage(RenderContext source, int pageOffset) {
        this.layout = source.getPageLayout();
        this.documentProperties = source.getDocumentProperties();
        this.inSectionPageNr = source.getInSectionPageNumber() + pageOffset;
        this.displayPageNr = source.getDisplayPageNumber() + pageOffset;
        this.totalPageNumber = source.getTotalPageNumber() + pageOffset;
        this.anchoredContent = new AnchorManager();
        this.initHeaderAndFooter();
        this.initNewSection(this.layout, 0.0);
        this.contextType = source.getContextType();
    }

    private RenderPage() {
    }

    public RenderPage createCopy() {
        RenderPage copy = new RenderPage();
        copy.layout = this.getPageLayout();
        copy.documentProperties = this.getDocumentProperties();
        copy.inSectionPageNr = this.getInSectionPageNumber();
        copy.displayPageNr = this.getDisplayPageNumber();
        copy.totalPageNumber = this.getTotalPageNumber();
        copy.anchoredContent = this.anchoredContent.copy();
        copy.header = this.header;
        copy.footer = this.footer;
        for (List<Column> column : this.columns) {
            ArrayList<Column> colCopy = new ArrayList<Column>();
            for (Column subCol : column) {
                Column subColCopy = new Column(subCol.width, subCol.xPosition);
                subColCopy.lines.addAll(subCol.lines);
                colCopy.add(subColCopy);
            }
            copy.columns.add(colCopy);
        }
        copy.sectionStartOffset = this.sectionStartOffset;
        copy.currentYOffset = this.currentYOffset;
        List<Column> colPart = copy.columns.get(copy.columns.size() - 1);
        copy.currentColumnNr = Math.min(this.currentColumnNr, colPart.size() - 1);
        copy.currentColumn = colPart.get(copy.currentColumnNr);
        copy.contextType = this.contextType;
        return copy;
    }

    public void initNewSection(PageProperties sectionProperties) {
        this.maxYOffset = Math.max(this.maxYOffset, this.currentYOffset + this.getRecentBottomSpacing());
        this.initNewSection(sectionProperties, this.maxYOffset);
    }

    private void initNewSection(PageProperties sectionProperties, double startYOffset) {
        ArrayList<Column> sectionColumns = new ArrayList<Column>();
        this.columns.add(sectionColumns);
        for (int i = 0; i < sectionProperties.getColumnCount(); ++i) {
            sectionColumns.add(new Column(sectionProperties.getColumnWidth(i), sectionProperties.getColumnXPos(i)));
        }
        this.currentColumnNr = 0;
        this.sectionStartOffset = startYOffset;
        this.currentYOffset = startYOffset;
        this.currentColumn = (Column)sectionColumns.get(0);
    }

    @Override
    public DocumentProperties getDocumentProperties() {
        return this.documentProperties;
    }

    private void initHeaderAndFooter() {
        if (this.documentProperties != null) {
            this.header = RenderPage.prepareHeaderOrFooter(this, this.documentProperties, true);
            this.footer = RenderPage.prepareHeaderOrFooter(this, this.documentProperties, false);
        }
    }

    private static HeaderFooter getHeaderFooterForPage(Map<String, HeaderFooter> hfs, int pageNr, boolean useFirstPageSettings, boolean evenAndOddHeaders, boolean isFirstPageOfSection) {
        if (hfs == null || hfs.isEmpty()) {
            return null;
        }
        if (useFirstPageSettings && isFirstPageOfSection) {
            return hfs.get("first");
        }
        if (!evenAndOddHeaders || pageNr % 2 == 1) {
            HeaderFooter hf = hfs.get("odd");
            if (hf == null) {
                hf = hfs.get("default");
            }
            return hf;
        }
        return hfs.get("even");
    }

    private static HeaderFooterView prepareHeaderOrFooter(RenderPage renderPage, DocumentProperties documentProperties, boolean header) {
        PageProperties pageLayout = renderPage.layout;
        Map<String, HeaderFooter> hfs = documentProperties.getHeaderFooter(header, header ? pageLayout.getHeaderReferenceKeys() : pageLayout.getFooterReferenceKeys());
        HeaderFooter hf = RenderPage.getHeaderFooterForPage(hfs, renderPage.getDisplayPageNumber(), pageLayout.useFirstPageHeaderAndFooter(), documentProperties.isUseOddAndEvenParts(), renderPage.getInSectionPageNumber() == 1);
        if (hf != null && !hf.isEmpty()) {
            List<DocumentElement> data = hf.getElements();
            HeaderFooterView hfView = new HeaderFooterView();
            int marginTop = header ? pageLayout.getHeaderTop() : pageLayout.getMarginTop();
            int marginBottom = header ? pageLayout.getMarginBottom() : pageLayout.getFooterBottom();
            PageProperties mockLayout = new PageProperties(pageLayout.getPageWidth(), pageLayout.getPageHeight() - marginTop - marginBottom, new Insets(0, pageLayout.getMarginLeft(), 0, pageLayout.getMarginRight()));
            List<RenderPage> pages = DocumentLayouter.layoutElements(data, new DefaultRenderContext(documentProperties, mockLayout, renderPage, RenderContext.CONTEXT_TYPE.headerFooter), false);
            RenderPage hfPage = pages.get(0);
            List<PageElement> headerContent = hfPage.getAllElements();
            double sectionSize = hfPage.getCurrentColumnContentHeight();
            double yOffset = header ? (double)pageLayout.getHeaderTop() : (double)(pageLayout.getPageHeight() - pageLayout.getFooterBottom()) - sectionSize;
            for (LayoutElement layoutElement : headerContent) {
                if (layoutElement instanceof Positionable) {
                    Positionable prd = (Positionable)((Object)layoutElement);
                    prd.move(0.0, yOffset);
                } else {
                    Util.LOGGER.error((Object)layoutElement.getClass().getName());
                }
                hfView.addLayoutElement(layoutElement, renderPage);
            }
            if (header) {
                pageLayout.setHeaderSize((int)Math.ceil(sectionSize));
            } else {
                pageLayout.setFooterSize((int)Math.ceil(sectionSize));
            }
            return hfView;
        }
        return null;
    }

    @Override
    public PageProperties getPageLayout() {
        return this.layout;
    }

    public boolean isPageCompleted() {
        return this.currentColumnNr >= this.getCurrentSection().size() || this.getRenderHeight() <= this.currentYOffset;
    }

    private List<Column> getCurrentSection() {
        return this.columns.get(this.columns.size() - 1);
    }

    private double getTopPartHeight() {
        double hh = 0.0;
        if (this.header != null) {
            hh = this.header.getHeight();
        }
        double minHeightTop = hh > 0.0 ? (double)this.layout.getHeaderTop() + hh : 0.0;
        return Math.max((double)this.layout.getMarginTop(), minHeightTop);
    }

    private double getEndPartHeight() {
        double fh = 0.0;
        if (this.footer != null) {
            fh = this.footer.getHeight();
        }
        double minHeightBottom = (double)this.layout.getFooterBottom() + fh;
        return Math.max((double)this.layout.getMarginBottom(), minHeightBottom);
    }

    public RenderContainer getContainer() {
        if (this.container == null) {
            this.container = RenderUtil.convertToDrawobject(this);
        }
        return this.container;
    }

    public double getRenderHeight() {
        return (double)this.layout.getPageHeight() - this.getTopPartHeight() - this.getEndPartHeight();
    }

    public int getRenderWidth() {
        return this.currentColumn.width;
    }

    public int getCurrentXPos() {
        return this.currentColumn.xPosition;
    }

    public void nextColumn() throws IllegalStateException {
        ++this.currentColumnNr;
        this.maxYOffset = Math.max(this.maxYOffset, this.getCurrentColumnContentHeight());
        int columnCount = this.getCurrentSection().size();
        if (this.currentColumnNr > columnCount) {
            throw new IllegalStateException("Cannot switch to column index " + this.currentColumnNr + " since there are only " + columnCount + " columns available");
        }
        if (this.currentColumnNr < columnCount) {
            this.currentColumn = this.getCurrentSection().get(this.currentColumnNr);
        }
        this.currentYOffset = this.sectionStartOffset;
    }

    public int getColumnElementCount() {
        return this.currentColumn.lines.size();
    }

    public double getCurrentColumnContentHeight() {
        return this.currentYOffset + this.getRecentBottomSpacing();
    }

    public void addElement(PageElement pageElement) {
        this.currentColumn.lines.add(pageElement);
        this.currentYOffset += pageElement.getHeight();
    }

    public void removeElements(DocumentElement removePosition) {
        if (removePosition == null) {
            this.currentColumnNr = 0;
            this.currentYOffset = 0.0;
            for (Column column : this.getCurrentSection()) {
                column.lines.clear();
            }
            return;
        }
        PageElement startRemoveElement = null;
        for (Column column : this.getCurrentSection()) {
            if (startRemoveElement != null) {
                column.lines.clear();
                continue;
            }
            boolean hasStarted = false;
            ArrayList<PageElement> removeElements = new ArrayList<PageElement>();
            for (PageElement line : column.lines) {
                if (line.getSource() == removePosition) {
                    startRemoveElement = line;
                    hasStarted = true;
                    this.currentColumnNr = this.getCurrentSection().indexOf(column);
                    this.currentYOffset = line.getBounds().getY();
                }
                if (!hasStarted) continue;
                removeElements.add(line);
            }
            column.lines.removeAll(removeElements);
        }
    }

    private double getRecentBottomSpacing() {
        if (this.currentColumn.lines.size() > 0) {
            PageElement prev = this.currentColumn.lines.get(this.currentColumn.lines.size() - 1);
            return prev.getSpacingBottom();
        }
        return 0.0;
    }

    public LayoutArea getAvailableColumnSpace(double upcommingTopSpacing) {
        upcommingTopSpacing = !this.contextType.canBreakPage() || this.currentColumn.lines.size() > 0 || this.currentColumnNr == 0 && this.getInSectionPageNumber() == 1 ? Math.max(upcommingTopSpacing, this.getRecentBottomSpacing()) : 0.0;
        double contentSize = this.currentYOffset + upcommingTopSpacing;
        double y = this.getTopPartHeight() + contentSize;
        double h = this.getRenderHeight() - this.currentYOffset - upcommingTopSpacing;
        this.currentYOffset += upcommingTopSpacing;
        List<PageElement> lines = this.currentColumn.lines;
        if (lines.size() > 0) {
            return new LayoutArea(this.getCurrentXPos(), y, this.getRenderWidth(), h);
        }
        return new LayoutArea(this.getCurrentXPos(), y, this.getRenderWidth(), h, this.currentColumnNr == 0);
    }

    @Override
    public int getDisplayPageNumber() {
        return this.displayPageNr;
    }

    @Override
    public int getInSectionPageNumber() {
        return this.inSectionPageNr;
    }

    @Override
    public int getTotalPageNumber() {
        return this.totalPageNumber;
    }

    public String toString() {
        return "RenderPage{documentProperties=" + String.valueOf(this.documentProperties) + ", props=" + String.valueOf(this.layout) + ", columns=" + String.valueOf(this.columns) + ", currentColumn=" + String.valueOf(this.currentColumn) + ", inSectionPageNr=" + this.inSectionPageNr + ", totalPageNumber=" + this.totalPageNumber + ", currentYOffset=" + this.currentYOffset + "}";
    }

    public AnchorManager getAnchorManager() {
        return this.anchoredContent;
    }

    public List<PageElement> getAllElements() {
        ArrayList<PageElement> elements = new ArrayList<PageElement>();
        this.columns.forEach(list -> list.forEach(col -> elements.addAll(col.lines)));
        return elements;
    }

    @Override
    public RenderContext.CONTEXT_TYPE getContextType() {
        return this.contextType;
    }

    @Override
    public void renderPage(Graphics2D graphicsOutput, Rectangle2D imgBounds) {
        graphicsOutput.setColor(Color.WHITE);
        double scaleX = imgBounds.getWidth() / (double)((float)Util.convertTwipsToPoint(this.layout.getPageWidth()));
        double scaleY = imgBounds.getHeight() / (double)((float)Util.convertTwipsToPoint(this.layout.getPageHeight()));
        graphicsOutput.fillRect(0, 0, (int)imgBounds.getWidth(), (int)imgBounds.getHeight());
        graphicsOutput.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphicsOutput.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphicsOutput.scale(scaleX, scaleY);
        this.getContainer().renderPage(graphicsOutput, imgBounds);
    }

    public class Column {
        private List<PageElement> lines = new ArrayList<PageElement>();
        private int width;
        private int xPosition;

        public List<PageElement> getLines() {
            return this.lines;
        }

        public int getWidth() {
            return this.width;
        }

        public int getxPosition() {
            return this.xPosition;
        }

        public Column(int width, int xPosition) {
            this.width = width;
            this.xPosition = xPosition;
        }
    }
}

