/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.view;

import com.inet.docx.document.DocumentProperties;
import com.inet.docx.document.elements.subelements.BorderLines;
import com.inet.docx.document.utilities.Util;
import com.inet.docx.view.AreaObjects;
import com.inet.docx.view.drawing.DrawingFactory;
import java.awt.Insets;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.xmlbeans.XmlTokenSource;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBorder;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTColumn;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTColumns;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHdrFtrRef;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPageBorders;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPageMar;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPageNumber;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPageSz;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSectPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSectType;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STHdrFtr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STNumberFormat;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STPageOrientation;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STSectionMark;

public class PageProperties {
    private boolean useFirstPageHeaderAndFooter = false;
    private Integer pageNumberStart;
    private int pageWidth;
    private int pageHeight;
    private int marginTop;
    private int marginLeft;
    private int marginRight;
    private int marginBottom;
    private int headerTop;
    private int headerSize = 0;
    private int footerBottom;
    private int footerSize = 0;
    private int columnCount = 1;
    private int[] columnWidths;
    private int[] columnSpaces;
    private List<String[]> headerReferences;
    private List<String[]> footerReferences;
    private BorderLines borders;
    private STNumberFormat.Enum numberFormat;
    private STSectionMark.Enum sectionType;

    private PageProperties() {
    }

    public PageProperties(int width, int height, Insets margins) {
        this.pageWidth = width;
        this.pageHeight = height;
        this.marginTop = margins.top;
        this.marginBottom = margins.bottom;
        this.marginLeft = margins.left;
        this.marginRight = margins.right;
        this.headerReferences = new ArrayList<String[]>();
        this.footerReferences = new ArrayList<String[]>();
        this.columnWidths = new int[]{width - this.marginLeft - this.marginRight};
        this.columnSpaces = new int[]{0};
    }

    public PageProperties(CTSectPr section, DocumentProperties props) {
        CTPageBorders pgBor;
        CTSectType secType = section.getType();
        if (secType != null) {
            this.sectionType = secType.getVal();
        }
        if (section.isSetTitlePg()) {
            this.useFirstPageHeaderAndFooter = true;
        }
        this.pageNumberStart = props.getPageNumberStart();
        CTPageNumber pn = section.getPgNumType();
        if (pn != null) {
            if (pn.getStart() != null) {
                this.pageNumberStart = pn.getStart().intValue();
            }
            this.numberFormat = pn.isSetFmt() ? pn.getFmt() : null;
        }
        List headers = section.getHeaderReferenceList();
        this.headerReferences = new ArrayList<String[]>();
        for (int i = 0; i < headers.size(); ++i) {
            String[] headerReference = new String[2];
            CTHdrFtrRef hdRef = (CTHdrFtrRef)headers.get(i);
            headerReference[0] = hdRef.getId();
            STHdrFtr.Enum type = hdRef.getType();
            headerReference[1] = type != null ? type.toString() : "default";
            this.headerReferences.add(headerReference);
        }
        List footers = section.getFooterReferenceList();
        this.footerReferences = new ArrayList<String[]>();
        for (int i = 0; i < footers.size(); ++i) {
            String[] footerReference = new String[2];
            CTHdrFtrRef ftRef = (CTHdrFtrRef)footers.get(i);
            footerReference[0] = ftRef.getId();
            STHdrFtr.Enum type = ftRef.getType();
            footerReference[1] = type != null ? type.toString() : "default";
            this.footerReferences.add(footerReference);
        }
        CTPageSz pageSize = section.getPgSz();
        this.pageWidth = Util.getInt(pageSize.getW());
        this.pageHeight = Util.getInt(pageSize.getH());
        STPageOrientation.Enum orient = pageSize.getOrient();
        CTPageMar pageMargins = section.getPgMar();
        this.marginTop = Util.readIntAttribute((XmlTokenSource)pageMargins, "top");
        this.marginLeft = Util.readIntAttribute((XmlTokenSource)pageMargins, "left");
        this.marginRight = Util.readIntAttribute((XmlTokenSource)pageMargins, "right");
        this.marginBottom = Util.readIntegerAttribute((XmlTokenSource)pageMargins, "bottom");
        this.headerTop = Util.readIntAttribute((XmlTokenSource)pageMargins, "header");
        this.footerBottom = Util.readIntAttribute((XmlTokenSource)pageMargins, "footer");
        CTColumns cols = section.getCols();
        if (cols != null) {
            this.columnCount = Util.getValueIfNotNull(cols.getNum(), 1);
            int columnSpace = Util.getInt(cols.getSpace());
            if (this.columnCount >= 1) {
                List colData = cols.getColList();
                this.columnWidths = new int[this.columnCount];
                this.columnSpaces = new int[this.columnCount];
                if (colData != null && colData.size() >= this.columnCount) {
                    for (int i = 0; i < this.columnCount; ++i) {
                        this.columnWidths[i] = Util.getInt(((CTColumn)colData.get(i)).getW());
                        Object spaceValue = ((CTColumn)colData.get(i)).getSpace();
                        this.columnSpaces[i] = spaceValue != null ? Util.getInt(spaceValue) : columnSpace;
                    }
                } else {
                    int sameWidth = (this.pageWidth - this.marginRight - this.marginLeft - (this.columnCount - 1) * columnSpace) / this.columnCount;
                    for (int i = 0; i < this.columnCount; ++i) {
                        this.columnWidths[i] = sameWidth;
                        this.columnSpaces[i] = columnSpace;
                    }
                }
            }
        }
        if (this.columnWidths == null) {
            this.columnWidths = new int[]{this.pageWidth - this.marginRight - this.marginLeft};
            this.columnSpaces = new int[]{0};
        }
        if ((pgBor = section.getPgBorders()) != null) {
            this.borders = new BorderLines();
            this.borders.setLeftLine(Util.getLinePropertiesFromBorder((CTBorder)pgBor.getLeft(), props.getThemeColors()));
            this.borders.setTopLine(Util.getLinePropertiesFromBorder((CTBorder)pgBor.getTop(), props.getThemeColors()));
            this.borders.setRightLine(Util.getLinePropertiesFromBorder((CTBorder)pgBor.getRight(), props.getThemeColors()));
            this.borders.setBottomLine(Util.getLinePropertiesFromBorder((CTBorder)pgBor.getBottom(), props.getThemeColors()));
        }
    }

    @Nullable
    public BorderLines getBorders() {
        return this.borders;
    }

    public STSectionMark.Enum getSectionType() {
        return this.sectionType;
    }

    public STNumberFormat.Enum getNumberFormat() {
        return this.numberFormat;
    }

    protected boolean useFirstPageHeaderAndFooter() {
        return this.useFirstPageHeaderAndFooter;
    }

    public void mergeHeaderAndFooterData(PageProperties nextProps) {
        this.mergeData(this.headerReferences, nextProps.headerReferences);
        this.mergeData(this.footerReferences, nextProps.footerReferences);
    }

    private void mergeData(List<String[]> master, List<String[]> dependent) {
        for (String[] entry : master) {
            boolean contains = false;
            for (String[] subEntry : dependent) {
                if (!entry[1].equals(subEntry[1])) continue;
                contains = true;
                break;
            }
            if (contains) continue;
            dependent.add(entry);
        }
    }

    protected void handleElementsFromProperties(AreaObjects elements) {
        if (this.borders == null) {
            return;
        }
        double y = Util.convertTwipsToPoint(this.borders.getTopLine() != null ? this.borders.getTopLine().getSpace() : 0.0);
        double x = Util.convertTwipsToPoint(this.borders.getLeftLine() != null ? this.borders.getLeftLine().getSpace() : 0.0);
        double height = Util.convertTwipsToPoint((double)this.pageHeight - (this.borders.getBottomLine() != null ? this.borders.getBottomLine().getSpace() : 0.0) - y);
        double width = Util.convertTwipsToPoint((double)this.pageWidth - (this.borders.getRightLine() != null ? this.borders.getRightLine().getSpace() : 0.0) - x);
        Rectangle2D.Double bounds = new Rectangle2D.Double(x, y, width, height);
        DrawingFactory.createBorderLines(this.borders, bounds, elements);
    }

    public List<String[]> getFooterReferenceKeys() {
        return this.footerReferences;
    }

    public List<String[]> getHeaderReferenceKeys() {
        return this.headerReferences;
    }

    public int getPageWidth() {
        return this.pageWidth;
    }

    public int getPageHeight() {
        return this.pageHeight;
    }

    public int getMarginTop() {
        return this.headerSize > 0 ? Math.max(this.marginTop, this.headerSize + this.headerTop) : this.marginTop;
    }

    public int getMarginTopIgnoringHeader() {
        return this.marginTop;
    }

    public int getMarginLeft() {
        return this.marginLeft;
    }

    public int getMarginRight() {
        return this.marginRight;
    }

    public int getMarginBottom() {
        return this.footerSize != 0 ? Math.max(this.marginBottom, this.footerBottom + this.footerSize) : this.marginBottom;
    }

    public int getMarginBottomIgnoringFooter() {
        return this.marginBottom;
    }

    public int getHeaderTop() {
        return this.headerTop;
    }

    public int getFooterBottom() {
        return this.footerBottom;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public int getColumnWidth(int colNr) {
        return this.columnWidths[colNr];
    }

    public Integer getPageNumberOffset() {
        return this.pageNumberStart;
    }

    public int getColumnXPos(int column) {
        int x = this.getMarginLeft();
        for (int i = 0; i < column; ++i) {
            x += this.getColumnWidth(i) + this.columnSpaces[i];
        }
        return x;
    }

    public String toString() {
        return "PageProperties{pageWidth=" + this.pageWidth + ", pageHeight=" + this.pageHeight + ", marginTop=" + this.marginTop + ", marginLeft=" + this.marginLeft + ", marginRight=" + this.marginRight + ", marginBottom=" + this.marginBottom + ", headerSize=" + this.headerSize + ", footerSize=" + this.footerSize + ", columnCount=" + this.columnCount + ", columnWidths=" + Arrays.toString(this.columnWidths) + ", columnSpaces=" + Arrays.toString(this.columnSpaces) + ", sectionType=" + String.valueOf(this.sectionType) + "}";
    }

    public void setHeaderSize(int headerSize) {
        this.headerSize = headerSize;
    }

    public void setFooterSize(int footerSize) {
        this.footerSize = footerSize;
    }

    public PageProperties clone() {
        PageProperties theClone = new PageProperties();
        theClone.pageNumberStart = this.pageNumberStart;
        theClone.pageWidth = this.pageWidth;
        theClone.pageHeight = this.pageHeight;
        theClone.marginTop = this.marginTop;
        theClone.marginLeft = this.marginLeft;
        theClone.marginRight = this.marginRight;
        theClone.marginBottom = this.marginBottom;
        theClone.headerTop = this.headerTop;
        theClone.footerBottom = this.footerBottom;
        theClone.columnCount = this.columnCount;
        theClone.columnWidths = this.columnWidths;
        theClone.columnSpaces = this.columnSpaces;
        theClone.headerReferences = this.headerReferences;
        theClone.footerReferences = this.footerReferences;
        theClone.borders = this.borders;
        theClone.useFirstPageHeaderAndFooter = this.useFirstPageHeaderAndFooter;
        theClone.numberFormat = this.numberFormat;
        theClone.sectionType = this.sectionType;
        theClone.headerSize = this.headerSize;
        theClone.footerSize = this.footerSize;
        return theClone;
    }
}

