/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.view;

import com.inet.docx.document.utilities.Util;
import com.inet.docx.view.drawing.DrawingReflection;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import org.apache.poi.util.Dimension2DDouble;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTDouble;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTLayout;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTManualLayout;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGroupTransform2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPoint2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPositiveSize2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTransform2D;

public class ObjectSizeAndPosition {
    private Dimension2DDouble objectSize;
    private Dimension2DDouble chObjectSize;
    private Point2D objectPosition;
    private Point2D chPosition;
    private double rotation;
    private double xPosPercent;
    private double yPosPercent;
    private double heightPercent;
    private double widthPercent;
    private boolean manualLayout = false;
    private boolean flipH = false;
    private boolean flipV = false;

    @Deprecated
    public ObjectSizeAndPosition(Dimension objectSize, Point2D objectPosition) {
        this(new Dimension2DDouble(objectSize.getWidth(), objectSize.getHeight()), objectPosition);
    }

    public ObjectSizeAndPosition(Dimension2DDouble objectSize, Point2D objectPosition) {
        this.objectSize = objectSize;
        this.objectPosition = objectPosition;
    }

    public ObjectSizeAndPosition(CTGroupTransform2D groupTransform) {
        this(groupTransform.getExt(), groupTransform.getChExt(), groupTransform.getOff(), groupTransform.getChOff(), groupTransform.getRot());
        try {
            this.flipH = groupTransform.getFlipH();
            this.flipV = groupTransform.getFlipV();
        }
        catch (Exception ex) {
            Util.LOGGER.warn((Object)("An unexpected error occurred. Some elements not visible. Please send your documents to the support.\nError = " + String.valueOf(ex) + "\nCause = " + Arrays.toString(ex.getStackTrace())));
        }
    }

    public ObjectSizeAndPosition(CTTransform2D transform) {
        this(transform.getExt(), null, transform.getOff(), transform.getOff(), transform.getRot());
        try {
            this.flipH = transform.getFlipH();
            this.flipV = transform.getFlipV();
        }
        catch (Exception ex) {
            Util.LOGGER.warn((Object)("An unexpected error occurred. Some elements not visible. Please send your documents to the support.\nError = " + String.valueOf(ex) + "\nCause = " + Arrays.toString(ex.getStackTrace())));
        }
    }

    private ObjectSizeAndPosition(CTPositiveSize2D ext, CTPositiveSize2D chExt, CTPoint2D off, CTPoint2D chOff, int rot) {
        try {
            if (ext != null) {
                this.objectSize = ObjectSizeAndPosition.getSize(ext);
            }
            if (chExt != null) {
                this.chObjectSize = ObjectSizeAndPosition.getSize(chExt);
            }
            if (off != null) {
                this.objectPosition = ObjectSizeAndPosition.getPoint(off);
            }
            if (chOff != null) {
                this.chPosition = ObjectSizeAndPosition.getPoint(chOff);
            }
            this.rotation = (double)rot / 60000.0;
        }
        catch (Exception ex) {
            Util.LOGGER.warn((Object)("An unexpected error occurred. Some elements not visible. Please send your documents to the support.\nError = " + String.valueOf(ex) + "\nCause = " + Arrays.toString(ex.getStackTrace())));
        }
    }

    public ObjectSizeAndPosition(CTLayout ctl) {
        CTManualLayout mLayout;
        if (ctl != null && (mLayout = ctl.getManualLayout()) != null) {
            this.xPosPercent = ObjectSizeAndPosition.getValue(mLayout.getX());
            this.yPosPercent = ObjectSizeAndPosition.getValue(mLayout.getY());
            this.widthPercent = ObjectSizeAndPosition.getValue(mLayout.getW());
            this.heightPercent = ObjectSizeAndPosition.getValue(mLayout.getH());
            this.manualLayout = true;
        }
    }

    public void calcSizeAndPosition(double width, double height) {
        this.objectPosition = new Point2D.Double(width * this.xPosPercent, height * this.yPosPercent);
        if (this.heightPercent != 0.0 && this.widthPercent != 0.0) {
            this.objectSize = new Dimension2DDouble((double)((int)(width * this.widthPercent)), (double)((int)(height * this.heightPercent)));
        }
    }

    public Point2D getChPosition() {
        return this.chPosition;
    }

    public Point2D getPosition() {
        if (this.objectPosition == null) {
            return new Point2D.Double(0.0, 0.0);
        }
        return this.objectPosition;
    }

    public double getScalingX() {
        if (this.objectSize != null && this.chObjectSize != null && this.objectSize.getWidth() != 0.0 && this.chObjectSize.getWidth() != 0.0) {
            return this.objectSize.getWidth() / this.chObjectSize.getWidth();
        }
        return 1.0;
    }

    public double getScalingY() {
        if (this.objectSize != null && this.chObjectSize != null && this.objectSize.getHeight() != 0.0 && this.chObjectSize.getHeight() != 0.0) {
            return this.objectSize.getHeight() / this.chObjectSize.getHeight();
        }
        return 1.0;
    }

    public void setPosition(Point2D position) {
        this.objectPosition = position;
    }

    public double getRotation() {
        return this.rotation;
    }

    public Dimension getSize() {
        return new Dimension((int)this.objectSize.getWidth(), (int)this.objectSize.getHeight());
    }

    public void setSize(Dimension objectSize) {
        this.objectSize = new Dimension2DDouble(objectSize.getWidth(), objectSize.getHeight());
    }

    public boolean isManualLayout() {
        return this.manualLayout;
    }

    private static double getValue(CTDouble dbl) {
        return dbl != null ? dbl.getVal() : 0.0;
    }

    private static Point2D getPoint(CTPoint2D p2d) {
        double x = 1.0 * Util.getDouble(p2d.getX()) / 635.0;
        double y = 1.0 * Util.getDouble(p2d.getY()) / 635.0;
        if (x > 0.0 || y > 0.0) {
            return new Point2D.Double(x, y);
        }
        return null;
    }

    private static Dimension2DDouble getSize(CTPositiveSize2D s2d) {
        double width = s2d.getCx();
        double height = s2d.getCy();
        if (width > 0.0 || height > 0.0) {
            return new Dimension2DDouble(width / 635.0, height / 635.0);
        }
        return null;
    }

    public Rectangle2D getBounds() {
        try {
            return new Rectangle2D.Double(this.getPosition().getX(), this.getPosition().getY(), this.objectSize.getWidth(), this.objectSize.getHeight());
        }
        catch (Exception ex) {
            Util.LOGGER.warn((Object)("An unexpected error occurred. Some elements not visible. Please send your documents to the support.\nError = " + String.valueOf(ex) + "\nCause = " + Arrays.toString(ex.getStackTrace())));
            return new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        }
    }

    public ObjectSizeAndPosition clone() {
        Dimension2DDouble dim = null;
        if (this.objectSize != null) {
            dim = new Dimension2DDouble(this.objectSize.getWidth(), this.objectSize.getHeight());
        }
        Point2D.Double pt = null;
        if (this.objectPosition != null) {
            pt = new Point2D.Double(this.objectPosition.getX(), this.objectPosition.getY());
        }
        ObjectSizeAndPosition osp = new ObjectSizeAndPosition(dim, pt);
        osp.rotation = this.rotation;
        osp.flipV = this.flipV;
        osp.flipH = this.flipH;
        return osp;
    }

    public DrawingReflection getReflection() {
        if (this.flipH && this.flipV) {
            return DrawingReflection.BOTH;
        }
        if (this.flipV) {
            return DrawingReflection.VERTICAL;
        }
        if (this.flipH) {
            return DrawingReflection.HORIZONTAL;
        }
        return DrawingReflection.NONE;
    }

    public String toString() {
        return "ObjectSizeAndPosition{objectSize=" + String.valueOf(this.objectSize) + ", chObjectSize=" + String.valueOf(this.chObjectSize) + ", objectPosition=" + String.valueOf(this.objectPosition) + ", chPosition=" + String.valueOf(this.chPosition) + ", rotation=" + this.rotation + ", xPosPercent=" + this.xPosPercent + ", yPosPercent=" + this.yPosPercent + ", heightPercent=" + this.heightPercent + ", widthPercent=" + this.widthPercent + ", manualLayout=" + this.manualLayout + ", flipH=" + this.flipH + ", flipV=" + this.flipV + "}";
    }
}

