/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.view;

import com.inet.docx.document.DocumentProperties;
import com.inet.docx.view.PageProperties;
import com.inet.docx.view.RenderContext;

public class DefaultRenderContext
implements RenderContext {
    private DocumentProperties documentProperties;
    private PageProperties defaultPageProperties;
    private int counter;
    private int inSectionPageNumber;
    private int displayPageNumber;
    private int totalPageNumber;
    private RenderContext.CONTEXT_TYPE contextType;

    public DefaultRenderContext(DocumentProperties documentProperties, PageProperties defaultPageProperties, RenderContext sourceContext, RenderContext.CONTEXT_TYPE contextType) {
        this(documentProperties, defaultPageProperties, sourceContext.getInSectionPageNumber(), sourceContext.getDisplayPageNumber(), sourceContext.getTotalPageNumber(), contextType);
    }

    public DefaultRenderContext(DocumentProperties documentProperties, PageProperties defaultPageProperties, int inSectionPageNumber, int displayPageNumber, int totalPageNumber, RenderContext.CONTEXT_TYPE contextType) {
        this.documentProperties = documentProperties;
        this.defaultPageProperties = defaultPageProperties;
        this.inSectionPageNumber = inSectionPageNumber;
        this.displayPageNumber = displayPageNumber;
        this.totalPageNumber = totalPageNumber;
        this.contextType = contextType;
    }

    @Override
    public DocumentProperties getDocumentProperties() {
        return this.documentProperties;
    }

    @Override
    public PageProperties getPageLayout() {
        return this.defaultPageProperties;
    }

    @Override
    public int getDisplayPageNumber() {
        return this.displayPageNumber + this.counter;
    }

    @Override
    public int getInSectionPageNumber() {
        return this.inSectionPageNumber + this.counter;
    }

    @Override
    public int getTotalPageNumber() {
        return this.totalPageNumber + this.counter;
    }

    public void addPages(int pages) {
        this.counter += pages;
    }

    public String toString() {
        return "DefaultRenderContext{documentProperties=" + String.valueOf(this.documentProperties) + ", defaultPageProperties=" + String.valueOf(this.defaultPageProperties) + ", counter=" + this.counter + ", inSectionPageNumber=" + this.inSectionPageNumber + ", displayPageNumber=" + this.displayPageNumber + ", totalPageNumber=" + this.totalPageNumber + "}";
    }

    @Override
    public RenderContext.CONTEXT_TYPE getContextType() {
        return this.contextType;
    }
}

