/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.layout;

import com.inet.docx.document.DocumentProperties;
import com.inet.docx.document.elements.style.Indent;
import com.inet.docx.document.elements.style.RenderFont;
import com.inet.docx.document.elements.style.Spacing;
import com.inet.docx.document.elements.style.TabStop;
import com.inet.docx.document.elements.subelements.Break;
import com.inet.docx.document.elements.subelements.Drawing;
import com.inet.docx.document.elements.subelements.Field;
import com.inet.docx.document.elements.subelements.NumberingInfo;
import com.inet.docx.document.elements.subelements.ParagraphElement;
import com.inet.docx.document.elements.subelements.Positionable;
import com.inet.docx.document.elements.subelements.Tab;
import com.inet.docx.document.elements.subelements.TextRowElement;
import com.inet.docx.document.elements.subelements.drawing.Anchor;
import com.inet.docx.document.elements.subelements.drawing.TextWrapping;
import com.inet.docx.document.paragraph.ParagraphData;
import com.inet.docx.document.paragraph.StringLayouter;
import com.inet.docx.document.utilities.Util;
import com.inet.docx.layout.AnchorManager;
import com.inet.docx.layout.LayoutArea;
import com.inet.docx.layout.Layouter;
import com.inet.docx.layout.LayouterResult;
import com.inet.docx.view.AreaObjects;
import com.inet.docx.view.RenderContext;
import com.inet.docx.view.RenderPage;
import com.inet.docx.view.drawing.DrawingElement;
import com.inet.docx.view.drawing.SimpleShape;
import com.inet.docx.view.paragraph.ParagraphPageBreakPosition;
import com.inet.docx.view.paragraph.ParagraphRow;
import com.inet.docx.view.paragraph.ParagraphView;
import com.inet.docx.view.paragraph.RowTextPiece;
import com.inet.docx.view.table.CellPageBreakPosition;
import java.awt.Color;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STJc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STTabJc;

public class ParagraphLayouter
implements Layouter<ParagraphView> {
    private static final Color EMPTYCOLOR = new Color(0, 0, 0, 0);
    public static final char TAB = '\t';
    public static final char LINEBREAK = '\n';
    public static final char WHITESPACE = ' ';
    public static final char WORDBOUNDARYCHARACTER = '-';
    public static final char PAGEBREAK = '\uf000';
    public static final char COLUMNBREAK = '\uf001';
    public static final char DRAWINGOBJECT = '\uf0ff';
    private final ParagraphData paragraphData;

    public ParagraphLayouter(ParagraphData paragraphData) {
        this.paragraphData = paragraphData;
    }

    @Override
    public LayouterResult<ParagraphView> doLayouter(CellPageBreakPosition startBreak, CellPageBreakPosition endBreak, LayoutArea layoutArea, RenderContext context, AnchorManager anchors, boolean isFirstPageContent) {
        TabStop tabStop = new TabStop(context.getDocumentProperties(), context.getPageLayout(), this.paragraphData.getCustomnizeTabs(), this.paragraphData.getIndent());
        ParagraphPageBreakPosition start = startBreak != null ? startBreak.getParagraphBreakInfo() : null;
        ParagraphPageBreakPosition end = endBreak != null ? endBreak.getParagraphBreakInfo() : null;
        this.paragraphData.setFirstContent(isFirstPageContent);
        return ParagraphLayouter.doParagraphLayout(this.paragraphData, start, end, layoutArea, context, anchors, tabStop);
    }

    public static ParagraphLayoutResult doParagraphLayout(ParagraphData pa, ParagraphPageBreakPosition pBreak, ParagraphPageBreakPosition end, LayoutArea bounds, RenderContext context, AnchorManager anchors, TabStop tabStop) {
        Indent indent = pa.getIndent();
        if (indent.getLeft() != 0) {
            double indentLeft = indent.getLeft() - indent.getHanging();
            bounds.setRect(bounds.getX() + indentLeft, bounds.getY(), bounds.getWidth() - indentLeft, bounds.getHeight());
        }
        if (indent.getRight() != 0) {
            bounds.setRect(bounds.getX(), bounds.getY(), bounds.getWidth() - (double)indent.getRight(), bounds.getHeight());
        }
        if (bounds.getWidth() < 0.0) {
            bounds.setRect(bounds.getX() + bounds.getWidth(), bounds.getY(), bounds.getWidth() * -1.0, bounds.getHeight());
        }
        ParagraphView prd = new ParagraphView(pa, bounds.x, bounds.y, bounds.getWidth());
        if (pa.isStartOnNewPage() && pBreak == null && !pa.isFirstContent() && context.getContextType().canBreakPage() && !((RenderPage)context).isRelayout()) {
            return new ParagraphLayoutResult(prd, new ParagraphPageBreakPosition(0, 0), Break.BreakType.page, false);
        }
        LayoutState state = new LayoutState(prd, bounds, pBreak);
        Rectangle2D.Double maxParagraphRange = new Rectangle2D.Double(state.xStart, state.yStart, state.maxWidth, state.maxHeight);
        List<ParagraphElement> textElements = ParagraphLayouter.getConvertedList(pa, context);
        List<FragmentInformation> fragmentInformations = ParagraphLayouter.convertToFragmentInfos(textElements, context.getDocumentProperties(), pBreak, end, pa.getSpacing().getSpacingFactor());
        List<PositionedParagraphElement> paragraphElementPieces = ParagraphLayouter.calcTextLayout(fragmentInformations, context, maxParagraphRange, anchors, tabStop, indent.getFirtsLine() - indent.getHanging(), ParagraphLayouter.isFirstLine(pa, pBreak), pa);
        ParagraphPageBreakPosition breakPosition = null;
        Break.BreakType breakType = null;
        boolean needRelayout = false;
        for (PositionedParagraphElement paragraphElementPiece : paragraphElementPieces) {
            switch (paragraphElementPiece.getType()) {
                case TEXT: {
                    breakPosition = state.add(paragraphElementPiece.getElement());
                    break;
                }
                case OTHER: {
                    if (paragraphElementPiece.getParent().isAnchored()) {
                        anchors.addAnchoredElement((Drawing)paragraphElementPiece.getParent());
                        state.add(paragraphElementPiece.getElement());
                        break;
                    }
                    breakPosition = state.add(paragraphElementPiece.getElement());
                    break;
                }
                case SOFTBREAK: {
                    RowTextPiece tmpRowTextPiece;
                    int index = paragraphElementPieces.indexOf(paragraphElementPiece);
                    int letterIndex = 0;
                    int textIndex = Math.max(0, textElements.indexOf(paragraphElementPiece.getParent()));
                    if (index > 0 && paragraphElementPieces.get(index - 1).getElement() instanceof RowTextPiece && (tmpRowTextPiece = (RowTextPiece)paragraphElementPieces.get(index - 1).getElement()).getParent() == paragraphElementPiece.getParent()) {
                        letterIndex = tmpRowTextPiece.getStartIndex();
                        if (!tmpRowTextPiece.getText().equalsIgnoreCase(Character.toString('\n'))) {
                            letterIndex += tmpRowTextPiece.getText().length();
                        }
                    }
                    breakPosition = new ParagraphPageBreakPosition(textIndex == -1 ? textElements.size() - 1 : textIndex, letterIndex);
                    break;
                }
                case RELAYOUT: {
                    needRelayout = true;
                    break;
                }
                case HARDCOLUMNBREAK: {
                    int indexInFragment = paragraphElementPiece.getIndexInTextFragmentInformation() + 1;
                    if (indexInFragment < fragmentInformations.size()) {
                        int indexInTextElements = textElements.indexOf(paragraphElementPiece.getParent()) + 1;
                        breakPosition = new ParagraphPageBreakPosition(indexInTextElements, 0);
                    }
                    if (Util.isDebugMode) {
                        state.add(paragraphElementPiece.getElement());
                    }
                    breakType = Break.BreakType.column;
                    break;
                }
                case HARDPAGEBREAK: {
                    int indexInFragment = paragraphElementPiece.getIndexInTextFragmentInformation() + 1;
                    if (indexInFragment < fragmentInformations.size()) {
                        breakPosition = new ParagraphPageBreakPosition(indexInFragment + (pBreak == null ? 0 : pBreak.getContinueIndex()), 0);
                    }
                    if (Util.isDebugMode) {
                        state.add(paragraphElementPiece.getElement());
                    }
                    breakType = Break.BreakType.page;
                    break;
                }
                case LINEBREAK: {
                    int textIndex;
                    int index = paragraphElementPieces.indexOf(paragraphElementPiece);
                    int letterIndex = 0;
                    if (index != 0 && paragraphElementPieces.get(index - 1).getElement() instanceof RowTextPiece) {
                        RowTextPiece tmpRowTextPiece = (RowTextPiece)paragraphElementPieces.get(index - 1).getElement();
                        letterIndex = tmpRowTextPiece.getStartIndex() + tmpRowTextPiece.getText().length();
                        if (tmpRowTextPiece.getParent().getText().length() == letterIndex) {
                            letterIndex = 0;
                        }
                    }
                    state.insertLineBreak(new ParagraphPageBreakPosition((textIndex = textElements.indexOf(paragraphElementPiece.getParent())) == -1 ? textElements.size() - 1 : textIndex, letterIndex));
                    break;
                }
            }
            if (breakPosition == null) continue;
            break;
        }
        if (breakPosition == null) {
            breakPosition = state.doFinalPositioning(bounds.isFistAreaOnPage());
        } else {
            state.insertLineBreak(breakPosition);
        }
        return new ParagraphLayoutResult(prd, breakPosition, breakType, needRelayout);
    }

    private static boolean isFirstLine(ParagraphData pa, ParagraphPageBreakPosition pBreak) {
        if (pBreak == null || pBreak.getContinueIndex() == 0 && pBreak.getInTextIndex() == 0) {
            return true;
        }
        for (int i = 0; i < pa.getElements().size(); ++i) {
            ParagraphElement paragraphElement = pa.getElements().get(i);
            if (pBreak.getContinueIndex() == i) {
                return true;
            }
            if (paragraphElement.getElementType() == ParagraphElement.ParagraphElementType.Break) continue;
            return false;
        }
        return false;
    }

    private static List<ParagraphElement> getConvertedList(ParagraphData paragraphData, RenderContext context) {
        LinkedList<ParagraphElement> elements = new LinkedList<ParagraphElement>();
        if (paragraphData.hasNumbering()) {
            NumberingInfo numberingInfo = paragraphData.getNumbering();
            TextRowElement numberingElement = new TextRowElement(numberingInfo.getDisplayText(), numberingInfo.getFont(), numberingInfo.getFontColor(), numberingInfo.getBgColor());
            elements.add(numberingElement);
            elements.add(new TextRowElement(Character.toString('\t'), numberingInfo.getFont(), numberingInfo.getFontColor(), numberingInfo.getBgColor()));
        }
        for (ParagraphElement element : paragraphData.getElements()) {
            if (element.isAnchored()) {
                elements.add(element);
                continue;
            }
            if (element.getElementType() == ParagraphElement.ParagraphElementType.Break) {
                Character breakChar = null;
                switch (((Break)element).getType()) {
                    case page: {
                        breakChar = Character.valueOf('\uf000');
                        break;
                    }
                    case column: {
                        breakChar = Character.valueOf('\uf001');
                        break;
                    }
                    case textWrapping: {
                        breakChar = Character.valueOf('\n');
                    }
                }
                if (context.getContextType().canBreakPage() || breakChar == null || breakChar.charValue() == '\n') {
                    TextRowElement textRowElement = new TextRowElement(Character.toString(breakChar.charValue()), element.getRenderFont(), EMPTYCOLOR, EMPTYCOLOR);
                    if (paragraphData.getElements().indexOf(element) == 0 && paragraphData.hasNumbering()) {
                        elements.addFirst(textRowElement);
                    } else {
                        elements.add(textRowElement);
                    }
                }
                if (context.getContextType() != RenderContext.CONTEXT_TYPE.page || paragraphData.getElements().indexOf(element) != paragraphData.getElements().size() - 1 || breakChar.charValue() != '\n' && breakChar.charValue() != '\uf001') continue;
                elements.add(new TextRowElement(" ", element.getRenderFont(), EMPTYCOLOR, EMPTYCOLOR));
                continue;
            }
            if (element.getElementType() == ParagraphElement.ParagraphElementType.EmptyRow) {
                elements.add(new TextRowElement(Character.toString('\n'), element.getRenderFont(), EMPTYCOLOR, EMPTYCOLOR));
                continue;
            }
            if (element.getElementType() == ParagraphElement.ParagraphElementType.Tab) {
                Tab tab = (Tab)element;
                if (tab.getPlaceholder() == null) {
                    elements.add(new TextRowElement(Character.toString('\t'), element.getRenderFont(), Color.BLACK, Color.WHITE));
                    continue;
                }
                elements.add(new TextRowElement(Character.toString('\t'), element.getRenderFont(), tab.getPlaceholder().getColor(), tab.getPlaceholder().getBackgroundColor()));
                continue;
            }
            if (element.getElementType() == ParagraphElement.ParagraphElementType.Field) {
                ((Field)element).checkFieldContent(context);
            }
            elements.add(element);
        }
        return elements;
    }

    private static List<FragmentInformation> convertToFragmentInfos(List<ParagraphElement> parents, DocumentProperties properties, ParagraphPageBreakPosition start, ParagraphPageBreakPosition end, double lineFactor) {
        ArrayList<FragmentInformation> textFragmentInformations = new ArrayList<FragmentInformation>();
        if (start != null && start.getContinueIndex() < 0) {
            Util.LOGGER.error((Object)("Fatal error: Index out of text.\tContinueIndex() " + start.getContinueIndex()));
        }
        int startElement = start != null ? Math.max(0, start.getContinueIndex()) : 0;
        int endElement = end != null ? end.getContinueIndex() + 1 : parents.size();
        for (int iText = startElement; iText < endElement; ++iText) {
            ParagraphElement paragraphElement = parents.get(iText);
            if (paragraphElement instanceof TextRowElement) {
                TextRowElement parent = (TextRowElement)paragraphElement;
                String text = parent.getText();
                if (iText == endElement - 1 && end != null) {
                    text = text.substring(0, end.getInTextIndex());
                }
                if (iText == startElement && start != null && start.getInTextIndex() > 0) {
                    if (start.getInTextIndex() > text.length()) {
                        Util.LOGGER.warn((Object)("Fatal error: Index out of text.\tgetInTextIndex() " + String.valueOf(start) + "\nPlease send the document to Support."));
                        return textFragmentInformations;
                    }
                    text = text.substring(start.getInTextIndex());
                }
                String[] textFragments = ParagraphLayouter.getSplittedText(text);
                StringLayouter layouter = properties.getLayouter(parent.getRenderFont());
                if (parent.getRenderFont() == null || parent.getRenderFont().getFontSize() <= 0.0f) {
                    Util.LOGGER.debug((Object)"ERROR: Font not set! Default font is used.");
                    layouter = properties.getLayouter(new RenderFont("Arial", 10.0f, 0, null, false, false, false, 0.0, 1.0, 0));
                }
                for (int i = 0; i < textFragments.length; ++i) {
                    textFragmentInformations.add(new TextFragmentInformation(parent, layouter, textFragments, i, start != null ? start.getInTextIndex() : 0, textFragmentInformations.size(), lineFactor));
                }
                continue;
            }
            if (paragraphElement instanceof Drawing) {
                textFragmentInformations.add(new DrawingFragmentInformation(paragraphElement, textFragmentInformations.size(), paragraphElement.isAnchored()));
                continue;
            }
            Util.LOGGER.error((Object)("Not implemented yet. " + String.valueOf(paragraphElement.getClass())));
        }
        return textFragmentInformations;
    }

    public static String[] getSplittedText(String text) {
        ArrayList<String> result = new ArrayList<String>();
        while (text.indexOf(32) != -1) {
            int index = text.indexOf(32);
            if (index == 0) {
                result.add(Character.toString(' '));
                text = text.substring(1);
                continue;
            }
            result.addAll(ParagraphLayouter.getSplittedText(text.substring(0, index), '-'));
            text = text.substring(index);
        }
        if (!text.isEmpty()) {
            result.addAll(ParagraphLayouter.getSplittedText(text, '-'));
        }
        return result.toArray(new String[0]);
    }

    static List<String> getSplittedText(String text, char wordBoundaryCharacter) {
        ArrayList<String> result = new ArrayList<String>();
        while (text.indexOf(wordBoundaryCharacter) != -1) {
            int index = text.indexOf(wordBoundaryCharacter);
            if (index == 0) {
                result.add(Character.toString(wordBoundaryCharacter));
                text = text.substring(1);
                continue;
            }
            result.add(text.substring(0, index));
            text = text.substring(index);
        }
        if (!text.isEmpty()) {
            result.add(text);
        }
        return result;
    }

    private static Area calcLine(Area baseArea, Rectangle2D textArea, double offsetY, double textHeight, double indent) {
        Area line = new Area(Util.getNormedBounds(new Rectangle2D.Double(textArea.getX() + indent, textArea.getY() + offsetY, textArea.getWidth() - indent, textHeight)));
        line.intersect(baseArea);
        return line;
    }

    private static PositionedParagraphElementImpl createSoftBreak(FragmentInformation fragmentInformation, Area line, Spacing spacing, int indexInFragment) {
        PositionedParagraphElement.Type breakPositionType = PositionedParagraphElement.Type.SOFTBREAK;
        Positionable debug = null;
        if (Util.isDebugMode) {
            fragmentInformation.setLine(line);
            fragmentInformation.setTextField(line.getBounds2D());
            debug = fragmentInformation.createPositionedElement(0.0, spacing).getElement();
            fragmentInformation.setLine(null);
            fragmentInformation.setTextField(null);
        }
        return new PositionedParagraphElementImpl(breakPositionType, fragmentInformation.getParent(), debug, indexInFragment);
    }

    public static List<PositionedParagraphElement> calcTextLayout(List<FragmentInformation> textFragmentInformations, RenderContext context, Rectangle2D textArea, AnchorManager anchors, TabStop tabStop, int indent, boolean paragraphHasFirstLine, ParagraphData pa) {
        Spacing spacing = pa.getSpacing();
        AbstractList result = new ArrayList<PositionedParagraphElement>();
        if (textFragmentInformations.isEmpty()) {
            return result;
        }
        Area baseArea = ParagraphLayouter.getFreeTextArea(textArea, anchors, context);
        double textHeight = -1.0;
        double offsetY = 0.0;
        boolean firstLine = paragraphHasFirstLine;
        int countLineRecalculate = 0;
        PositionedParagraphElementImpl hasSoftPageBreak = null;
        PositionedParagraphElementImpl hasHardPageBreak = null;
        int lineStartIndex = 0;
        int killCount = 0;
        block2: for (int i = 0; i < textFragmentInformations.size(); ++i) {
            int i2;
            if (killCount > 10000) {
                Util.LOGGER.error((Object)"An unexpected error occurred. Please send your documents to the support.");
                return result;
            }
            ++killCount;
            FragmentInformation fragmentInformation = textFragmentInformations.get(i);
            double lineIndent = firstLine && indent > 0 ? indent : (!firstLine && indent < 0 ? -1 * indent : 0);
            if (textHeight <= 0.0) {
                textHeight = fragmentInformation.isAnchor() ? 0.001 : fragmentInformation.getLineHeight();
                for (FragmentInformation textFragmentInformation : textFragmentInformations) {
                    if (textFragmentInformation.getLayouter() == null || textFragmentInformation.isAnchor()) continue;
                    textHeight = textFragmentInformation.getLineHeight();
                    break;
                }
            }
            Area line = ParagraphLayouter.calcLine(baseArea, textArea, offsetY, textHeight, lineIndent);
            if (Util.isDebugMode) {
                Util.LOGGER.debug((Object)("Zeile " + String.valueOf(line.getBounds2D())));
            }
            if (fragmentInformation.isAnchor()) {
                ArrayList<Drawing> interuptedText;
                AreaObjects objects = new AreaObjects();
                if (anchors != null) {
                    anchors.getElements(objects);
                }
                boolean needRelayout = !(interuptedText = objects.getDrawingElements()).contains(fragmentInformation.getParent());
                Rectangle2D fallback = line.getBounds2D();
                if (line.getBounds().getHeight() == 0.0) {
                    fallback = new Rectangle2D.Double(fallback.getX(), textArea.getY(), fallback.getWidth(), fallback.getHeight());
                }
                ParagraphLayouter.anchorHandling(textFragmentInformations, i, line, fallback, anchors);
                baseArea = ParagraphLayouter.getFreeTextArea(textArea, anchors, context);
                Drawing drawing = (Drawing)fragmentInformation.getParent();
                Rectangle2D drawingBounds = drawing.getCalcBoundsShape(context).getBounds2D();
                if (firstLine && textFragmentInformations.size() == 1 || !needRelayout || !(drawingBounds.getY() < line.getBounds2D().getY()) || !(drawingBounds.getWidth() < (double)context.getPageLayout().getPageWidth())) continue;
                result.add(new PositionedParagraphElementImpl(PositionedParagraphElement.Type.RELAYOUT, null, null, 0));
                return result;
            }
            if (offsetY > textArea.getY() + textArea.getHeight()) {
                hasSoftPageBreak = ParagraphLayouter.createSoftBreak(fragmentInformation, line, spacing, textFragmentInformations.indexOf(fragmentInformation));
                break;
            }
            if (!fragmentInformation.isAnchor() && Math.abs(line.getBounds2D().getHeight() - textHeight) > 0.01) {
                if (!fragmentInformation.isAnchor()) {
                    if (line.getBounds().getMaxY() >= baseArea.getBounds2D().getMaxY()) {
                        hasSoftPageBreak = ParagraphLayouter.createSoftBreak(fragmentInformation, line, spacing, textFragmentInformations.indexOf(fragmentInformation));
                        break;
                    }
                } else {
                    line = ParagraphLayouter.calcLine(baseArea, textArea, offsetY, textHeight, lineIndent);
                }
                offsetY += textHeight;
                if (line.getBounds2D().getWidth() == 0.0) {
                    Area availableArea = ParagraphLayouter.calcLine(baseArea, textArea, line.getBounds2D().getY() - textArea.getY(), textArea.getY() + textArea.getHeight() - line.getBounds2D().getY(), lineIndent);
                    Area tmpBase = new Area(baseArea);
                    tmpBase.subtract(new Area(new Rectangle2D.Double(textArea.getX(), textArea.getY() - availableArea.getBounds2D().getY(), textArea.getWidth(), textArea.getHeight())));
                    if (availableArea.getBounds2D().getWidth() == 0.0) {
                        hasSoftPageBreak = ParagraphLayouter.createSoftBreak(fragmentInformation, line, spacing, textFragmentInformations.indexOf(fragmentInformation));
                        break;
                    }
                    if (offsetY > availableArea.getBounds2D().getY() - textArea.getY()) {
                        Util.LOGGER.debug((Object)"Wrong offset calculation");
                    } else {
                        offsetY = availableArea.getBounds2D().getY() - textArea.getY();
                    }
                }
                --i;
                continue;
            }
            boolean isRightToLeft = false;
            LinkedList<Rectangle2D> textAreas = new LinkedList<Rectangle2D>(ParagraphLayouter.getTextAreas(line));
            if (isRightToLeft) {
                Collections.reverse(textAreas);
            }
            double newHeight = -1.0;
            int endIndex = i;
            block4: for (i2 = i; i2 < textFragmentInformations.size(); ++i2) {
                FragmentInformation currentText = textFragmentInformations.get(i2);
                if (currentText.isAnchor()) {
                    boolean isSet = ParagraphLayouter.anchorHandling(textFragmentInformations, i2, line, (Rectangle2D)textAreas.peek(), anchors);
                    if (!isSet) break;
                    baseArea = ParagraphLayouter.getFreeTextArea(textArea, anchors, context);
                    continue;
                }
                if (currentText.getText().contains(Character.toString('\uf000')) || currentText.getText().contains(Character.toString('\uf001'))) {
                    PositionedParagraphElement.Type breakPositionType = currentText.getText().contains(Character.toString('\uf000')) ? PositionedParagraphElement.Type.HARDPAGEBREAK : PositionedParagraphElement.Type.HARDCOLUMNBREAK;
                    Positionable debug = null;
                    if (Util.isDebugMode) {
                        currentText.setLine(line);
                        currentText.setTextField(textAreas.peek() == null ? line.getBounds2D() : (Rectangle2D)textAreas.peek());
                        debug = currentText.createPositionedElement(0.0, spacing).getElement();
                        double x = textArea.getX();
                        double y = offsetY;
                        if (textAreas.peek() != null) {
                            x = ((Rectangle2D)textAreas.peek()).getX();
                            y = ((Rectangle2D)textAreas.peek()).getY();
                        }
                        debug.setPageX(x);
                        debug.setPageY(y);
                        currentText.setLine(null);
                        currentText.setTextField(null);
                    }
                    hasHardPageBreak = new PositionedParagraphElementImpl(breakPositionType, currentText.getParent(), debug, textFragmentInformations.indexOf(currentText));
                    break block2;
                }
                if (currentText.getText().contains(Character.toString('\n'))) {
                    endIndex = i2;
                    newHeight = Math.max(newHeight, currentText.getLineHeight());
                    currentText.setLine(line);
                    currentText.setTextField((Rectangle2D)textAreas.peek());
                    break;
                }
                while (textAreas.peek() != null) {
                    Rectangle2D peek = (Rectangle2D)textAreas.peek();
                    Rectangle2D.Double peekCopy = new Rectangle2D.Double();
                    peekCopy.setFrame(peek);
                    boolean hasTab = currentText.getText().contains(Character.toString('\t'));
                    double textWidth = currentText.getWidth();
                    if (hasTab) {
                        currentText.setLine(line);
                        currentText.setTextField(peek.getBounds2D());
                        newHeight = Math.max(newHeight, currentText.getLineHeight());
                        double nextTabStopPosition = tabStop.getNextTabStopPosition(peek.getX());
                        double tabStopPosition = tabStop.getNextTabStopPosition(textArea.getX());
                        STTabJc.Enum aligmnent = tabStop.getAligmnent(peek.getX());
                        endIndex = i2;
                        if (aligmnent != STTabJc.RIGHT && tabStopPosition >= textArea.getX() + textArea.getWidth() || i2 + 1 >= textFragmentInformations.size()) break block4;
                        peek.setFrame(nextTabStopPosition, peek.getY(), peek.getX() + peek.getWidth() - nextTabStopPosition, peek.getHeight());
                        FragmentInformation nextText = textFragmentInformations.get(i2 + 1);
                        if (nextText.getText().contains(Character.toString('\t'))) {
                            if (!(peek.getWidth() <= 0.0)) continue block4;
                            break block4;
                        }
                        textWidth = nextText.getWidth();
                        double availableLineWidth = currentText.getTextField().getWidth();
                        double availableTabWidth = nextTabStopPosition - ((RectangularShape)peekCopy).getX();
                        double availableAfterTabWidth = textArea.getX() + textArea.getWidth() - nextTabStopPosition;
                        double diffWidth = aligmnent.intValue() == 9 || aligmnent.intValue() == 3 ? availableLineWidth : textArea.getX() + textArea.getWidth() - tabStopPosition;
                        currentText = textFragmentInformations.get(++i2);
                        if (diffWidth < textWidth) {
                            if (currentText.isSingleCharacter()) {
                                endIndex = i2 - 1;
                                break block4;
                            }
                            List<FragmentInformation> splittedFragment = currentText.splittFragment(Math.abs(diffWidth));
                            textFragmentInformations.addAll(i2, splittedFragment);
                            textFragmentInformations.remove(currentText);
                            i2 -= 2;
                            continue block4;
                        }
                        if (aligmnent.intValue() == 8 && peek.getWidth() < textWidth || (aligmnent.intValue() == 9 || aligmnent.intValue() == 3) && diffWidth < textWidth) {
                            endIndex = i2 - 2;
                            break block4;
                        }
                        if (aligmnent.intValue() == 9 || aligmnent.intValue() == 3) {
                            FragmentInformation textFragmentInformation;
                            ArrayList<FragmentInformation> tabsTextFragments = new ArrayList<FragmentInformation>();
                            double textWidthForTab = 0.0;
                            for (int i3 = i2; !(i3 >= textFragmentInformations.size() || (textFragmentInformation = textFragmentInformations.get(i3)).getText().equals(Character.toString('\t')) || textFragmentInformation.getText().equals(Character.toString('\uf000')) || textFragmentInformation.getText().equals(Character.toString('\n'))); ++i3) {
                                if (!(diffWidth > (textWidthForTab += textFragmentInformation.getWidth()))) {
                                    textWidthForTab -= textFragmentInformation.getWidth();
                                    break;
                                }
                                tabsTextFragments.add(textFragmentInformation);
                                textFragmentInformation.setLine(line);
                            }
                            if (aligmnent.intValue() == 9 && textWidthForTab < availableTabWidth) {
                                ParagraphLayouter.doAlignment(tabsTextFragments, STJc.RIGHT, false, new Area(new Rectangle2D.Double(((RectangularShape)peekCopy).getX(), ((RectangularShape)peekCopy).getY(), availableTabWidth, ((RectangularShape)peekCopy).getHeight())));
                                if (!tabsTextFragments.isEmpty()) {
                                    i2 = textFragmentInformations.indexOf(tabsTextFragments.get(tabsTextFragments.size() - 1));
                                }
                                endIndex = i2;
                                continue block4;
                            }
                            if (aligmnent.intValue() == 9 && textWidthForTab > availableTabWidth || aligmnent.intValue() == 3 && availableTabWidth <= availableAfterTabWidth && textWidthForTab / 2.0 > availableTabWidth) {
                                peek.setFrame(peekCopy);
                                --i2;
                                continue block4;
                            }
                            if (aligmnent.intValue() == 3 && availableTabWidth >= availableAfterTabWidth && textWidthForTab / 2.0 > availableAfterTabWidth) {
                                ParagraphLayouter.doAlignment(tabsTextFragments, STJc.RIGHT, false, new Area(peekCopy));
                                if (!tabsTextFragments.isEmpty()) {
                                    i2 = textFragmentInformations.indexOf(tabsTextFragments.get(tabsTextFragments.size() - 1));
                                }
                                endIndex = i2;
                                continue block4;
                            }
                            if (aligmnent.intValue() == 3) {
                                double widthLeftOrRight = Math.min(availableTabWidth, availableAfterTabWidth);
                                Area centerLine = new Area(new Rectangle2D.Double(nextTabStopPosition - widthLeftOrRight, line.getBounds2D().getY(), widthLeftOrRight * 2.0, line.getBounds2D().getHeight()));
                                ParagraphLayouter.doAlignment(tabsTextFragments, STJc.CENTER, false, centerLine);
                                if (!tabsTextFragments.isEmpty()) {
                                    FragmentInformation lastFragment = tabsTextFragments.get(tabsTextFragments.size() - 1);
                                    i2 = textFragmentInformations.indexOf(lastFragment);
                                    double x = (lastFragment.getTextField() != null ? lastFragment.getTextField().getX() : peek.getX()) + lastFragment.getWidth();
                                    double width = peek.getX() + peek.getWidth() - x;
                                    peek.setFrame(x, peek.getY(), width, peek.getHeight());
                                }
                                endIndex = i2;
                                continue block4;
                            }
                        }
                    }
                    if (textWidth > textArea.getWidth() - lineIndent && !currentText.isSingleCharacter()) {
                        List<FragmentInformation> splittedFragment = currentText.splittFragment(textArea.getWidth());
                        textFragmentInformations.addAll(i2, splittedFragment);
                        textFragmentInformations.remove(currentText);
                        --i2;
                        continue block4;
                    }
                    if (textArea.getWidth() == peek.getWidth() && textWidth > textArea.getWidth() && currentText.isSingleCharacter()) {
                        FragmentInformation nextElement;
                        currentText.setLine(line);
                        currentText.setTextField(peek.getBounds2D());
                        endIndex = i2;
                        int j = i2 + 1;
                        while (j < textFragmentInformations.size() && (nextElement = textFragmentInformations.get(j)).canOverlappedBorder()) {
                            nextElement.setLine(line);
                            nextElement.setTextField(new Rectangle2D.Double(line.getBounds2D().getX() + currentText.getWidth(), line.getBounds2D().getY(), nextElement.getWidth(), line.getBounds2D().getHeight()));
                            endIndex = j++;
                        }
                        break block4;
                    }
                    if (peek.getWidth() >= textWidth || currentText.isSingleCharacter() && currentText.getText().equals(Character.toString(' '))) {
                        currentText.setLine(line);
                        currentText.setTextField(peek.getBounds2D());
                        endIndex = i2;
                        if (!currentText.isAnchor()) {
                            newHeight = Math.max(newHeight, currentText.getLineHeight());
                        }
                        peek.setFrame(peek.getX() + textWidth, peek.getY(), peek.getWidth() - textWidth, peek.getHeight());
                        continue block4;
                    }
                    textAreas.poll();
                    if (textAreas.peek() != null) continue;
                    if (endIndex == i2) {
                        --endIndex;
                    }
                    if (currentText.getParent().getElementType() != ParagraphElement.ParagraphElementType.FootnoteReference) break block4;
                    --endIndex;
                    break block4;
                }
            }
            if (newHeight == -1.0 || newHeight == textHeight) {
                double tmpHeight = endIndex > i ? textFragmentInformations.subList(i, endIndex).stream().mapToDouble(ti -> ti.isAnchor() ? 0.0 : ti.getLineHeight()).max().getAsDouble() : 0.0;
                double lineHeight = tmpHeight == 0.0 ? textHeight : tmpHeight;
                offsetY += lineHeight;
                for (int elemIndex = lineStartIndex; elemIndex <= endIndex; ++elemIndex) {
                    FragmentInformation element = textFragmentInformations.get(elemIndex);
                    if (!element.isAnchor()) continue;
                    Drawing drawingElement = (Drawing)element.getParent();
                    DrawingElement content = drawingElement.getContent();
                    double borderLineWidth = content instanceof SimpleShape ? ((SimpleShape)content).getBasicStrokeData().getBorderLineWidth() : 0.0;
                    boolean oddPage = context.getInSectionPageNumber() % 2 != 0;
                    double drawingElementHeight = drawingElement.getHeightValue().calculateValue(context.getPageLayout(), oddPage);
                    boolean lastLine = endIndex == textFragmentInformations.size() - 1;
                    Anchor.LinePosition linePosition = Anchor.LinePosition.getLinePosition(firstLine, lastLine);
                    double drawingElementOffsetY = drawingElement.getAnchorVertical().calculateVerticalOffsetForElementAnchoredToLine(lineHeight, spacing, linePosition, drawingElementHeight, borderLineWidth, oddPage);
                    if (drawingElementOffsetY == 0.0) continue;
                    drawingElement.move(0.0, drawingElementOffsetY);
                }
                firstLine = false;
                i = endIndex;
                lineStartIndex = endIndex + 1;
                continue;
            }
            for (i2 = i; i2 <= endIndex; ++i2) {
                FragmentInformation clearFragmentInfo = textFragmentInformations.get(i2);
                clearFragmentInfo.setLine(null);
                clearFragmentInfo.setTextField(null);
            }
            textHeight = newHeight;
            --i;
            Util.LOGGER.debug((Object)"Line must recalculate!");
            if (++countLineRecalculate <= 1000) continue;
            Util.LOGGER.warn((Object)"To much Line must recalculate!");
            break;
        }
        HashMap<Area, List> lineToTextFragments = new HashMap<Area, List>();
        Area lastParagraphLine = null;
        List firstParagraphLine = null;
        for (FragmentInformation textFragmentInformation : textFragmentInformations) {
            List lineTexts = lineToTextFragments.computeIfAbsent(textFragmentInformation.getLine(), k -> new ArrayList());
            if (lineToTextFragments.size() == 1) {
                firstParagraphLine = lineTexts;
            }
            if (textFragmentInformation.getTextField() != null) {
                if (lastParagraphLine == null || lastParagraphLine.getBounds2D().getY() < textFragmentInformation.getLine().getBounds2D().getY() && !textFragmentInformation.getText().equals("\uf000")) {
                    lastParagraphLine = textFragmentInformation.getLine();
                }
                lineTexts.add(textFragmentInformation);
                continue;
            }
            if (textFragmentInformation.getText().equals("\uf000")) break;
            lastParagraphLine = null;
            break;
        }
        for (List value : lineToTextFragments.values()) {
            ParagraphLayouter.doAlignment((List<FragmentInformation>)value, pa.getHorizontalAlign(), value == firstParagraphLine && paragraphHasFirstLine && pa.hasNumbering(), lineToTextFragments.get(lastParagraphLine) == value);
        }
        if (!Util.isDebugMode) {
            ParagraphLayouter.fillTabs(textFragmentInformations, tabStop, textArea.getX() + textArea.getWidth());
        }
        boolean hasLastElement = false;
        HashMap<Double, Double> linePositionYToMaxDescend = new HashMap<Double, Double>();
        Area lastLine = null;
        int countLine = 1;
        ArrayList<FragmentInformation> avaiableTextElements = new ArrayList<FragmentInformation>();
        for (int i = 0; i < textFragmentInformations.size(); ++i) {
            FragmentInformation textFragmentInformation = textFragmentInformations.get(i);
            Rectangle2D textField = textFragmentInformation.getTextField();
            if (textField == null) {
                if (textFragmentInformation.getLayouter() == null) continue;
                avaiableTextElements.add(textFragmentInformation);
                continue;
            }
            Area currentLine = textFragmentInformation.getLine();
            if (lastLine != null && lastLine != currentLine && lastLine.getBounds2D().getMaxY() != currentLine.getBounds2D().getMaxY()) {
                PositionedParagraphElementImpl breakElement = new PositionedParagraphElementImpl(PositionedParagraphElement.Type.LINEBREAK, textFragmentInformation.getParent(), null, 0);
                result.add(breakElement);
                ++countLine;
            }
            lastLine = textFragmentInformation.getLine();
            PositionedParagraphElement rowTextPiece = textFragmentInformation.createPositionedElement(textArea.getX(), spacing);
            if (!textFragmentInformation.isAnchor()) {
                double lineYPosition = textField.getY();
                if (textFragmentInformation.getLayouter() != null) {
                    Double maxDescendForLine = (Double)linePositionYToMaxDescend.get(textField.getY());
                    if (maxDescendForLine == null) {
                        maxDescendForLine = 0.0;
                        for (int i2 = i; i2 < textFragmentInformations.size(); ++i2) {
                            FragmentInformation tmpFragmentInformation = textFragmentInformations.get(i);
                            if (textField.getY() != tmpFragmentInformation.getTextField().getY()) break;
                            if (tmpFragmentInformation.getLayouter() == null) continue;
                            maxDescendForLine = Math.max(maxDescendForLine, tmpFragmentInformation.getLayouter().getFontDimensions().getDescent());
                        }
                        linePositionYToMaxDescend.put(textField.getY(), maxDescendForLine);
                    }
                    lineYPosition = textField.getY() + textField.getHeight() / spacing.getSpacingFactor() - textFragmentInformation.getLayouter().getFontDimensions().getBaselineHeight() - maxDescendForLine;
                }
                Positionable rowElement = rowTextPiece.getElement();
                try {
                    rowElement.setPageX(textField.getX());
                    rowElement.setPageY(lineYPosition);
                }
                catch (IllegalStateException e) {
                    rowElement.move(-rowElement.getPageX(), -rowElement.getPageY());
                    rowElement.move(textField.getX(), lineYPosition);
                }
            }
            result.add(rowTextPiece);
            hasLastElement = i + 1 == textFragmentInformations.size();
        }
        if (hasHardPageBreak != null) {
            result.add(hasHardPageBreak);
        }
        if (result.isEmpty() && pa.isFirstContent()) {
            FragmentInformation fragmentInformation = textFragmentInformations.get(0);
            double lineIndent = firstLine && indent > 0 ? indent : (!firstLine && indent < 0 ? -1 * indent : 0);
            Area line = ParagraphLayouter.calcLine(new Area(textArea), textArea, 0.0, fragmentInformation.getLineHeight(), lineIndent);
            fragmentInformation.setLine(line);
            fragmentInformation.setTextField(line.getBounds2D().getBounds2D());
            PositionedParagraphElement rowTextPiece = fragmentInformation.createPositionedElement(textArea.getX(), spacing);
            rowTextPiece.getElement().setPageX(textArea.getX());
            rowTextPiece.getElement().setPageY(textArea.getY());
            result.add(rowTextPiece);
            if (textFragmentInformations.size() != 1) {
                result.add(new PositionedParagraphElementImpl(PositionedParagraphElement.Type.SOFTBREAK, textFragmentInformations.get(0).getParent(), null, 0));
            }
            hasLastElement = true;
        } else if (hasSoftPageBreak != null) {
            result.add(hasSoftPageBreak);
        }
        if (pa.isParagraphControl() && ParagraphLayouter.isTextParagraph(pa) && !pa.isStartOnNewPage() && !pa.isFirstContent() && context.getContextType().canBreakPage() && !hasLastElement) {
            if (countLine == 1) {
                result = new ArrayList();
                FragmentInformation first = textFragmentInformations.get(0);
                result.add(ParagraphLayouter.createSoftBreak(first, new Area(), spacing, 0));
            } else {
                List<PositionedParagraphElement> tmpElements = ParagraphLayouter.calcTextLayout(avaiableTextElements, context, textArea, null, tabStop, indent, true, pa);
                int countTmpLine = 0;
                double tmpY = 0.0;
                for (PositionedParagraphElement tmpElement : tmpElements) {
                    if (tmpElement.getElement() == null || tmpElement.getElement().getPageY() == tmpY) continue;
                    tmpY = tmpElement.getElement().getPageY();
                    ++countTmpLine;
                }
                if (countTmpLine <= 1 && countLine <= 2) {
                    result = new ArrayList();
                    FragmentInformation first = textFragmentInformations.get(0);
                    result.add(ParagraphLayouter.createSoftBreak(first, new Area(), spacing, 0));
                } else if (countTmpLine <= 1) {
                    LinkedList<PositionedParagraphElement> resultRemoveElements = new LinkedList<PositionedParagraphElement>(result);
                    while (resultRemoveElements.peekLast() != null) {
                        PositionedParagraphElement positionedParagraphElement = resultRemoveElements.pollLast();
                        if (positionedParagraphElement.getType() != PositionedParagraphElement.Type.LINEBREAK) continue;
                        resultRemoveElements.add(new PositionedParagraphElementImpl(PositionedParagraphElement.Type.SOFTBREAK, positionedParagraphElement.getParent(), positionedParagraphElement.getElement(), positionedParagraphElement.getIndexInTextFragmentInformation()));
                        break;
                    }
                    result = resultRemoveElements;
                }
            }
        }
        if ((pa.isKeepParagraphOnTheSamePage() && hasHardPageBreak == null || pa.isParagraphControl() && countLine == 1 && ParagraphLayouter.isTextParagraph(pa) && !pa.isStartOnNewPage()) && !hasLastElement && context.getContextType() == RenderContext.CONTEXT_TYPE.page && !pa.isFirstContent()) {
            result = new ArrayList();
            FragmentInformation first = textFragmentInformations.get(0);
            result.add(ParagraphLayouter.createSoftBreak(first, new Area(), spacing, 0));
        }
        return result;
    }

    private static boolean isTextParagraph(ParagraphData paragraphData) {
        boolean result = false;
        for (ParagraphElement element : paragraphData.getElements()) {
            Break.BreakType type;
            if (element.getElementType() == ParagraphElement.ParagraphElementType.Text) {
                result = true;
                continue;
            }
            if (element.getElementType() != ParagraphElement.ParagraphElementType.Break || (type = ((Break)element).getType()) != Break.BreakType.page && type != Break.BreakType.column) continue;
            return false;
        }
        return result;
    }

    private static boolean anchorHandling(List<FragmentInformation> fragments, int index, Area currentLine, Rectangle2D fallback, AnchorManager anchorManager) {
        FragmentInformation currentElement = fragments.get(index);
        double widthNextElement = 0.0;
        if (index > 0) {
            FragmentInformation previousElement = fragments.get(index - 1);
            while (index + 1 < fragments.size()) {
                FragmentInformation nextElement;
                if ((nextElement = fragments.get(++index)).isAnchor() || nextElement.getText().trim().isEmpty()) continue;
                widthNextElement = nextElement.getWidth();
                break;
            }
            if (fallback != null && fallback.getWidth() < widthNextElement && previousElement.getTextField() != null && previousElement.getTextField().getY() == fallback.getY()) {
                return false;
            }
            if (fallback != null && (previousElement.getTextField() == null || previousElement.getTextField().getY() != currentLine.getBounds2D().getY())) {
                currentElement.setLine(currentLine);
                currentElement.setTextField(fallback);
            } else if (previousElement.getTextField() != null) {
                currentElement.setLine(previousElement.getLine());
                Rectangle2D bounds2D = previousElement.getTextField().getBounds2D();
                double width = previousElement.getWidth();
                double lastSignWidth = previousElement.getLastSignWidth();
                currentElement.setTextField(new Rectangle2D.Double(bounds2D.getX() + width - lastSignWidth, bounds2D.getY(), lastSignWidth, bounds2D.getHeight()));
            }
        } else {
            currentElement.setLine(currentLine);
            if (fallback == null) {
                currentElement.setTextField(currentLine.getBounds2D());
            } else {
                currentElement.setTextField(fallback.getBounds2D());
            }
        }
        boolean shouldPos = true;
        Drawing drawingElement = (Drawing)currentElement.getParent();
        if (anchorManager != null) {
            shouldPos = anchorManager.addAnchoredElement(drawingElement);
        }
        if (shouldPos) {
            Rectangle2D tf = currentElement.getTextField();
            drawingElement.setPageX(tf.getX());
            drawingElement.setPageY(tf.getY());
        }
        return true;
    }

    public static void fillTabs(List<FragmentInformation> textFragmentInformations, TabStop tabStop, double defaultEndPos) {
        for (int i = 0; i < textFragmentInformations.size(); ++i) {
            String placeHolder;
            TextFragmentInformation textFragmentInformation;
            FragmentInformation fragmentInformation = textFragmentInformations.get(i);
            Rectangle2D textField = fragmentInformation.getTextField();
            if (textField == null || !(fragmentInformation instanceof TextFragmentInformation) || !(textFragmentInformation = (TextFragmentInformation)textFragmentInformations.get(i)).getText().equals(Character.toString('\t'))) continue;
            int index = textFragmentInformations.indexOf(textFragmentInformation);
            double endXPos = defaultEndPos;
            if (index + 1 < textFragmentInformations.size() && textFragmentInformations.get(index + 1).getTextField() != null) {
                endXPos = textFragmentInformations.get(index + 1).getTextField().getX();
            }
            if ((placeHolder = tabStop.getPlaceholder(textFragmentInformation.getTextField().getX(), textFragmentInformation.getParent().getRenderFont(), textFragmentInformation.getParent().getColor(), textFragmentInformation.getParent().getBackgroundColor())) == null && textFragmentInformation.getLayouter().getFont().canDisplay(' ')) {
                placeHolder = " ";
            }
            if (placeHolder != null) {
                textFragmentInformation.setPlaceHolder(ParagraphLayouter.getPlaceHolderTextForTab(placeHolder, endXPos - textFragmentInformation.getTextField().getX(), textFragmentInformation.getLayouter()));
                continue;
            }
            textFragmentInformation.setPlaceHolder("");
        }
    }

    public static String getPlaceHolderTextForTab(String placeHolder, double width, StringLayouter layouter) {
        StringBuilder builder = new StringBuilder();
        boolean hasFirst = false;
        boolean hasLast = false;
        int placeHolderIndex = 0;
        boolean hasSpaceChar = layouter.getFont().canDisplay(' ');
        while (layouter.getTextLength(builder.toString()) < width) {
            if (!hasFirst) {
                if (hasSpaceChar) {
                    builder.append(" ");
                }
                hasFirst = true;
                continue;
            }
            if (!hasLast) {
                if (hasSpaceChar) {
                    builder.append(" ");
                }
                hasLast = true;
                continue;
            }
            if (hasSpaceChar) {
                builder.insert(builder.length() - 1, placeHolder.charAt(placeHolderIndex));
            } else {
                builder.append(placeHolder.charAt(placeHolderIndex));
            }
            placeHolderIndex = (placeHolderIndex + 1) % placeHolder.length();
        }
        return builder.toString();
    }

    private static void doAlignment(List<FragmentInformation> fullLineElements, STJc.Enum alignment, boolean isFirstLine, boolean isLastLine) {
        if (fullLineElements.isEmpty() || "left".equalsIgnoreCase(alignment.toString())) {
            return;
        }
        ArrayList<FragmentInformation> lineElements = new ArrayList<FragmentInformation>(fullLineElements);
        ArrayList numberingElements = new ArrayList();
        if (isFirstLine) {
            lineElements.remove(0);
            if (!lineElements.isEmpty()) {
                lineElements.remove(0);
            }
        }
        lineElements.sort(Comparator.comparingDouble(o -> o.getTextField().getBounds2D().getX()));
        for (int i = lineElements.size() - 1; i >= 0 && ((FragmentInformation)lineElements.get(i)).canOverlappedBorder(); --i) {
            lineElements.remove(lineElements.get(i));
        }
        Area area = null;
        for (FragmentInformation lineElement : lineElements) {
            if (area == null) {
                area = lineElement.getLine();
                continue;
            }
            area.add(lineElement.getLine());
        }
        if (isFirstLine && area != null) {
            area.intersect(new Area(fullLineElements.get(2).getTextField()));
        }
        ParagraphLayouter.doAlignment(lineElements, alignment, isLastLine, area);
    }

    private static void doAlignment(List<FragmentInformation> fullLineElements, STJc.Enum alignment, boolean isLastLine, Area area) {
        if ("left".equalsIgnoreCase(alignment.toString()) || area == null) {
            return;
        }
        ArrayList<FragmentInformation> lineElements = new ArrayList<FragmentInformation>(fullLineElements);
        ArrayList<FragmentInformation> fragmentAtEnd = new ArrayList<FragmentInformation>();
        for (int i = lineElements.size() - 1; i >= 0 && ((FragmentInformation)lineElements.get(i)).canOverlappedBorder(); --i) {
            fragmentAtEnd.add((FragmentInformation)lineElements.get(i));
            lineElements.remove(lineElements.get(i));
        }
        if (lineElements.isEmpty()) {
            return;
        }
        double wordWidth = lineElements.stream().mapToDouble(FragmentInformation::getWidth).sum();
        if ("center".equalsIgnoreCase(alignment.toString())) {
            spaceLeftAndRight = area.getBounds2D().getWidth() - wordWidth;
            double spaceLeft = spaceLeftAndRight / 2.0;
            for (FragmentInformation lineElement : lineElements) {
                lineElement.setTextField(new Rectangle2D.Double(area.getBounds2D().getX() + spaceLeft, area.getBounds2D().getY(), lineElement.getWidth(), area.getBounds2D().getHeight()));
                spaceLeft += lineElement.getWidth();
            }
        } else if ("right".equalsIgnoreCase(alignment.toString())) {
            double startPos;
            Collections.reverse(lineElements);
            double positionRight = startPos = area.getBounds2D().getMaxX();
            for (FragmentInformation lineElement : lineElements) {
                if (lineElement.canOverlappedBorder() && positionRight == startPos) continue;
                lineElement.setTextField(new Rectangle2D.Double(positionRight - lineElement.getWidth(), area.getBounds2D().getY(), lineElement.getWidth(), area.getBounds2D().getHeight()));
                positionRight -= lineElement.getWidth();
            }
        } else if ("both".equalsIgnoreCase(alignment.toString()) || "lowKashida".equalsIgnoreCase(alignment.toString()) || "mediumKashida".equalsIgnoreCase(alignment.toString()) || "highKashida".equalsIgnoreCase(alignment.toString())) {
            if (isLastLine) {
                ParagraphLayouter.doAlignment(lineElements, STJc.Enum.forString((String)"left"), true, area);
                return;
            }
            spaceLeftAndRight = area.getBounds2D().getWidth() - wordWidth;
            double whiteSpaceWidth = spaceLeftAndRight / (double)(lineElements.size() - 1);
            double positionX = 0.0;
            for (FragmentInformation lineElement : lineElements) {
                lineElement.setTextField(new Rectangle2D.Double(area.getBounds2D().getX() + positionX, area.getBounds2D().getY(), lineElement.getWidth(), area.getBounds2D().getHeight()));
                positionX += lineElement.getWidth() + whiteSpaceWidth;
            }
        }
        FragmentInformation lastElement = (FragmentInformation)lineElements.get(lineElements.size() - 1);
        double x = lastElement.getTextField().getX() + lastElement.getTextField().getWidth();
        double y = lastElement.getTextField().getY();
        double height = lastElement.getTextField().getHeight();
        for (FragmentInformation fragmentInformation : fragmentAtEnd) {
            double width = fragmentInformation.getWidth();
            fragmentInformation.setLine(lastElement.getLine());
            fragmentInformation.setTextField(new Rectangle2D.Double(x, y, width, height));
        }
    }

    private static Area getFreeTextArea(Rectangle2D textArea, AnchorManager anchors, RenderContext context) {
        AreaObjects objects = new AreaObjects();
        if (anchors != null) {
            anchors.getElements(objects);
        }
        ArrayList<Drawing> interuptedText = objects.getDrawingElements();
        ArrayList<Area> reservedAreas = new ArrayList<Area>();
        for (Drawing drawing : interuptedText) {
            if (drawing.getTextWrapping() == TextWrapping.NONE || drawing.getTextWrapping() == TextWrapping.NONEONTOP) continue;
            Shape addForm = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
            Shape shapeBounds = drawing.getCalcBoundsShape(context);
            switch (drawing.getTextWrapping()) {
                case POLYGON: 
                case THROUGH: 
                case TIGHT: {
                    switch (drawing.getTextWrappingSide()) {
                        case BOTHSIDE: {
                            addForm = shapeBounds;
                            break;
                        }
                        case LEFT: {
                            Util.LOGGER.warn((Object)("TextWrapping not implemented yet.\tWrapping " + String.valueOf((Object)drawing.getTextWrapping()) + "\tSide " + String.valueOf((Object)drawing.getTextWrappingSide())));
                            addForm = new Rectangle2D.Double(shapeBounds.getBounds2D().getX(), shapeBounds.getBounds2D().getY(), textArea.getWidth() - shapeBounds.getBounds2D().getX(), shapeBounds.getBounds2D().getHeight());
                            break;
                        }
                        case RIGHT: {
                            Util.LOGGER.warn((Object)("TextWrapping not implemented yet.\tWrapping " + String.valueOf((Object)drawing.getTextWrapping()) + "\tSide " + String.valueOf((Object)drawing.getTextWrappingSide())));
                            addForm = new Rectangle2D.Double(shapeBounds.getBounds2D().getX(), shapeBounds.getBounds2D().getY(), shapeBounds.getBounds2D().getWidth(), shapeBounds.getBounds2D().getHeight());
                        }
                    }
                    break;
                }
                case SQUARE: {
                    switch (drawing.getTextWrappingSide()) {
                        case BOTHSIDE: {
                            addForm = new Rectangle2D.Double(shapeBounds.getBounds2D().getX(), shapeBounds.getBounds2D().getY(), shapeBounds.getBounds2D().getWidth(), shapeBounds.getBounds2D().getHeight());
                            break;
                        }
                        case LARGEST: {
                            break;
                        }
                        case LEFT: {
                            addForm = new Rectangle2D.Double(shapeBounds.getBounds2D().getX(), shapeBounds.getBounds2D().getY(), textArea.getWidth() - shapeBounds.getBounds2D().getX(), shapeBounds.getBounds2D().getHeight());
                            break;
                        }
                        case RIGHT: {
                            addForm = new Rectangle2D.Double(shapeBounds.getBounds2D().getX(), shapeBounds.getBounds2D().getY(), shapeBounds.getBounds2D().getWidth(), shapeBounds.getBounds2D().getHeight());
                        }
                    }
                    break;
                }
                case TOPANDBOTTOM: {
                    addForm = new Rectangle2D.Double(textArea.getX(), shapeBounds.getBounds2D().getY(), textArea.getWidth(), shapeBounds.getBounds2D().getHeight());
                }
            }
            drawing.getWrappingInsets().top = Math.max(20, drawing.getWrappingInsets().top);
            drawing.getWrappingInsets().bottom = Math.max(20, drawing.getWrappingInsets().bottom);
            reservedAreas.add(ParagraphLayouter.createShapeWithInsets(addForm, drawing.getWrappingInsets()));
        }
        Area baseArea = new Area(textArea);
        for (Area area : reservedAreas) {
            Util.LOGGER.debug((Object)("reservedArea = " + String.valueOf(area.getBounds2D())));
            baseArea.subtract(area);
        }
        return baseArea;
    }

    private static Area createShapeWithInsets(Shape shape, Insets insets) {
        Shape transformedShape;
        Area resultForm = new Area(shape);
        if (insets.top != 0 || insets.left != 0) {
            transformedShape = AffineTransform.getTranslateInstance(-insets.left, -insets.top).createTransformedShape(shape);
            resultForm.add(new Area(transformedShape));
        }
        if (insets.top != 0 || insets.right != 0) {
            transformedShape = AffineTransform.getTranslateInstance(insets.right, -insets.top).createTransformedShape(shape);
            resultForm.add(new Area(transformedShape));
        }
        if (insets.bottom != 0 || insets.left != 0) {
            transformedShape = AffineTransform.getTranslateInstance(-insets.left, insets.bottom).createTransformedShape(shape);
            resultForm.add(new Area(transformedShape));
        }
        if (insets.bottom != 0 || insets.right != 0) {
            transformedShape = AffineTransform.getTranslateInstance(insets.right, insets.bottom).createTransformedShape(shape);
            resultForm.add(new Area(transformedShape));
        }
        return resultForm;
    }

    public static List<Rectangle2D> getTextAreas(Area textLine) {
        ArrayList<Rectangle2D> result = new ArrayList<Rectangle2D>();
        Area tmpAreaNoneText = new Area(textLine.getBounds2D());
        tmpAreaNoneText.exclusiveOr(textLine);
        if (tmpAreaNoneText.getBounds2D().getWidth() == 0.0) {
            if (textLine.getBounds2D().getWidth() > 0.0) {
                result.add(textLine.getBounds2D());
            }
        } else {
            Area tmpAreaText = new Area(tmpAreaNoneText.getBounds2D());
            tmpAreaText.exclusiveOr(tmpAreaNoneText);
            Rectangle2D.Double left = new Rectangle2D.Double(textLine.getBounds2D().getX(), textLine.getBounds2D().getY(), tmpAreaNoneText.getBounds2D().getX() - textLine.getBounds2D().getX(), textLine.getBounds2D().getHeight());
            Rectangle2D.Double right = new Rectangle2D.Double(tmpAreaNoneText.getBounds2D().getX() + tmpAreaNoneText.getBounds2D().getWidth(), textLine.getBounds2D().getY(), textLine.getBounds2D().getX() + textLine.getBounds2D().getWidth() - tmpAreaNoneText.getBounds2D().getX() - tmpAreaNoneText.getBounds2D().getWidth(), textLine.getBounds2D().getHeight());
            if (((Rectangle2D)left).getBounds2D().getWidth() > 0.0) {
                result.add(left);
            }
            if (tmpAreaText.getBounds2D().getWidth() != 0.0 && tmpAreaText.getBounds2D().getWidth() != textLine.getBounds2D().getWidth() && tmpAreaText.getBounds2D().getHeight() == textLine.getBounds2D().getHeight()) {
                result.addAll(ParagraphLayouter.getTextAreas(tmpAreaText));
            }
            if (((Rectangle2D)right).getBounds2D().getWidth() > 0.0) {
                result.add(right);
            }
        }
        return result;
    }

    public static class ParagraphLayoutResult
    implements LayouterResult<ParagraphView> {
        private ParagraphView view;
        private ParagraphPageBreakPosition pBreak;
        private Break.BreakType breakType;
        private boolean needRelayout;

        public ParagraphLayoutResult(ParagraphView view, ParagraphPageBreakPosition pBreak, Break.BreakType breakType, boolean needRelayout) {
            this.view = view;
            this.pBreak = pBreak;
            this.breakType = breakType;
            this.needRelayout = needRelayout;
        }

        public ParagraphView getView() {
            return this.view;
        }

        @Override
        public Break.BreakType getBreakType() {
            return this.breakType;
        }

        @Override
        public CellPageBreakPosition getBreakPosition() {
            if (this.pBreak == null) {
                return null;
            }
            return new CellPageBreakPosition(this.view.getSource(), this.pBreak, true);
        }

        @Override
        public ParagraphView getPageView() {
            return this.view;
        }

        @Override
        public boolean needPageRelayout() {
            return this.needRelayout;
        }
    }

    private static class LayoutState
    implements Iterator<ParagraphElement> {
        private double xStart;
        private double yOffset = 0.0;
        private double yStart;
        private double maxWidth;
        private double maxHeight;
        private ParagraphRow row;
        private int elementIndex = 0;
        private ParagraphView parent;

        public LayoutState(ParagraphView parent, LayoutArea bounds, ParagraphPageBreakPosition startBreak) {
            this.parent = parent;
            this.xStart = bounds.getX();
            this.maxWidth = bounds.getWidth();
            this.yStart = bounds.getY();
            this.maxHeight = bounds.getHeight();
            if (startBreak == null) {
                startBreak = new ParagraphPageBreakPosition(0, 0);
            }
            this.row = new ParagraphRow(parent, startBreak);
            this.row.setPageX(this.xStart);
            this.row.setPageY(this.yStart);
        }

        public ParagraphPageBreakPosition insertLineBreak(ParagraphPageBreakPosition paragraphPageBreakPosition) {
            this.yOffset += this.row.getHeight() + (double)this.row.getSpacingBottom();
            this.parent.addRow(this.row);
            this.row = new ParagraphRow(this.parent, paragraphPageBreakPosition);
            this.row.setPageX(this.xStart);
            this.row.setPageY(this.yStart + this.yOffset);
            return paragraphPageBreakPosition;
        }

        private ParagraphPageBreakPosition doFinalPositioning(boolean isFirstContentOnPage) {
            boolean tooLarge;
            this.yOffset += this.row.getHeight();
            boolean bl = tooLarge = this.yOffset > this.maxHeight;
            if (tooLarge && !isFirstContentOnPage) {
                return this.row.getStartBreak();
            }
            this.parent.addRow(this.row);
            this.row = null;
            return null;
        }

        public ParagraphPageBreakPosition add(Positionable element) {
            this.row.addElement(element);
            return null;
        }

        @Override
        public boolean hasNext() {
            return this.elementIndex < this.parent.getSource().getElementCount();
        }

        @Override
        public ParagraphElement next() {
            return this.parent.getSource().getElement(this.elementIndex++);
        }
    }

    private static interface PositionedParagraphElement {
        public ParagraphElement getParent();

        public Positionable getElement();

        public int getIndexInTextFragmentInformation();

        public Type getType();

        public static enum Type {
            TEXT,
            SOFTBREAK,
            RELAYOUT,
            HARDCOLUMNBREAK,
            HARDPAGEBREAK,
            LINEBREAK,
            OTHER;

        }
    }

    private static class TextFragmentInformation
    extends AbstractFragmentInformation {
        private final TextRowElement parent;
        private final String[] textFragments;
        private final int textIndex;
        private final StringLayouter layouter;
        private double width;
        private int offsetText;
        private int indexInTextFragment;
        private boolean isSingleCharacter;
        private double lineFactor;
        private boolean isSplitted = false;

        public TextFragmentInformation(TextRowElement parent, StringLayouter layouter, String[] textFragments, int textIndex, int offsetText, int indexInTextFragment, double lineFactor) {
            super(parent);
            this.parent = parent;
            this.layouter = layouter;
            this.textFragments = textFragments;
            this.textIndex = textIndex;
            this.width = layouter.getTextLength(this.textFragments[this.textIndex]);
            this.offsetText = offsetText;
            this.indexInTextFragment = indexInTextFragment;
            this.isSingleCharacter = this.getText().length() == 1;
            this.lineFactor = lineFactor;
        }

        @Override
        public TextRowElement getParent() {
            return this.parent;
        }

        @Override
        public String getText() {
            return this.textFragments[this.textIndex];
        }

        @Override
        public PositionedParagraphElement createPositionedElement(double startX, Spacing spacing) {
            String addElement = this.isSplitted ? "-" : "";
            RowTextPiece rowTextPiece = new RowTextPiece(this.getText() + addElement, this.getWidth(), this.getTextField().getX() - startX, this.getParent(), this.getIndex(), spacing.getSpacingFactor());
            rowTextPiece.setBounded(this.isSplitted);
            return new PositionedParagraphElementImpl(PositionedParagraphElement.Type.TEXT, this.getParent(), rowTextPiece, this.indexInTextFragment);
        }

        private int getIndex() {
            int count = this.offsetText;
            for (int i = 0; i < this.textIndex; ++i) {
                count += this.textFragments[i].length();
            }
            return count;
        }

        @Override
        public StringLayouter getLayouter() {
            return this.layouter;
        }

        @Override
        public double getWidth() {
            return this.width;
        }

        @Override
        public boolean canOverlappedBorder() {
            return this.getText().equals(Character.toString(' ')) || this.getText().equals(Character.toString('\n'));
        }

        @Override
        public boolean isSingleCharacter() {
            return this.isSingleCharacter;
        }

        @Override
        public List<FragmentInformation> splittFragment(double maxWidth) {
            ArrayList<FragmentInformation> result = new ArrayList<FragmentInformation>();
            ArrayList<String> splittedText = new ArrayList<String>();
            String text = this.getText().trim();
            while (!text.isEmpty()) {
                String tmpWord;
                String foundWord = "";
                for (int i = 1; i < text.length() && this.layouter.getTextLength(tmpWord = text.substring(0, i)) < maxWidth; ++i) {
                    foundWord = tmpWord;
                }
                if (foundWord.isEmpty()) {
                    foundWord = text.substring(0, 1);
                }
                splittedText.add(foundWord);
                text = text.substring(foundWord.length());
            }
            String[] splittedTextArea = splittedText.toArray(new String[0]);
            int offsetText = this.getIndex();
            for (int i = 0; i < splittedTextArea.length; ++i) {
                TextFragmentInformation textFragmentInformation = new TextFragmentInformation(this.parent, this.layouter, splittedTextArea, i, offsetText, this.indexInTextFragment, this.lineFactor);
                if (i + 1 < splittedTextArea.length) {
                    textFragmentInformation.isSplitted = true;
                }
                result.add(textFragmentInformation);
            }
            return result;
        }

        @Override
        public double getLineHeight() {
            return this.layouter.getFontDimensions().getRowHeight() * this.lineFactor;
        }

        public void setPlaceHolder(String text) {
            this.textFragments[this.textIndex] = text;
            this.width = this.layouter.getTextLength(this.textFragments[this.textIndex]);
        }

        @Override
        public double getLastSignWidth() {
            if (this.isSingleCharacter()) {
                return this.getWidth();
            }
            String splittText = this.getText().substring(this.getText().length() - 1);
            return this.getLayouter().getTextLength(splittText);
        }

        public String toString() {
            Object text = this.textFragments[this.textIndex];
            if (((String)text).length() == 1) {
                text = (String)text + " (" + ((String)text).charAt(0) + " )";
            }
            return "TextFragmentInformation{text=" + (String)text + ", textIndex=" + this.textIndex + ", width=" + this.width + ", line=" + String.valueOf(this.getLine()) + ", textField=" + String.valueOf(this.getTextField()) + ", textFragments=" + Arrays.toString(this.textFragments) + "}";
        }
    }

    private static class DrawingFragmentInformation
    extends AbstractFragmentInformation {
        private final Positionable element;
        private final int indexInTextFragment;
        private final boolean isAnchor;

        public DrawingFragmentInformation(ParagraphElement paragraphElement, int indexInTextFragment, boolean isAnchor) {
            super(paragraphElement);
            this.indexInTextFragment = indexInTextFragment;
            this.isAnchor = isAnchor;
            this.element = (Positionable)((Object)this.getParent());
        }

        @Override
        public double getWidth() {
            return this.element.getWidth();
        }

        @Override
        public double getLineHeight() {
            return this.element.getHeight();
        }

        @Override
        public String getText() {
            return Character.toString('\uf0ff');
        }

        @Override
        public PositionedParagraphElement createPositionedElement(double startX, Spacing spacing) {
            return new PositionedParagraphElementImpl(PositionedParagraphElement.Type.OTHER, this.getParent(), this.element, this.indexInTextFragment);
        }

        @Override
        public List<FragmentInformation> splittFragment(double maxWidth) {
            throw new IllegalStateException("Graphic cann't be splitted");
        }

        @Override
        public boolean isAnchor() {
            return this.isAnchor;
        }

        @Override
        public double getLastSignWidth() {
            return this.getWidth();
        }
    }

    private static interface FragmentInformation {
        public ParagraphElement getParent();

        public double getWidth();

        public double getLineHeight();

        public Rectangle2D getTextField();

        public void setTextField(Rectangle2D var1);

        public Area getLine();

        public void setLine(Area var1);

        public boolean canOverlappedBorder();

        public boolean isSingleCharacter();

        public String getText();

        public PositionedParagraphElement createPositionedElement(double var1, Spacing var3);

        public List<FragmentInformation> splittFragment(double var1);

        public boolean isAnchor();

        public double getLastSignWidth();

        public StringLayouter getLayouter();
    }

    private static class PositionedParagraphElementImpl
    implements PositionedParagraphElement {
        private final PositionedParagraphElement.Type type;
        private final ParagraphElement parent;
        private final Positionable element;
        private int indexInFragmentInformation;

        public PositionedParagraphElementImpl(PositionedParagraphElement.Type type, ParagraphElement parent, Positionable element, int indexInFragmentInformation) {
            this.type = type;
            this.parent = parent;
            this.element = element;
            this.indexInFragmentInformation = indexInFragmentInformation;
        }

        @Override
        public ParagraphElement getParent() {
            return this.parent;
        }

        @Override
        public Positionable getElement() {
            return this.element;
        }

        @Override
        public int getIndexInTextFragmentInformation() {
            return this.indexInFragmentInformation;
        }

        @Override
        public PositionedParagraphElement.Type getType() {
            return this.type;
        }
    }

    private static abstract class AbstractFragmentInformation
    implements FragmentInformation {
        private final ParagraphElement parent;
        private Area line;
        private Rectangle2D textField;

        public AbstractFragmentInformation(ParagraphElement paragraphElement) {
            this.parent = paragraphElement;
        }

        @Override
        public ParagraphElement getParent() {
            return this.parent;
        }

        @Override
        public boolean canOverlappedBorder() {
            return false;
        }

        @Override
        public boolean isSingleCharacter() {
            return true;
        }

        @Override
        public Area getLine() {
            return this.line;
        }

        @Override
        public Rectangle2D getTextField() {
            return this.textField;
        }

        @Override
        public void setLine(Area line) {
            this.line = line;
        }

        @Override
        public void setTextField(Rectangle2D textField) {
            this.textField = textField;
        }

        @Override
        public boolean isAnchor() {
            return false;
        }

        @Override
        public double getLastSignWidth() {
            return 0.0;
        }

        @Override
        public StringLayouter getLayouter() {
            return null;
        }
    }
}

