/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.layout;

import com.inet.docx.document.DocumentProperties;
import com.inet.docx.document.Section;
import com.inet.docx.document.elements.DocumentElement;
import com.inet.docx.document.elements.subelements.Break;
import com.inet.docx.document.paragraph.ParagraphData;
import com.inet.docx.document.utilities.Util;
import com.inet.docx.layout.LayoutArea;
import com.inet.docx.layout.Layouter;
import com.inet.docx.layout.LayouterResult;
import com.inet.docx.view.DefaultRenderContext;
import com.inet.docx.view.PageElement;
import com.inet.docx.view.PageProperties;
import com.inet.docx.view.RenderContext;
import com.inet.docx.view.RenderPage;
import com.inet.docx.view.table.CellPageBreakPosition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STSectionMark;

public class DocumentLayouter {
    public static final int HARDKILLCOUNTER = 100;

    public static List<RenderPage> splitPages(List<Section> sections, DocumentProperties documentProperties) {
        ArrayList<RenderPage> pages = new ArrayList<RenderPage>();
        int displayCounter = 1;
        int totalCounter = 1;
        for (Section section : sections) {
            List<DocumentElement> elements;
            PageProperties pageProp = section.getDefaultProperties();
            if (pageProp.getPageNumberOffset() != null) {
                displayCounter = pageProp.getPageNumberOffset();
            }
            DefaultRenderContext context = new DefaultRenderContext(documentProperties, pageProp, 1, displayCounter, totalCounter, RenderContext.CONTEXT_TYPE.page);
            STSectionMark.Enum breakType = pageProp.getSectionType();
            if (breakType == null || breakType == STSectionMark.NEXT_PAGE) {
                pages.add(new RenderPage(context));
                ++displayCounter;
                ++totalCounter;
            } else if (breakType == STSectionMark.EVEN_PAGE) {
                do {
                    pages.add(new RenderPage(context));
                    ++totalCounter;
                } while (++displayCounter % 2 != 0);
            } else if (breakType == STSectionMark.ODD_PAGE) {
                do {
                    pages.add(new RenderPage(context));
                    ++totalCounter;
                } while (++displayCounter % 2 != 1);
            } else if (breakType == STSectionMark.NEXT_COLUMN) {
                if (pages.size() > 0) {
                    recent = (RenderPage)pages.get(pages.size() - 1);
                    recent.nextColumn();
                    context = new DefaultRenderContext(documentProperties, pageProp, recent.isPageCompleted() ? 1 : 2, displayCounter, totalCounter, RenderContext.CONTEXT_TYPE.page);
                }
            } else if (pages.size() > 0) {
                recent = (RenderPage)pages.get(pages.size() - 1);
                recent.initNewSection(pageProp);
                context = new DefaultRenderContext(documentProperties, pageProp, recent.isPageCompleted() ? 1 : 2, displayCounter, totalCounter, RenderContext.CONTEXT_TYPE.page);
            }
            if ((elements = section.getElements()).size() <= 0) continue;
            int count = pages.size();
            DocumentLayouter.layoutElements(elements, null, null, context, section == sections.get(sections.size() - 1), pages);
            count = pages.size() - count;
            displayCounter += count;
            totalCounter += count;
        }
        return pages;
    }

    public static List<RenderPage> layoutElements(List<DocumentElement> elements, RenderContext context) {
        return DocumentLayouter.layoutElements(elements, context, true);
    }

    public static List<RenderPage> layoutElements(List<DocumentElement> elements, RenderContext context, boolean isLastSection) {
        return DocumentLayouter.layoutElements(elements, null, null, context, isLastSection);
    }

    public static List<RenderPage> layoutElements(List<DocumentElement> elements, CellPageBreakPosition startPosition, CellPageBreakPosition endPosition, RenderContext context, boolean isLastSection) {
        return DocumentLayouter.layoutElements(elements, startPosition, endPosition, context, isLastSection, new ArrayList<RenderPage>());
    }

    public static List<RenderPage> layoutElements(List<DocumentElement> elements, CellPageBreakPosition startPosition, CellPageBreakPosition endPosition, RenderContext context, boolean isLastSection, List<RenderPage> pages) {
        if (startPosition != null || endPosition != null) {
            int start = Math.max(startPosition != null ? elements.indexOf(startPosition.getBreakElement()) : 0, 0);
            int end = endPosition != null ? elements.indexOf(endPosition.getBreakElement()) + 1 : elements.size();
            elements = elements.subList(start, end);
        }
        if (!elements.isEmpty()) {
            DocumentLayouter.layoutElements(pages, elements, elements.get(0), elements.get(elements.size() - 1), startPosition, endPosition, context, isLastSection);
        }
        return pages;
    }

    private static void layoutElements(List<RenderPage> pages, List<DocumentElement> elements, DocumentElement firstElement, DocumentElement lastElement, CellPageBreakPosition startPosition, CellPageBreakPosition endPosition, RenderContext context, boolean isLastSection) {
        DocumentElement element;
        HashMap firstKeepToAllKeepElements = new HashMap();
        LinkedList<DocumentElement> layoutElements = new LinkedList<DocumentElement>(elements);
        DocumentElement firstKeepElement = null;
        if (context.getContextType() != RenderContext.CONTEXT_TYPE.keepTogetherCheck) {
            for (int i = 0; i < layoutElements.size(); ++i) {
                DocumentElement element2 = layoutElements.get(i);
                if (firstKeepElement == null) {
                    if (!element2.isKeepParagraphTogetherWithNextParagraph()) continue;
                    firstKeepElement = element2;
                    LinkedList<DocumentElement> keepElements = new LinkedList<DocumentElement>();
                    keepElements.add(firstKeepElement);
                    firstKeepToAllKeepElements.put(firstKeepElement, keepElements);
                    continue;
                }
                if (element2 instanceof ParagraphData && !element2.isKeepParagraphTogetherWithNextParagraph()) {
                    ((LinkedList)firstKeepToAllKeepElements.get(firstKeepElement)).add(element2);
                    firstKeepElement = null;
                    continue;
                }
                ((LinkedList)firstKeepToAllKeepElements.get(firstKeepElement)).add(element2);
            }
        }
        while ((element = layoutElements.poll()) != null) {
            boolean isFirst = element == firstElement;
            boolean isLast = element == lastElement;
            CellPageBreakPosition elementStartPosition = isFirst && startPosition != null ? startPosition : null;
            CellPageBreakPosition elementEndPosition = isLast && endPosition != null ? endPosition : null;
            LinkedList keepTogetherElements = (LinkedList)firstKeepToAllKeepElements.get(element);
            if (keepTogetherElements != null && keepTogetherElements.size() != elements.size()) {
                List<RenderPage> startWithNewPages;
                DefaultRenderContext contextCopy = new DefaultRenderContext(context.getDocumentProperties(), context.getPageLayout().clone(), context, RenderContext.CONTEXT_TYPE.keepTogetherCheck);
                ArrayList<RenderPage> pageContext = new ArrayList<RenderPage>();
                if (pages.size() > 0) {
                    pageContext.add(pages.get(pages.size() - 1).createCopy());
                }
                if ((startWithNewPages = DocumentLayouter.layoutElements(keepTogetherElements, null, null, contextCopy, true, pageContext)).size() > 1) {
                    pages.add(new RenderPage(context, 1));
                }
            }
            DocumentLayouter.addToPages(pages, element, elementStartPosition, elementEndPosition, context, isLastSection && isLast, 0);
        }
    }

    private static void addToPages(List<RenderPage> pages, DocumentElement element, CellPageBreakPosition startPosition, CellPageBreakPosition endPosition, RenderContext context, boolean isLastElementInLastSection, int cancelCounter) {
        RenderPage currentPage;
        if (cancelCounter > 100) {
            Util.LOGGER.error((Object)"An unexpected error occurred. Please send your documents to the support.");
            return;
        }
        if (pages.isEmpty()) {
            currentPage = new RenderPage(context);
            pages.add(currentPage);
        }
        context = (currentPage = pages.get(pages.size() - 1)).getPageLayout() == context.getPageLayout() ? currentPage : new DefaultRenderContext(context.getDocumentProperties(), context.getPageLayout(), context.getInSectionPageNumber() - 1, context.getDisplayPageNumber() - 1, context.getTotalPageNumber() - 1, context.getContextType());
        if (element.isEmpty() && isLastElementInLastSection && currentPage.getAllElements().size() > 0 && !currentPage.isPageCompleted()) {
            return;
        }
        Util.LOGGER.debug((Object)("currentPage = " + pages.size()));
        Layouter layouter = element.getLayouter();
        do {
            if (currentPage.isPageCompleted()) {
                currentPage = new RenderPage(context, 1);
                context = currentPage;
                pages.add(currentPage);
            }
            int spacing = element.getSpacing() != null ? element.getSpacing().getBefore() : 0;
            LayoutArea availableColumnSpace = currentPage.getAvailableColumnSpace(spacing);
            boolean isFirstPageContent = currentPage.getRenderHeight() == availableColumnSpace.getHeight();
            LayouterResult layouterResult = layouter.doLayouter(startPosition, endPosition, availableColumnSpace, currentPage, currentPage.getAnchorManager(), isFirstPageContent);
            if (layouterResult.needPageRelayout()) {
                currentPage.setRelayout(true);
                ArrayList relayoutElements = new ArrayList();
                currentPage.getAllElements().forEach(e -> relayoutElements.add(e.getSource()));
                if (!relayoutElements.isEmpty()) {
                    currentPage.removeElements(null);
                }
                currentPage.getAnchorManager().removeParagraphSpecificAnchorElements();
                for (int i = 0; i < relayoutElements.size(); ++i) {
                    DocumentElement documentElement = (DocumentElement)relayoutElements.get(i);
                    CellPageBreakPosition start = i == 0 ? startPosition : null;
                    CellPageBreakPosition end = i == relayoutElements.size() - 1 ? endPosition : null;
                    boolean endSection = i == relayoutElements.size() - 1 && isLastElementInLastSection;
                    DocumentLayouter.addToPages(pages, documentElement, start, end, currentPage, endSection, cancelCounter + 1);
                }
                DocumentLayouter.addToPages(pages, element, startPosition, endPosition, currentPage, isLastElementInLastSection, cancelCounter + 1);
                return;
            }
            Object view = layouterResult.getPageView();
            if (view != null) {
                currentPage.addElement((PageElement)layouterResult.getPageView());
            }
            startPosition = layouterResult.getBreakPosition();
            if (layouterResult.getBreakType() == Break.BreakType.page) {
                if (startPosition != null || isLastElementInLastSection) {
                    currentPage = new RenderPage(context, 1);
                    context = currentPage;
                    pages.add(currentPage);
                    continue;
                }
                while (!currentPage.isPageCompleted()) {
                    currentPage.nextColumn();
                }
            } else {
                if (startPosition == null && layouterResult.getBreakType() != Break.BreakType.column) continue;
                currentPage.nextColumn();
            }
        } while (startPosition != null);
    }
}

