/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.layout;

import com.inet.docx.document.elements.subelements.Drawing;
import com.inet.docx.document.elements.subelements.Positionable;
import com.inet.docx.view.AreaObjects;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AnchorManager {
    private Map<Drawing, Positionable> anchorViews = new LinkedHashMap<Drawing, Positionable>();

    public boolean addAnchoredElement(Drawing source) {
        if (this.anchorViews.containsKey(source)) {
            return false;
        }
        this.anchorViews.put(source, source);
        return true;
    }

    public void removeParagraphSpecificAnchorElements() {
        ArrayList<Drawing> removeElements = new ArrayList<Drawing>();
        for (Drawing drawing : this.anchorViews.keySet()) {
            if (!drawing.isAnchorParagraphSpecific()) continue;
            removeElements.add(drawing);
            break;
        }
        for (Drawing removeElement : removeElements) {
            this.anchorViews.remove(removeElement);
        }
    }

    public void getElements(AreaObjects addTo) {
        this.anchorViews.keySet().forEach(addTo::addDrawing);
    }

    public void collectElements(List<Positionable> addTo) {
        addTo.addAll(this.anchorViews.keySet());
    }

    public boolean hasElements() {
        return !this.anchorViews.isEmpty();
    }

    public AnchorManager copy() {
        AnchorManager copy = new AnchorManager();
        this.anchorViews.forEach((d, p) -> copy.anchorViews.put((Drawing)d, (Positionable)p));
        return copy;
    }
}

