/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.document.utilities;

import com.inet.docx.document.DocumentProperties;
import com.inet.docx.document.elements.DocumentElement;
import com.inet.docx.document.elements.format.WindowsDateFormat;
import com.inet.docx.document.elements.style.Indent;
import com.inet.docx.document.elements.style.LineProperties;
import com.inet.docx.document.elements.style.RenderFont;
import com.inet.docx.document.elements.style.RunRenderInformations;
import com.inet.docx.document.elements.subelements.BorderLines;
import com.inet.docx.document.elements.subelements.ParagraphElement;
import com.inet.docx.document.elements.subelements.Tab;
import com.inet.docx.document.elements.subelements.TextRowElement;
import com.inet.docx.document.elements.subelements.drawing.TextWrapping;
import com.inet.docx.document.paragraph.ParagraphData;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.apache.poi.xssf.model.ThemesTable;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.xmlbeans.SimpleValue;
import org.apache.xmlbeans.XmlAnySimpleType;
import org.apache.xmlbeans.XmlBoolean;
import org.apache.xmlbeans.XmlTokenSource;
import org.apache.xmlbeans.impl.values.XmlObjectBase;
import org.apache.xmlbeans.impl.values.XmlValueNotSupportedException;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTBoolean;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPercentage;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPositiveFixedPercentage;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPresetColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSRgbColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSchemeColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSolidColorFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.STSchemeColorVal;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.STWrapText;
import org.openxmlformats.schemas.officeDocument.x2006.sharedTypes.STOnOff;
import org.openxmlformats.schemas.officeDocument.x2006.sharedTypes.STOnOff1;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTColor;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBorder;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHighlight;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTInd;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTOnOff;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPBdr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTabStop;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTabs;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblWidth;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STBorder;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STShd;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class Util {
    public static final HashMap<String, Double> SUPPORTED_UNIT = new HashMap();
    public static final double TWIPS_PER_PIXEL = 15.0;
    public static final double POINT_IN_TWIPS = 20.0;
    public static final double MM_IN_TWIPS = 56.69291338583;
    public static final double CM_IN_TWIPS = 566.9291338583;
    public static final double IN_IN_TWIPS = 1440.0;
    public static final double PARSECS_IN_TWIPS = 56.69291338583;
    public static final int TWIPS_IN_EMU = 635;
    public static final double PERCENTAGE = 100000.0;
    public static String defaultPattern;
    public static char dateEnd;
    public static boolean isDebugMode;
    private static final Map<String, Color> NAMED_TEXT_BACKGROUND_COLORS;
    public static final Logger LOGGER;

    public static HashMap<String, Double> getSupportedUnit() {
        if (SUPPORTED_UNIT.isEmpty()) {
            SUPPORTED_UNIT.put("pt", 20.0);
            SUPPORTED_UNIT.put("in", 1440.0);
            SUPPORTED_UNIT.put("mm", 56.69291338583);
            SUPPORTED_UNIT.put("cm", 566.9291338583);
            SUPPORTED_UNIT.put("pc", 56.69291338583);
            SUPPORTED_UNIT.put("px", 15.0);
            SUPPORTED_UNIT.put("%", 0.01);
            SUPPORTED_UNIT.put("f", 1.52587890625E-5);
        }
        return SUPPORTED_UNIT;
    }

    private static Map<String, Color> initColors() {
        HashMap<String, Color> colorMap = new HashMap<String, Color>();
        colorMap.put("aqua", new Color(0, 255, 255));
        colorMap.put("black", Color.BLACK);
        colorMap.put("blue", Color.BLUE);
        colorMap.put("cyan", Color.CYAN);
        colorMap.put("darkBlue", new Color(0, 0, 139));
        colorMap.put("darkCyan", new Color(0, 139, 139));
        colorMap.put("darkGray", new Color(169, 169, 169));
        colorMap.put("darkGreen", new Color(0, 100, 0));
        colorMap.put("darkMagenta", new Color(139, 0, 139));
        colorMap.put("darkRed", new Color(139, 0, 0));
        colorMap.put("darkYellow", new Color(139, 139, 0));
        colorMap.put("green", Color.GREEN);
        colorMap.put("lightGray", new Color(211, 211, 211));
        colorMap.put("magenta", Color.MAGENTA);
        colorMap.put("red", Color.RED);
        colorMap.put("silver", new Color(192, 192, 192));
        colorMap.put("yellow", Color.YELLOW);
        return colorMap;
    }

    public static Color getColorByName(String name) {
        return NAMED_TEXT_BACKGROUND_COLORS.get(name);
    }

    public static Color getColorByName(CTHighlight highlight) {
        String sthc = highlight.xgetVal().getStringValue();
        return NAMED_TEXT_BACKGROUND_COLORS.get(sthc);
    }

    public static Color getColorFromString(String colorString, Color defaultColor) {
        if (!"auto".equals(colorString)) {
            int red = Integer.parseInt(colorString.substring(0, 2), 16);
            int green = Integer.parseInt(colorString.substring(2, 4), 16);
            int blue = Integer.parseInt(colorString.substring(4, 6), 16);
            return new Color(red, green, blue, 255);
        }
        return defaultColor;
    }

    private static int getBrightness(Color c) {
        return (int)Math.sqrt((double)(c.getRed() * c.getRed()) * 0.241 + (double)(c.getGreen() * c.getGreen()) * 0.691 + (double)(c.getBlue() * c.getBlue()) * 0.068);
    }

    public static void applyAutoColor(ParagraphData pa, Color background) {
        if (background == null) {
            return;
        }
        List<ParagraphElement> paraElements = pa.getElements();
        for (ParagraphElement paraE : paraElements) {
            if (!(paraE instanceof TextRowElement)) continue;
            Util.applyAutoColor((TextRowElement)paraE, background);
        }
        Color paColor = pa.getStyle().getFontColor();
        if ((paColor == null || paColor == RunRenderInformations.AUTO) && pa.getNumbering() != null) {
            Color autoColor = Util.getAutoColorForBackground(background);
            pa.getNumbering().setAutoColor(autoColor);
        }
    }

    private static void applyAutoColor(TextRowElement row, Color background) {
        if (row.getColor() != null && row.getColor() != RunRenderInformations.AUTO) {
            return;
        }
        row.setColor(Util.getAutoColorForBackground(background));
    }

    private static Color getAutoColorForBackground(Color bgColor) {
        if (bgColor != null && bgColor.getAlpha() > 192 && Util.getBrightness(bgColor) < 130) {
            return Color.white;
        }
        return Color.BLACK;
    }

    public static Color getColorFromObject(Object obj, Color defaultColor) {
        if (obj instanceof byte[] && ((byte[])obj).length == 3) {
            byte[] colInfo = (byte[])obj;
            return new Color(0xFF & colInfo[0], 0xFF & colInfo[1], 0xFF & colInfo[2]);
        }
        return defaultColor;
    }

    private static int getAlphaFromSTShd(STShd.Enum shdAlpha) {
        switch (shdAlpha.toString()) {
            case "pct5": {
                return 12;
            }
            case "pct10": {
                return 25;
            }
            case "pct15": {
                return 38;
            }
            case "pct20": {
                return 51;
            }
            case "pct25": {
                return 63;
            }
            case "pct30": {
                return 76;
            }
            case "pct35": {
                return 89;
            }
            case "pct40": {
                return 102;
            }
            case "pct45": {
                return 114;
            }
            case "pct50": {
                return 127;
            }
            case "pct55": {
                return 140;
            }
            case "pct60": {
                return 153;
            }
            case "pct65": {
                return 165;
            }
            case "pct70": {
                return 178;
            }
            case "pct80": {
                return 204;
            }
            case "pct85": {
                return 216;
            }
            case "pct90": {
                return 229;
            }
            case "pct95": {
                return 242;
            }
        }
        return 255;
    }

    public static Color getColor(STShd.Enum shdAlpha, Object color, Object fill, Object theme, HashMap<String, Color> themeColors) {
        Color result = null;
        if (color != null) {
            result = "auto".equals(color) ? Color.BLACK : Util.getColorFromObject(color, null);
        }
        if (result == null && fill != null) {
            result = Util.getColorFromObject(fill, null);
        }
        if (result == null && fill != null && theme != null) {
            result = themeColors.get(theme.toString());
        }
        if (shdAlpha != null && result != null && result.getAlpha() == 255) {
            result = new Color(result.getRed(), result.getGreen(), result.getBlue(), Util.getAlphaFromSTShd(shdAlpha));
        }
        return result;
    }

    public static Color getColorFrom(CTSchemeColor sc, CTSRgbColor srgb, CTPresetColor prst, DocumentProperties props, HashMap<String, String> colorAiasMap) {
        Color color = null;
        List percentageList = null;
        if (sc != null) {
            STSchemeColorVal.Enum name = sc.getVal();
            String colorName = name.toString();
            if (colorAiasMap != null && colorAiasMap.get(colorName) != null) {
                colorName = colorAiasMap.get(colorName);
            }
            Color color2 = color = props != null ? props.getThemeColor(colorName) : null;
            if (color != null) {
                percentageList = sc.getAlphaList();
                color = percentageList.size() > 0 ? Util.getColorWithAlpha(color, (CTPositiveFixedPercentage)percentageList.get(0)) : ((percentageList = sc.getShadeList()).size() > 0 ? Util.getColorWithShade(color, (CTPositiveFixedPercentage)percentageList.get(0)) : Util.convertColorLumModandOff(color, sc.getLumModList(), sc.getLumOffList()));
            }
        } else if (srgb != null) {
            byte[] colorBytes = srgb.getVal();
            color = new Color(0xFF & colorBytes[0], 0xFF & colorBytes[1], 0xFF & colorBytes[2]);
            percentageList = srgb.getAlphaList();
            color = percentageList.size() > 0 ? Util.getColorWithAlpha(color, (CTPositiveFixedPercentage)percentageList.get(0)) : ((percentageList = srgb.getShadeList()).size() > 0 ? Util.getColorWithShade(color, (CTPositiveFixedPercentage)percentageList.get(0)) : Util.convertColorLumModandOff(color, srgb.getLumModList(), srgb.getLumOffList()));
        } else if (prst != null && prst.getVal() != null) {
            color = NAMED_TEXT_BACKGROUND_COLORS.get(prst.getVal().toString());
        }
        return color;
    }

    private static Color getColorWithShade(Color color, CTPositiveFixedPercentage percentage) {
        double shadeValue = Util.getDouble(percentage.getVal()) / 100000.0;
        return new Color((int)((double)color.getRed() * shadeValue), (int)((double)color.getGreen() * shadeValue), (int)((double)color.getBlue() * shadeValue));
    }

    private static Color getColorWithAlpha(Color color, CTPositiveFixedPercentage percentage) {
        int alphaValue = (int)Math.round(Util.getDouble(percentage.getVal()) * 255.0 / 100000.0);
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alphaValue);
    }

    public static Color getColorFromSolidFill(CTSolidColorFillProperties scfp, DocumentProperties props, HashMap<String, String> colorAiasMap) {
        Color color = null;
        if (scfp != null) {
            color = Util.getColorFrom(scfp.getSchemeClr(), scfp.getSrgbClr(), scfp.getPrstClr(), props, colorAiasMap);
        }
        return color;
    }

    public static Color convertColorLumModandOff(Color color, List<CTPercentage> lumMod, List<CTPercentage> lumOff) {
        if (lumMod.size() == 0 && lumOff.size() == 0) {
            return color;
        }
        int off = 0;
        int mod = 0;
        if (lumOff.size() > 0) {
            off = Util.getInt(lumOff.get(0).getVal());
        }
        if (lumMod.size() > 0) {
            mod = Util.getInt(lumMod.get(0).getVal());
        }
        return Util.getColorLumModandOff(color, mod, off);
    }

    private static Color getColorLumModandOff(Color color, int lumMod, int lumOff) {
        if (lumMod == 0 && lumOff == 0) {
            return color;
        }
        float[] rgb = color.getRGBColorComponents(null);
        float r = rgb[0];
        float g = rgb[1];
        float b = rgb[2];
        float min = Math.min(r, Math.min(g, b));
        float max = Math.max(r, Math.max(g, b));
        float h = 0.0f;
        if (max == min) {
            h = 0.0f;
        } else if (max == r) {
            h = (60.0f * (g - b) / (max - min) + 360.0f) % 360.0f;
        } else if (max == g) {
            h = 60.0f * (b - r) / (max - min) + 120.0f;
        } else if (max == b) {
            h = 60.0f * (r - g) / (max - min) + 240.0f;
        }
        float l = (max + min) / 2.0f;
        l = l * (float)lumMod / 100000.0f + (float)lumOff / 100000.0f;
        float s = 0.0f;
        s = max == min ? 0.0f : (l <= 0.5f ? (max - min) / (max + min) : (max - min) / (2.0f - max - min));
        h %= 360.0f;
        float q = 0.0f;
        q = (double)l < 0.5 ? l * (1.0f + s) : l + s - s * l;
        float p = 2.0f * l - q;
        r = Math.max(0.0f, Util.HueToRGB(p, q, (h /= 360.0f) + 0.33333334f));
        g = Math.max(0.0f, Util.HueToRGB(p, q, h));
        b = Math.max(0.0f, Util.HueToRGB(p, q, h - 0.33333334f));
        r = Math.min(r, 1.0f);
        g = Math.min(g, 1.0f);
        b = Math.min(b, 1.0f);
        return new Color(r, g, b, 1.0f);
    }

    public static Color convertCtColor(CTColor color, ThemesTable themesTable) {
        if (color.isSetIndexed()) {
            XSSFColor col = themesTable.getThemeColor((int)((short)color.getTheme()));
            return Util.convertXssfColor(col);
        }
        byte[] rgb = color.getRgb();
        if (rgb != null) {
            return new Color(0xFF & rgb[1], 0xFF & rgb[2], 0xFF & rgb[3], 0xFF & rgb[0]);
        }
        return null;
    }

    public static Color convertXssfColor(XSSFColor color) {
        if (color != null) {
            if (color.isRGB()) {
                byte[] rgb = color.getRGB();
                return new Color(0xFF & rgb[0], 0xFF & rgb[1], 0xFF & rgb[2]);
            }
            if (color.isAuto()) {
                return Color.BLACK;
            }
            LOGGER.error((Object)(String.valueOf(color.getCTColor()) + " " + color.isIndexed() + " " + color.isThemed() + " " + color.getARGBHex()));
        }
        return null;
    }

    public static double convertTwipsToPoint(double twips) {
        return twips / 20.0;
    }

    public static double convertPointToTwips(double point) {
        return point * 20.0;
    }

    public static int readIntAttribute(XmlTokenSource modelObject, String key) {
        Integer result = Util.readIntegerAttribute(modelObject, key);
        return result != null ? result : 0;
    }

    public static Integer readIntegerAttribute(XmlTokenSource modelObject, String key) {
        NamedNodeMap map = modelObject.getDomNode().getAttributes();
        for (int i = 0; i < map.getLength(); ++i) {
            Node node = map.item(i);
            if (!key.equals(node.getLocalName())) continue;
            return (int)Double.parseDouble(node.getNodeValue());
        }
        return null;
    }

    public static boolean isSet(CTOnOff onoff) {
        return Util.getBool(onoff);
    }

    public static boolean isSet(STOnOff onoff) {
        return Util.getBool(onoff);
    }

    public static Boolean getBooleanForOnOff(CTOnOff onoff, boolean defaultIfNull) {
        if (onoff != null) {
            return onoff.getVal() != null ? Boolean.valueOf(Util.isSet(onoff)) : (defaultIfNull ? Boolean.TRUE : Boolean.FALSE);
        }
        return null;
    }

    public static boolean isSet(CTBoolean ctb) {
        if (ctb != null) {
            return ctb.getVal();
        }
        return false;
    }

    public static int getValueFromWidth(CTTblWidth val) {
        if (val != null) {
            return Util.getIntValue(() -> ((CTTblWidth)val).getW(), (XmlTokenSource)val, "w:w");
        }
        return 0;
    }

    public static BorderLines getBorders(CTPBdr paraBdr, HashMap<String, Color> themeColors) {
        if (paraBdr != null) {
            BorderLines borders = new BorderLines();
            borders.setBottomLine(Util.getLinePropertiesFromBorder(paraBdr.getBottom(), themeColors));
            borders.setTopLine(Util.getLinePropertiesFromBorder(paraBdr.getTop(), themeColors));
            borders.setLeftLine(Util.getLinePropertiesFromBorder(paraBdr.getLeft(), themeColors));
            borders.setRightLine(Util.getLinePropertiesFromBorder(paraBdr.getRight(), themeColors));
            return borders;
        }
        return null;
    }

    public static LineProperties getLinePropertiesFromBorder(CTBorder border, HashMap<String, Color> themeColors) {
        if (border != null) {
            STBorder.Enum val;
            int width = 0;
            double space = 0.0;
            Color color = null;
            String style = "single";
            color = Util.getColor(null, border.getColor(), null, border.getThemeColor(), themeColors);
            if (color == null && "auto".equals(border.getColor())) {
                color = Color.BLACK;
            }
            if ((val = border.getVal()) != null) {
                style = val.toString();
            }
            if (border.isSetSz()) {
                width = Util.convertBorderValueToTwips(Util.getIntValue(() -> ((CTBorder)border).getSz(), (XmlTokenSource)border, "w:sz"));
                if ("double".equals(style)) {
                    width *= 3;
                } else if ("triple".equals(style)) {
                    width *= 5;
                }
            }
            if (border.isSetSpace()) {
                space = border.getSpace().doubleValue() * 20.0;
            }
            return new LineProperties(color, style, width, space);
        }
        return LineProperties.EMPTY_LINE;
    }

    public static DecimalFormat getFormaterForDecimalPattern(String pattern) {
        pattern = pattern.replace('0', '#');
        return new DecimalFormat(pattern);
    }

    private static boolean isDecimalPattern(String pattern) {
        block3: for (int i = 0; i < pattern.length(); ++i) {
            char ch = pattern.charAt(i);
            switch (ch) {
                case '#': 
                case '%': 
                case '.': 
                case '0': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public static Format getFormaterForPattern(String pattern) {
        if (defaultPattern == null) {
            SimpleDateFormat sdf = new SimpleDateFormat();
            defaultPattern = sdf.toPattern();
            dateEnd = defaultPattern.charAt(defaultPattern.indexOf(121) - 1);
        }
        if (((String)pattern).endsWith(";@")) {
            pattern = ((String)pattern).substring(0, ((String)pattern).length() - 2);
        }
        boolean isDecimalPattern = Util.isDecimalPattern((String)pattern);
        if ("General".equals(pattern)) {
            return Util.getFormaterForDecimalPattern("#.#");
        }
        if (isDecimalPattern) {
            return new DecimalFormat((String)pattern);
        }
        if ("m/d/yyyy".equals(pattern)) {
            pattern = defaultPattern.substring(0, defaultPattern.indexOf(32));
            pattern = ((String)pattern).replace("yy", "yyyy");
        } else if (((String)pattern).startsWith("[$-F800]")) {
            pattern = "EEEE," + defaultPattern.substring(0, defaultPattern.indexOf(32));
            pattern = ((String)pattern).replace("dd", "d");
            pattern = ((String)pattern).replace("MM.", "MMMM ");
            pattern = ((String)pattern).replace("yy", "yyyy");
            pattern = ((String)pattern).replace(".", ". ");
            pattern = ((String)pattern).replace(",", ", ");
            pattern = ((String)pattern).replace("/", "/ ");
        } else if (((String)pattern).startsWith("[$-")) {
            pattern = ((String)pattern).substring(((String)pattern).indexOf(93) + 1);
            pattern = Util.convertPattern((String)pattern);
        } else {
            pattern = Util.convertPattern((String)pattern);
        }
        return new WindowsDateFormat((String)pattern);
    }

    private static String convertPattern(String pattern) {
        if (pattern.contains("mmmmm")) {
            pattern = pattern.replace("mmmmm", "M");
        }
        if (pattern.contains("dddd")) {
            pattern = pattern.replace("dddd", "EEEE");
        } else if (pattern.contains("ddd")) {
            pattern = pattern.replace("ddd", "EEEE");
        }
        if (pattern.contains("AM/PM")) {
            pattern = pattern.replace("AM/PM", "aaa");
        } else if (pattern.contains("am/pm")) {
            pattern = pattern.replace("am/pm", "aaa");
        } else if (pattern.contains("hh:mm")) {
            pattern = pattern.replace("hh:mm", "HH:mm");
        } else if (pattern.contains("h:mm")) {
            pattern = pattern.replace("h:mm", "H:mm");
        }
        boolean fixChar = false;
        boolean time = false;
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < pattern.length(); ++i) {
            int patChar = pattern.charAt(i);
            if (fixChar) {
                fixChar = false;
            } else {
                if (patChar == 92) {
                    fixChar = true;
                    continue;
                }
                if (104 == patChar || 72 == patChar) {
                    time = true;
                } else if (109 == patChar && !time) {
                    patChar = 77;
                }
            }
            buf.append((char)patChar);
        }
        pattern = buf.toString();
        return pattern;
    }

    public static Indent getIndent(CTInd ind, Indent defaultIndent) {
        Integer left = null;
        Integer right = null;
        Integer hanging = null;
        Integer firstLine = null;
        if (ind.getLeftChars() != null) {
            LOGGER.debug((Object)"Indent left chars not implemented yet");
        }
        if (ind.getRightChars() != null) {
            LOGGER.debug((Object)"Indent right chars not implemented yet");
        }
        if (ind.getFirstLineChars() != null) {
            LOGGER.debug((Object)"Indent firstline chars not implemented yet");
        }
        if (ind.getHangingChars() != null) {
            LOGGER.debug((Object)"Indent hanging chars not implemented yet");
        }
        if (ind.isSetLeft()) {
            int leftValue = Util.getIntValue(() -> ((CTInd)ind).getLeft(), (XmlTokenSource)ind, "w:left");
            left = leftValue;
        }
        if (ind.isSetFirstLine()) {
            int leftfirstLine = Util.getIntValue(() -> ((CTInd)ind).getFirstLine(), (XmlTokenSource)ind, "w:firstLine");
            firstLine = leftfirstLine;
        }
        if (ind.isSetRight()) {
            int rightValue = Util.getIntValue(() -> ((CTInd)ind).getRight(), (XmlTokenSource)ind, "w:right");
            right = rightValue;
        }
        if (ind.isSetHanging()) {
            int hangingValue = Util.getIntValue(() -> ((CTInd)ind).getHanging(), (XmlTokenSource)ind, "w:hanging");
            hanging = hangingValue;
        }
        return Indent.mergeIndentInformations(new Indent(right, left, firstLine, hanging), defaultIndent);
    }

    private static int convertBorderValueToTwips(int val) {
        return (int)((double)val * 2.5);
    }

    public static double convertEmuToTwips(long emu) {
        return (double)emu / 635.0;
    }

    public static double convertEmuToTwips(double emu) {
        return emu / 635.0;
    }

    public static int convertPtStringToTwips(String value) {
        if (Pattern.matches("([0-9]*\\.?[0-9]+)pt", value)) {
            value = value.substring(0, value.length() - 2);
            float f = Float.parseFloat(value) * 20.0f;
            return (int)f;
        }
        return -1;
    }

    public static ArrayList<Tab> getTabs(CTTabs tabDef, RenderFont rf) {
        ArrayList<Tab> tabsData = new ArrayList<Tab>();
        List tabs = tabDef.getTabList();
        for (CTTabStop ctTab : tabs) {
            Tab tab = new Tab(ctTab.getVal(), ctTab.getLeader(), Util.getIntValue(() -> ((CTTabStop)ctTab).getPos(), (XmlTokenSource)ctTab, "w:pos"));
            tab.setRenderFont(rf);
            tabsData.add(tab);
        }
        return tabsData;
    }

    private static int getIntValue(Supplier<Object> intProvider, XmlTokenSource source, String attributeName) {
        try {
            return Util.getInt(intProvider.get());
        }
        catch (Exception e) {
            Node positionNode = source.getDomNode().getAttributes().getNamedItem(attributeName);
            if (positionNode != null && positionNode.getNodeValue() != null) {
                try {
                    return (int)Double.parseDouble(positionNode.getNodeValue());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return 0;
        }
    }

    public static ArrayList<DocumentElement> cloneData(List<DocumentElement> elements) {
        ArrayList<DocumentElement> newElements = new ArrayList<DocumentElement>();
        for (DocumentElement element : elements) {
            newElements.add(element.clone());
        }
        return newElements;
    }

    public static int getIntValue(XmlObjectBase source, QName name, int defaultValue) {
        SimpleValue value = (SimpleValue)source.get_store().find_element_user(name, 0);
        if (value != null) {
            String str = value.getStringValue();
            return Integer.parseInt(str);
        }
        return defaultValue;
    }

    private static float HueToRGB(float p, float q, float h) {
        if (h < 0.0f) {
            h += 1.0f;
        }
        if (h > 1.0f) {
            h -= 1.0f;
        }
        if (6.0f * h < 1.0f) {
            return p + (q - p) * 6.0f * h;
        }
        if (2.0f * h < 1.0f) {
            return q;
        }
        if (3.0f * h < 2.0f) {
            return p + (q - p) * 6.0f * (0.6666667f - h);
        }
        return p;
    }

    public static int getValueIfNotNull(BigInteger val, int defaultValue) {
        if (val != null) {
            return val.intValue();
        }
        return defaultValue;
    }

    public static TextWrapping.Side getWrappingSide(STWrapText.Enum value) {
        switch (value.intValue()) {
            case 1: {
                return TextWrapping.Side.BOTHSIDE;
            }
            case 4: {
                return TextWrapping.Side.LARGEST;
            }
            case 2: {
                return TextWrapping.Side.LEFT;
            }
            case 3: {
                return TextWrapping.Side.RIGHT;
            }
        }
        LOGGER.error((Object)("The wrapping side is not implemented (not defined). It used The fallback bothside. The current value is " + value.intValue()));
        return TextWrapping.Side.BOTHSIDE;
    }

    public static double[] calcToPoint(double[] values) {
        for (int i = 0; i < values.length; ++i) {
            values[i] = values[i] / 20.0;
        }
        return values;
    }

    public static int getEndNumber(String value) {
        char[] chars = value.toCharArray();
        int startNumber = -1;
        for (int i = 0; i < chars.length; ++i) {
            if (Character.isDigit(chars[i])) {
                if (startNumber != -1) continue;
                startNumber = i;
                continue;
            }
            startNumber = -1;
        }
        if (startNumber != -1) {
            return Integer.parseInt(value.substring(startNumber));
        }
        return -1;
    }

    public static boolean getBool(Object o) {
        return Util.getBool(o, false);
    }

    public static boolean getBool(Object o, boolean defaultValue) {
        if (o == null) {
            return defaultValue;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof STOnOff1) {
            try {
                return ((STOnOff1)o).getEnumValue() == STOnOff1.ON;
            }
            catch (XmlValueNotSupportedException xmlValueNotSupportedException) {
                // empty catch block
            }
        }
        if (o instanceof XmlBoolean) {
            try {
                return ((XmlBoolean)o).getBooleanValue();
            }
            catch (XmlValueNotSupportedException xmlValueNotSupportedException) {
                // empty catch block
            }
        }
        if (o instanceof SimpleValue) {
            try {
                return ((SimpleValue)o).getBooleanValue();
            }
            catch (XmlValueNotSupportedException xmlValueNotSupportedException) {
                // empty catch block
            }
        }
        String booleanValue = null;
        if (o instanceof String) {
            booleanValue = (String)o;
        }
        if (o instanceof STOnOff) {
            booleanValue = ((STOnOff)o).getStringValue().toLowerCase();
        }
        if (o instanceof CTOnOff) {
            return Util.getBool(((CTOnOff)o).getVal(), defaultValue);
        }
        if (o instanceof XmlAnySimpleType) {
            booleanValue = ((XmlAnySimpleType)o).getStringValue().toLowerCase();
        }
        if (booleanValue != null) {
            return "on".equals(booleanValue) || "true".equals(booleanValue) || "1".equals(booleanValue);
        }
        throw new IllegalArgumentException("Cannot convert value of type " + o.getClass().getName() + " / " + String.valueOf(o) + " to a boolean value");
    }

    public static long getLong(Object o) {
        if (o == null) {
            return 0L;
        }
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        if (o instanceof SimpleValue) {
            return ((SimpleValue)o).getLongValue();
        }
        throw new IllegalArgumentException("Cannot convert value of type " + o.getClass().getName() + " to a long value");
    }

    public static int getInt(Object o) {
        if (o == null) {
            return 0;
        }
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        if (o instanceof SimpleValue) {
            return ((SimpleValue)o).getIntValue();
        }
        if (o instanceof String) {
            try {
                return Integer.parseInt((String)o);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException("Cannot convert value of type " + o.getClass().getName() + " / " + String.valueOf(o) + " to an int value");
    }

    public static double getDouble(Object o) {
        if (o == null) {
            return 0.0;
        }
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        if (o instanceof String) {
            String value = o.toString().trim();
            NumberFormat format = value.endsWith("%") ? DecimalFormat.getPercentInstance(Locale.US) : DecimalFormat.getNumberInstance(Locale.US);
            try {
                return format.parse(value).doubleValue();
            }
            catch (ParseException e) {
                new IllegalArgumentException("Cannot convert value '" + value + "'of type String to a double value");
            }
        }
        if (o instanceof SimpleValue) {
            return ((SimpleValue)o).getDoubleValue();
        }
        throw new IllegalArgumentException("Cannot convert value of type " + o.getClass().getName() + " to a double value");
    }

    public static Double getDoubleAsDouble(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        if (o instanceof SimpleValue) {
            return ((SimpleValue)o).getDoubleValue();
        }
        throw new IllegalArgumentException("Cannot convert value of type " + o.getClass().getName() + " to a Double value");
    }

    public static float getFloat(Object o) {
        if (o == null) {
            return 0.0f;
        }
        if (o instanceof Number) {
            return ((Number)o).floatValue();
        }
        if (o instanceof SimpleValue) {
            return ((SimpleValue)o).getFloatValue();
        }
        throw new IllegalArgumentException("Cannot convert value of type " + o.getClass().getName() + " to a float value");
    }

    public static <T> T getLast(T[] values) {
        if (values == null || values.length == 0) {
            return null;
        }
        return values[values.length - 1];
    }

    public static Rectangle2D getNormedBounds(Rectangle2D rect) {
        if (rect == null) {
            return null;
        }
        if (rect.getWidth() >= 0.0 && rect.getHeight() >= 0.0) {
            return rect;
        }
        double x1 = Util.getMinX(rect);
        double y1 = Util.getMinY(rect);
        double x2 = Util.getMaxX(rect);
        double y2 = Util.getMaxY(rect);
        return new Rectangle2D.Double(x1, y1, x2 - x1, y2 - y1);
    }

    public static double getMaxX(Rectangle2D rect) {
        return rect.getWidth() > 0.0 ? rect.getMaxX() : rect.getX();
    }

    public static double getMaxY(Rectangle2D rect) {
        return rect.getHeight() > 0.0 ? rect.getMaxY() : rect.getY();
    }

    public static double getMinX(Rectangle2D rect) {
        return rect.getWidth() < 0.0 ? rect.getMaxX() : rect.getX();
    }

    public static double getMinY(Rectangle2D rect) {
        return rect.getHeight() < 0.0 ? rect.getMaxY() : rect.getY();
    }

    public static String translateSymbolFontCharacters(String text, RenderFont renderFont) {
        if ("Symbol".equals(renderFont.getFontName())) {
            char[] chars = text.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                chars[i] = (char)(chars[i] | 0xF000);
            }
            text = new String(chars);
        }
        return text;
    }

    static {
        isDebugMode = false;
        NAMED_TEXT_BACKGROUND_COLORS = Util.initColors();
        LOGGER = LogManager.getLogger((String)"DocXParser");
    }
}

