/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.document.utilities;

import com.inet.docx.document.utilities.Util;
import javax.annotation.SuppressFBWarnings;

public class UnitNumber {
    private final double number;
    private final Unit unit;
    private double defaultFactor = 1.0;

    public UnitNumber(double value) {
        this(value, Unit.NONE);
    }

    public UnitNumber(double value, Unit unit) {
        this.number = value;
        this.unit = unit;
    }

    public UnitNumber(String valueWithUnit) {
        this(valueWithUnit, 1.0);
    }

    @SuppressFBWarnings(value={"REDOS"}, justification="TODO")
    public UnitNumber(String valueWithUnit, double defaultFactor) {
        if (valueWithUnit == null || valueWithUnit.isEmpty()) {
            this.number = 0.0;
            for (Unit value : Unit.values()) {
                if (!(Math.abs(value.getTwipsFactor() - defaultFactor) < 1.0E-7)) continue;
                this.unit = value;
                return;
            }
            this.unit = Unit.NONE;
        } else if (valueWithUnit.matches("[+-]?([0-9]+\\.)?[0-9]+")) {
            this.number = Double.parseDouble(valueWithUnit);
            for (Unit value : Unit.values()) {
                if (value.getTwipsFactor() != defaultFactor) continue;
                this.unit = value;
                return;
            }
            this.unit = Unit.NONE;
            this.defaultFactor = defaultFactor;
        } else if (valueWithUnit.matches(";")) {
            UnitNumber unitNumber = new UnitNumber(valueWithUnit.split(";")[0], defaultFactor);
            this.number = unitNumber.number;
            this.unit = unitNumber.unit;
            this.defaultFactor = unitNumber.defaultFactor;
        } else {
            valueWithUnit = valueWithUnit.toLowerCase();
            for (Unit value : Unit.values()) {
                if (!valueWithUnit.endsWith(value.getUnit())) continue;
                this.unit = value;
                UnitNumber unitNumber = new UnitNumber(valueWithUnit.replace(value.getUnit().toLowerCase(), ""));
                this.number = unitNumber.number;
                return;
            }
            Util.LOGGER.error((Object)("Not supported unit. The value is " + valueWithUnit));
            this.number = 0.0;
            this.unit = Unit.NONE;
        }
    }

    public double getNumber() {
        return this.number;
    }

    public double getAsTwips() {
        return this.number * this.defaultFactor * this.unit.getTwipsFactor();
    }

    public double getAsPoints() {
        return this.number * this.defaultFactor * this.unit.getTwipsFactor() / 20.0;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public String toString() {
        return "UnitNumber{number=" + this.number + ", unit=" + String.valueOf((Object)this.unit) + ", defaultFactor=" + this.defaultFactor + "}";
    }

    public static enum Unit {
        NONE("none", 1.0),
        PIXEL("px", 15.0),
        POINTS("pt", 20.0),
        MM("mm", 56.69291338583),
        CM("cm", Unit.MM.twipsFactor * 10.0),
        INCH("in", 1440.0),
        EMU("emu", 0.0015748031496062992),
        PERCENTAGE("%", 0.01),
        F("f", 1.52587890625E-5),
        PC("pc", 250.0);

        private double twipsFactor;
        private String unit;

        private Unit(String unit, double twipsFactor) {
            this.unit = unit;
            this.twipsFactor = twipsFactor;
        }

        public double getTwipsFactor() {
            return this.twipsFactor;
        }

        public String getUnit() {
            return this.unit;
        }

        public String toString() {
            return "Unit{" + this.name() + " twipsFactor=" + this.twipsFactor + "}";
        }
    }
}

