/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.document.utilities;

import com.inet.docx.document.utilities.Util;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STNumberFormat;

public class NumberFormating {
    private static final String LETTER_PATTERN = "ZABCDEFGHIJKLMNOPQRSTUVWXY";

    public static String getFormatedValue(STNumberFormat.Enum format, int number) {
        if (format == null) {
            format = STNumberFormat.DECIMAL;
        }
        if (STNumberFormat.DECIMAL.equals(format)) {
            return String.valueOf(number);
        }
        if (STNumberFormat.UPPER_ROMAN.equals(format)) {
            return NumberFormating.getUpperRoman(number);
        }
        if (STNumberFormat.LOWER_ROMAN.equals(format)) {
            return NumberFormating.getLowerRoman(number);
        }
        if (STNumberFormat.UPPER_LETTER.equals(format)) {
            return NumberFormating.getUpperLetter(number);
        }
        if (STNumberFormat.LOWER_LETTER.equals(format)) {
            return NumberFormating.getLowerLetter(number);
        }
        Util.LOGGER.error((Object)("Format not implemented: " + String.valueOf(format)));
        return String.valueOf(number);
    }

    private static String toRoman(int number) {
        String prefix = "";
        if (number == 0) {
            return "";
        }
        if (number < 0) {
            prefix = "-";
            number *= -1;
        }
        return prefix + String.valueOf(new char[number]).replace('\u0000', 'I').replace("IIIII", "V").replace("IIII", "IV").replace("VV", "X").replace("VIV", "IX").replace("XXXXX", "L").replace("XXXX", "XL").replace("LL", "C").replace("LXL", "XC").replace("CCCCC", "D").replace("CCCC", "CD").replace("DD", "M").replace("DCD", "CM");
    }

    public static String getUpperRoman(int value) {
        return NumberFormating.toRoman(value);
    }

    public static String getLowerRoman(int value) {
        return NumberFormating.toRoman(value).toLowerCase();
    }

    public static String getLowerLetter(int value) {
        return NumberFormating.getUpperLetter(value).toLowerCase();
    }

    public static String getUpperLetter(int value) {
        Object result = "";
        String prefix = "";
        if (value < 0) {
            prefix = "-";
            value = Math.abs(value);
        }
        while (value > 0) {
            int ch = value % 26;
            if (((String)result).length() > 0 && ((String)result).startsWith("Z") && ch > 0) {
                --ch;
            }
            if ((value /= 26) == 1 && ch == 0) {
                value = 0;
            }
            result = new String(new char[]{LETTER_PATTERN.charAt(ch)}) + (String)result;
        }
        return prefix + (String)result;
    }
}

