/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.document.table;

import com.inet.docx.document.DocumentAnalyzer;
import com.inet.docx.document.DocumentProperties;
import com.inet.docx.document.elements.style.CellBorder;
import com.inet.docx.document.elements.style.CellStyle;
import com.inet.docx.document.elements.style.ParagraphAndRunStyle;
import com.inet.docx.document.elements.style.StyleTable;
import com.inet.docx.document.elements.subelements.drawing.Anchor;
import com.inet.docx.document.elements.subelements.table.TableBorder;
import com.inet.docx.document.elements.subelements.table.TableCell;
import com.inet.docx.document.paragraph.ParagraphData;
import com.inet.docx.document.paragraph.ParagraphFactory;
import com.inet.docx.document.table.TableData;
import com.inet.docx.document.utilities.Util;
import java.awt.Insets;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.ICell;
import org.apache.poi.xwpf.usermodel.ISDTContent;
import org.apache.poi.xwpf.usermodel.ISDTContents;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFSDT;
import org.apache.poi.xwpf.usermodel.XWPFSDTCell;
import org.apache.poi.xwpf.usermodel.XWPFSDTContent;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.officeDocument.x2006.sharedTypes.STXAlign;
import org.openxmlformats.schemas.officeDocument.x2006.sharedTypes.STYAlign;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTCnf;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHeight;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTOnOff;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtCell;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtContentCell;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtContentRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblBorders;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblCellMar;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblGrid;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblGridCol;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblPPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblPrEx;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblWidth;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTrPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STHAnchor;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STHeightRule;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STJcTable;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STVAnchor;

public class TableFactory {
    public static TableData readTable(XWPFTable table, DocumentProperties documentProperties) {
        CTTblCellMar tblCellMar;
        int[] columnSizes;
        String tableStyle = table.getStyleID();
        StyleTable styleTable = null;
        styleTable = tableStyle != null ? (StyleTable)documentProperties.getStyle(tableStyle) : documentProperties.getBaseTableStyle();
        CTTbl ctbl = table.getCTTbl();
        CTTblPr pr = ctbl.getTblPr();
        if (ctbl.getTblGrid() != null) {
            CTTblGrid ctblGrid = ctbl.getTblGrid();
            List gridCols = ctblGrid.getGridColList();
            columnSizes = new int[gridCols.size()];
            if (((CTTblGridCol)gridCols.get(0)).isSetW()) {
                for (int i = 0; i < gridCols.size(); ++i) {
                    columnSizes[i] = Util.getInt(((CTTblGridCol)gridCols.get(i)).getW());
                }
            } else if (pr.isSetTblW()) {
                int width = Util.getValueFromWidth(pr.getTblW());
                for (int i = 0; i < columnSizes.length; ++i) {
                    columnSizes[i] = width / columnSizes.length;
                }
            }
        } else if (table.getRows().isEmpty()) {
            columnSizes = new int[]{};
        } else {
            int columns = 0;
            for (XWPFTableRow row : table.getRows()) {
                columns = Math.max(columns, row.getTableICells().size());
            }
            columnSizes = new int[columns];
        }
        CellStyle defaultCellStyle = styleTable != null ? styleTable.getCellStyle(new ArrayList<StyleTable.CellType>(StyleTable.DEFAULT_STYLE)).clone() : new CellStyle(null, null);
        TableBorder tbBor = null;
        CTTblBorders tableBorders = pr.getTblBorders();
        if (styleTable == null || styleTable.getTableBorders() == null) {
            if (tableBorders != null) {
                tbBor = new TableBorder(tableBorders, documentProperties.getThemeColors());
            }
        } else {
            tbBor = styleTable.getTableBorders().mergeBorders(tableBorders, documentProperties.getThemeColors());
        }
        if (tableBorders != null) {
            defaultCellStyle.setBorder(CellBorder.merge(tbBor, defaultCellStyle.getBorder()));
        }
        Anchor verticalAnchor = null;
        Anchor horizontalAnchor = null;
        STJcTable.Enum tjc = null;
        if (pr.isSetTblpPr()) {
            CTTblPPr tppr = pr.getTblpPr();
            verticalAnchor = TableFactory.analyseOffset(tppr, true);
            horizontalAnchor = TableFactory.analyseOffset(tppr, false);
        } else if (pr.isSetJc()) {
            tjc = pr.getJc().getVal();
        }
        List sdtRows = ctbl.getSdtList();
        List<XWPFTableRow> rows = sdtRows.size() > 0 ? TableFactory.getTableRowsFromSdt(sdtRows, table) : table.getRows();
        Insets defaultMargins = new Insets(table.getCellMarginTop(), table.getCellMarginLeft(), table.getCellMarginBottom(), table.getCellMarginRight());
        int sum = defaultMargins.top + defaultMargins.left + defaultMargins.bottom + defaultMargins.right;
        if (sum == 0 && styleTable != null && styleTable.getCellMargin() != null) {
            defaultMargins = styleTable.getCellMargin();
        }
        if ((tblCellMar = pr.getTblCellMar()) != null) {
            CTTblWidth ctw = tblCellMar.getBottom();
            if (ctw != null) {
                defaultMargins.bottom = Util.getInt(ctw.xgetW().getObjectValue());
            }
            if ((ctw = tblCellMar.getTop()) != null) {
                defaultMargins.top = Util.getInt(ctw.xgetW().getObjectValue());
            }
            if ((ctw = tblCellMar.getLeft()) != null) {
                defaultMargins.left = Util.getInt(ctw.xgetW().getObjectValue());
            }
            if ((ctw = tblCellMar.getRight()) != null) {
                defaultMargins.right = Util.getInt(ctw.xgetW().getObjectValue());
            }
        }
        int tableIndent = Util.getValueFromWidth(pr.getTblInd());
        int repeatingHeaderRow = TableFactory.getRepeatingHeaderRowCount(table);
        TableData ta = new TableData(columnSizes, rows.size(), repeatingHeaderRow, horizontalAnchor, verticalAnchor, tjc, defaultMargins, tableIndent, styleTable, defaultCellStyle);
        for (int rowNumber = 0; rowNumber < rows.size(); ++rowNumber) {
            CTTblBorders excepBorders;
            XWPFTableRow row = rows.get(rowNumber);
            int height = row.getHeight();
            boolean exact = false;
            CTRow ctRow = row.getCtRow();
            CTTrPr trpr = ctRow.getTrPr();
            CTTblPrEx tprex = ctRow.getTblPrEx();
            if (tbBor != null) {
                ta.setBorders(tbBor);
            }
            if (tprex != null && (excepBorders = tprex.getTblBorders()) != null) {
                ta.setBorders(new TableBorder(excepBorders, documentProperties.getThemeColors()));
            }
            List<StyleTable.CellType> rowCellStyles = null;
            if (trpr != null) {
                List cnfList;
                List heightList = trpr.getTrHeightList();
                if (heightList.size() > 0) {
                    CTHeight heightDef = (CTHeight)heightList.get(0);
                    STHeightRule.Enum rule = heightDef.getHRule();
                    exact = STHeightRule.EXACT == rule;
                    height = Util.getInt(heightDef.getVal());
                }
                if ((cnfList = trpr.getCnfStyleList()).size() > 0 && styleTable != null) {
                    CTCnf cnf = (CTCnf)cnfList.get(0);
                    rowCellStyles = styleTable.getCellTypesForCnfKey(cnf.getVal());
                }
            }
            List<XmlObject> rowContent = null;
            List cells = row.getTableICells();
            for (int n = 0; n < cells.size(); ++n) {
                CTSdtCell cellObj;
                CTSdtContentCell cellContent;
                List cellList;
                ICell cell = (ICell)cells.get(n);
                if (cell instanceof XWPFTableCell) {
                    TableFactory.handleCell(styleTable, ta, rowNumber, rowCellStyles, height, exact, (XWPFTableCell)cell, documentProperties);
                    continue;
                }
                if (!(cell instanceof XWPFSDTCell) || (cellList = (cellContent = (cellObj = TableFactory.getCellObject(rowContent = rowContent == null ? TableFactory.getObjectList((XmlObject)row.getCtRow()) : rowContent, n)).getSdtContent()).getTcList()).size() <= 0) continue;
                TableFactory.handleCell(styleTable, ta, rowNumber, rowCellStyles, height, exact, new XWPFTableCell((CTTc)cellList.get(0), row, table.getBody()), documentProperties);
            }
        }
        for (int col = 0; col < ta.getColumnCount(); ++col) {
            for (int row = 0; row < ta.getRowCount(); ++row) {
                TableCell tc = ta.getCell(col, row);
                if (tc == null || tc.getStartColumn() != tc.getEndColumn()) continue;
                if (row == 0) {
                    columnSizes[col] = Math.max(columnSizes[col], tc.getWidth());
                }
                tc.setWidth(columnSizes[col]);
            }
        }
        return ta;
    }

    private static CTSdtCell getCellObject(List<XmlObject> rowContent, int positoion) {
        Object cellObj = null;
        int cellCount = -1;
        for (XmlObject o : rowContent) {
            if (o instanceof CTTc || o instanceof CTSdtCell) {
                ++cellCount;
            }
            if (cellCount != positoion) continue;
            return (CTSdtCell)o;
        }
        return null;
    }

    private static List<XmlObject> getObjectList(XmlObject ctRow) {
        ArrayList<XmlObject> cells = new ArrayList<XmlObject>();
        XmlCursor cursor = ctRow.newCursor();
        cursor.selectPath("./*");
        while (cursor.toNextSelection()) {
            cells.add(cursor.getObject());
        }
        cursor.dispose();
        return cells;
    }

    private static List<XWPFTableRow> getTableRowsFromSdt(List<CTSdtRow> sdtRows, XWPFTable table) {
        ArrayList<XWPFTableRow> rows = new ArrayList<XWPFTableRow>();
        for (int rowNumber = 0; rowNumber < sdtRows.size(); ++rowNumber) {
            CTSdtContentRow xmlRow = sdtRows.get(rowNumber).getSdtContent();
            XmlCursor cursor = xmlRow.newCursor();
            cursor.selectPath("./*");
            while (cursor.toNextSelection()) {
                XmlObject o = cursor.getObject();
                if (o instanceof CTRow) {
                    rows.add(new XWPFTableRow((CTRow)o, table));
                    continue;
                }
                Util.LOGGER.error((Object)("No table row: " + String.valueOf(o)));
            }
            cursor.dispose();
        }
        return rows;
    }

    private static Anchor analyseOffset(CTTblPPr tppr, boolean vertical) {
        int offSet;
        String anchorAlign;
        String reference;
        if (vertical) {
            STVAnchor.Enum vAnch = tppr.getVertAnchor();
            reference = vAnch != null ? vAnch.toString() : "page";
            STYAlign.Enum vAlign = tppr.getTblpYSpec();
            anchorAlign = vAlign != null ? vAlign.toString() : "top";
            offSet = Util.getInt(tppr.getTblpY());
        } else {
            STHAnchor.Enum hAnch = tppr.getHorzAnchor();
            reference = hAnch != null ? hAnch.toString() : "margin";
            STXAlign.Enum hAlign = tppr.getTblpXSpec();
            anchorAlign = hAlign != null ? hAlign.toString() : "left";
            offSet = Util.getInt(tppr.getTblpX());
        }
        return new Anchor(reference, anchorAlign, (double)offSet, false, vertical);
    }

    private static void handleCell(StyleTable styleTable, TableData ta, int rowNumber, List<StyleTable.CellType> rowCellStyles, int height, boolean isExact, XWPFTableCell cell, DocumentProperties documentProperties) {
        TableCell tca = ta.addCell(rowNumber, cell != null ? cell.getCTTc() : null, rowCellStyles, documentProperties.getThemeColors());
        if (tca.getContent().size() > 0) {
            return;
        }
        if (height > 0) {
            tca.setHeight(height, isExact);
        }
        ParagraphAndRunStyle specificStyleFont = tca.getCellStyle().getFontStyle();
        List cellContent = cell.getBodyElements();
        for (IBodyElement ele : cellContent) {
            if (ele instanceof XWPFTable) {
                TableData subTa = TableFactory.readTable((XWPFTable)ele, documentProperties);
                tca.addElement(subTa);
            } else if (ele instanceof XWPFParagraph) {
                CTCnf cnf;
                CTPPr ppr = ((XWPFParagraph)ele).getCTP().getPPr();
                if (ppr != null && styleTable != null && (cnf = ppr.getCnfStyle()) != null) {
                    specificStyleFont = styleTable.getCnfFontStyle(cnf.getVal());
                }
                ParagraphData pa = ParagraphFactory.readParagraph(documentProperties, (XWPFParagraph)ele, false, specificStyleFont);
                Util.applyAutoColor(pa, tca.getCellStyle().getCellBackground());
                tca.addElement(pa);
            } else if (ele instanceof XWPFSDT) {
                XWPFSDT sdt = (XWPFSDT)ele;
                ISDTContent content = sdt.getContent();
                if (content instanceof XWPFSDTContent) {
                    try {
                        Field bodyElements = content.getClass().getDeclaredField("bodyElements");
                        bodyElements.setAccessible(true);
                        List contentList = (List)bodyElements.get(content);
                        for (ISDTContents element : contentList) {
                            CTCnf cnf;
                            if (element instanceof XWPFTable) {
                                TableData subTa = TableFactory.readTable((XWPFTable)element, documentProperties);
                                tca.addElement(subTa);
                                continue;
                            }
                            if (!(element instanceof XWPFParagraph)) continue;
                            CTPPr ppr = ((XWPFParagraph)element).getCTP().getPPr();
                            if (ppr != null && styleTable != null && (cnf = ppr.getCnfStyle()) != null) {
                                specificStyleFont = styleTable.getCnfFontStyle(cnf.getVal());
                            }
                            ParagraphData pa = ParagraphFactory.readParagraph(documentProperties, (XWPFParagraph)element, false, specificStyleFont);
                            Util.applyAutoColor(pa, tca.getCellStyle().getCellBackground());
                            tca.addElement(pa);
                        }
                    }
                    catch (Throwable th) {
                        Util.LOGGER.error((Object)("Unsupported type of SDT content: " + String.valueOf(ele) + " -> " + String.valueOf(content)));
                        Util.LOGGER.error(th);
                    }
                }
            } else {
                Util.LOGGER.error((Object)("UNKNOWN TABLE ELEMENT " + String.valueOf(ele)));
            }
            DocumentAnalyzer.handleGroups(tca.getContent(), new ArrayList<ParagraphData>(), documentProperties);
        }
    }

    private static int getRepeatingHeaderRowCount(XWPFTable table) {
        int repeatLines = 0;
        for (XWPFTableRow row : table.getRows()) {
            CTTrPr trpr;
            boolean repeat = false;
            CTRow ctRow = row.getCtRow();
            if (ctRow.isSetTrPr() && (trpr = ctRow.getTrPr()).sizeOfTblHeaderArray() > 0) {
                CTOnOff rpt = trpr.getTblHeaderArray(0);
                boolean bl = repeat = rpt.isSetVal() ? Util.getBool(rpt.getVal()) : true;
            }
            if (!repeat) break;
            ++repeatLines;
        }
        return repeatLines;
    }
}

