/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.document.paragraph;

import com.inet.docx.document.DocumentProperties;
import com.inet.docx.document.elements.Comment;
import com.inet.docx.document.elements.style.ParagraphAndRunStyle;
import com.inet.docx.document.elements.style.RenderFont;
import com.inet.docx.document.elements.style.RunRenderInformations;
import com.inet.docx.document.elements.style.Spacing;
import com.inet.docx.document.elements.style.TextFrame;
import com.inet.docx.document.elements.subelements.Break;
import com.inet.docx.document.elements.subelements.CommentReferenz;
import com.inet.docx.document.elements.subelements.EmptyRow;
import com.inet.docx.document.elements.subelements.Field;
import com.inet.docx.document.elements.subelements.FieldPart;
import com.inet.docx.document.elements.subelements.Footnote;
import com.inet.docx.document.elements.subelements.FootnoteEndReference;
import com.inet.docx.document.elements.subelements.MathematicalFunction;
import com.inet.docx.document.elements.subelements.ParagraphElement;
import com.inet.docx.document.elements.subelements.Tab;
import com.inet.docx.document.elements.subelements.TextRowElement;
import com.inet.docx.document.paragraph.ParagraphData;
import com.inet.docx.document.utilities.NameSpaceHandler;
import com.inet.docx.document.utilities.Util;
import com.inet.docx.view.PageProperties;
import com.inet.docx.view.drawing.DrawingFactory;
import java.awt.Color;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.poi.ooxml.POIXMLTypeLoader;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.impl.values.XmlAnyTypeImpl;
import org.apache.xmlbeans.impl.values.XmlValueOutOfRangeException;
import org.apache.xmlbeans.impl.xb.xmlschema.SpaceAttribute;
import org.openxmlformats.schemas.officeDocument.x2006.math.CTOMath;
import org.openxmlformats.schemas.officeDocument.x2006.math.CTOMathPara;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDrawing;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTEmpty;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFldChar;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFramePr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFtnEdnRef;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHyperlink;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTMarkup;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTMarkupRange;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTNumPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTObject;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPTab;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTParaRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPicture;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTR;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRunTrackChange;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtContentRun;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtRun;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSectPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTShd;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSimpleField;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSmartTagRun;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTString;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSym;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTText;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.impl.CTProofErrImpl;
import org.w3c.dom.Node;

public class ParagraphFactory {
    public static ParagraphData readParagraph(DocumentProperties documentProperties, XWPFParagraph paragraphPOI, boolean mainPart, ParagraphAndRunStyle parentStyle) {
        ParagraphData paragraphData = new ParagraphData();
        CTSectPr sectionPageProperties = ParagraphFactory.readParagraphRenderInformations(documentProperties, paragraphPOI, paragraphData, parentStyle);
        if (mainPart && sectionPageProperties != null) {
            paragraphData.setPageProperties(new PageProperties(sectionPageProperties, documentProperties));
        }
        ParagraphFactory.readParagraphElements(documentProperties, paragraphPOI, paragraphData);
        ParagraphFactory.mergeSimilarRuns(paragraphData);
        if (paragraphData.hasTextFrame()) {
            paragraphData.convertTextFrame(documentProperties);
        }
        return paragraphData;
    }

    private static ParagraphAndRunStyle readParagraphFontInformations(ParagraphData pa, CTParaRPr paraRpr, CTString styleName, DocumentProperties defaults, ParagraphAndRunStyle parentStyle) {
        ParagraphAndRunStyle sf;
        String style = null;
        if (styleName != null) {
            style = styleName.getVal();
            sf = defaults.getStyleFont(style);
            sf = ParagraphAndRunStyle.mergeStyles(sf, sf.getDefaultStyle());
            if (pa.getContextualSpacing() == null) {
                pa.setContextualSpacing(sf.getContextualSpacing());
            }
            if (pa.getParagraphControl() == null) {
                pa.setParagraphControl(sf.getWidowControl());
            }
        } else {
            style = parentStyle.getName();
            sf = parentStyle;
        }
        RunRenderInformations paraRenderInfos = RunRenderInformations.getRenderInformations(paraRpr, defaults);
        paraRenderInfos = RunRenderInformations.mergeRenderInformations(paraRenderInfos, sf);
        pa.setFontRenderInfos(paraRenderInfos);
        pa.setStyle(sf, style, defaults);
        RenderFont rf = paraRenderInfos.createFont(defaults);
        if (sf.getHorAlign() != null) {
            pa.setHorizontalAlign(sf.getHorAlign());
        }
        defaults.getLayouter(rf);
        pa.setMarkerRenderFont(rf);
        return sf;
    }

    private static CTSectPr readParagraphRenderInformations(DocumentProperties documentProperties, XWPFParagraph paragraph, ParagraphData pa, ParagraphAndRunStyle parentStyle) {
        CTSectPr sectionPageProperties = null;
        CTP ctp = paragraph.getCTP();
        CTPPr ppr = ctp.getPPr();
        if (parentStyle == null) {
            parentStyle = documentProperties.getStandardStyleFont();
        }
        if (ppr != null) {
            CTShd shd = ppr.getShd();
            if (shd != null) {
                Color paraBg = Util.getColor(shd.getVal(), shd.getColor(), shd.getFill(), shd.getThemeFill(), documentProperties.getThemeColors());
                pa.setAreaBackground(paraBg);
            }
            Boolean contextSpacing = Util.getBooleanForOnOff(ppr.getContextualSpacing(), true);
            pa.setContextualSpacing(contextSpacing);
            sectionPageProperties = ppr.getSectPr();
            parentStyle = ParagraphFactory.readParagraphFontInformations(pa, ppr.getRPr(), ppr.getPStyle(), documentProperties, parentStyle);
            CTFramePr frmPr = ppr.getFramePr();
            if (frmPr != null) {
                pa.setTextFrame(TextFrame.merge(new TextFrame(frmPr), parentStyle.getTextFrame()));
            } else {
                pa.setTextFrame(parentStyle.getTextFrame());
            }
            pa.setBorder(Util.getBorders(ppr.getPBdr(), documentProperties.getThemeColors()));
            if (pa.getBorder() == null) {
                pa.setBorder(parentStyle.getBorder());
            }
            if (ppr.isSetPageBreakBefore()) {
                pa.setPageBreakBefore(true);
            }
            if (ppr.isSetWidowControl()) {
                pa.setParagraphControl(Util.getBooleanForOnOff(ppr.getWidowControl(), false));
            }
            if (ppr.isSetKeepLines()) {
                pa.setKeepParagraphOnTheSamePage(true);
            }
            if (ppr.isSetKeepNext()) {
                pa.setKeepParagraphTogetherWithNextParagraph(true);
            }
            if (ppr.isSetSpacing()) {
                Spacing parentSpacing = pa.getSpacing() != null ? pa.getSpacing() : parentStyle.getParagraphSpacing(true);
                Spacing space = new Spacing(ppr.getSpacing(), parentSpacing);
                pa.setSpacing(space);
            }
            if (ppr.isSetNumPr()) {
                CTNumPr numPr = ppr.getNumPr();
                BigInteger lvl = BigInteger.ZERO;
                if (numPr.isSetIlvl() && numPr.getIlvl().getVal() != null) {
                    lvl = numPr.getIlvl().getVal();
                }
                BigInteger id = BigInteger.ZERO;
                if (numPr.isSetNumId() && numPr.getNumId().getVal() != null) {
                    id = numPr.getNumId().getVal();
                }
                pa.setNumbering(documentProperties, id.intValue(), lvl.intValue());
            }
            if (ppr.isSetInd()) {
                pa.setIndent(Util.getIndent(ppr.getInd(), null));
            }
            if (ppr.isSetJc()) {
                try {
                    pa.setHorizontalAlign(ppr.getJc().getVal());
                }
                catch (XmlValueOutOfRangeException xmlValueOutOfRangeException) {}
            } else if (pa.getHorizontalAlign() == null && parentStyle.getHorAlign() != null) {
                pa.setHorizontalAlign(parentStyle.getHorAlign());
            }
            if (ppr.isSetTabs()) {
                pa.setTabs(Util.getTabs(ppr.getTabs(), pa.getMarkerRenderFont()));
            }
        } else {
            ParagraphFactory.readParagraphFontInformations(pa, null, null, documentProperties, parentStyle);
        }
        return sectionPageProperties;
    }

    private static void readParagraphElements(DocumentProperties documentProperties, XWPFParagraph paragraph, ParagraphData pa) {
        CTP ctp = paragraph.getCTP();
        XmlCursor curs = ctp.newCursor();
        curs.selectPath("./*");
        int itemCount = curs.getSelectionCount();
        while (curs.toNextSelection()) {
            XmlObject paraSubObj = curs.getObject();
            if (paraSubObj instanceof CTPPr) {
                if (--itemCount != 0) continue;
                CTPPr ppr = (CTPPr)paraSubObj;
                CTParaRPr rpr = ppr.getRPr();
                pa.setCanBeEmpty(rpr == null);
                pa.addElement(new EmptyRow(pa.getMarkerRenderFont()));
                continue;
            }
            if (paraSubObj instanceof CTR) {
                ParagraphFactory.handleCTR(documentProperties, (CTR)paraSubObj, pa, paragraph.getBody(), itemCount, null);
                continue;
            }
            if (paraSubObj instanceof CTSimpleField) {
                CTSimpleField field = (CTSimpleField)paraSubObj;
                for (CTR innerRun : field.getRList()) {
                    ParagraphFactory.handleCTR(documentProperties, innerRun, pa, paragraph.getBody(), itemCount, field.getInstr());
                }
                continue;
            }
            if (paraSubObj instanceof CTOMath) {
                MathematicalFunction mf = new MathematicalFunction((CTOMath)paraSubObj, documentProperties);
                if (mf.canHandle()) {
                    mf.handleContent(pa);
                    continue;
                }
                ParagraphFactory.addNotSupportedElement(documentProperties, pa, "Math");
                continue;
            }
            if (paraSubObj instanceof CTOMathPara) {
                if (Util.isDebugMode) {
                    new MathematicalFunction((CTOMathPara)paraSubObj, documentProperties);
                }
                ParagraphFactory.addNotSupportedElement(documentProperties, pa, "Math");
                continue;
            }
            if (paraSubObj instanceof CTProofErrImpl || paraSubObj instanceof CTMarkupRange) continue;
            if (paraSubObj instanceof CTHyperlink) {
                ParagraphFactory.handleCTHyperlink(documentProperties, (CTHyperlink)paraSubObj, pa, paragraph.getBody(), itemCount);
                continue;
            }
            if (paraSubObj instanceof CTSmartTagRun) {
                ParagraphFactory.handleSmartTag((CTSmartTagRun)paraSubObj, documentProperties, paragraph.getBody(), pa, itemCount);
                continue;
            }
            if (paraSubObj instanceof CTRunTrackChange) {
                CTRunTrackChange rtc = (CTRunTrackChange)paraSubObj;
                for (CTR ctr : rtc.getRList()) {
                    ParagraphFactory.handleCTR(documentProperties, ctr, pa, paragraph.getBody(), itemCount, null);
                }
                continue;
            }
            if (paraSubObj instanceof CTSdtRun) {
                ParagraphFactory.handleStructuredDocumentTag(documentProperties, (CTSdtRun)paraSubObj, pa, paragraph.getBody(), itemCount);
                continue;
            }
            Util.LOGGER.error((Object)("Unknown object: " + paraSubObj.getClass().getName()));
        }
        curs.dispose();
        if (pa.getElementCount() == 0) {
            pa.addElement(new EmptyRow(pa.getMarkerRenderFont()));
        }
        pa.handleNumberingText(documentProperties);
    }

    private static void handleStructuredDocumentTag(DocumentProperties documentProperties, CTSdtRun sdt, ParagraphData pa, IBody body, int itemCount) {
        CTSdtContentRun sdtcr = sdt.getSdtContent();
        XmlCursor cursor = sdtcr.newCursor();
        cursor.selectPath("./*");
        while (cursor.toNextSelection()) {
            XmlObject runObj = cursor.getObject();
            if (runObj instanceof CTR) {
                ParagraphFactory.handleCTR(documentProperties, (CTR)runObj, pa, body, itemCount, null);
                continue;
            }
            if (runObj instanceof CTHyperlink) {
                ParagraphFactory.handleCTHyperlink(documentProperties, (CTHyperlink)runObj, pa, body, itemCount);
                continue;
            }
            if (runObj instanceof CTSdtRun) {
                ParagraphFactory.handleStructuredDocumentTag(documentProperties, (CTSdtRun)runObj, pa, body, itemCount);
                continue;
            }
            if (runObj instanceof CTMarkupRange) continue;
            Util.LOGGER.error((Object)("Unknown object: " + runObj.getClass().getName()));
        }
        cursor.dispose();
    }

    private static void handleCTHyperlink(DocumentProperties documentProperties, CTHyperlink hyper, ParagraphData pa, IBody body, int itemCount) {
        for (CTR ctr : hyper.getRList()) {
            List fldChar = ctr.getFldCharList();
            String func = fldChar.size() > 0 ? ((CTFldChar)fldChar.get(0)).getFldCharType().toString() : null;
            ParagraphFactory.handleCTR(documentProperties, ctr, pa, body, itemCount, func);
        }
    }

    private static void handleSmartTag(CTSmartTagRun str, DocumentProperties documentProperties, IBody body, ParagraphData pa, int itemCount) {
        XmlCursor cursor = str.newCursor();
        cursor.selectPath("./*");
        while (cursor.toNextSelection()) {
            XmlObject smartTagObj = cursor.getObject();
            if (smartTagObj instanceof CTSmartTagRun) {
                ParagraphFactory.handleSmartTag((CTSmartTagRun)smartTagObj, documentProperties, body, pa, itemCount);
                continue;
            }
            if (smartTagObj instanceof CTR) {
                ParagraphFactory.handleCTR(documentProperties, (CTR)smartTagObj, pa, body, itemCount, null);
                continue;
            }
            Util.LOGGER.error((Object)("Unknown smart tag sub object: " + smartTagObj.getClass().getName()));
        }
    }

    private static void handleCTR(DocumentProperties documentProperties, CTR ctr, ParagraphData pa, IBody body, int itemCount, String function) {
        XmlCursor cursor = ctr.newCursor();
        cursor.selectPath("./*");
        while (cursor.toNextSelection()) {
            Object tab;
            RenderFont rf;
            XmlObject runObj = cursor.getObject();
            if (runObj instanceof CTText) {
                CTText tElement = (CTText)runObj;
                String text = tElement.getStringValue();
                if (tElement.getSpace() != SpaceAttribute.Space.PRESERVE) {
                    text = text.trim();
                } else if (tElement.isSetSpace()) {
                    text = documentProperties.checkPreserveText(text);
                }
                TextRowElement tre = ParagraphFactory.readRunRenderInfos(documentProperties, ctr.getRPr(), pa, text);
                if (function != null) {
                    Field fld = new Field(function, documentProperties, tre);
                    pa.addElement(fld);
                    continue;
                }
                if (ParagraphFactory.textMerge(pa, text, tre)) continue;
                pa.addElement(tre);
                continue;
            }
            if (runObj instanceof CTRPr) {
                pa.setCanBeEmpty(false);
                continue;
            }
            if (runObj instanceof CTFldChar) {
                rf = ParagraphFactory.createRunRenderFont(documentProperties, ctr.getRPr(), pa.getStyle());
                pa.addElement(new FieldPart((CTFldChar)runObj, rf));
                continue;
            }
            if (runObj instanceof CTBr) {
                rf = ParagraphFactory.createRunRenderFont(documentProperties, ctr.getRPr(), pa.getStyle());
                pa.addElement(new Break(((CTBr)runObj).getType(), rf));
                continue;
            }
            if (runObj instanceof CTMarkup) {
                Comment comment = ParagraphFactory.prepareComment(documentProperties, ((CTMarkup)runObj).getId());
                pa.addElement(new CommentReferenz(comment));
                continue;
            }
            if (runObj instanceof CTDrawing) {
                rf = ParagraphFactory.createRunRenderFont(documentProperties, ctr.getRPr(), pa.getStyle());
                pa.addElement(DrawingFactory.createDrawing((CTDrawing)runObj, documentProperties, body, rf));
                continue;
            }
            if (runObj instanceof CTObject) {
                pa.addElement(DrawingFactory.createDrawing((CTObject)runObj, body, documentProperties));
                continue;
            }
            if (runObj instanceof CTPicture) {
                pa.addElement(DrawingFactory.createDrawing((CTPicture)runObj, body, documentProperties));
                continue;
            }
            if (runObj instanceof CTFtnEdnRef) {
                CTFtnEdnRef fr = (CTFtnEdnRef)runObj;
                BigInteger id = fr.getId();
                Footnote footnote = documentProperties.getFootnoteData(id);
                String footnoteText = footnote == null ? "" : String.valueOf(footnote.getFootnoteDisplayId());
                CTRPr ctrPr = ctr.getRPr();
                TextRowElement tre = ParagraphFactory.readRunRenderInfos(documentProperties, ctrPr, pa, footnoteText);
                FootnoteEndReference fer = new FootnoteEndReference(tre, footnote);
                pa.addElement(fer);
                continue;
            }
            if (runObj instanceof CTPTab) {
                CTPTab ptab = (CTPTab)runObj;
                tab = new Tab(ptab.getAlignment(), ptab.getLeader(), ptab.getRelativeTo());
                TextRowElement style = ParagraphFactory.readRunRenderInfos(documentProperties, ctr.getRPr(), pa, "void");
                ((Tab)tab).setRenderData(style.getRenderFont(), style.getColor(), style.getBackgroundColor());
                pa.addElement((ParagraphElement)tab);
                continue;
            }
            if (runObj instanceof XmlAnyTypeImpl && "mc:AlternateContent".equals(runObj.getDomNode().getNodeName())) {
                XmlObject[] alternates = NameSpaceHandler.examineNamespace("mc", "Choice", runObj);
                for (XmlObject xo : alternates) {
                    String contentName = xo.getDomNode().getFirstChild().getNodeName();
                    if ("w:drawing".equals(contentName)) {
                        try {
                            Node drawNode = xo.getDomNode().getFirstChild();
                            RenderFont rf2 = ParagraphFactory.createRunRenderFont(documentProperties, ctr.getRPr(), pa.getStyle());
                            CTDrawing draw = (CTDrawing)CTDrawing.Factory.parse(drawNode.getFirstChild(), new XmlOptions(POIXMLTypeLoader.DEFAULT_XML_OPTIONS));
                            pa.addElement(DrawingFactory.createDrawing(draw, documentProperties, body, rf2));
                        }
                        catch (Exception ex) {
                            Util.LOGGER.error((Throwable)ex);
                        }
                        continue;
                    }
                    Util.LOGGER.warn((Object)("Alternate content name: " + contentName));
                }
                if (itemCount != 1 || !pa.isEmpty()) continue;
                pa.addElement(new EmptyRow(ParagraphFactory.createRunRenderFont(documentProperties, ctr.getRPr(), pa.getStyle())));
                continue;
            }
            if (runObj instanceof CTEmpty) {
                String nodeName = runObj.getDomNode().getNodeName();
                if (nodeName.endsWith(":tab")) {
                    tab = new Tab(null, null, 0);
                    TextRowElement style = ParagraphFactory.readRunRenderInfos(documentProperties, ctr.getRPr(), pa, "void");
                    ((Tab)tab).setRenderData(style.getRenderFont(), style.getColor(), style.getBackgroundColor());
                    pa.addElement((ParagraphElement)tab);
                    continue;
                }
                if (nodeName.endsWith(":cr")) {
                    RenderFont rf3 = ParagraphFactory.createRunRenderFont(documentProperties, ctr.getRPr(), pa.getStyle());
                    pa.addElement(new Break(null, rf3));
                    continue;
                }
                if (nodeName.endsWith(":lastRenderedPageBreak")) continue;
                Util.LOGGER.error((Object)("Unknown empty: " + nodeName + " " + runObj.getClass().getName()));
                continue;
            }
            if (!(runObj instanceof CTSym)) continue;
            CTSym sym = (CTSym)runObj;
            String str = sym.xgetChar().getStringValue();
            char ch = (char)(Integer.parseInt(str, 16) & 0xFFFF);
            TextRowElement tre = ParagraphFactory.readRunRenderInfos(documentProperties, ctr.getRPr(), pa, new String(new char[]{ch}));
            RenderFont rf4 = tre.getRenderFont();
            String fontName = sym.getFont();
            if (!fontName.equals(rf4.getFontName())) {
                RenderFont newRf = new RenderFont(fontName, rf4.getFontSize(), rf4.getFontStyle(), rf4.getUnderline(), rf4.isStrikethrough(), rf4.isInvisible(), rf4.isSmallCaps(), rf4.getSpacingValue(), rf4.getTextScale(), rf4.getVerticalOffset());
                newRf.setVerticalAlign(rf4.getVerticalAlign());
                documentProperties.getLayouter(rf4);
                tre = new TextRowElement(tre.getText(), newRf, tre.getColor(), tre.getBackgroundColor());
            }
            if (ParagraphFactory.textMerge(pa, str, tre)) continue;
            pa.addElement(tre);
        }
        cursor.dispose();
    }

    private static boolean textMerge(ParagraphData pa, String text, TextRowElement tre) {
        ParagraphElement lastParagraphElement;
        if (!pa.getElements().isEmpty() && (lastParagraphElement = pa.getElements().get(pa.getElements().size() - 1)) instanceof TextRowElement) {
            TextRowElement lastElement = (TextRowElement)lastParagraphElement;
            if (text.equals(" ") && lastElement.getRenderFont().getFontName().equals(tre.getRenderFont().getFontName()) || lastElement.getColor() == tre.getColor() && lastElement.getRenderFont().equals(tre.getRenderFont())) {
                lastElement.merge(tre);
                return true;
            }
        }
        return false;
    }

    private static RunRenderInformations readRunRenderInfos(DocumentProperties documentProperties, @Nullable CTRPr rpr, ParagraphAndRunStyle sf) {
        RunRenderInformations runInfos = RunRenderInformations.getRenderInformations(rpr, documentProperties);
        return RunRenderInformations.mergeRenderInformations(runInfos, sf);
    }

    private static RenderFont createRunRenderFont(DocumentProperties documentProperties, @Nullable CTRPr rpr, ParagraphAndRunStyle sf) {
        RunRenderInformations runInfos = ParagraphFactory.readRunRenderInfos(documentProperties, rpr, sf);
        return runInfos.createFont(documentProperties);
    }

    private static TextRowElement readRunRenderInfos(DocumentProperties documentProperties, CTRPr rpr, ParagraphData pa, String text) {
        RunRenderInformations runInfos = ParagraphFactory.readRunRenderInfos(documentProperties, rpr, pa.getStyle());
        if (runInfos.isUppercase()) {
            text = text.toUpperCase();
        }
        RenderFont rf = runInfos.createFont(documentProperties);
        text = Util.translateSymbolFontCharacters(text, rf);
        return new TextRowElement(text, rf, runInfos.getFontColor(), runInfos.getFontBackgroundColor());
    }

    private static Comment prepareComment(DocumentProperties documentProperties, BigInteger id) {
        Comment comment = documentProperties.getComment(id);
        if (comment != null) {
            ArrayList<XWPFParagraph> paras = comment.removeParagraphs();
            while (paras.size() > 0) {
                XWPFParagraph paragraph = paras.remove(0);
                ParagraphData pa = ParagraphFactory.readParagraph(documentProperties, paragraph, false, null);
                comment.addParaArea(pa);
            }
        }
        return comment;
    }

    private static boolean equalColorSettings(Color a, Color b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    private static void mergeSimilarRuns(ParagraphData paragraphData) {
        for (int i = paragraphData.getElementCount() - 1; i >= 1; --i) {
            ParagraphElement after;
            ParagraphElement prev = paragraphData.getElement(i - 1);
            ParagraphElement cur = paragraphData.getElement(i);
            if (prev.getElementType() != ParagraphElement.ParagraphElementType.Text || cur.getElementType() != ParagraphElement.ParagraphElementType.Text) continue;
            TextRowElement previous = (TextRowElement)prev;
            TextRowElement current = (TextRowElement)cur;
            if (!previous.getRenderFont().equals(current.getRenderFont()) || !ParagraphFactory.equalColorSettings(previous.getColor(), current.getColor()) || !ParagraphFactory.equalColorSettings(previous.getBackgroundColor(), current.getBackgroundColor())) continue;
            ParagraphElement paragraphElement = after = i < paragraphData.getElementCount() - 1 ? paragraphData.getElement(i + 1) : null;
            if (after instanceof CommentReferenz) continue;
            previous.merge(current);
            paragraphData.removeElement(i);
        }
    }

    private static void addNotSupportedElement(DocumentProperties documentProperties, ParagraphData pa, String feature) {
        TextRowElement textElement = new TextRowElement("Currently not supported Feature " + feature, pa.getStyle().getTextRenderInformations().createFont(documentProperties), Color.RED, Color.YELLOW);
        pa.addElement(textElement);
    }
}

