/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.document.paragraph;

import com.inet.docx.document.DocumentProperties;
import com.inet.docx.document.elements.DocumentElement;
import com.inet.docx.document.elements.style.Indent;
import com.inet.docx.document.elements.style.NumberingLevel;
import com.inet.docx.document.elements.style.ParagraphAndRunStyle;
import com.inet.docx.document.elements.style.RenderFont;
import com.inet.docx.document.elements.style.RunRenderInformations;
import com.inet.docx.document.elements.style.Spacing;
import com.inet.docx.document.elements.style.TextFrame;
import com.inet.docx.document.elements.subelements.BorderLines;
import com.inet.docx.document.elements.subelements.Break;
import com.inet.docx.document.elements.subelements.EmptyRow;
import com.inet.docx.document.elements.subelements.Field;
import com.inet.docx.document.elements.subelements.FieldPart;
import com.inet.docx.document.elements.subelements.NumberingInfo;
import com.inet.docx.document.elements.subelements.ParagraphElement;
import com.inet.docx.document.elements.subelements.Tab;
import com.inet.docx.layout.Layouter;
import com.inet.docx.layout.ParagraphLayouter;
import com.inet.docx.view.PageProperties;
import com.inet.docx.view.drawing.DrawingFactory;
import com.inet.docx.view.paragraph.ParagraphView;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STFldCharType;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STJc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STTabJc;

public class ParagraphData
implements DocumentElement {
    private RenderFont markerRenderFont;
    private RunRenderInformations paraFontInfos;
    private Spacing spacing;
    private List<ParagraphElement> elements = new ArrayList<ParagraphElement>();
    private PageProperties pageProperties;
    private Indent indent;
    private NumberingInfo numbering;
    private Boolean contextualSpacing;
    private BorderLines border;
    private Color areaBackground;
    private TextFrame textFrame;
    private boolean keepParagraphOnTheSamePage = false;
    private boolean keepParagraphTogetherWithNextParagraph = false;
    private boolean pageBreakBefore = false;
    private boolean isFirstContent = false;
    private Boolean paragraphControl;
    private STJc.Enum horizontalAlign;
    private ParagraphAndRunStyle style;
    private String styleName;
    private boolean canBeEmpty = true;
    private List<Tab> tabDataBuffer;
    private Indent numberingIndent;

    public Color getAreaBackground() {
        return this.areaBackground;
    }

    public void setAreaBackground(Color areaBackground) {
        this.areaBackground = areaBackground;
    }

    public BorderLines getBorder() {
        return this.border;
    }

    void setBorder(BorderLines border) {
        this.border = border;
    }

    public boolean isFirstContent() {
        return this.isFirstContent;
    }

    public void setFirstContent(boolean firstContent) {
        this.isFirstContent = firstContent;
    }

    public boolean isInField() {
        FieldPart fp = null;
        for (ParagraphElement pe : this.elements) {
            if (!(pe instanceof FieldPart)) continue;
            fp = (FieldPart)pe;
        }
        return fp != null && fp.getTypeMarker() != STFldCharType.END;
    }

    @Override
    public DocumentElement clone() {
        ParagraphData theClone = new ParagraphData();
        theClone.elements = new ArrayList<ParagraphElement>(this.elements);
        theClone.markerRenderFont = this.markerRenderFont;
        theClone.paraFontInfos = this.paraFontInfos;
        theClone.spacing = this.spacing;
        theClone.indent = this.indent;
        theClone.border = this.border;
        if (this.tabDataBuffer != null) {
            theClone.tabDataBuffer = new ArrayList<Tab>(this.tabDataBuffer);
        }
        return theClone;
    }

    @Override
    public Layouter<ParagraphView> getLayouter() {
        return new ParagraphLayouter(this);
    }

    public Tab[] getCustomnizeTabs() {
        return this.tabDataBuffer == null ? new Tab[]{} : this.tabDataBuffer.toArray(new Tab[0]);
    }

    public PageProperties getPageProperties() {
        return this.pageProperties;
    }

    public void setPageProperties(PageProperties pageProperties) {
        this.pageProperties = pageProperties;
    }

    public void addElement(ParagraphElement element) {
        this.elements.add(element);
    }

    public List<ParagraphElement> getElements() {
        return Collections.unmodifiableList(this.elements);
    }

    public int getElementCount() {
        return this.elements.size();
    }

    public ParagraphElement getElement(int index) {
        return this.elements.get(index);
    }

    public void removeElement(ParagraphElement element) {
        this.elements.remove(element);
    }

    public void removeElement(int index) {
        this.elements.remove(index);
    }

    public boolean isPageBreak() {
        Break br;
        return this.elements.size() == 1 && this.elements.get(0) instanceof Break && Break.BreakType.page == (br = (Break)this.elements.get(0)).getType();
    }

    @Override
    public boolean isEmpty() {
        if (!this.canBeEmpty && this.pageProperties == null) {
            return false;
        }
        if (this.elements.size() == 1) {
            return this.elements.get(0) instanceof EmptyRow;
        }
        return this.elements.size() == 0;
    }

    public Indent getIndent() {
        Indent effectiveIndent = this.numberingIndent;
        if (this.style != null) {
            effectiveIndent = Indent.mergeIndentInformations(effectiveIndent, this.style.getIndent());
        }
        return (effectiveIndent = Indent.mergeIndentInformations(this.indent, effectiveIndent)) != null ? effectiveIndent : new Indent(0, 0, 0, 0);
    }

    public void setIndent(Indent indent) {
        this.indent = Indent.mergeIndentInformations(indent, this.indent);
    }

    @Override
    public Spacing getSpacing() {
        return this.spacing;
    }

    public void setSpacing(Spacing spacing) {
        this.spacing = spacing;
    }

    public void convertTextFrame(DocumentProperties documentProperties) {
        ParagraphData intenalObject = (ParagraphData)this.clone();
        while (intenalObject.handleFields(documentProperties) != null) {
        }
        this.elements.clear();
        this.elements.add(DrawingFactory.convertToDrawing(intenalObject, this.textFrame));
        intenalObject.textFrame = null;
        this.textFrame = null;
    }

    public boolean hasTextFrame() {
        return this.textFrame != null && this.textFrame.getWidth() != null && this.textFrame.getHeight() != null;
    }

    public void setTextFrame(TextFrame textFrame) {
        this.textFrame = textFrame;
    }

    void setTabs(List<Tab> tabs) {
        if (tabs != null && this.tabDataBuffer != null) {
            ArrayList<Tab> tabList = new ArrayList<Tab>(this.tabDataBuffer);
            block0: for (int i = tabs.size() - 1; i >= 0; --i) {
                Tab tab = tabs.get(i);
                if (tab.getTabStyle() != STTabJc.CLEAR) continue;
                tabs.remove(tab);
                for (Tab tabCompare : tabList) {
                    if (tab.getPosition() != tabCompare.getPosition()) continue;
                    tabList.remove(tabCompare);
                    continue block0;
                }
            }
            tabList.addAll(tabs);
            tabList.sort(Comparator.comparingInt(o -> o.getPosition()));
            this.tabDataBuffer = tabList;
        } else if (tabs != null) {
            this.tabDataBuffer = tabs;
        }
    }

    void setNumbering(DocumentProperties documentProperties, int key, int lvl) {
        NumberingLevel abstractNumbering = documentProperties.getNumberingLevel(key, lvl);
        if (abstractNumbering != null) {
            if (this.numbering != null) {
                this.numbering.resetCount();
            }
            this.numbering = new NumberingInfo(documentProperties, key, lvl, this.paraFontInfos);
            this.numberingIndent = abstractNumbering.getIndent();
            ArrayList<Tab> numberingTabs = abstractNumbering.getTabs();
            if (numberingTabs != null) {
                this.setTabs((ArrayList)numberingTabs.clone());
            }
        } else {
            this.numbering = null;
            this.numberingIndent = null;
        }
    }

    protected void handleNumberingText(DocumentProperties documentProperties) {
        if (this.numbering != null) {
            if (this.elements.size() == 0 || this.elements.size() == 1 && this.elements.get(0) instanceof EmptyRow) {
                this.numbering = null;
            } else {
                this.numbering.setDisplayText(documentProperties);
            }
        }
    }

    public boolean hasNumbering() {
        return this.numbering != null;
    }

    public NumberingInfo getNumbering() {
        return this.numbering;
    }

    public void setFontRenderInfos(RunRenderInformations paraFontInfos) {
        this.paraFontInfos = paraFontInfos;
    }

    public RenderFont getMarkerRenderFont() {
        return this.markerRenderFont;
    }

    void setMarkerRenderFont(RenderFont markerRenderFont) {
        this.markerRenderFont = markerRenderFont;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "<Empty Paragraph>";
        }
        return this.elements.size() + " - " + String.valueOf(this.markerRenderFont) + ": \"" + String.join((CharSequence)", ", this.elements.stream().map(e -> e.toString()).collect(Collectors.toList()).toArray(new String[0])) + "\"";
    }

    public Boolean getContextualSpacing() {
        return this.contextualSpacing;
    }

    public void setContextualSpacing(Boolean contextualSpacing) {
        this.contextualSpacing = contextualSpacing;
    }

    public boolean isCaps() {
        return this.paraFontInfos.getCaps() != null && this.paraFontInfos.getCaps() != false;
    }

    public boolean isKeepParagraphOnTheSamePage() {
        return this.keepParagraphOnTheSamePage;
    }

    public void setKeepParagraphOnTheSamePage(boolean keepParagraphOnTheSamePage) {
        this.keepParagraphOnTheSamePage = keepParagraphOnTheSamePage;
    }

    @Override
    public boolean isKeepParagraphTogetherWithNextParagraph() {
        return this.keepParagraphTogetherWithNextParagraph;
    }

    public void setKeepParagraphTogetherWithNextParagraph(boolean keepParagraphTogetherWithNextParagraph) {
        this.keepParagraphTogetherWithNextParagraph = keepParagraphTogetherWithNextParagraph;
    }

    public boolean isStartOnNewPage() {
        return this.pageBreakBefore;
    }

    public void setPageBreakBefore(boolean pageBreakBefore) {
        this.pageBreakBefore = pageBreakBefore;
    }

    public boolean isParagraphControl() {
        return this.paragraphControl != null ? this.paragraphControl : true;
    }

    public Boolean getParagraphControl() {
        return this.paragraphControl;
    }

    public void setParagraphControl(Boolean paragraphControl) {
        this.paragraphControl = paragraphControl;
    }

    public ParagraphElement handleFields(DocumentProperties documentProperties) {
        int beginIndex = -1;
        int separateIndex = -1;
        for (int i = 0; i < this.elements.size(); ++i) {
            ParagraphElement pe = this.elements.get(i);
            if (!(pe instanceof FieldPart)) continue;
            if (STFldCharType.BEGIN.equals(((FieldPart)pe).getTypeMarker())) {
                beginIndex = i;
                continue;
            }
            if (STFldCharType.SEPARATE.equals(((FieldPart)pe).getTypeMarker())) {
                separateIndex = i;
                continue;
            }
            if (!STFldCharType.END.equals(((FieldPart)pe).getTypeMarker())) continue;
            if (beginIndex > -1) {
                ArrayList<ParagraphElement> subList = new ArrayList<ParagraphElement>();
                for (int n = i; n >= beginIndex; --n) {
                    ParagraphElement element = this.elements.remove(n);
                    subList.add(0, element);
                }
                Field field = new Field(subList, documentProperties);
                if (field.getDrawing() != null) {
                    this.elements.add(beginIndex, field.getDrawing());
                } else {
                    this.elements.add(beginIndex, field);
                }
                return field;
            }
            return pe;
        }
        if (beginIndex > -1) {
            return this.elements.get(beginIndex);
        }
        if (separateIndex > -1) {
            return this.elements.get(separateIndex);
        }
        return null;
    }

    public STJc.Enum getHorizontalAlign() {
        return this.horizontalAlign != null ? this.horizontalAlign : STJc.LEFT;
    }

    public void setHorizontalAlign(String horizontalAlign) {
        if ("center".equals(horizontalAlign) || "centerGroup".equals(horizontalAlign) || "ctr".equals(horizontalAlign)) {
            this.setHorizontalAlign(STJc.CENTER);
        } else if ("right".equals(horizontalAlign) || "r".equals(horizontalAlign)) {
            this.setHorizontalAlign(STJc.RIGHT);
        } else if ("left".equals(horizontalAlign) || "l".equals(horizontalAlign)) {
            this.setHorizontalAlign(STJc.LEFT);
        }
    }

    public void setHorizontalAlign(STJc.Enum horizontalAlign) {
        this.horizontalAlign = horizontalAlign;
    }

    public ParagraphAndRunStyle getStyle() {
        return this.style;
    }

    public String getStyleName() {
        return this.styleName;
    }

    public void setStyle(ParagraphAndRunStyle style, String styleName, DocumentProperties documentProperties) {
        this.style = style;
        this.styleName = styleName;
        if (style.getNumberingLevel() != null) {
            NumberingLevel numLevel = style.getNumberingLevel();
            this.setNumbering(documentProperties, numLevel.getKey(), numLevel.getLevel());
        }
        this.setTabs(style.getTabData());
        this.setSpacing(style.getParagraphSpacing(true));
        this.setPageBreakBefore(style.isPageBreakBefore());
        this.setBorder(style.getBorder());
        this.setKeepParagraphOnTheSamePage(this.keepParagraphOnTheSamePage);
        this.setKeepParagraphTogetherWithNextParagraph(style.isKeepParagraphTogetherWithNextParagraph());
    }

    public void setCanBeEmpty(boolean canBeEmpty) {
        this.canBeEmpty = canBeEmpty;
    }
}

