/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.document.excel.coditional;

import com.inet.docx.document.excel.WorkbookAnalyzer;
import com.inet.docx.document.excel.coditional.CellAddressAndValue;
import com.inet.docx.document.excel.coditional.ConditionalFormatingHandler;
import com.inet.docx.document.excel.coditional.FormatingHandler;
import com.inet.docx.document.utilities.Util;
import java.util.List;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDxf;

public class ValueRuleHandler
extends FormatingHandler {
    private List<String> formulas;
    private String operator;

    protected ValueRuleHandler(int priority, ConditionalFormatingHandler formatingHandler, CTDxf dfx, String operator, List<String> formulas) {
        super(priority, formatingHandler, dfx);
        this.formulas = formulas;
        this.operator = operator;
    }

    @Override
    protected void checkValues(List<CellAddressAndValue> cellValues, WorkbookAnalyzer.IndexSizeAndStyle[] rows, WorkbookAnalyzer.IndexSizeAndStyle[] columns) {
        CellAddressAndValue firstCompare = ValueRuleHandler.getCompareValue(this.formulas.get(0));
        CellAddressAndValue secondCompare = this.formulas.size() > 1 ? ValueRuleHandler.getCompareValue(this.formulas.get(1)) : null;
        for (CellAddressAndValue cav : cellValues) {
            if (!ValueRuleHandler.isInDisplayedRange(rows, columns, cav.getAddress()) || !this.isAffectedByCondition(cav, firstCompare, secondCompare)) continue;
            this.addAddress(cav.getAddress());
        }
    }

    private boolean isAffectedByCondition(CellAddressAndValue value, CellAddressAndValue firstCompare, CellAddressAndValue secondCompare) {
        switch (this.operator) {
            case "greaterThan": {
                return CellAddressAndValue.VALUE_COMPARATOR.compare(firstCompare, value) < 0;
            }
            case "lessThan": {
                return CellAddressAndValue.VALUE_COMPARATOR.compare(firstCompare, value) > 0;
            }
            case "between": {
                return CellAddressAndValue.VALUE_COMPARATOR.compare(firstCompare, value) <= 0 && CellAddressAndValue.VALUE_COMPARATOR.compare(secondCompare, value) >= 0;
            }
            case "equal": {
                return CellAddressAndValue.VALUE_COMPARATOR.compare(firstCompare, value) == 0;
            }
        }
        Util.LOGGER.error((Object)("Unhandeld operator: " + this.operator));
        return false;
    }

    private static CellAddressAndValue getCompareValue(String stringValue) {
        try {
            Double value = new Double(stringValue);
            return new CellAddressAndValue(null, value);
        }
        catch (Exception ex) {
            return new CellAddressAndValue(null, stringValue);
        }
    }
}

